/**
 * @file   AXCCommFreeRTOS.hpp
 * @brief  AXCCommFreeRTOSクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCCOMMFREERTOS_HPP_
#define AXCCOMMFREERTOS_HPP_

#include "AXCComm.hpp"
#ifdef BB_TMP_PASS	/* 一旦コンパイルを通す用 */
#include "FreeRTOS.h"
#include "event_groups.h"
#define COM_MEM_FROM_ARM_SIZE 512
#define COM_MEM_FROM_XTENSA_SIZE 512
#define axc_comm_flg_r (*(volatile UINT32_t*)(0x20000000))
#define axc_comm_flg_w (*(volatile UINT32_t*)(0x20000004))
#else
#include <drvXInt.h>	// baba 以前のデータシート取得後検討
#endif

/**
 * @class AXCCommFreeRTOS
 * @brief AXFCommInternal に対し、CPU間通信機能を提供する
 *
 */
class AXCCommFreeRTOS : public AXCComm {
  bool m_isInited;
  UINT32_t m_fromXtensa;
  UINT32_t m_fromArm;
  UINT32_t m_dspRegBase;

  enum commMemStat {
    COMM_MEM_STAT_EMPTY = 0,
    COMM_MEM_STAT_DATA = 1,
    COMM_MEM_STAT_ACK = -2,
  };

 public:
  /**
   * @brief AXCCommFreeRTOSコンストラクタ
   */
  AXCCommFreeRTOS();

  /**
   * @brief AXCCommFreeRTOSデストラクタ
   */
  virtual ~AXCCommFreeRTOS();

  // AXF GoogleTest対応のため、仮想関数として実装する */

  /**
   * @brief 初期化
   * @param [in] type AXCommタイプ
   * @return AXComm初期化状況
   * - COMM_SUCCESS 正常終了
   * - COMM_ERROR 異常終了
   */
  virtual commStatus init(AXComm_t type);

  /**
   * @brief 同期読み出し
   * @param [out] buf
   * @param [in] size
   * @return 読み出しデータサイズ(エラー時は 0 未満)
   */
  virtual int readSync(char *buf, int size);

  /**
   * @brief 同期書き込み
   * @param [in] buf
   * @param [in] size
   * @return 書き込みデータサイズ(エラー時は 0 未満)
   */
  virtual int writeSync(char *buf, int size);

  /**
   * @brief ベースアドレスの設定 (GoogleTest用)
   * @param [in] fromXtensa 共有メモリのバッファ (from Xtensa方向)
   * @param [in] fromArm 共有メモリのバッファ (from ARM方向)
   * @param [in] dspRegBase DSPレジスタのベースアドレス
   */
  void setBaseAddr(UINT32_t fromXtensa, UINT32_t fromArm, UINT32_t dspRegBase);

 private:
  void raiseIntr();
  UINT32_t readReg(int offset);
  void writeReg(int offset, UINT32_t v);
  commMemStat getCommMemStat(UINT32_t phyAddr);
  void setCommMemStat(UINT32_t phyAddr, commMemStat stat);
};

#endif /* AXCCOMMFREERTOS_HPP_ */
