/**
 * @file   AXCCommRingBufFreeRTOS.hpp
 * @brief  AXCCommRingBufFreeRTOSクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCCOMMRINGBUFFREERTOS_HPP_
#define AXCCOMMRINGBUFFREERTOS_HPP_

#include "AXCRingBuf.hpp"
#include "AXCStdint.hpp"
#include "cpuCommInt.h"	// baba これは以前のスタブヘッダのため一旦仮のヘッダを用意する

/**
 * @class AXCCommRingBufFreeRTOS
 * @brief AXFRingBuf に対し、CPU間通信リング・バッファ機能を提供する
 *
 * @n     [注意]AXM層は本クラスは直接使用せず、AXFRingBuf を使用し、OS依存しないようにする。
 *
 */
class AXCCommRingBufFreeRTOS : public AXCRingBuf {
  volatile int* m_offsetP[2];
  UINT32_t m_dspRegBase;

 public:
  /**
   * @brief AXCCommRingBufFreeRTOSコンストラクタ
   */
  AXCCommRingBufFreeRTOS(
    char* buf = (char *)(COM_MEM_LOG + 4*2),	// baba 以前のデータシート取得後検討（おそらく共有メモリ用アドレス）
    int size = COM_MEM_LOG_SIZE - 4*2,				// baba 本サイズはAXF側で指定。（現状AXFStageにて512に設定されている）
		volatile int* rp = (volatile int *)(COM_MEM_LOG + 0),	// baba 上記同様
		volatile int* wp = (volatile int *)(COM_MEM_LOG + 4),	// baba 上記同様
    UINT32_t dspRegBase = 0x31500000);

  /**
   * @brief AXCCommRingBufFreeRTOSデストラクタ
   */
  virtual ~AXCCommRingBufFreeRTOS() {
    if (getBuf() == (char *)(0x204ffc00 + 4*2)) setBuf(NULL);
  }

  /**
   * @brief 初期化
   * @return AXCCommRingBufFreeRTOS初期化状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus init();

  /**
   * @brief オフセット位置取得
   * @param [in] rw リード・ライト指定
   * @return バイト・オフセット位置
   */
  virtual int getOffset(ringBufRW rw);

  /**
   * @brief オフセット位置設定
   * @param [in] rw リード・ライト指定
   * @param [in] v バイト・オフセット位置
   */
  virtual void setOffset(ringBufRW rw, int v);

  /**
   * @brief ウエイト
   * @param [in] rw リード・ライト指定
   * @return ウエイト状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus waitFor(ringBufRW rw);

  /**
   * @brief シグナル発行
   * @param [in] rw リード・ライト指定
   * @return シグナル発行状況
   * - RINGBUF_SUCCESS 正常終了
   * - RINGBUF_ERROR 異常終了
   */
  virtual ringBufStatus signalTo(ringBufRW rw);

 private:
  void raiseIntr();
  UINT32_t readReg(int offset);
  void writeReg(int offset, UINT32_t v);
};

#endif /* AXCCOMMRINGBUFFREERTOS_HPP_ */
