/**
 * @file   AXCStdio.hpp
 * @brief  AXCStdioクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCSTDIO_HPP_
#define AXCSTDIO_HPP_

#include <iostream>
#include <sstream>

/**
 * @class AXCStdio
 * @brief AXC層の 標準入出力クラス に対し、抽象クラスを提供する
 *
 * @n     使用方法
 * @n     1. インスタンスを生成する
 * @n        標準出力へログを出力するより前で宣言する必要があります
 * @n       AXFStdio stdio;
 * @n     2. 標準出力へログを出力する
 * @n        改行する場合は、std::endlではなくaxstdio::endlを使用する必要があります
 * @n        (axstdio::endlはバッファフラッシュを伴いませんので、手順３でフラッシュして出力する必要があります)
 * @n       std::cout << "出力したい文字列" << axstdio::endl;
 * @n     3. 標準出力のログをフラッシュする
 * @n       stdio.flush();
 * @n     4. 標準入力した結果を得る
 * @n       １行入力の場合
 * @n        std::string inData = stdio.getline();
 * @n       １文字入力の場合
 * @n        char inData = stdio.getchar();
 */
class AXCStdio {
 public:
  
  /**
   * @brief AXCStdioコンストラクタ
   */
  AXCStdio();

  /**
   * @brief AXCStdioデストラクタ
   */
  virtual ~AXCStdio();

  /**
   * @brief flush
   * @n     std::coutへ標準出力した内容を出力する
   */
  virtual void flush() = 0;

  /**
   * @brief  getLine
   * @n      標準入力から１行入力する
   * @return １行分の標準入力文字列
   */
  virtual std::string getLine() = 0;

  /**
   * @brief  getChar
   * @n      標準入力から１文字入力する
   * @return １文字分の標準入力文字
   */
  virtual char getChar() = 0;
};

#endif /* AXCSTDIO_HPP_ */
