/*
 * AXCStdioFreeRTOS.cpp
 */
extern "C" {	/* このリンケージは何度も使用しないで済むように出来ればヘッダ側に追加してほしい */
#include "lisoc_test.h"	/* このヘッダにuart.hで使用する型などが存在するため現状必要 */
#include "uart.h"
}
#include "AXCStdioFreeRTOS.hpp"

const int BUFF_SIZE = 256; /* 文字列格納用バッファサイズ */

AXCStdioFreeRTOS::AXCStdioFreeRTOS(){
	uart0_init();
	
	mBuf.str("");
	mPrevBuf = NULL;
		
	/* streambufをローカルバッファへ変更する */
	mPrevBuf = std::cout.rdbuf(&mBuf);
	
	mIsInited = true;
}

AXCStdioFreeRTOS::~AXCStdioFreeRTOS() {
	if (mIsInited) {
		/* streambufを元に戻す */
		std::cout.rdbuf(mPrevBuf);
		mPrevBuf = NULL;
	}
}

void AXCStdioFreeRTOS::flush() {
	if (mIsInited) {
		/* UARTドライバにてstreambufの内容を出力する */
		for (int i = 0; i < (int)mBuf.str().size(); i++) {
			uart1_send((mBuf.str())[i]);
		}
		
		mBuf.str("");
	}
}

std::string AXCStdioFreeRTOS::getLine(){
  std::string line;
  uint8_t buff[BUFF_SIZE];
  int maxindex = sizeof(buff)-1;
  int i=0;
  while(i < maxindex) {
	buff[i] = AXCStdioFreeRTOS::getChar();
    if(buff[i]=='\n') {
      break;
    }
    i++;
  }
  buff[i]='\0';
  line = std::string((char*)buff);
  return line;
}

char AXCStdioFreeRTOS::getChar(){
	return uart1_recv();
}
