/**
 * @file   AXCTimerUnitFreeRTOS.hpp
 * @brief  AXCTimerUnitFreeRTOSクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXCTIMERUNITFREERTOS_HPP_
#define AXCTIMERUNITFREERTOS_HPP_

#include "FreeRTOS.h"
#include "timers.h"
#include "AXCTimerUnit.hpp"

/**
 * @class AXCTimerUnitFreeRTOS
 * @brief タイマの生成、設定、開始、停止、取得を行う機能を提供する
 */
class AXCTimerUnitFreeRTOS : public AXCTimerUnit {
  AXCTimerTask* m_task;
  bool m_isSingle;
	TimerHandle_t m_cycId;   ///< FreeRTOS周期タイマID
  TickType_t m_cycphs;   	 ///< 周期起動位相(起動までの時間) [ミリ秒]
	TickType_t m_cyctim;   	 ///< 実行間隔 [ミリ秒]
  int m_expNum;

 public:

  /**
   * @brief AXCTimerUnitFreeRTOSコンストラクタ
   * @n
   * @param [in] task タイマタスク
   */
  AXCTimerUnitFreeRTOS(AXCTimerTask* task);

  /**
   * @brief AXCTimerUnitFreeRTOSデストラクタ
   */
  virtual ~AXCTimerUnitFreeRTOS();

  /**
   * @brief create
   * @n     タイマを初期化する
   * @n
   * @return 設定可否
   */
  virtual int init();

  /**
   * @brief set
   * @n     タイマを設定、開始する
   * @n
   * @param[in]  spec          周期時間（秒、秒未満）
   * @param[in]  isSingle      単発タイマか否か
   * @n
   * @return 設定可否
   */
  virtual int set(CoreTimeSpec* spec, bool isSingle);

  /**
   * @brief get
   * @n     タイマ情報を取得する
   * @n
   * @param[out] *ret_spec タイマ周期(満了)の経過時間（秒、秒未満）
   * @n
   * @return 設定可否
   */
  virtual int get(CoreTimeSpec* ret_spec);

  /**
   * @brief cancel
   * @n     タイマをキャンセルする
   * @n
   * @return 設定可否
   */
  virtual int cancel();

  /**
   * @brief getExpNum
   * @n     本メソッドの前回呼出しが返ってからの
   * @n     タイマの満了回数を返す
   * @n
   * @return タイマの満了回数
   */
  virtual int getExpNum();

  bool isExpired(); // AXCTimerTaskFreeRTOSクラスからのみ呼び出される

 private:

  int stop();
  static void expireFunc(void* exinf);
  void expire();
};

#endif /* AXCTIMERUNITFREERTOS_HPP_ */
