/**
 * @file   AX.hpp
 * @brief  AXクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AX_HPP_
#define AX_HPP_

#include <vector>
#include <string>

class AXFConditionVariableInternal;
class AXFObjectName;
class AXFStageResourceInfo;
class AXFStageStartInfo;

extern std::string axdaemonActorName;
extern std::string axshellActorName;

/**
 * @class AX
 * @brief AXインスタンスの生成・破棄機能を提供する
 *
 * @n AXインスタンスは1プロセスとなる。
 */
class AX {
  static AX* ax;
  static AXFConditionVariableInternal* m_quitCond;
  static AXFObjectName* m_nameAXDaemon;
  static AXFObjectName* m_nameAXShell;
  bool setInitResourceInfo(std::vector<AXFStageResourceInfo>& resourceInfo);
  bool setInitStartInfo(std::vector<AXFStageStartInfo>& startInfo);

 public:

  /**
   * @brief AXコンストラクタ
   */
  AX();

  /**
   * @brief AXデストラクタ
   */
  virtual ~AX();

  /**
   * @brief AXインスタンスを生成する
   */
  static bool create();

  /**
   * @brief AXインスタンスを破棄する
   */
  static bool destroy();

  /**
   * @brief AXインスタンスを取得する
   * @return AXインスタンス
   */
  static AX* getInstance();

  /**
   * @brief AXを初期化する
   */
  virtual bool init();

  /**
   * @brief AXの終了待ち
   */
  virtual bool waitQuit();

  /**
   * @brief AXへ終了要求する
   * @n     AXShellクラスのみ使用する
   */
  virtual bool requestQuit();
};

#endif /* AX_HPP_ */
