/**
 * @file   AXFMutex.hpp
 * @brief  AXFMutexクラスヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFMUTEX_HPP_
#define AXFMUTEX_HPP_

#include "AXCMutexFreeRTOS.hpp"

/**
 * @class AXFMutex
 * @brief Mutex を使用してクリティカルセクションを保護する機能を提供する
 *
 * @n     使用方法:
 * @n     1. Mutexインスタンスを生成する。
 * @n       int stat;
 * @n       AXFMutex* mutex = new (std::nothrow) AXFMutex();
 * @n     2. Mutexインスタンスの初期化を行う。
 * @n        本メソッドは、複数回呼び出してはならない。
 * @n        初期化に失敗した場合、呼び出し元の異常処理を行う。
 * @n       stat = mutex.init();
 * @n       if (AXFMutex::MUTEX_SUCCESS != stat) {
 * @n         ...
 * @n     3.1 Mutexを獲得する。(ブロックあり)
 * @n        獲得に失敗した場合、呼び出し元の異常処理を行う。
 * @n       stat = mutex.lock();
 * @n       if (AXFMutex::MUTEX_SUCCESS != stat) {
 * @n         ...
 * @n     3.2 Mutexを獲得する。(ブロックなし)
 * @n        獲得に成功した場合、保護対象のリソースにアクセスする。
 * @n        MUTEX_ERROR_BUSY が返ってきた場合、タイミングをおいて、再度、trylock を行う。
 * @n        獲得に失敗した場合、呼び出し元の異常処理を行う。
 * @n       stat = mutex.trylock();
 * @n       switch (stat) {
 * @n         case AXFMutex::MUTEX_SUCCESS:
 * @n           ...
 * @n           break;
 * @n         case AXFMutex::MUTEX_ERROR_BUSY:
 * @n           ...
 * @n           mutex.trylock();
 * @n         defalut:
 * @n           ...
 * @n     4. Mutexを解放する。
 * @n        解放に失敗した場合、呼び出し元の異常処理を行う。
 * @n        stat = mutex.unlock();
 * @n        if (AXFMutex::MUTEX_SUCCESS != stat) {
 * @n          ...
 * @n     5. Mutexインスタンスを破棄する。
 * @n       delelte mutex;
 * @n
 * @n     AXFMutexクラスの 詳細は AXCMutexクラス の説明に記述する。
 *
 */
class AXFMutex :
	public AXCMutexFreeRTOS
{
};

#endif /* AXFMUTEX_HPP_ */
