/**
 * @file   AXFStatus.hpp
 * @brief  AXFStatusヘッダ
 *
 * @par    Programming Language
 *         C++
 */

#ifndef AXFSTATUS_HPP_
#define AXFSTATUS_HPP_

namespace ax {
/** @enum  actorFuncStatus
 *  @brief ライフサイクル・メソッド実行完了状態
 *
 */
enum actorFuncStatus {
  AXFACTOR_SUCCESS = 0,     ///< 正常終了
  AXFACTOR_ERROR,           ///< 異常終了
  AXFACTOR_ERROR_NOCREATE,  ///< アクタ未生成

  AXFACTOR_STATE_ERROR,             ///< 異常終了　状態遷移内処理で致命的なエラーが発生し、動作できない状態
  AXFACTOR_STATE_ERROR_NOREGIST,    ///< 異常終了　状態遷移が未登録
  AXFACTOR_STATE_ERROR_NOFUNCTION,  ///< 異常終了　メンバ関数が未登録
  AXFACTOR_STATE_ERROR_RECEIVEDATA, ///< 異常終了　パラメータ異常
};
}
#endif /* AXFSTATUS_HPP_ */
