/*
 * AXFWatchdogInternal.hpp
 */

#ifndef AXFWATCHDOGINTERNAL_HPP_
#define AXFWATCHDOGINTERNAL_HPP_

#include "AXFEvent.hpp"
#include "AXFActor.hpp"
#include "AXFStage.hpp"

#include <vector>

class AXFLog;
class AXFObjectName;
class AXFStage;

/**
 * @class AXFWatchdogInternal
 * @brief アクタ監視機能を提供する
 *
 * @n     AXFDaemonInternalクラスのみ、使用する。
 * @n
 */
class AXFWatchdogInternal {
  static AXFObjectName* m_daemonName;
  AXFActor::TimerId_t m_dogTimerId;
  std::vector<AXFStageActorInfo>* m_actorInfoList;

 public:
  /**
   * @brief  AXFWatchdogInternal コンストラクタ
   */
  AXFWatchdogInternal();

  /**
   * @brief  AXFWatchdogInternal デストラクタ
   */
  virtual ~AXFWatchdogInternal();

  /**
   * @brief  Watchdog 初期化処理
   *
   * @n      AXFDaemonInternalクラスのみ使用する
   */
  virtual bool init(AXFStage* stage);

  /**
   * @brief  Watchdog 開始処理
   *
   * @n      AXFDaemonInternalクラスのみ使用する
   */
  virtual bool start(AXFLog& log, AXFActor& obj, AXFEvent_t doctimeEvent);

  /**
   * @brief  Watchdog 停止処理
   *
   * @n      AXFDaemonInternalクラスのみ使用する
   */
  virtual bool stop(AXFLog& log, AXFActor& obj);

  /**
   * @brief  Watchdog 生死確認・応答要求処理
   *
   * @n      AXFDaemonInternalクラスのみ使用する
   */
  virtual bool interval(AXFLog& log);

  /**
   * @brief  Watchdog 応答処理
   *
   * @n      AXFActorクラスのみ使用する
   */
  static bool ack(AXFLog& log, AXFActor& obj);

  /**
   * @brief  Watchdog 応答時間更新処理
   *
   * @n      AXFDaemonInternalクラスのみ使用する
   */
  virtual bool updateAckTime(AXFLog& log, INT32_t actorId);
};
#endif /* AXFWATCHDOGINTERNAL_HPP_ */
