/*
 * @file   AXHAperture.cpp
 * @brief  Source file of Aperture Class.
 * @par    Programming Language
 *         C++
 */
#include "AXHAperture.hpp"
#include "AXHRegAddr.hpp"
//#define AP_CONNECT_TEST
#ifdef AP_CONNECT_TEST
#include <iostream>
#endif
AXHAperture::AXHAperture() :
	  REG_DATA_SIZE(4)
	, TOTAL_GAIN_SHIFT           (24)
	, LIMIT_POSITIVE_SHIFT       (16)
	, HIGH_RANGE_GAIN_RATIO_SHIFT(8)
	, LUT_3B_ON_SHIFT            (17)
	, CORING_TH_SHIFT            (16)
	, TOTAL_GAIN_CLEAR_MASK      (0x00FFFFFF)
	, LIMIT_POSITIVE_CLEAR_MASK  (0x0000FFFF)
	, GAIN_RATIO_CLEAR_MASK      (0xFFFF0000)
	, LUT_ACS_EDITON_VALUE       (0x00000FFF)
	, LUT_ACS_EDITOFF_VALUE      (0x00000000)
	, LUT_3B_CLEAR_MASK          (0xFFF1FFFF)
	, CORING_TH_CLEAR_MASK       (0xFF00FFFF)
{
	// TODO 自動生成されたコンストラクター・スタブ
}

AXHAperture::~AXHAperture() {
	// TODO Auto-generated destructor stub
}

void AXHAperture::set_aperture_totalgain(unsigned char totalgain) {
	// 現状ハードとは異なるため不要
	/*

	unsigned int val = 0;
	unsigned int adr = AXH_SAC_VAL02;
	val = GetReg32(adr);
	val &= TOTAL_GAIN_CLEAR_MASK;
	val |= (totalgain << TOTAL_GAIN_SHIFT);
	SetReg32(adr, val);
#ifdef AP_CONNECT_TEST
	std::cout << "totalGainSet:";
	std::cout << (unsigned int)totalgain << std::endl;
#endif
#ifdef PARASOFT_CPPTEST
	CPPTEST_val = val;
#endif
	*/
}

void AXHAperture::set_aperture_plus_minus_limit(unsigned short limitPositive, unsigned short limitNegative) {
	// 現状ハードとは異なるため不要
	/*
	unsigned int val = 0;

	val  = (limitNegative << LIMIT_POSITIVE_SHIFT);
	val |= (LIMIT_POSITIVE_CLEAR_MASK & (unsigned int)limitPositive);
	unsigned int adr = AXH_SAC_VAL01;
	SetReg32(adr, val);
#ifdef AP_CONNECT_TEST
	std::cout << "limitPositive:";
	std::cout << (int)limitPositive << std::endl;
	std::cout << "limitNegative:";
	std::cout << (int)limitNegative << std::endl;
#endif
#ifdef PARASOFT_CPPTEST
	CPPTEST_val = val;
#endif
	*/
}

void AXHAperture::set_aperture_overmidrange_gainratio(unsigned char highRangeGainRatio, unsigned char midRangeGainRatio) {
	// 現状ハードとは異なるため不要
	/*

	unsigned int val = 0;
	unsigned int adr = AXH_SAC_VAL00;
	val = GetReg32(adr);
	val &= GAIN_RATIO_CLEAR_MASK;
	val |= (highRangeGainRatio << HIGH_RANGE_GAIN_RATIO_SHIFT | midRangeGainRatio);
	SetReg32(adr, val);
#ifdef AP_CONNECT_TEST
	std::cout << "highGainRatio:";
	std::cout << (unsigned int)highRangeGainRatio << std::endl;
	std::cout << "midGainRatio:";
	std::cout << (unsigned int)midRangeGainRatio << std::endl;
#endif
#ifdef PARASOFT_CPPTEST
	CPPTEST_val = val;
#endif
	*/
}

void AXHAperture::set_aperture_lut(unsigned char* lut, int size) {
	// 現状ハードとは異なるため不要
	/*

	unsigned int adr = 0;
	unsigned int val = 0;

	SetReg32(AXH_LUT_ACS, LUT_ACS_EDITON_VALUE);
	adr = AXH_LUT_3B_000;
	for (int i = 0; i < size; i++) {
		SetReg32(adr, (unsigned int)lut[i]);
#ifdef PARASOFT_CPPTEST
		lut[i] = adr;
#endif
		adr += REG_DATA_SIZE;
	}
	SetReg32(AXH_LUT_ACS, LUT_ACS_EDITOFF_VALUE);

	adr  = AXH_SAC_C00;
	val  = GetReg32(adr);
#ifdef PARASOFT_CPPTEST
	val  = 0xFFFFFFFF;
#endif
	val &= LUT_3B_CLEAR_MASK;			// bit(0start):17-19 clear
	val |= (0x01 << LUT_3B_ON_SHIFT);	// bit(0start):17-19 set "001"
	SetReg32(adr, val);

#ifdef PARASOFT_CPPTEST
	lut[size - 1] = val >> 17;
#endif

#ifdef AP_CONNECT_TEST
	std::cout << "setLut:" << std::endl;
	for (int i = 0; i < size; i++) {
		std::cout << (unsigned int)lut[i] << std::endl;
	}
#endif
	*/
}

void AXHAperture::set_aperture_coring(unsigned char coringTh) {
	// 現状ハードとは異なるため不要
	/*

	unsigned int val = 0;
	unsigned int adr = AXH_C0COR;
	val = GetReg32(adr);
	val &= CORING_TH_CLEAR_MASK;
	val |= (coringTh << CORING_TH_SHIFT);
	val |= 0x01;
	SetReg32(adr, val);
#ifdef AP_CONNECT_TEST
	std::cout << "setcoring:";
	std::cout << (unsigned int)coringTh << std::endl;
#endif
#ifdef PARASOFT_CPPTEST
	CPPTEST_val = val;
#endif
	*/
}
