/*
 * @file   AXHLensShade.cpp
 * @brief  Source file of LensShade Class
 * @par    Programming Language
 *         C++
 */

#include "AXHLensShade.hpp"
#include "AXHRegAddr.hpp"
#include "AXHSpecStruct.hpp"
#include "AXHCommonParam.hpp"


#define SFT_SPP_C_SHDEN                 (unsigned int)13
#define SFT_SPP_C_SHPITCH               (unsigned int)14
#define SFT_SPP_C_SHDSD                 (unsigned int)22
#define SFT_SPP_C2_ALSCSL               (unsigned int)10

#define BIT_RPU_C0_DMAI4ENA             0x01000000ul
#define BIT_SPP_C_MLS4ID                0x00000002ul
#define BIT_SPP_C_SHDEN                 0x00002000ul
#define BIT_RPU_DMA_ACT_SHD             0x00000002ul

#define SET_RPU_ID4_ID4BL_SHADE_ON      0x00000004ul
#define SET_RPU_ID4_ID4BL_SHADE_OFF     0x00000007ul
#define SET_SPP_C2_ALSCSL_SHADE_ON      ((0x00000005ul) << SFT_SPP_C2_ALSCSL)
#define SET_SPP_C2_ALSCSL_SHADE_OFF     ((0x00000003ul) << SFT_SPP_C2_ALSCSL)
#define SET_RPU_DMAR1_FMT_LEN_SHADE_ON  4620
#define SET_RPU_DMAR1_FMT_LEN_SHADE_OFF 0x0018C00ul

#define MASK_RPU_ID4_ID4BL              0x0000000Ful
#define MASK_SPP_C_SHPITCH              (0x000000FFul << SFT_SPP_C_SHPITCH)
#define MASK_SPP_C_SHDSD                (0x00000007UL << SFT_SPP_C_SHDSD)
#define MASK_SPP_C2_ALSCSL              (0x00000007ul << SFT_SPP_C2_ALSCSL)
#define MASK_RPU_DMAR1_FMT_LEN          0x07FFFFFFul

#define CLR_RPU_C0_DMAI4ENA             ~BIT_RPU_C0_DMAI4ENA
#define CLR_RPU_ID4_ID4BL               ~MASK_RPU_ID4_ID4BL
#define CLR_SPP_C_MLS4ID                ~BIT_SPP_C_MLS4ID
#define CLR_SPP_C_SHDEN                 ~BIT_SPP_C_SHDEN
#define CLR_SPP_C_SHPITCH               ~MASK_SPP_C_SHPITCH
#define CLR_SPP_C_SHDSD                 ~MASK_SPP_C_SHDSD
#define CLR_SPP_C2_ALSCSL               ~MASK_SPP_C2_ALSCSL
#define CLR_RPU_DMAR1_FMT_LEN           ~MASK_RPU_DMAR1_FMT_LEN
#define CLR_RPU_DMA_ACT_SHD             ~BIT_RPU_DMA_ACT_SHD

AXHLensShade::AXHLensShade() {
	// 現状ハードとは異なるため不要
	/*
#ifdef  PARASOFT_CPPTEST
  //  c++test実行時のみInit関数でSPP_Cを初期化したくないので、ここで初期化する
  SPP_C = ::AXHLensShade_SPP_C;
#endif  //  PARASOFT_CPPTEST
  Init(AXH_LensShade_Mode_Run);
	*/
}

AXHLensShade::AXHLensShade(AXH_LENS_SHADE_MODE mode) {
	// 現状ハードとは異なるため不要
	/*
#ifdef  PARASOFT_CPPTEST
  //  c++test実行時のみInit関数でSPP_Cを初期化したくないので、ここで初期化する
  SPP_C = ::AXHLensShade_SPP_C;
#endif  //  PARASOFT_CPPTEST
  Init(mode);
	*/
}

AXHLensShade::~AXHLensShade() {
}

void AXHLensShade::Init(AXH_LENS_SHADE_MODE mode) {
	// 現状ハードとは異なるため不要
	/*
  //  アドレス設定
  p_RPU_C0        = (unsigned int *)AXH_RPU_C0;
  p_RPU_ID4       = (unsigned int *)AXH_RPU_ID4;
  p_SPP_C         = (unsigned int *)AXH_SPP_C;
  p_SPP_C2        = (unsigned int *)AXH_SPP_C2;
  p_RPU_DMAR1_FMT = (unsigned int *)AXH_RPU_DMAR1_FMT;
  p_RPU_DMA_ACT   = (unsigned int *)AXH_RPU_DMA_ACT;

  Enabled = 0;
//  Klocwork指摘 AX-AXH-master #67(コードが未到達です)
//  SPP_CのSHDENの初期値は0のため、以下のコードはコメントアウトする
//  if((*p_SPP_C & BIT_SPP_C_SHDEN) == BIT_SPP_C_SHDEN) {
//    Enabled = 1;
//  }
  Pitch = (unsigned char)((*p_SPP_C & MASK_SPP_C_SHPITCH) >> SFT_SPP_C_SHPITCH);
  Shift = (unsigned char)((*p_SPP_C & MASK_SPP_C_SHDSD) >> SFT_SPP_C_SHDSD);
	*/
}

unsigned char AXHLensShade::getEnabled() {
	// 現状ハードとは異なるため不要
	/*
  return Enabled;
	*/
	return 0;
}

void AXHLensShade::setEnabled(unsigned char enabled) {
	// 現状ハードとは異なるため不要
	/*
  Enabled = enabled;
	*/
}

unsigned char AXHLensShade::getPitch() {
	// 現状ハードとは異なるため不要
	/*
  return Pitch;
	*/
	return 0;
}

void AXHLensShade::setPitch(unsigned char pitch) {
	// 現状ハードとは異なるため不要
	/*
  Pitch = pitch;
	*/
}

unsigned char AXHLensShade::getShift() {
	// 現状ハードとは異なるため不要
	/*
  return Shift + AXH_LensShade_Shift_Min;
	*/
}

void AXHLensShade::setShift(unsigned char shift) {
	// 現状ハードとは異なるため不要
	/*
  Shift = shift - AXH_LensShade_Shift_Min;
	*/
}

void AXHLensShade::Execute() {
	// 現状ハードとは異なるため不要
	/*
  if(Enabled != 0x00u) {
    //  レンズシェーディング補正 有効設定
    *p_RPU_C0  |= BIT_RPU_C0_DMAI4ENA;                      //  DMAI4ENA = 1
    *p_RPU_ID4 &= CLR_RPU_ID4_ID4BL;
    *p_RPU_ID4 |= SET_RPU_ID4_ID4BL_SHADE_ON;               //  ID4BL = 4
    *p_SPP_C |= BIT_SPP_C_MLS4ID;                           //  MLS4ID = 1
    *p_SPP_C |= BIT_SPP_C_SHDEN;                            //  SHDEN = 1
    *p_SPP_C &= CLR_SPP_C_SHPITCH;
    *p_SPP_C |= (((unsigned int)Pitch << SFT_SPP_C_SHPITCH) & MASK_SPP_C_SHPITCH);
                                                            //  SHPITCH
    *p_SPP_C |= (((unsigned int)Shift << SFT_SPP_C_SHDSD) & MASK_SPP_C_SHDSD);
                                                            //  SHDSD
    *p_SPP_C2 &= CLR_SPP_C2_ALSCSL;
    *p_SPP_C2 |= SET_SPP_C2_ALSCSL_SHADE_ON;                //  ALSCLS = 5
    *p_RPU_DMAR1_FMT &= CLR_RPU_DMAR1_FMT_LEN;
    *p_RPU_DMAR1_FMT |= SET_RPU_DMAR1_FMT_LEN_SHADE_ON;     //  RPU_DMAR1_LEN = 60
    *p_RPU_DMA_ACT |= BIT_RPU_DMA_ACT_SHD;                  //  RPU_ACT_SHD = 1
  }
  else {
    //  レンズシェーディング補正 無効設定
    *p_RPU_C0  &= CLR_RPU_C0_DMAI4ENA;                      //  DMAI4ENA = 0
    *p_RPU_ID4 &= CLR_RPU_ID4_ID4BL;
    *p_RPU_ID4 |= SET_RPU_ID4_ID4BL_SHADE_OFF;              //  ID4BL = 7
    *p_SPP_C &= CLR_SPP_C_MLS4ID;                           //  MLS4ID = 0
    *p_SPP_C &= CLR_SPP_C_SHDEN;                            //  SHDEN = 0
    *p_SPP_C &= CLR_SPP_C_SHPITCH;
    *p_SPP_C |= (((unsigned int)Pitch << SFT_SPP_C_SHPITCH) & MASK_SPP_C_SHPITCH);
                                                            //  SHPITCH
    *p_SPP_C |= (((unsigned int)Shift << SFT_SPP_C_SHDSD) & MASK_SPP_C_SHDSD);
                                                            //  SHDSD
    *p_SPP_C2 &= CLR_SPP_C2_ALSCSL;
    *p_SPP_C2 |= SET_SPP_C2_ALSCSL_SHADE_OFF;               //  ALSCLS = 3
    *p_RPU_DMAR1_FMT &= CLR_RPU_DMAR1_FMT_LEN;
    *p_RPU_DMAR1_FMT |= SET_RPU_DMAR1_FMT_LEN_SHADE_OFF;    //  RPU_DMAR1_LEN = 0
    *p_RPU_DMA_ACT &= CLR_RPU_DMA_ACT_SHD;                  //  RPU_ACT_SHD = 0
  }
	*/
}
