/**
 * @file   AXHLensShade.hpp
 * @brief  Header file of LensShade Class
 * @par    Programming Language
 *         C++
 */
#ifndef AXH_LENS_SHADE_H
#define AXH_LENS_SHADE_H

/**
 * @enum	AXH_LENS_SHADE_MODE
 * @brief	IRIDIX設定モード定義
 */
typedef enum
{
  AXH_LensShade_Mode_Init = 0,                              ///< レンズシェーディング初期化モード
  AXH_LensShade_Mode_Run                                    ///< レンズシェーディング通常モード
} AXH_LENS_SHADE_MODE;

/**
 * @class AXHLensShade
 * @brief LensShade Class
 * 
 */
class AXHLensShade {
 private:
  /**
   * @brief Enabled設定値
   */
  unsigned char Enabled;
  /**
   * @brief 水平ピッチ設定値
   */
  unsigned char Pitch;
  /**
   * @brief シフト量設定値
   */
  unsigned char Shift;
  /**
   * @brief RPU_C0レジスタ参照先
   */
  unsigned int *p_RPU_C0;
  /**
   * @brief RPU_ID4レジスタ参照先
   */
  unsigned int *p_RPU_ID4;
  /**
   * @brief SPP_Cレジスタ参照先
   */
  unsigned int *p_SPP_C;
  /**
   * @brief SPP_C2レジスタ参照先
   */
  unsigned int *p_SPP_C2;
  /**
   * @brief RPU_DMAR1_FMTレジスタ参照先
   */
  unsigned int *p_RPU_DMAR1_FMT;
  /**
   * @brief RPU_DMA_ACTレジスタ参照先
   */
  unsigned int *p_RPU_DMA_ACT;

 public:
  /**
   * @brief  オブジェクトを初期化する
   */
  AXHLensShade();

  /**
   * @brief  オブジェクトを初期化する
   *
   * @param  [in] mode 初期化モード
   */
  AXHLensShade(AXH_LENS_SHADE_MODE mode);
  /**
   * @brief  オブジェクトを開放する
   */
  ~AXHLensShade();

  /**
   * @brief 変数初期化処理
   *
   * @param [in] mode 初期化モード
   */
  void Init(AXH_LENS_SHADE_MODE mode);

  /**
   * @brief Enabled(有効/無効)設定値を取得する
   *
   * @return Enabled設定値
   */
  unsigned char getEnabled();

  /**
   * @brief Enabled(有効/無効)を設定する
   *
   * @param [in] enabled 有効/無効設定
   */
  void setEnabled(unsigned char enabled);

  /**
   * @brief 水平ピッチ設定値を取得する
   *
   * @return 水平ピッチ設定値
   */
  unsigned char getPitch();

  /**
   * @brief 水平ピッチを設定する
   *
   * @param [in] pitch 水平ピッチ
   */
  void setPitch(unsigned char pitch);

  /**
   * @brief シフト量設定値を取得する
   *
   * @return シフト量設定値
   */
  unsigned char getShift();

  /**
   * @brief 水平ピッチを設定する
   *
   * @param [in] shift 水平ピッチ
   */
  void setShift(unsigned char shift);

  /**
   * @brief レンズシェーディング補正関連の設定値を設定する
   */
  void Execute();
};
#endif
