/*
 * @file   AXHOb.cpp
 * @brief  Source file of Ob settings.
 * @par    Programming Language
 *         C++
 */
#include "AXHOb.hpp"
#include "AXHRegAddr.hpp"

const unsigned int COLOR_INTERVAL[][2] = { { 2, 2 }, { 2, 4 }, { 4, 2 }, { 4, 4 }, { 2, 8 }, { 8, 2 } };

AXHOb::AXHOb() :
	  CLITVL_HLEN_POS   (6)
	, CLITVL_VLEN_POS   (7)
	, CLITVL_V_POS      (3)
	, C0CS_FIELD_SHIFT  (3)
	, PTN_INDX_MAX_CNT  (16)
	, PTN_INDX_DIV_CNT  (10)
	, OBC_EN_MASK       (0x80000000ul) {
	// 現状ハードとは異なるため不要
	/*
	// TODO 自動生成されたコンストラクター・スタブ
	init();
	*/
}

AXHOb::~AXHOb() {
	// TODO Auto-generated destructor stub
}

void AXHOb::init() {
	// LISRに設定が無いため不要
	/*
	p_RegC0CS_L     = (unsigned int*)AXH_RegC0CS_L;
	p_RegC0CS_H     = (unsigned int*)AXH_RegC0CS_H;
	p_RegDL0        = (unsigned int*)AXH_RegDL0;
	p_RegDL1        = (unsigned int*)AXH_RegDL1;
	p_RegDL2        = (unsigned int*)AXH_RegDL2;
	p_RegDL3        = (unsigned int*)AXH_RegDL3;
	p_RegDL4        = (unsigned int*)AXH_RegDL4;
	p_RegDL5        = (unsigned int*)AXH_RegDL5;
	p_RegDL6        = (unsigned int*)AXH_RegDL6;
	p_RegDL7        = (unsigned int*)AXH_RegDL7;
	p_RegCOLOR_TMG  = (unsigned int*)AXH_RegCOLOR_TMG;
	p_RegOBEAH      = (unsigned int*)AXH_RegOBEAH;
	p_RegOBEAV      = (unsigned int*)AXH_RegOBEAV;
	p_RegOBCRR0     = (unsigned int*)AXH_RegOBCRR0;
	p_RegOBCRR1     = (unsigned int*)AXH_RegOBCRR1;
	p_RegOBCRR2     = (unsigned int*)AXH_RegOBCRR2;
	p_RegOBCRR3     = (unsigned int*)AXH_RegOBCRR3;
	*/
}

void AXHOb::set_ob_area(unsigned short hStart, unsigned short hEnd, unsigned short vStart, unsigned short vEnd) {
	// LISRに設定が無いため不要
	/*
    *p_RegOBEAH = (OBC_EN_MASK | (hEnd << 16) | hStart);
    *p_RegOBEAV = ((vEnd << 16) | vStart);
	*/
}

void AXHOb::get_ob_accumlator(unsigned long* accumR, unsigned long* accumGr, unsigned long* accumB, unsigned long* accumGb) {
	// LISRに設定が無いため不要
	/*
	if (accumR != 0) {
		*accumR  = *p_RegOBCRR0;
	}
	if (accumGr != 0) {
		*accumGr = *p_RegOBCRR1;
	}
	if (accumB != 0) {
		*accumB  = *p_RegOBCRR2;
	}
	if (accumGb != 0) {
		*accumGb = *p_RegOBCRR3;
	}
	*/
}

void AXHOb::set_ob_dark_level(unsigned long dl0, unsigned long dl1, unsigned long dl2, unsigned long dl3) {
	// LISRに設定が無いため不要
	/*
	*p_RegDL0 = (-dl0) & 0x7FFF;
	*p_RegDL1 = (-dl1) & 0x7FFF;
	*p_RegDL2 = (-dl2) & 0x7FFF;
	*p_RegDL3 = (-dl3) & 0x7FFF;
	*/
}

void AXHOb::set_ob_fix_dark_level(unsigned int* dl) {
	if (dl == 0) {
		return;
	}
	// LISRに設定が無いため不要
	/*
	*p_RegDL0 = (-dl[0]) & 0x7FFF;
	*p_RegDL1 = (-dl[1]) & 0x7FFF;
	*p_RegDL2 = (-dl[2]) & 0x7FFF;
	*p_RegDL3 = (-dl[3]) & 0x7FFF;
	*p_RegDL4 = (-dl[4]) & 0x7FFF;
	*p_RegDL5 = (-dl[5]) & 0x7FFF;
	*p_RegDL6 = (-dl[6]) & 0x7FFF;
	*p_RegDL7 = (-dl[7]) & 0x7FFF;
	*/
}

void AXHOb::set_ob_sensor_array_ptn(unsigned char arrayPtn) {
	// LISRに設定が無いため不要
	/*
	bool set = true;
	unsigned int val = 0;
	switch (arrayPtn) {
	case 0:
	case 3:
		// Interval 2x2
		// Interval 4x4
		break;
	case 1:
		val = (1 << CLITVL_VLEN_POS);
		break;
	case 2:
		val = (1 << CLITVL_HLEN_POS);
		break;
	case 4:
		val = (1 << CLITVL_VLEN_POS);
		break;
	case 5:
		val = (1 << CLITVL_HLEN_POS);
		break;
	default:
		set = false;
		break;
	}
	if (set) {
		val |= ((COLOR_INTERVAL[arrayPtn][1] - 1) << CLITVL_V_POS) | (COLOR_INTERVAL[arrayPtn][0] - 1);
		*p_RegCOLOR_TMG = val;
	}
	*/
}

void AXHOb::set_ob_array_ptn_index(unsigned char* ptnIndexes) {
	// LISRに設定が無いため不要
	/*
	if (ptnIndexes == 0) {
		return;
	}
	unsigned int val = 0;
	// ０〜９までの１０個分のデータはLowデータに設定
	for (int i = 0; i < PTN_INDX_DIV_CNT; i++) {
		val |= (ptnIndexes[i] << (C0CS_FIELD_SHIFT * i));
	}
	*p_RegC0CS_L = val;

	// １０〜１５までの６個分のデータはHighデータに設定
	val = 0;
	for (int i = PTN_INDX_DIV_CNT; i < PTN_INDX_MAX_CNT; i++) {
		val |= (ptnIndexes[i] << (C0CS_FIELD_SHIFT * (i - PTN_INDX_DIV_CNT)));
	}
	*p_RegC0CS_H = val;
	*/
}
