/**
 * @file   AXHOb.hpp
 * @brief  Header file of Ob setting.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_OB_H_
#define A_X_H_OB_H_

/**
 * @class AXHOb
 * @brief AXHOb Class
 */
class AXHOb {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 */
	AXHOb();
	/**
	 * @brief  オブジェクトを開放する
	 */
	virtual ~AXHOb();

private:
	/**
	 * @brief  メンバ変数の初期化を行う
	 */
	void          init();

public:
	/**
	 * @brief  OBサンプリング領域の設定を行う
	 *
	 * @param  [in]  hStart                    OBエリア水平方向開始位置
	 * @param  [in]  hEnd                      OBエリア水平方向終了位置
	 * @param  [in]  vStart                    OBエリア垂直方向開始位置
	 * @param  [in]  vEnd                      OBエリア垂直方向終了位置
	 */
	void			set_ob_area(unsigned short hStart, unsigned short hEnd, unsigned short vStart, unsigned short vEnd);
	/**
	 * @brief	OB積算値を取得する
	 *
	 * @param  [out] accumR                    R積算値
	 * @param  [out] accumGr                   Gr積算値
	 * @param  [out] accumB                    B積算値
	 * @param  [out] accumGb                   Gb積算値
	 */
	void			get_ob_accumlator(unsigned long* accumR, unsigned long* accumGr, unsigned long* accumB, unsigned long* accumGb);
	/**
	 * @brief	黒レベルの設定を行う
	 *
	 * @param  [in]  dl0                       R黒レベル
	 * @param  [in]  dl1                       Gr黒レベル
	 * @param  [in]  dl2                       B黒レベル
	 * @param  [in]  dl3                       Gb黒レベル
	 */
	void			set_ob_dark_level(unsigned long dl0, unsigned long dl1, unsigned long dl2, unsigned long dl3);
	/**
	 * @brief	固定黒レベルの設定を行う
	 *
	 * @param  [in]  dl                        黒レベル値0〜7
	 */
	void			set_ob_fix_dark_level(unsigned int* dl);
	/**
	 * @brief	センサ配列パターン選択領域の設定を行う
	 *
	 * @param  [in]  arrayPtn                  センサ配列パターン選択領域\n
	 * @n                                      0:2x2\n
	 * @n                                      1:2x4\n
	 * @n                                      2:4x2\n
	 * @n                                      3:4x4\n
	 * @n                                      4:2x8\n
	 * @n                                      5:8x2
	 */
	void			set_ob_sensor_array_ptn(unsigned char arrayPtn);
	/**
	 * @brief	配列パターンへのインデックス設定値を設定する
	 *
	 * @param  [in]  ptnIndexes                配列パターンへのインデックス設定値
	 */
	void			set_ob_array_ptn_index(unsigned char* ptnIndexes);
private:
	/**
	 * @brief  COLOR_TMG HLENビット位置
	 */
	const unsigned int CLITVL_HLEN_POS;
	/**
	 * @brief  COLOR_TMG VLENビット位置
	 */
	const unsigned int CLITVL_VLEN_POS;
	/**
	 * @brief  COLOR_TMG CLITVL_Vビット開始位置
	 */
	const unsigned int CLITVL_V_POS;
	/**
	 * @brief  C0CS_L各フィールド間シフト量
	 */
	const unsigned int C0CS_FIELD_SHIFT;
	/**
	 * @brief  配列パターンへのインデックス設定データ数
	 */
	const int          PTN_INDX_MAX_CNT;
	/**
	 * @brief  配列パターンへのインデックスHIGH開始データ位置
	 */
	const int          PTN_INDX_DIV_CNT;
	/**
	 * @brief  OBモード設定・取得マスク
	 */
	const unsigned int OBC_EN_MASK;

	/**
	 * @brief  Color Select Timing Low設定アドレス
	 */
	unsigned int* p_RegC0CS_L;
	/**
	 * @brief  Color Select Timing High設定アドレス
	 */
	unsigned int* p_RegC0CS_H;
	/**
	 * @brief  Dark Level correction value Color index 0設定アドレス
	 */
	unsigned int* p_RegDL0;
	/**
	 * @brief  Dark Level correction value Color index 1設定アドレス
	 */
	unsigned int* p_RegDL1;
	/**
	 * @brief  Dark Level correction value Color index 2設定アドレス
	 */
	unsigned int* p_RegDL2;
	/**
	 * @brief  Dark Level correction value Color index 3設定アドレス
	 */
	unsigned int* p_RegDL3;
	/**
	 * @brief  Dark Level correction value Color index 4設定アドレス
	 */
	unsigned int* p_RegDL4;
	/**
	 * @brief  Dark Level correction value Color index 5設定アドレス
	 */
	unsigned int* p_RegDL5;
	/**
	 * @brief  Dark Level correction value Color index 6設定アドレス
	 */
	unsigned int* p_RegDL6;
	/**
	 * @brief  Dark Level correction value Color index 7設定アドレス
	 */
	unsigned int* p_RegDL7;
	/**
	 * @brief  Color Select Timing設定アドレス
	 */
	unsigned int* p_RegCOLOR_TMG;
	/**
	 * @brief  OBサンプリング領域幅設定アドレス
	 */
	unsigned int* p_RegOBEAH;
	/**
	 * @brief  OBサンプリング領域高さ設定アドレス
	 */
	unsigned int* p_RegOBEAV;
	/**
	 * @brief  OB積算値0取得アドレス
	 */
	unsigned int* p_RegOBCRR0;
	/**
	 * @brief  OB積算値1取得アドレス
	 */
	unsigned int* p_RegOBCRR1;
	/**
	 * @brief  OB積算値2取得アドレス
	 */
	unsigned int* p_RegOBCRR2;
	/**
	 * @brief  OB積算値3取得アドレス
	 */
	unsigned int* p_RegOBCRR3;
};

#endif /* A_X_H_OB_H_ */
