/**
 * @file   AXHOpdData.hpp
 * @brief  Header file of OPD Data for AE and AWB.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_OPD_DATA_H
#define A_X_H_OPD_DATA_H

#define CNV_BYER_TO_OPD

#ifdef CNV_BYER_TO_OPD
#define BAYER_ROW 0x16		// ROW(0d22)
#define BAYER_COL 0x28		// COLUMN(0d40)

/**
 * @enum
 * @brief OPDデータタイプ
 * @n   以前環境がLittleEndianで
 * @n   動作していると考えられるため
 * @n   今回も合わせてBGRYとする
 */
enum OpdDataType {
	OPD_D_TYPE_B = 0,
	OPD_D_TYPE_G,
	OPD_D_TYPE_R,
	OPD_D_TYPE_Y,
	OPE_D_TYPE_MAX,
};

/**
 * @struct  ST_BAYER_I
 * @n   ベイヤー配列格納用構造体（各32bit）
 */
typedef struct _st_bayer_i
{
	unsigned int gr;
	unsigned int r;
	unsigned int b;
	unsigned int gb;
} ST_BAYER_TYPE_I;
#endif
#endif
