/**
 * @file   AXHOpdDataAE.hpp
 * @brief  Header file of OPD Data for AE class.
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_OPD_DATA_A_E_H
#define A_X_H_OPD_DATA_A_E_H

#include "AXHOpdData.hpp"

#ifdef CNV_BYER_TO_OPD
#define AE_OPD_ROW BAYER_ROW >> 2		// 1/4（22/4=5)※少数以下切り捨て
#define AE_OPD_COL BAYER_COL >> 2		// 1/4（40/4=10)※少数以下切り捨て

static unsigned char ae_opd_data[AE_OPD_ROW][AE_OPD_COL][OPE_D_TYPE_MAX];	// OPDデータ（ベイヤー配列から変換後データ格納）
#endif

/**
 * @class AXHOpdDataAE
 * @brief OPD Data for AE Class
 * 
 */
class AXHOpdDataAE {
 public:
  /**
   * @brief  オブジェクトを初期化する
   */
  AXHOpdDataAE();

  /**
   * @brief  オブジェクトを開放する
   */
  ~AXHOpdDataAE();

  /**
   * @brief getOpdData
   *
   * OPDデータ格納先アドレス取得
   */
  unsigned char* getOpdData(int cmd);

#ifdef CNV_BYER_TO_OPD
  /**
   * @brief cnvBayerToOpd
   *
   * ベイヤデータ格納先アドレスからベイヤーデータを取得しOPDデータに変換し格納アドレスを返す
   */
  unsigned char* cnvBayerToOpd(void);
#endif
};
#endif
