/**
 * @file   AXHRegDefine.hpp
 * @brief  Header file of Register Definition
 * @par    Programming Language
 *         C++
 */
#ifndef A_X_H_REGDEFINE_H
#define A_X_H_REGDEFINE_H

const unsigned int  AXH_MASK_1BIT  = 0x00000001ul;
const unsigned int  AXH_MASK_2BIT  = 0x00000003ul;
const unsigned int  AXH_MASK_13BIT = 0x00001FFFul;
const unsigned int  AXH_MASK_14BIT = 0x00003FFFul;

const unsigned int  AXH_BIT_SPU_C_CPEN     = 0x00000400ul;
const unsigned int  AXH_BIT_SPU_C_DEFCSL   = 0x00008000ul;
const unsigned int  AXH_BIT_SPU_C_DMAW0SEL = 0x00040000ul;  //  SPU Control
const unsigned int  AXH_BIT_SPU_C_RPULNKEN = 0x00080000ul;  //  MIX Control

//const unsigned int  AXH_MASK_SPU_C_DEFCSL = 0x00000001ul;
const unsigned int  AXH_SFT_SPU_C_DEFCSL  = 15;

const unsigned int  AXH_BIT_DEFCT_C_ADFCTEN = 0x00000001ul;
//const unsigned int  AXH_MASK_DEFCT_C_ADFCTEN = 0x00000001ul;
const unsigned int  AXH_SFT_DEFCT_C_ADFCTEN = 0;

const unsigned int  AXH_SFT_DEFCT_C_CDEF_CLS_AUTO = 1;
const unsigned int  AXH_MASK_DEFCT_C_CDEF_CLS_AUTO = (0x00000003ul << AXH_SFT_DEFCT_C_CDEF_CLS_AUTO);

const unsigned int  AXH_SFT_DEFCT_C_C0CDEFAVE = 16;
const unsigned int  AXH_MASK_DEFCT_C_C0CDEFAVE = (AXH_MASK_2BIT << AXH_SFT_DEFCT_C_C0CDEFAVE);

//const unsigned int  AXH_MASK_CDEF_H_V = 0x00001FFFul;
const unsigned int  AXH_SFT_CDEF_H =  0;
const unsigned int  AXH_SFT_CDEF_V = 13;
//const unsigned int  AXH_MASK_CDEF_CLS = 0x00000003ul;
const unsigned int  AXH_SFT_CDEF_CLS = 30;

const unsigned int  AXH_SFT_ADFCTTH_H_ADFCT_WTL = 16;
const unsigned int  AXH_MASK_ADFCTTH_H_ADFCT_WTL = (AXH_MASK_14BIT << AXH_SFT_ADFCTTH_H_ADFCT_WTL);

const unsigned int  AXH_SFT_ADFCTTH_L_ADFCT_DKL = 16;
const unsigned int  AXH_MASK_ADFCTTH_L_ADFCT_DKL = (AXH_MASK_14BIT << AXH_SFT_ADFCTTH_L_ADFCT_DKL);

const unsigned int AXH_SFT_ADFOFS_L =  0;
const unsigned int AXH_SFT_ADFOFS_H = 16;
const unsigned int AXH_MASK_ADFOFS_L = (AXH_MASK_14BIT << AXH_SFT_ADFOFS_L);
const unsigned int AXH_MASK_ADFOFS_H = (AXH_MASK_14BIT << AXH_SFT_ADFOFS_H);
const unsigned int AXH_INDEX_ADFOFS_H = 0x00000001ul;

const unsigned int AXH_LMBC_Init = 0x00007777ul;            ///< レジスタ:LMBC初期値

const unsigned int AXH_MASK_CSCF = 0x0003FFFFul;
const unsigned int AXH_MASK_CSOS = 0x00007FFFul;

#endif  //  A_X_H_REGDEFINE_H
