/*
 * @file   AXHScaler.cpp
 * @brief  Source file of Scaler settings.
 * @par    Programming Language
 *         C++
 */
#include "AXHScaler.hpp"
#include "AXHRegAddr.hpp"
//#define CONNECT_TEST
#ifdef CONNECT_TEST
#include <iostream>
#endif

// ビット設定
#define       SCL_IMAGE_HEIGHT_SHIFT        (16)
#define       SCL_NEG                       (1)
#define       SCL_H_FLIP                    (1<<8)
#define       SCL_V_FLIP                    (1<<12)

// 入出力画像設定
static const int        IMG_ADDRESS_CNT = 3;

// ネガポジ・上下左右反転設定
static const int        NEG_FLIP_ADDRESS_CNT = 5;
static const unsigned int* src_address[] = { (unsigned int*)AXH_REG_ISP_SCL_SRC0, (unsigned int*)AXH_REG_ISP_SCL_SRC1, (unsigned int*)AXH_REG_ISP_SCL_SRC2 };
static const unsigned int* dst_address[] = { (unsigned int*)AXH_REG_ISP_SCL_DST0, (unsigned int*)AXH_REG_ISP_SCL_DST1, (unsigned int*)AXH_REG_ISP_SCL_DST2 };
static const unsigned int* neg_flip_address[] = { (unsigned int*)AXH_REG_ISP_SCL_NEG_FLIP0, (unsigned int*)AXH_REG_ISP_SCL_NEG_FLIP1, (unsigned int*)AXH_REG_ISP_SCL_NEG_FLIP2, (unsigned int*)AXH_REG_ISP_SCL_NEG_FLIP3, (unsigned int*)AXH_REG_ISP_SCL_NEG_FLIP4 };

//static unsigned char picNum = 0;
AXHScaler::AXHScaler() :
	  SCL_DIO_SATD8X8_CLEAR_MASK (0x03FFFFFF)
	, IMAGE_DST_SIZE_MAX         (0x00003FFF)
	, IMAGE_SRC_SIZE_MAX         (0x00000FFF)
{
	// TODO 自動生成されたコンストラクター・スタブ
}

AXHScaler::~AXHScaler() {
	// TODO Auto-generated destructor stub
}

void AXHScaler::set_scaler_src_img_size(unsigned char ch, unsigned short width, unsigned short height) {
	// 現状ハードとは異なるため不要
	/*
	// 0〜2chのみ有効
	if (IMG_ADDRESS_CNT <= ch) {
		return;
	}
	if (width == 0 || height == 0) {
		return;
	}
	if (IMAGE_SRC_SIZE_MAX < width || IMAGE_SRC_SIZE_MAX < height) {
		return;
	}

	SetReg32(src_address[ch], (unsigned int)((height << SCL_IMAGE_HEIGHT_SHIFT) | width));
#ifdef PARASOFT_CPPTEST
	CPPTEST_val1 = (unsigned int)src_address[ch];
	CPPTEST_val2 = (unsigned int)((height << SCL_IMAGE_HEIGHT_SHIFT) | width);
#endif  //  PARASOFT_CPPTEST
#ifdef CONNECT_TEST
	std::cout << "scaler src image:" << std::endl;
	std::cout << "ch    :" << (unsigned int)ch << std::endl;
	std::cout << "width :" << (unsigned int)width << std::endl;
	std::cout << "height:" << (unsigned int)height << std::endl;
#endif
	*/
}

void AXHScaler::set_scaler_dst_img_size(unsigned char ch, unsigned short width, unsigned short height) {
	// 現状ハードとは異なるため不要
	/*
	// 0〜2chのみ有効
	if (IMG_ADDRESS_CNT <= ch) {
		return;
	}
	if (width == 0 || height == 0) {
		return;
	}
	if (IMAGE_DST_SIZE_MAX < width || IMAGE_DST_SIZE_MAX < height) {
		return;
	}
	SetReg32(dst_address[ch], (unsigned int)((height << SCL_IMAGE_HEIGHT_SHIFT) | width));
#ifdef PARASOFT_CPPTEST
	CPPTEST_val1 = (unsigned int)dst_address[ch];
	CPPTEST_val2 = (unsigned int)((height << SCL_IMAGE_HEIGHT_SHIFT) | width);
#endif  //  PARASOFT_CPPTEST
#ifdef CONNECT_TEST
	std::cout << "scaler dst image:" << std::endl;
	std::cout << "ch    :" << (unsigned int)ch << std::endl;
	std::cout << "width :" << (unsigned int)width << std::endl;
	std::cout << "height:" << (unsigned int)height << std::endl;
#endif
	*/
}

void AXHScaler::set_scaler_neg_flip(unsigned char ch, unsigned char vflip, unsigned char hflip, unsigned char neg) {
	// 現状ハードとは異なるため不要
	/*
	// 0〜4chまで有効
	if (NEG_FLIP_ADDRESS_CNT <= ch) {
		return;
	}
	unsigned int val = 0;

	if (1 == vflip) {
		val |= SCL_V_FLIP;
	}
	if (1 == hflip) {
		val |= SCL_H_FLIP;
	}
	if (1 == neg) {
		val |= SCL_NEG;
	}
	SetReg32(neg_flip_address[ch], val);
#ifdef PARASOFT_CPPTEST
	CPPTEST_val2 = (unsigned int)neg_flip_address[ch];
	CPPTEST_val1 = val;
#endif  //  PARASOFT_CPPTEST
#ifdef CONNECT_TEST
	std::cout << "scaler neg flip:" << std::endl;
	std::cout << "ch    :" << (unsigned int)ch << std::endl;
	std::cout << "vflip :" << (unsigned int)vflip << std::endl;
	std::cout << "hflip :" << (unsigned int)hflip << std::endl;
	std::cout << "neg   :" << (unsigned int)neg << std::endl;
#endif
	*/
}

void AXHScaler::get_scaler_satd(unsigned int* satd) {
	// 現状ハードとは異なるため不要
	/*
	if (satd == 0) {
		return;
	}
	unsigned int val = 0;
	*satd = 0;
	val = GetReg32(AXH_REG_ISP_SCL_SATD8X8);
#ifdef PARASOFT_CPPTEST
	val = 0xFFFFFFFF;
#endif  //  PARASOFT_CPPTEST
	*satd = (unsigned int)(val & SCL_DIO_SATD8X8_CLEAR_MASK);
#ifdef PARASOFT_CPPTEST
	CPPTEST_val1 = *satd;
#endif  //  PARASOFT_CPPTEST
#ifdef CONNECT_TEST
	std::cout << "scaler satd get:" << std::endl;
	std::cout << "satd  :" << *satd << std::endl;
#endif
	*/

}
