/*
 * @file   AXHSpec.cpp
 * @brief  Source file of Spec class.
 * @par    Programming Language
 *         C++
 */

#include <string.h>
#include "AXHSpec.hpp"
#include "AXHCommonConfig.hpp"
#include "AXHCommonParam.hpp"
#include "AXHSpecStruct.hpp"
#include "AXHSpecAwbParam.hpp"
#include "AXHSpecInit.hpp"


ST_SPEC    g_spec                                __attribute__ ((at (0x20058000)));		//今回セクション名では無く直接アドレス指定を行う ((section ("ispParam0")));
ST_CDEF    g_Defect_Addr[AXH_Defect_ExtAddr_Max] __attribute__ ((section ("ispParamDefect")));	// 今回使用しないため容量が不足するようであれば本変数を削除する
ST_CORRECT g_Correct                             __attribute__ ((section ("ispParamShade")));		// 今回使用しないため容量が不足するようであれば本変数を削除する

AXHSpec::AXHSpec() {
}

AXHSpec::AXHSpec(AXH_SPEC_MODE mode) {
  if(mode == AXH_Spec_Mode_Default) {
    setDefault();
  }
}

AXHSpec::~AXHSpec() {
}

void AXHSpec::setDefault() {
  //  設定値格納用変数領域初期化
  memset(&g_spec, 0, sizeof(g_spec));
  //  設定値更新要求フラグON(起動時)
  g_spec.changeStatus[0] = 0xFFFFFFFFul;
  g_spec.changeStatus[1] = 0xFFFFFFFFul;
  //  シミュレータ用初期値
  //  動作モード設定
  g_spec.Mode = 0;
  //  AWB設定値
  setDefault_AWB();

  // Linear動作モード
  g_spec.imageIFOpeMode = 1;

  setDefault_Scaler();

  //  RGBマトリックス
  for(unsigned int i = 0; i < AXH_RGBMatrixSetOut_Max; i++) {
    for(unsigned int j = 0; j < AXH_RGBMatrixSetIn_Max; j++) {
      if(i==j) {
        g_spec.RGBMatrix.Coef[i][j] = 0x0100u;
      }
      else {
        g_spec.RGBMatrix.Coef[i][j] = 0x0000u;
      }
    }
    g_spec.RGBMatrix.Offset[i] = 0x0000u;
  }

  //  画素欠陥補正
  //  モード設定
  g_spec.Defect.Mode.External = 1;
  //  内部モード時アドレス設定
  for(unsigned int i = 0; i < AXH_Defect_IntAddr_Max; i++) {
    g_spec.Defect.Address[i].H = AXH_DEFECT_CDEF_H_Init;
    g_spec.Defect.Address[i].V = AXH_DEFECT_CDEF_V_Init;
    g_spec.Defect.Address[i].CLS = 0;
  }
  //  白欠陥アドレス静的検出方法設定
  g_spec.Defect.DetectSet.TH = 0x007Fu;                     //  14Bitの中間をしきい値として設定
  //  AE状態設定
  g_spec.Defect.DetectSet.AE.ShutterSpeed = 1000;
  g_spec.Defect.DetectSet.AE.Gain = 0;
  g_spec.Defect.DetectSet.AE.IrisCloseMode = 1;
  //  レンズシェーディング補正設定値(仮設定値)
  g_spec.LensShade.Enabled = 0;
  g_spec.LensShade.Pitch = 60;
  g_spec.LensShade.Shift = 5;
  //  レンズシェーディング補正データ
  //  1〜8ライン目
  for(unsigned int i = 0; i < 8; i++) {
	for(unsigned int j = 0; j < AXH_Shade_Grid_Width; j++) {
      g_Correct.Data[i][j] = 0x60606060ul;
	}
  }
  //  9〜24ライン目
  for(unsigned int i = 8; i < 24; i++) {
	for(unsigned int j = 0; j < 8; j++) {
      g_Correct.Data[i][j] = 0x60606060ul;
	}
	for(unsigned int j = 8; j < 24; j++) {
      g_Correct.Data[i][j] = 0x44444444ul;
	}
	for(unsigned int j = 24; j < AXH_Shade_Grid_Width; j++) {
      g_Correct.Data[i][j] = 0x60606060ul;
	}
  }
  //  25〜35ライン目
  for(unsigned int i = 24; i < AXH_Shade_Grid_Height_Max; i++) {
	for(unsigned int j = 0; j < AXH_Shade_Grid_Width; j++) {
      g_Correct.Data[i][j] = 0x60606060ul;
	}
  }
  //  IRIDIX設定値
  g_spec.Iridix.Strength = 0x80;
  g_spec.Iridix.MinSlope = 0x40;
  g_spec.Iridix.MaxSlope = 0x40;
  //  NR設定値(仮設定値)
  g_spec.NR.Mode = 0x00000004ul;
  //  3DNR
  g_spec.NR.Main.YTH[0] = 0x09u;
  g_spec.NR.Main.YIN[0] = 0x27u;
  g_spec.NR.Main.YLV[0] = 0x00u;
  g_spec.NR.Main.CTH[0] = 0x09u;
  g_spec.NR.Main.CIN[0] = 0x27u;
  g_spec.NR.Main.CLV[0] = 0x00u;
  for(unsigned int i = 1; i < AXH_NR_Main_Max; i++) {
    g_spec.NR.Main.YTH[i] = 0x08u;
    g_spec.NR.Main.YIN[i] = 0x31u;
    g_spec.NR.Main.YLV[i] = 0x00u;
    g_spec.NR.Main.CTH[i] = 0x08u;
    g_spec.NR.Main.CIN[i] = 0x31u;
    g_spec.NR.Main.CLV[i] = 0x00u;
  }
  //  2DNR
  for(unsigned int i = 0; i < AXH_NR_Sub_Max; i++) {
    g_spec.NR.Sub.YTH[i] = 0x10u;
    g_spec.NR.Sub.YIN[i] = 0x40u;
    g_spec.NR.Sub.YLV[i] = 0x00u;
    g_spec.NR.Sub.CTH[i] = 0x10u;
    g_spec.NR.Sub.CIN[i] = 0x40u;
    g_spec.NR.Sub.CLV[i] = 0x00u;
  }
  // OB調整初回設定値
  setDefault_OB();

  // ガンマ補正補正初回設定値
  setDefault_Gamma();

  // アパーチャ補正初回設定値
  setDefault_Aperture();

  // クロマサプレス初回設定値
  setDefault_Chroma();
	
  // AEデフォルト値設定
  setDefault_AE();

  // AFデフォルト値設定
  setDefault_AF();

  // ImageSensorデフォルト値設定
  setDefault_ImageSensor();

  // DayNightデフォルト値設定
  setDefault_DayNight();

}

void AXHSpec::setDefault_AWB() {
  //  [AWB-1]ATWモード選択
  g_spec.AWB.AWBMode = AWBMode_ATWMode;                     //  ATW標準モード
  //  [AWB-2]ATWシーンモード選択
  g_spec.AWB.ATWSceaneMode = 1;                             //  屋内蛍光灯モード
  //  [AWB-3]色温度指定(色温度指定マニュアルモード時)
  g_spec.AWB.ManuModeColorTemp = 5000;                      //  5000K
  //  [AWB-4]照明指定(照明指定マニュアルモード時)
  g_spec.AWB.ManuModeLightSelect = 2;                       //  白色蛍光灯
  //  [AWB-5]全引込み実行設定
  //  OPDエリア設定
  g_spec.AWB.OnePush.Area[AWBOnePushPnt_Start].h = 16;
  g_spec.AWB.OnePush.Area[AWBOnePushPnt_Start].v = 14;
  g_spec.AWB.OnePush.Area[AWBOnePushPnt_End  ].h = 25;
  g_spec.AWB.OnePush.Area[AWBOnePushPnt_End  ].v = 23;
  g_spec.AWB.OnePush.Range = AWBOnePushRange_ALL;           //  引き込み範囲指定(全範囲)
  g_spec.AWB.OnePush.Speed = 5;                             //  引込み速度
  //  [AWB-6]引き込み範囲
  g_spec.AWB.LightRange.HTempAdjust = 10000;
  g_spec.AWB.LightRange.LTempAdjust = 2400;
  g_spec.AWB.LightRange.MgDirAdjust = 100;
  g_spec.AWB.LightRange.GDirAdjust = 100;
  //  [AWB-7]オフセット調整設定
  for(int i = 0; i < AWBLightSource_Max; i++) {
    g_spec.AWB.Offset.Pnt[i].Bg = 0;
    g_spec.AWB.Offset.Pnt[i].Rg = 0;
  }
  //  [AWB-8]カラーマトリックス調整設定
  for(int i = 0; i < AWBLightSource_Max; i++) {
    g_spec.AWB.AdjustMatrix.Matrix[i].AJCF11 = 0x0100u;     //  Cbクロマゲイン
    g_spec.AWB.AdjustMatrix.Matrix[i].AJCF12 = 0x0100u;     //  Cbマトリックスゲイン
    g_spec.AWB.AdjustMatrix.Matrix[i].AJCF21 = 0x0100u;     //  Crマトリックスゲイン
    g_spec.AWB.AdjustMatrix.Matrix[i].AJCF22 = 0x0100u;     //  Crクロマゲイン
  }
  g_spec.AWB.AdjustMatrix.Matrix[AWBLightSource_A  ].AJCF22 = 0x00D0u;          //  白熱灯:Crクロマゲイン
  g_spec.AWB.AdjustMatrix.Matrix[AWBLightSource_Day].AJCF22 = 0x00C0u;          //  昼光:Crクロマゲイン
  //  [AWB-9]AWBマニュアルモード時ゲイン指定
  g_spec.AWB.WBGain.bGain = AXH_AWB_WB_BGain_Init;
  g_spec.AWB.WBGain.rGain = AXH_AWB_WB_RGain_Init;
  //  [AWB-10]AWB遷移特性設定
#ifdef IMX662
  g_spec.AWB.Convergence.Speed = 10;                        //  引込み速度
#elif IMX415	// IMX662
  // IMX415用
  g_spec.AWB.Convergence.Speed = 6;                        //  引込み速度
#else	// IMX662
  // IMX412,IMX415用
  g_spec.AWB.Convergence.Speed = 2;                        //  引込み速度
#endif	// IMX662
#ifndef ENABLE_AF_LENS_DATA
  g_spec.AWB.Convergence.LightTH = 100;                     //  照明変化閾値
  g_spec.AWB.Convergence.StableTH = 50;                     //  安定性確認閾値
#else   //  ENABLE_AF_LENS_DATA
  g_spec.AWB.Convergence.LightTH =  60;                     //  照明変化閾値
  g_spec.AWB.Convergence.StableTH = 30;                     //  安定性確認閾値
#endif  //  ENABLE_AF_LENS_DATA
#ifdef IMX662
  g_spec.AWB.Convergence.StableTerm = 10;                   //  安定性確認期間
#else	// IMX662
  // IMX412,IMX415用
  g_spec.AWB.Convergence.StableTerm = 5;                   //  安定性確認期間
#endif	// IMX662
  //  [AWB-11]光源枠重み付け設定
  //   0.白熱灯
  g_spec.AWB.LightWeight.Weight[AWBLightSource_A].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_A].WeightH = 0;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_A].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_A].LimitH = 10000;
  //   1.電球色蛍光灯
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbF].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbF].WeightH = 0;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbF].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbF].LimitH = 10000;
  //   2.白色蛍光灯
  g_spec.AWB.LightWeight.Weight[AWBLightSource_CWF].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_CWF].WeightH = 0;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_CWF].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_CWF].LimitH = 10000;
  //   3.昼白色蛍光灯
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayWF].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayWF].WeightH = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayWF].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayWF].LimitH = 10000;
  //   4.昼光色蛍光灯
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayF].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayF].WeightH = 4;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayF].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayF].LimitH = 10000;
  //   5.昼光
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Day].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Day].WeightH = 4;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Day].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Day].LimitH = 10000;
  //   6.雲天
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Cloudy].WeightL = 1;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Cloudy].WeightH = 4;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Cloudy].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Cloudy].LimitH = 10000;
  //   7.水銀灯
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Merculy].WeightL = 1;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Merculy].WeightH = 0;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Merculy].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_Merculy].LimitH = 10000;
  //   8.ナトリウムランプ
  g_spec.AWB.LightWeight.Weight[AWBLightSource_NaLamp].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_NaLamp].WeightH = 0;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_NaLamp].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_NaLamp].LimitH = 10000;
  //   9.電球色LED
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbLED].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbLED].WeightH = 0;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbLED].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_EBulbLED].LimitH = 10000;
  //   10.白色LED
  g_spec.AWB.LightWeight.Weight[AWBLightSource_WhiteLED].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_WhiteLED].WeightH = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_WhiteLED].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_WhiteLED].LimitH = 10000;
  //   11.昼光色LED
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayLED].WeightL = 2;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayLED].WeightH = 4;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayLED].LimitL = 2000;
  g_spec.AWB.LightWeight.Weight[AWBLightSource_DayLED].LimitH = 10000;
  //  [AWB-12]ATW停止閾値設定
  g_spec.AWB.stopLowBrightTH = 0;
  //  [AWB-13]OPD設定
  g_spec.AWB.OPDSet.HDiv = AXH_AWB_OPD_H_Div;
  g_spec.AWB.OPDSet.VDiv = AXH_AWB_OPD_V_Div;
  g_spec.AWB.OPDSet.LLimit = 0;
  g_spec.AWB.OPDSet.HLimit = 0xFFFFu;
  //  [AWB-14]OPD重み付け仮設定
  g_spec.AWB.OPDWeight.V1 = 10;
  g_spec.AWB.OPDWeight.H2 = 7;
  g_spec.AWB.OPDWeight.H3 = 30;
  g_spec.AWB.OPDWeight.V4 = 25;
  g_spec.AWB.OPDWeight.WeightMode[AWB_OPDArea_Idx_0] = AWBWeightMode_1;
  g_spec.AWB.OPDWeight.WeightMode[AWB_OPDArea_Idx_1] = AWBWeightMode_1;
  g_spec.AWB.OPDWeight.WeightMode[AWB_OPDArea_Idx_2] = AWBWeightMode_1;
  g_spec.AWB.OPDWeight.WeightMode[AWB_OPDArea_Idx_3] = AWBWeightMode_1;
  g_spec.AWB.OPDWeight.WeightMode[AWB_OPDArea_Idx_4] = AWBWeightMode_1;
  //  [AWB-15]OPDマスクデータ仮設定
  {
    int index = 0;
    //  0/35行目マスク
    for(int i = 0; i < 40; i++)
    {
      g_spec.AWB.OPDMask.Pnt[index  ].h = i;
      g_spec.AWB.OPDMask.Pnt[index++].v = 0;
      g_spec.AWB.OPDMask.Pnt[index  ].h = i;
      g_spec.AWB.OPDMask.Pnt[index++].v = AXH_AWB_OPD_V_Div - 1;
    }
  }
  //  [AWB-17]光源枠仮設定
#ifndef ENABLE_AF_LENS_DATA
#ifdef IMX662
  //  0.白熱灯枠
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Bg =  -6;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Rg = 489;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Bg =   0;	// 59;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Rg = 489;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Bg =  88;	// 111;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Rg = 210;	// 254;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Rg = 175;
  //  1.電球色蛍光灯
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Bg =  -6;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Rg = 489;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Bg =   0;	// 59;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Rg = 489;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Bg =  88;	// 111;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Rg = 210;	// 254;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Rg = 175;
  //  2.白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Rg = 175;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Bg =  88;	// 111;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Rg = 210;	// 254;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Bg = 122;	// 127;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Rg = 190;	// 215;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Rg = 137;
  //  3.昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Bg = 122;	// 127;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Rg = 190;	// 215;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Rg = 190;	// 208;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Rg = 123;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Rg = 137;
  //  4.昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Rg = 208;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Bg = 174;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Rg = 195;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Bg = 174;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Rg = 116;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Rg = 123;
  //  5.昼光枠
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Rg = 221;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Bg = 166;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Rg = 188;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Bg = 166;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Rg = 116;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Rg = 123;
  //  6.雲天/日陰枠
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Bg = 166;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Rg = 188;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Bg = 217;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Rg = 181;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Bg = 217;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Rg = 110;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Bg = 166;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Rg = 116;
  //  7.水銀灯枠
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Rg = 137;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Rg = 123;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Bg = 132;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Rg =  90;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Rg = 103;
  //  8.ナトリウムランプ
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Bg =   6;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Rg = 555;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Rg = 555;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Rg = 332;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Rg = 254;
  //  9.電球色LED
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Bg =  -6;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Rg = 489;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Bg =  59;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Rg = 489;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Rg = 254;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Rg = 175;
  //  10.白色LED
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Rg = 175;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Rg = 254;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Rg = 208;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Rg = 123;
  //  11.昼光色LED
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Rg = 208;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Bg = 174;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Rg = 195;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Bg = 174;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Rg = 116;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Rg = 123;
  //  12.カラーローリング検知時白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Bg =  69;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Rg = 175;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Rg = 254;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Bg = 127;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Rg = 215;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Rg = 137;
  //  13.カラーローリング検知時昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Bg = 127;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Rg = 215;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Rg = 208;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Rg = 123;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Bg = 111;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Rg = 137;
  //  14.カラーローリング検知時昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Rg = 208;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Bg = 174;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Rg = 195;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Bg = 174;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Rg = 116;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Rg = 123;
#elif IMX415	// IMX662
  // IMX415用
  //  0.白熱灯枠
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Bg = -42;	//-34;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Rg = 1259;	//672;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Bg =  32;	//51;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Rg = 1259;	//672;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Bg =  73;	//99;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Rg = 287;	//243;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Bg =  44;	//65;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Rg = 158;	//186;
  //  1.電球色蛍光灯
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Bg = -42;	//-34;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Rg = 1259;	//672;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Bg =  32;		//51;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Rg = 1259;	//672;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Bg =  73;		//99;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Rg = 287;		//243;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Bg =  44;		//65;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Rg = 158;		//186;
  //  2.白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Bg =  44;	//65;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Rg = 158;	//186;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Bg =  73;	//99;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Rg = 287;	//243;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Bg = 101;	//132;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Rg = 168;	//190;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Bg = 91;		//120;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Rg = 32;		//129;
  //  3.昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Bg = 101;	//132;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Rg = 168;	//190;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Rg = 168;	//190;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Rg = -18;	//107;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Bg = 91;		//120;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Rg = 32;		//129;
  //  4.昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Bg = 127;		//161;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Rg = 274;		//237;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Bg = 161;		//201;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Rg = 230;		//218;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Bg = 161;		//201;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Rg =  -43;	//96;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Bg = 127;		//161;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Rg = -18;		//107;
  //  5.昼光枠
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Rg = 316;	//256;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Bg = 152;	//190;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Rg = 204;	//206;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Bg = 152;	//190;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Rg =  -43;	//96;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Rg = -18;	//107;
  //  6.雲天/日陰枠
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Bg = 152;	//190;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Rg = 204;	//206;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Bg = 210;	//257;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Rg = 179;	//195;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Bg = 210;	//257;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Rg =  -64;	//87;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Bg = 152;	//190;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Rg =  -43;	//96;
  //  7.水銀灯枠
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Bg = 91;	//120;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Rg = 32;	//129;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Rg = -18;	//107;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Bg = 115;	//147;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Rg =  -131;	//57;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Bg = 91;	//120;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Rg = -87;	//77;
  //  8.ナトリウムランプ
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Bg = -29;	//-19;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Rg = 1494;	//775;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Bg = 44;	//65;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Rg = 1494;	//775;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Bg = 91;	//120;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Rg = 708;	//429;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Bg =  44;	//65;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Rg = 429;	//306;
  //  9.電球色LED
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Bg = -42;	//-34;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Rg = 1259;	//672;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Bg =  32;	//51;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Rg = 1259;	//672;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Bg = 91;	//120;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Rg = 429;	//306;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Bg =  44;	//65;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Rg = 158;	//186;
  //  10.白色LED
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Bg = 44;	//65;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Rg = 158;	//186;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Bg = 91;	//120;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Rg = 429;	//306;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Rg = 274;	//237;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Rg = -18;	//107;
  //  11.昼光色LED
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Rg = 274;	//237;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Bg = 161;	//201;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Rg = 230;	//218;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Bg = 161;	//201;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Rg =  -43;	//96;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Rg = -18;	//107;
  //  12.カラーローリング検知時白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Bg =  23;	//41;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Rg = 89;	//155;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Bg = 82;	//109;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Rg = 446;	//313;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Bg = 104;	//135;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Rg = 268;	//235;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Bg = 82;	//109;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Rg =  -81;	//79;
  //  13.カラーローリング検知時昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Bg = 104;	//135;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Rg = 268;	//235;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Rg = 238;	//222;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Rg =  -146;	//51;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Bg = 82;	//109;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Rg =  -81;	//79;
  //  14.カラーローリング検知時昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Rg = 238;	//222;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Bg = 169;	//211;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Rg = 181;	//196;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Bg = 169;	//211;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Rg =  -178;	//37;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Bg = 127;	//161;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Rg =  -146;	//51;
#else	// IMX662
  // IMX412用
  //  0.白熱灯枠
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Bg = -81;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Rg = 789;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Bg =  24;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Rg = 789;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Bg =  84;	// 109;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Rg = 230;	// 313;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Rg = 155;
  //  1.電球色蛍光灯
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Bg = -81;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Rg = 789;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Bg =  24;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Rg = 789;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Bg =  84;	// 109;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Rg = 230;	// 313;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Rg = 155;
  //  2.白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Rg = 155;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Bg =  84;	// 109;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Rg = 230;	// 313;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Bg = 125;	// 135;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Rg = 160;	// 235;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Rg =  79;
  //  3.昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Bg = 125;	// 135;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Rg = 160;	// 235;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Bg = 161;	// 161;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Rg = 160;	// 222;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Rg =  51;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Rg =  79;
  //  4.昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Rg = 222;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Bg = 211;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Rg = 196;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Bg = 211;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Rg =  37;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Rg =  51;
  //  5.昼光枠
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Rg = 247;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Bg = 198;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Rg = 181;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Bg = 198;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Rg =  37;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Rg =  51;
  //  6.雲天/日陰枠
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Bg = 198;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Rg = 181;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Bg = 281;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Rg = 167;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Bg = 281;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Rg =  25;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Bg = 198;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Rg =  37;
  //  7.水銀灯枠
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Rg =  79;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Rg =  51;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Bg = 143;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Rg = -15;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Rg =  11;
  //  8.ナトリウムランプ
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Bg = -63;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Rg = 923;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Rg = 923;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Rg = 472;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Rg = 313;
  //  9.電球色LED
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Bg = -81;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Rg = 789;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Bg =  24;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Rg = 789;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Rg = 313;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Rg = 155;
  //  10.白色LED
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Rg = 155;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Rg = 313;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Rg = 222;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Rg =  51;
  //  11.昼光色LED
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Rg = 222;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Bg = 211;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Rg = 196;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Bg = 211;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Rg =  37;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Rg =  51;
  //  12.カラーローリング検知時白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Bg =  41;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Rg = 155;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Rg = 313;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Bg = 135;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Rg = 235;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Rg =  79;
  //  13.カラーローリング検知時昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Bg = 135;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Rg = 235;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Rg = 222;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Rg =  51;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Bg = 109;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Rg =  79;
  //  14.カラーローリング検知時昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Rg = 222;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Bg = 211;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Rg = 196;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Bg = 211;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Rg =  37;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Bg = 161;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Rg =  51;
#endif	// IMX662
#else   //  ENABLE_AF_LENS_DATA
  //  0.白熱灯枠
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Bg =  24;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[0].Rg = 231;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Bg =  84;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[1].Rg = 231;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[2].Rg = 126;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_A].Area[3].Rg =  90;
  //  1.電球色蛍光灯
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Bg =  24;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[0].Rg = 231;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Bg =  84;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[1].Rg = 231;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[2].Rg = 126;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_EBulbF].Area[3].Rg =  90;
  //  2.白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[0].Rg =  90;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[1].Rg = 126;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Bg = 148;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[2].Rg = 108;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_CWF].Area[3].Rg =  73;
  //  3.昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Bg = 148;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[0].Rg = 108;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[1].Rg = 105;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[2].Rg =  68;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_DayWF].Area[3].Rg =  73;
  //  4.昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[0].Rg = 105;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Bg = 192;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[1].Rg =  99;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Bg = 192;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[2].Rg =  65;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayF].Area[3].Rg =  68;
  //  5.昼光枠
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[0].Rg = 111;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Bg = 185;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[1].Rg =  96;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Bg = 185;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[2].Rg =  65;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_Day].Area[3].Rg =  68;
  //  6.雲天/日陰枠
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Bg = 185;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[0].Rg =  96;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Bg = 232;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[1].Rg =  93;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Bg = 232;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[2].Rg =  62;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Bg = 185;
  g_spec.AWB.LightSource[AWBLightSource_Cloudy].Area[3].Rg =  65;
  //  7.水銀灯枠
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[0].Rg =  73;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[1].Rg =  68;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Bg = 153;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[2].Rg =  53;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_Merculy].Area[3].Rg =  59;
  //  8.ナトリウムランプ
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Bg =  34;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[0].Rg = 261;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[1].Rg = 261;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[2].Rg = 160;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_NaLamp].Area[3].Rg = 126;
  //  9.電球色LED
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Bg =  24;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[0].Rg = 231;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Bg =  84;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[1].Rg = 231;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[2].Rg = 126;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_EBulbLED].Area[3].Rg =  90;
  //  10.白色LED
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[0].Rg =  90;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[1].Rg = 126;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[2].Rg = 105;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_WhiteLED].Area[3].Rg =  68;
  //  11.昼光色LED
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[0].Rg = 105;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Bg = 192;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[1].Rg =  99;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Bg = 192;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[2].Rg =  65;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayLED].Area[3].Rg =  68;
  //  12.カラーローリング検知時白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Bg =  94;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[0].Rg =  90;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[1].Rg = 126;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Bg = 148;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[2].Rg = 108;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_CWFRolling].Area[3].Rg =  73;
  //  13.カラーローリング検知時昼白色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Bg = 148;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[0].Rg = 108;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[1].Rg = 105;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[2].Rg =  68;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Bg = 133;
  g_spec.AWB.LightSource[AWBLightSource_DayWFRolling].Area[3].Rg =  73;
  //  14.カラーローリング検知時昼光色蛍光灯枠
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[0].Rg = 105;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Bg = 192;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[1].Rg =  99;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Bg = 192;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[2].Rg =  65;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Bg = 163;
  g_spec.AWB.LightSource[AWBLightSource_DayFRolling].Area[3].Rg =  68;
#endif  //  ENABLE_AF_LENS_DATA
  //  [AWB-16]センサー分光バラツキ調整
  //  [AWB-18]光源枠デフォルト座標
#ifndef ENABLE_AF_LENS_DATA
#ifdef IMX662
  //  18.0.電球色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Bg = 81;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Rg = 219;
  //  18.1.白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Bg =  97;
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Rg = 174;
  //  18.2.昼白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Bg = 129;
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Rg = 161;
  //  18.3.昼光色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Bg = 153;
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Rg = 146;
  //  18.4.水銀灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Bg = 125;
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Rg = 114;
  //  18.5.高圧ナトリウムランプデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Bg =  67;
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Rg = 382;
  //  18.6.電球色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Bg =  81;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Rg = 219;
  //  18.1.白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Bg =  97;
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Rg = 174;
  //  18.2.昼白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Bg = 153;
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Rg = 146;
  //  18.9.黒体放射 1800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Bg =  48;
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Rg = 417;
  //  16.0.低色温度側調整ポイント：黒体放射 2800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Bg =  99;
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Rg = 212;
  //  18.10.黒体放射 3200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Bg =  95;
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Rg = 236;
  //  18.11.黒体放射 4200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Bg = 119;
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Rg = 198;
  //  18.12.黒体放射 5200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Bg = 135;
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Rg = 176;
  //  16.1.高色温度側調整ポイント：黒体放射 5800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Bg = 143;
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Rg = 167;
  //  18.13.黒体放射 5800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Bg = 143;
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Rg = 167;
  //  18.14.黒体放射 7000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Bg = 162;
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Rg = 154;
  //  18.15.黒体放射 10000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Bg = 197;
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Rg = 133;
#elif IMX415	// IMX662
  // IMX415用
  //  18.0.電球色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Bg =  58;	//80;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Rg = 310;	//253;
  //  18.1.白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Bg = 76;	//102;
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Rg = 155;	//184;
  //  18.2.昼白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Bg = 111;	//143;
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Rg = 114;	//166;
  //  18.3.昼光色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Bg = 137;	//173;
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Rg = 61;	//143;
  //  18.4.水銀灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Bg = 106;	//137;
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Rg = -50;	//93;
  //  18.5.高圧ナトリウムランプデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Bg = 41;	//61;
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Rg = 884;	//506;
  //  18.6.電球色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Bg =  58;	//80;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Rg = 310;	//253;
  //  18.1.白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Bg = 76;	//102;
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Rg = 154;	//184;
  //  18.2.昼白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Bg = 137;	//173;
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Rg = 61;	//143;
  //  18.9.黒体放射 1800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Bg =  19;	//37;
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Rg = 1017;	//561;
  //  16.0.低色温度側調整ポイント：黒体放射 2800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Bg =  99;
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Rg = 212;
  //  18.10.黒体放射 3200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Bg =  73;	//99;
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Rg = 368;	//279;
  //  18.11.黒体放射 4200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Bg = 100;	//130;
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Rg = 238;	//222;
  //  18.12.黒体放射 5200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Bg = 119;	//152;
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Rg = 164;	//188;
  //  16.1.高色温度側調整ポイント：黒体放射 5800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Bg = 161;
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Rg = 139;
  //  18.13.黒体放射 5800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Bg = 127;	//161;
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Rg = 130;	//174;
  //  18.14.黒体放射 7000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Bg = 147;	//185;
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Rg = 89;	//155;
  //  18.15.黒体放射 10000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Bg = 187;	//231;
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Rg = 17;	//123;
#else	// IMX662
  // IMX412用
  //  18.0.電球色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Bg =  60;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Rg = 243;
  //  18.1.白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Bg =  87;
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Rg = 152;
  //  18.2.昼白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Bg = 138;
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Rg = 128;
  //  18.3.昼光色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Bg = 177;
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Rg =  98;
  //  18.4.水銀灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Bg = 131;
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Rg =  33;
  //  18.5.高圧ナトリウムランプデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Bg =  37;
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Rg = 573;
  //  18.6.電球色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Bg =  60;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Rg = 243;
  //  18.1.白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Bg =  87;
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Rg = 152;
  //  18.2.昼白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Bg = 177;
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Rg =  98;
  //  18.9.黒体放射 1800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Bg =   7;
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Rg = 644;
  //  16.0.低色温度側調整ポイント：黒体放射 2800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Bg =  99;
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Rg = 212;
  //  18.10.黒体放射 3200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Bg =  84;
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Rg = 277;
  //  18.11.黒体放射 4200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Bg = 122;
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Rg = 202;
  //  18.12.黒体放射 5200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Bg = 149;
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Rg = 157;
  //  16.1.高色温度側調整ポイント：黒体放射 5800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Bg = 161;
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Rg = 139;
  //  18.13.黒体放射 5800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Bg = 161;
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Rg = 139;
  //  18.14.黒体放射 7000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Bg = 191;
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Rg = 113;
  //  18.15.黒体放射 10000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Bg = 249;
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Rg =  72;
#endif	// IMX662
#else   //  ENABLE_AF_LENS_DATA
  //  18.0.電球色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Bg = 105;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbF].Rg = 110;
  //  18.1.白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Bg = 120;
  g_spec.AWB.LightDefault[AWBLightDefault_CWF].Rg =  90;
  //  18.2.昼白色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Bg = 150;
  g_spec.AWB.LightDefault[AWBLightDefault_DayWF].Rg =  85;
  //  18.3.昼光色蛍光灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Bg = 172;
  g_spec.AWB.LightDefault[AWBLightDefault_DayF].Rg =  78;
  //  18.4.水銀灯デフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Bg = 146;
  g_spec.AWB.LightDefault[AWBLightDefault_Merculy].Rg =  63;
  //  18.5.高圧ナトリウムランプデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Bg =  92;
  g_spec.AWB.LightDefault[AWBLightDefault_NaLamp].Rg = 183;
  //  18.6.電球色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Bg = 105;
  g_spec.AWB.LightDefault[AWBLightDefault_EBulbLED].Rg = 110;
  //  18.7.白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Bg = 120;
  g_spec.AWB.LightDefault[AWBLightDefault_WhiteLED].Rg =  90;
  //  18.8.昼白色LEDデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Bg = 172;
  g_spec.AWB.LightDefault[AWBLightDefault_DayLED].Rg =  78;
  //  18.9.黒体放射 1800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Bg =  74;
  g_spec.AWB.LightDefault[AWBLightDefault_1800K].Rg = 199;
  //  16.0.低色温度側調整ポイント：黒体放射 2800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Bg = 102;
  g_spec.AWB.SpectrumAdjust.pntLowTemp.Rg = 130;
  //  18.10.黒体放射 3200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Bg = 118;
  g_spec.AWB.LightDefault[AWBLightDefault_3200K].Rg = 117;
  //  18.11.黒体放射 4200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Bg = 140;
  g_spec.AWB.LightDefault[AWBLightDefault_4200K].Rg = 100;
  //  18.12.黒体放射 5200Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Bg = 155;
  g_spec.AWB.LightDefault[AWBLightDefault_5200K].Rg =  91;
  //  16.1.高色温度側調整ポイント：黒体放射 5800Kデフォルト座標
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Bg = 163;
  g_spec.AWB.SpectrumAdjust.pntHighTemp.Rg =  87;
  //  18.13.黒体放射 5800Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Bg = 163;
  g_spec.AWB.LightDefault[AWBLightDefault_5800K].Rg =  87;
  //  18.14.黒体放射 7000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Bg = 181;
  g_spec.AWB.LightDefault[AWBLightDefault_7000K].Rg =  81;
  //  18.15.黒体放射 10000Kデフォルト座標
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Bg = 214;
  g_spec.AWB.LightDefault[AWBLightDefault_10000K].Rg =  72;
#endif  //  ENABLE_AF_LENS_DATA
  //  [AWB-19]OPD信頼性判定レベル
  g_spec.AWB.OPDTrust.TH = 144;                             //  信頼性閾値
  g_spec.AWB.OPDTrust.Sel = AWBLowTrust_Default;             //  低信頼性時の処理
  g_spec.AWB.OPDTrust.Zero = AWBLightSource_CWF;            //  OPDデータゼロ時処理
  //  [Img-5.2.2]カラーマトリックス設定
  g_spec.AWB.ColorMatrix.Mode = 1;                          //  独立モードON
  for(int i = 0; i < AWB_ColorMatrixMax; i++) {
    g_spec.AWB.ColorMatrix.Matrix[i].CC22 = 448;
    g_spec.AWB.ColorMatrix.Matrix[i].CC23 = 130;
    g_spec.AWB.ColorMatrix.Matrix[i].CC32 = 160;
    g_spec.AWB.ColorMatrix.Matrix[i].CC33 = 512;
  }
  g_spec.AWB.ColorMatrix.Matrix[1].CC32 = 40;               //  第二象限Crのみ40を設定
  g_spec.AWB.ColorMatrix.CC11 = 0x0100u;
  g_spec.AWB.ColorMatrix.COF1 = 0x000bu;
}

void AXHSpec::setDefault_Scaler() {
	g_spec.Scaler.scaling.InImgSize.Width   = AXH_SCL_DEF_IMG_WIDTH;
	g_spec.Scaler.scaling.InImgSize.Height  = AXH_SCL_DEF_IMG_HEIGHT;
	for (int i = 0; i < SCL_SCALING_CH_CNT; i++) {
		g_spec.Scaler.scaling.enabled[i] = 0;
		switch (i) {
		case 0:
		default:
			g_spec.Scaler.scaling.OutImgSize[i].Width  = 320;
			g_spec.Scaler.scaling.OutImgSize[i].Height = 184;
			break;
		case 1:
			g_spec.Scaler.scaling.OutImgSize[i].Width  = 640;
			g_spec.Scaler.scaling.OutImgSize[i].Height = 360;
			break;
		case 2:
			g_spec.Scaler.scaling.OutImgSize[i].Width  = 1024;
			g_spec.Scaler.scaling.OutImgSize[i].Height = 768;
			break;
		}
	}
	for (int i = 0; i < SCL_NEG_FLIP_CH_CNT; i++) {
		g_spec.Scaler.flip[i].vFlip     = 0;
		g_spec.Scaler.flip[i].hFlip     = 0;
		g_spec.Scaler.neg [i]           = 0;
	}
}

void AXHSpec::setDefault_OB() {
	g_spec.OB.mode               = 0;
	g_spec.OB.samplingWidth      = AXH_OB_SAMPLING_WIDTH;      //  OB調整 サンプリング領域幅
	g_spec.OB.samplingHeight     = AXH_OB_SAMPLING_HEIGHT;     //  OB調整 サンプリング領域高さ
	g_spec.OB.darkLevelFloorR    = AXH_OB_DARK_LEVEL_FLOOR;    //  11
	g_spec.OB.darkLevelFloorGr   = AXH_OB_DARK_LEVEL_FLOOR;    //  11
	g_spec.OB.darkLevelFloorB    = AXH_OB_DARK_LEVEL_FLOOR;    //  11
	g_spec.OB.darkLevelFloorGb   = AXH_OB_DARK_LEVEL_FLOOR;    //  11
	g_spec.OB.sensorArrayPtn     = 0;
	// LOW は0x00013008が初期値でHIGHは0x00000000が初期値
	//  0- 2:000
	//  3- 5:001
	//  6- 8:000
	//  9-11:000
	// 12-14:011
	// 15-17:010
	// 18-20:000
	// 21-23:000
	// 24-26:000
	// 27-29:000
	// 30-31:00
	for (int i = 0; i < OB_ARRAY_PTN_INDEX_CNT; i++) {
		g_spec.OB.arrayPtnIndex[i]= 0;
	}
	g_spec.OB.arrayPtnIndex[1]= 0x1;
	g_spec.OB.arrayPtnIndex[4]= 0x3;
	g_spec.OB.arrayPtnIndex[5]= 0x2;
	for (int i = 0; i < OB_INDEX_VALUE_CNT; i++) {
		g_spec.OB.indexValue[i]   = 240 - AXH_OB_DARK_LEVEL_FLOOR; // 229
	}
}

void AXHSpec::setDefault_Gamma() {
	g_spec.Gamma.mode            = 0;                          // プリセットモード
	g_spec.Gamma.curveSelect     = 6; // 3;                    // GammaCurve_4 → GammaCurve_7(γ2.2)
	g_spec.Gamma.dRange          = 500;                        // Kneeポイント入力デフォルト値(x1000値)
	g_spec.Gamma.hRange          = 850;                        // Kneeポイント出力デフォルト値(x1000値)
	g_spec.Gamma.compLevelSelect = 0;                          // 圧縮レベル
}

void AXHSpec::setDefault_Aperture() {
	g_spec.Aperture.totalGain                       = 0x96;
	g_spec.Aperture.limitPositive                   = 4095;
	g_spec.Aperture.limitNegative                   =-4096;
	g_spec.Aperture.coringTh                        = 0x00;
	g_spec.Aperture.midRangeRatio                   = 0x40;
	g_spec.Aperture.weakSignalStrLevel              = 0x00;
	g_spec.Aperture.darkSupressStartLuminance       = 0x00;
	g_spec.Aperture.highCorrectStartStrongLuminance = 0xC8;
	g_spec.Aperture.darkCorrectSupressInc           = 0x00;
	g_spec.Aperture.highCorrectStrongInc            = 0x20;
	g_spec.Aperture.highCorrectStrongLimit          = 0xFF;
}

void AXHSpec::setDefault_Chroma() {
	g_spec.CHROMA.darkStartLuminance                = 0x28;    // 40;
	g_spec.CHROMA.darkInc                           = 0x18;    // 24;
	g_spec.CHROMA.highColorStartLuminance           = 0xB4;    // 180;
	g_spec.CHROMA.highColorInc                      = 0x30;    // 48;
	g_spec.CHROMA.highColorLimit                    = 0xA8;    // 168;
	g_spec.CHROMA.highLightStartLuminance           = 0xDC;    // 220;
	g_spec.CHROMA.highLightInc                      = 0x50;    // 80;
	g_spec.CHROMA.lowStartGain                      = 0x12;    // 18;
	g_spec.CHROMA.lowInc                            = 0x30;    // 48(傾き3);
}

static const unsigned char defaultPhotometUser[100]={
		1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 ,
		1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 ,
		1 , 1 , 1 , 1 , 2 , 2 , 1 , 1 , 1 , 1 ,
		1 , 1 , 1 , 2 , 3 , 3 , 2 , 1 , 1 , 1 ,
		1 , 1 , 1 , 2 , 3 , 3 , 3 , 1 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1 ,
		1 , 1 , 2 , 3 , 3 , 3 , 3 , 2 , 1 , 1
};


void AXHSpec::setDefault_AE() {
	g_spec.AE.AEMode = 4;		// 今回ハードにIRISは無いためシャッター&ゲインモード
	g_spec.AE.flickerEnable = 0;				//  フリッカ補正 ON/OFF
#ifdef IMX662
	g_spec.AE.aeChara.st_shutterSpeed.upper = 4369;					// シャッタースピード範囲
#elif IMX415	// IMX662
	// IMX415用
	g_spec.AE.aeChara.st_shutterSpeed.upper = 8738;					// シャッタースピード範囲 1/30sec
#else	// IMX662
	// IMX412
	g_spec.AE.aeChara.st_shutterSpeed.upper = 17476;					// シャッタースピード範囲
#endif	// IMX662
	//g_spec.AE.aeChara.st_shutterSpeed.lower = 33;					// シャッタースピード範囲 1/8000sec
	g_spec.AE.aeChara.st_shutterSpeed.lower = 17;					// シャッタースピード範囲 1/16000sec
	g_spec.AE.aeChara.gainUpper = 24;							// ゲイン範囲(上限値)			
	g_spec.AE.aeChara.slowShutterEnable = 1;					// 低速シャッタースピード制御  1. ON"
	g_spec.AE.aeChara.gainSlowShutterPrio = 0;				// ゲイン制御/シャッタースピード制御の優先設定 "0. ゲイン制御
	g_spec.AE.aeChara.slowShutterMax = 17476;				// 低速シャッタースピード制御時 最長露光時間設定 1/15S
	g_spec.AE.aeChara.photometryPatNo = 0;					// 測光パターンの指定（通常AE時）	0. 中央重点
	g_spec.AE.aeChara.selectBL_CorFLCEnable = 0;				// 自動逆光/過順光補正 0. OFF
	g_spec.AE.aeChara.selectBL_CorFLC = 0;					// 逆光補正／過順光補正切り替え 0. 逆光補正
	g_spec.AE.aeChara.selectHISTorMAIN = 0;					// 自動補正モード選択 0. 主要被写体指定モード
	g_spec.AE.aeChara.st_mainSubjArea.start.h = 3;			// "主要被写体指定モード時 エリア指定 （自動補正モード）"	
	g_spec.AE.aeChara.st_mainSubjArea.start.v = 3;			// "主要被写体指定モード時 エリア指定 （自動補正モード）"	
	g_spec.AE.aeChara.st_mainSubjArea.end.h = 6;			// "主要被写体指定モード時 エリア指定 （自動補正モード）"	
	g_spec.AE.aeChara.st_mainSubjArea.end.v = 8;			// "主要被写体指定モード時 エリア指定 （自動補正モード）"	

	for (short i = 0; i < 100 ; i++) {
	  	g_spec.AE.photPatt.pattern[i] = defaultPhotometUser[i];							// エリア重み[100:1]
	}
	g_spec.AE.AETarget = 90;                           // AE目標値 10倍して少数点１位までを設定する
#ifdef IMX662
	g_spec.AE.aeManual.shutter_speed = 4369;							// マニュアルモード設定（AEモード選択：マニュアルモードの時有効）
#elif IMX415
	// IMX415用
	g_spec.AE.aeManual.shutter_speed = 8738;							// マニュアルモード設定（AEモード選択：マニュアルモードの時有効）
#else	// IMX662
	// IMX412
	g_spec.AE.aeManual.shutter_speed = 17476;							// マニュアルモード設定（AEモード選択：マニュアルモードの時有効）
#endif	// IMX662
	g_spec.AE.aeManual.gain = 0;							// マニュアルモード設定（AEモード選択：マニュアルモードの時有効）
#ifdef IMX662
	g_spec.AE.aeConvAdj.aeSpeed = 60;							// AE収束調整（AEモード選択：0～2の時有効）
#else	// IMX662
	// IMX412,IMX415用
	g_spec.AE.aeConvAdj.aeSpeed = 30;							// AE収束調整（AEモード選択：0～2の時有効）
#endif	// IMX662
	g_spec.AE.aeConvAdj.deadZoneOut = 10;							// AE収束調整（AEモード選択：0～2の時有効）
	g_spec.AE.aeConvAdj.deadZoneIn = 10;							// AE収束調整（AEモード選択：0～2の時有効）
#ifdef MECHA_IRIS
	g_spec.AE.mechaIrisAdjust.flagIrisRegion = 0;					
	g_spec.AE.mechaIrisAdjust.roughIrisValue = 255;					
	g_spec.AE.mechaIrisAdjust.irisStopUpper = 136;					
	g_spec.AE.mechaIrisAdjust.irisStopLower = 120;					
	g_spec.AE.mechaIrisAdjust.irisCloseSlow = 176;					
	g_spec.AE.mechaIrisAdjust.irisCloseFast = 255;					
	g_spec.AE.mechaIrisAdjust.irisOpenSlow = 80;					
	g_spec.AE.mechaIrisAdjust.irisOpenFast = 0;		
#endif	
	g_spec.AE.wdrCharacteristic.exposureRatio = 0x0400;	// 16倍;
	g_spec.AE.wdrCharacteristic.mixExpRatio = 0x0000;	// ;					
	g_spec.AE.wdrCharacteristic.mixThrLong = 0xC00;					
	g_spec.AE.wdrCharacteristic.mixThrShort = 0xF00;					
	g_spec.AE.wdrCharacteristic.mixThrErr = 0x02000010;					
	g_spec.AE.wdrCharacteristic.shortExpoControl = 0;					
	g_spec.AE.wdrCharacteristic.autoWdrShortExpTarget = 512;					
	g_spec.AE.wdrCharacteristic.autoWdrLongExpTarget = 128;					
	g_spec.AE.wdrCompoChara1 = 0;						// WDR時合成特性設定１ 長時間露光画像 合成実施下限レベル設定
	g_spec.AE.wdrCompoChara2 = 0;						// WDR時合成特性設定２ 短時間露光画像 合成実施上限レベル設定
	g_spec.AE.wdrCompoChara3 = 0;						// WDR時合成特性設定３ 合成エラー検知感度
}

void AXHSpec::setDefault_AF() {
	g_spec.AF.focusArea = 4;			// フォーカスエリア指定 0～8
	g_spec.AF.afStartDir = 1;				// 初動方向
	g_spec.AF.afStartDirJudMax = 5;		// 開始時方向切替判定所定回数
	g_spec.AF.afStartDirChangeThresh = 5000;	// 開始時方向切替判定閾値
//	ST_AF_DEC_START_DIR afStart;		// 開始時方向判定
	g_spec.AF.afChngSpedThresh = 8000;	// 駆動速度切替閾値
	g_spec.AF.afOverPeakThresh = 5000;	// 頂点超え閾値
	g_spec.AF.afEvalRebootThresh = 50;	// 再起動閾値
	g_spec.AF.afEvalPeakRatio = 95;	// ピークに戻る時のAF評価値比率（％）
	g_spec.AF.afOneShotEnable = 1;	// AFワンショットモードOn/Off
	g_spec.AF.lensAtEndJudg = 300;		// レンズが端にあるか判定用
}

void AXHSpec::setDefault_DayNight() {
	g_spec.DayNight.dayNightMode = 0;			//  Day/Nightモード  0. OFF
	g_spec.DayNight.judgeMode = 0;				// 判定モード  0. AGCとシャッタスピードから算出されるセンサー像面照度に基づく判定
	g_spec.DayNight.upperLimit = 5;			// 上限設定（判定モード：センサー像面照度に基づく判定）"
	g_spec.DayNight.dayNightInThre = 75;		// Day/Nightモード IN点閾値
	g_spec.DayNight.dayNightOutThre = 9;		// Day/Nightモード OUT点閾値
	g_spec.DayNight.judgeTransTime = 10;		// 判定遷移時間
	g_spec.DayNight.nightColorSig = 0;			// Night時の色信号設定
	g_spec.DayNight.forceMode = 0;			// 強制モード  0. OFF
	g_spec.DayNight.forceDayNightSelect = 0;	// 強制モードON時Day/Night選択 0. Dayモード

}

void AXHSpec::setDefault_ImageSensor() {
	g_spec.ImageSensor.lensKind = 1;			//	1 DCアイリス
}

void *AXHSpec::getSpecAddr() {
  return (void *)&g_spec;
}
