/*
 * AXHSpecParam.hpp
 */

#ifndef AXH_SPEC_PARAM_HPP_
#define AXH_SPEC_PARAM_HPP_


// ガンマ補正カーブ頂点数
const short			GAMMA_CURVE_POI_CNT = 65;

const unsigned int AXH_OBPixelIndex_Max = 16;            ///<  OB 画素位置[15:0]のindex最大値
const unsigned int AXH_OBIndexValue_Max = 8;             ///<  OB index値の設定(固定値設定モード時に有効)最大値

/**
 * @enum	AXH_AE_SlowShutter_Mode
 * @brief	スローシャッターモード定義
 */
typedef enum
{
  AXH_AE_SlowShutter_OFF = 0,                               ///<  AE スローシャッターOFF
  AXH_AE_SlowShutter_ON,                                    ///<  AE スローシャッターON
} AXH_AE_SlowShutter_Mode;


const unsigned int AXH_RGBMatrixIn_Max = 4;                 ///<  RGBMatrix 入力数
const unsigned int AXH_RGBMatrixOut_Max = 4;                ///<  RGBMatrix 出力数
const unsigned int AXH_RGBMatrixSetIn_Max = 3;              ///<  RGBMatrix 入力側設定数
const unsigned int AXH_RGBMatrixSetOut_Max = 3;             ///<  RGBMatrix 出力側設定数


/**
 * @enum	AXH_Defect_Mode
 * @brief	画素欠陥補正 内部/外部モード定義
 */
typedef enum
{
  AXH_Defect_Mode_Internal = 0,                             ///<  アドレス指定モード(内部選択)
  AXH_Defect_Mode_External,                                 ///<  アドレス指定モード(外部選択)
} AXH_Defect_Mode;


/**
 * @enum	AXH_Defect_Auto
 * @brief	画素欠陥補正 自動補正 ON/OFFモード定義
 */
typedef enum
{
  AXH_Defect_Auto_OFF = 0,                                  ///<  自動補正 OFF
  AXH_Defect_Auto_ON,                                       ///<  自動補正 ON
} AXH_Defect_Auto;



const unsigned int AXH_Shade_Grid_Width = 33;               ///<  シェーディング補正データ 座標幅
const unsigned int AXH_Shade_Grid_Height_Max = 35;          ///<  シェーディング補正データ 座標高 最大値

const unsigned int AXH_LensShade_Shift_Min = 3;             ///<  シェーディング補正データ シフト量最小値

const unsigned char AXH_Shade_Correct_Start = 0x01u;        ///<  シェーディング補正 補正開始
const unsigned char AXH_Shade_Correct_Reset = 0x00u;        ///<  シェーディング補正 補正開始リセット

const unsigned int AXH_Defect_IntAddr_Max = 16;             ///<  画素欠陥補正 内部指定時座標設定点数
const unsigned int AXH_Defect_ExtAddr_Max = 64;             ///<  画素欠陥補正 外部指定時設定点数
const unsigned int AXH_Defect_ADFOFS_Max = 16;              ///<  輝度信号レベル変調設定 設定個数
const unsigned int AXH_Defect_ADFOFS_REG_Max = (AXH_Defect_ADFOFS_Max >> 1);
                                                            ///<  輝度信号レベル変調設定 レジスタ数

const unsigned char AXH_Defect_Detect_Start = 0x01u;        ///<  画素欠陥補正 検出開始
const unsigned char AXH_Defect_Detect_Reset = 0x00u;        ///<  画素欠陥補正 検出開始リセット

const unsigned int AXH_NR_Main_Max = 16;                    ///<  3DNR設定エリア数
const unsigned int AXH_NR_Sub_Max = 4;                      ///<  2DNR設定アリア数
const int AXH_NR_Col = 4;                                   ///<  1レジスタあたりの設定値数
const int AXH_NR_MainTH_Max = 4;                            ///<  NR_MAIN_xTHxレジスタ数
const int AXH_NR_MainIN_Max = 4;                            ///<  NR_MAIN_xINxレジスタ数
const int AXH_NR_MainLV_Max = 4;                            ///<  NR_MAIN_xTHxレジスタ数
const unsigned char SCL_SCALING_CH_CNT  = 3;                ///<  拡大縮小機能チャンネル数
const unsigned char SCL_NEG_FLIP_CH_CNT = 5;                ///<  上下・左右反転/ネガポジ反転機能チャンネル数
const unsigned char OB_ARRAY_PTN_INDEX_CNT = 16;            ///<  OB配列パターンインデックス数
const unsigned char OB_INDEX_VALUE_CNT      = 8;            ///<  OBIndex値データ数


typedef enum
{
    SPEC_CHG_AWB_Range    = 0x00000001ul ,                  // AWB 引き込み範囲設定
    SPEC_CHG_AWB_WBOffset = 0x00000002ul ,                  // AWB WBオフセット調整設定
    SPEC_CHG_AWB_Matrix   = 0x00000004ul ,                  // AWB カラーマトリックス調整/Yゲイン設定・カラーマトリックス設定
    SPEC_CHG_AWB_Weight   = 0x00000008ul ,                  // AWB 光源枠重み付け設定
    SPEC_CHG_AWB_OPD      = 0x00000010ul ,                  // AWB OPD設定/OPD枠重み付け/OPD枠マスク領域
    SPEC_CHG_AWB_Source   = 0x00000020ul ,                  // AWB 光源枠詳細調整
    SPEC_CHG_AWB_Default  = 0x00000040ul ,                  // AWB 光源デフォルト位置設定
    SPEC_CHG_AWB_Reserve1 = 0x00000080ul ,
    SPEC_CHG_AWB_Reserve2 = 0x00000100ul ,
    SPEC_CHG_AWB_Reserve3 = 0x00000200ul ,
    SPEC_CHG_AWB_Reserve4 = 0x00000400ul ,
    SPEC_CHG_AWB_Reserve5 = 0x00000800ul ,
    SPEC_CHG_AWB_Reserve6 = 0x00001000ul ,
    SPEC_CHG_AWB_Reserve7 = 0x00002000ul ,
    SPEC_CHG_AE001        = 0x00004000ul ,                  // AEモード選択
    SPEC_CHG_AE002        = 0x00008000ul ,                  // AE特性設定
    SPEC_CHG_AE003        = 0x00010000ul ,                  // AEユーザー測光パターン
    SPEC_CHG_AE004        = 0x00020000ul ,                  // AE目標値
    SPEC_CHG_AE005        = 0x00040000ul ,                  // AEマニュアルモード設定
    SPEC_CHG_AE006        = 0x00080000ul ,                  // AE収束調整
    SPEC_CHG_AE007        = 0x00100000ul ,                  // AEメカアイリス調整
    SPEC_CHG_AE008        = 0x00200000ul ,                  // AE WDR時合成特性設定1
    SPEC_CHG_AE009        = 0x00400000ul ,                  // AE WDR時合成特性設定2
    SPEC_CHG_AE010        = 0x00800000ul ,                  // AE WDR時合成特性設定3
    SPEC_CHG_AE011        = 0x01000000ul ,                  // AE WDR時合成特性設定4
    SPEC_CHG_OB           = 0x02000000ul ,                  // OB
    SPEC_CHG_OB_FIX       = 0x04000000ul ,                  // OB 固定モード設定
    SPEC_CHG_OB_Reserve   = 0x08000000ul ,                  //
    SPEC_CHG_DAR001       = 0x10000000ul ,                  // ダークシェーディング補正
    SPEC_CHG_DAR002       = 0x20000000ul ,                  // ダークシェーディング補正
    SPEC_CHG_RGB_Matrix   = 0x40000000ul ,                  // RGBマトリックス
    SPEC_CHG_DAYNI        = 0x80000000ul ,                  // Day/Night機能
}SPEC_ChangeStatus00;
typedef enum
{
    SPEC_CHG_KIZU_Dynamic = 0x00000001ul ,	// 画素欠陥補正(キズ補正 自動補正)
    SPEC_CHG_KIZU_Static  = 0x00000002ul ,	// 画素欠陥補正(キズ補正 静的検出)
    SPEC_CHG_SHADE        = 0x00000004ul ,	// レンズシェーディング補正
    SPEC_CHG_IRIDIX       = 0x00000008ul ,	// 適応階調補正(IRIDIX)
    SPEC_CHG_NR           = 0x00000010ul ,	// NR
    SPEC_CHG_SCAL_ZOOM    = 0x00000020ul ,	// スケーラ機能拡大縮小設定
    SPEC_CHG_SCAL_REVERSE = 0x00000040ul ,	// スケーラ機能上下反転機能/ネガポジ反転機能
    SPEC_CHG_AFH1         = 0x00000080ul ,	// 水平ＡＦエリア座標設定
    SPEC_CHG_AFH2         = 0x00000100ul ,	// 水平AFフィルタ設定
    SPEC_CHG_AFH3         = 0x00000200ul ,	// 垂直ＡＦエリア座標設定
    SPEC_CHG_AFH4         = 0x00000400ul ,	// 垂直AFフィルタ設定
    SPEC_CHG_AFH5         = 0x00000800ul ,	// 水平AF検波結果
    SPEC_CHG_AHF6         = 0x00001000ul ,	// 垂直AF検波結果
    SPEC_CHG_AF           = 0x00002000ul ,	// AF機能
    SPEC_CHG_IMGS         = 0x00004000ul ,	// イメージセンサ
    SPEC_CHG_GAM_PRE      = 0x00008000ul ,	// ガンマ補正プリセットモード設定
    SPEC_CHG_GAM_USR      = 0x00010000ul ,	// ガンマ補正ユーザ設定モード設定
    SPEC_CHG_GAM_Reserve  = 0x00020000ul ,	// ガンマ補正予備
    SPEC_CHG_APER         = 0x00040000ul ,	// アパーチャ補正
    SPEC_CHG_APER_ADP     = 0x00080000ul ,	// アパーチャ補正適応処理
    SPEC_CHG_APER_Reserve = 0x00100000ul ,
    SPEC_CHG_CHRO         = 0x00200000ul ,	// クロマサプレス
    SPEC_CHG_EDGE_CHRO    = 0x00400000ul ,	// エッジクロマサプレス
    SPEC_CHG_LOW_CHRO     = 0x00800000ul ,	// 低輝度クロマサプレス
    SPEC_CHG_RSV02        = 0x01000000ul ,	// Reserved
    SPEC_CHG_RSV03        = 0x02000000ul ,	// Reserved
    SPEC_CHG_RSV04        = 0x04000000ul ,	// Reserved
    SPEC_CHG_RSV05        = 0x08000000ul ,	// Reserved
    SPEC_CHG_RSV06        = 0x10000000ul ,	// Reserved
    SPEC_CHG_ZOOMIN       = 0x20000000ul ,	// 1にするとzoominを１回行う
    SPEC_CHG_ZOOMOUT      = 0x40000000ul ,	// 1にするとzoomoutを１回行う
    SPEC_CHG_AFONESHOT    = 0x80000000ul ,	// 1にするとAFを起動する
} SPEC_ChangeStatus01;

const int AXH_Index_SPEC_CHG_AWB        = 0;
const int AXH_Index_SPEC_CHG_RGB_Matrix = 0;
const int AXH_Index_SPEC_CHK_OB         = 0;

const int AXH_Index_SPEC_CHG_KIZU_Dynamic = 1;
const int AXH_Index_SPEC_CHG_KIZU_Static  = 1;
const int AXH_Index_SPEC_CHG_SHADE        = 1;
const int AXH_Index_SPEC_CHG_IRIDIX       = 1;
const int AXH_Index_SPEC_CHG_NR           = 1;

const int AXH_Index_SPEC_CHK_SCALER       = 1;
const int AXH_Index_SPEC_CHK_GAMMA        = 1;
const int AXH_Index_SPEC_CHK_APERTURE     = 1;
const int AXH_Index_SPEC_CHK_CHROMA       = 1;

#endif /* AXH_SPEC_PARAM_HPP_ */
