/*
 * AXHSpecStruct.hpp
 */

#ifndef AXH_SPEC_STRUCT_HPP_
#define AXH_SPEC_STRUCT_HPP_

#include "AXHSpecParam.hpp"
#include "AXHSpecAwbParam.hpp"
#include "AXHSpecAwbStruct.hpp"
#include "AXHSpecDefectStruct.hpp"


/**
 * @struct  ST_SHUTTER_SPEED
 * @n   シャッタースピード範囲	
 */
typedef struct st_shutter_speed {
	unsigned short upper;	// 上限値	
	unsigned short lower;	// 下限値	
} ST_SHUTTER_SPEED;

/**
 * @struct  ST_COORD
 * @n   主要被写体指定モード時 エリア指定（自動補正モード）
 */
typedef struct st_coord {
	unsigned char h;										// 水平
	unsigned char v;										// 垂直
} ST_COORD;

typedef struct st_main_subject_area {
	ST_COORD	start;										// 開始
	ST_COORD	end;										// 終了
} ST_MAIN_SUBJ_AREA;

/**
 * @struct  ST_AE_CHARACTERISTIC
 * @n   AE用特性
 */
typedef struct st_ae_characteristic {
	ST_SHUTTER_SPEED    st_shutterSpeed;					// シャッタースピード範囲
	unsigned short		gainUpper;							// ゲイン範囲(上限値)			
	unsigned char       slowShutterEnable;					// 低速シャッタースピード制御  0. OFF
															//                             1. ON"
	unsigned char		gainSlowShutterPrio;				// ゲイン制御/シャッタースピード制御の優先設定 "0. ゲイン制御
															//                                              1. 低速シャッタースピード制御"
	unsigned long       slowShutterMax;						// 低速シャッタースピード制御時 最長露光時間設定
	unsigned char		photometryPatNo;					// 測光パターンの指定（通常AE時）	0. 中央重点
															//									1. 中央下重点
															//									2. 右重点
															//									3. 左重点
															//									4. ユーザーパターン
	unsigned char		selectBL_CorFLCEnable;				// 自動逆光/過順光補正 0. OFF
															//                     1. ON
	unsigned char		selectBL_CorFLC;					// 逆光補正／過順光補正切り替え 0. 逆光補正
															//                              1. 過順光補正
	unsigned char		selectHISTorMAIN;					// 自動補正モード選択 0. 主要被写体指定モード
															//                    1. ヒストグラム分割モード
	ST_MAIN_SUBJ_AREA	st_mainSubjArea;					// "主要被写体指定モード時 エリア指定 （自動補正モード）"	
} ST_AE_CHARACTERISTIC;

/**
 * @struct  ST_PHOTOMETRY_PATTERN
 * @n   ユーザー測光パターン設定構造体
 */
typedef struct st_photometry_pattern {
	unsigned char pattern[100];						// エリア重み
} ST_PHOTOMETRY_PATTERN;

/**
 * @struct  ST_AE_MANUAL
 * @n   AEマニュアルモード設定構造体
 */
typedef struct st_ae_manual_mode {
	unsigned short		shutter_speed;						// シャッタースピード設定
	unsigned short		gain;								// ゲイン設定
} ST_AE_MANUAL_MODE;

/**
 * @struct ST_CONV_ADJ
 * @brief AE収束調整設定構造体
 *
 */
typedef struct st_convergence_adjust {
  unsigned short aeSpeed;						// 収束速度調整
  unsigned short deadZoneOut;					// 不感帯調整 IN閾値
  unsigned short deadZoneIn;					// OUT閾値
}ST_CONV_ADJ;

#ifdef MECHA_IRIS
/**
 * @struct ST_MECHA_IRIS_ADJ
 * @brief メカアイリス調整設定構造体
 *
 */
typedef struct st_mecha_iris_adjust {
  unsigned char flagIrisRegion;					// 調整モード
  unsigned char roughIrisValue;					// アイリス制御値
  unsigned char irisStopUpper;					// 1）停止範囲上限電圧
  unsigned char irisStopLower;					// 2）停止範囲下限電圧
  unsigned char irisCloseSlow;					// 3）アイリス閉低速電圧
  unsigned char irisCloseFast;					// 4）アイリス閉高速電圧
  unsigned char irisOpenSlow;					// 5）アイリス開低速電圧
  unsigned char irisOpenFast;					// 6）アイリス開高速電圧
}ST_MECHA_IRIS_ADJ;
#endif
/**
 * @struct ST_WDR_CHARACTERISTIC
 * @brief "WDR時AE制御特性設定（AEモード：5～6の時有効）"
 *
 */
typedef struct st_WDR_characteristic {
  unsigned short       exposureRatio;           // 露光比率指定WDRモード 露光比率 0x040が１倍 0を指定する場合は0x1000を入力する
  unsigned short       mixExpRatio;             // MIXレジスタ設定 露光比率 0x040が１倍 0を指定する場合は0x1000を入力する
  unsigned short       mixThrLong;              // MIXレジスタ設定 長時間露光閾値 0を指定する場合は0x1000を入力する
  unsigned short       mixThrShort;             // MIXレジスタ設定 短時間露光閾値 0を指定する場合は0x1000を入力する
  unsigned long        mixThrErr;               // MIXレジスタ設定 エラースレッショルド 上位16ビットはSTITCH_ERROR_LIMIT 下位16ビットはSTITCH_ERROR_THRESH
  unsigned char        shortExpoControl;        // 短時間露光AE制御方法 0. 露光補正
												//                      1. ピーク測光
												//                      2. 自動過順光補正アルゴリズム
  unsigned short       autoWdrShortExpTarget;	// オートWDR時短時間露光AE目標値
  unsigned short       autoWdrLongExpTarget;	// オートWDR時長時間露光AE目標値
} ST_WDR_CHARACTERISTIC;


/**
 * @struct  ST_AE
 */
typedef struct st_ae {
  unsigned char       AEMode;                               //  [AE-1]AEモード選択
                                                            // 0 AE 制御なし
                                                            // 1 マニュアルモード
                                                            // 2 通常プログラムモード
                                                            // 3 シャッター制御モード
                                                            // 4 シャッター＆ゲイン制御AEモード
                                                            // 5 露光比指定WDRモード
                                                            // 6 オートWDRモード
  unsigned char       flickerEnable;                        //  フリッカ補正 ON/OFF
  ST_AE_CHARACTERISTIC	aeChara;							// "AE特性設定（AEモード選択：0～2の時有効）
  ST_PHOTOMETRY_PATTERN	photPatt;							// エリア重み[100:1]
  unsigned short      	AETarget;                           // AE目標値 10倍して少数点１位までを設定する
  ST_AE_MANUAL_MODE		aeManual;							// マニュアルモード設定（AEモード選択：マニュアルモードの時有効）
  ST_CONV_ADJ			aeConvAdj;							// AE収束調整（AEモード選択：0～2の時有効）
#ifdef MECHA_IRIS  
	ST_MECHA_IRIS_ADJ		mechaIrisAdjust;					// メカアイリス調整
#endif
  ST_WDR_CHARACTERISTIC	wdrCharacteristic;					// "WDR時AE制御特性設定（AEモード：5～6の時有効）"
  unsigned short		wdrCompoChara1;						// WDR時合成特性設定１ 長時間露光画像 合成実施下限レベル設定
  unsigned short		wdrCompoChara2;						// WDR時合成特性設定２ 短時間露光画像 合成実施上限レベル設定
  unsigned short		wdrCompoChara3;						// WDR時合成特性設定３ 合成エラー検知感度
} ST_AE;

#if 0
/**
 * @struct  GRID_POS
 * @n       DarkShading格子位置格納用構造体
 */
typedef struct st_grid_pos {
  unsigned short  hPosition;                                 //!< 水平座標
  unsigned short  vPosition;                                 //!< 垂直座標
} GRID_POS;

/**
 * @struct  ST_DARK_SHADE
 * @n   [Img-7.2]ダークシェーディング補正設定値格納用構造体
 */
typedef struct st_dark_shade
{
  unsigned char   gridSize;                                  //!< 格子サイズ
  GRID_POS        gridPos;                                   //!< 格子位置
  unsigned short  compTopLeft;                               //!< 左上ポイントデータ
  unsigned short  compTopCenter;                             //!< 中央上ポイントデータ
  unsigned short  compTopRight;                              //!< 右上ポイントデータ
  unsigned short  compCenterLeft;                            //!< 左中央ポイントデータ
  unsigned short  compCenter;                                //!< 中央ポイントデータ
  unsigned short  compCenterRight;                           //!< 右中央ポイントデータ
  unsigned short  compBottomLeft;                            //!< 左下ポイントデータ
  unsigned short  compBottomCenter;                          //!< 中央下ポイントデータ
  unsigned short  compBottomRight;                           //!< 右下ポイントデータ
} ST_DARK_SHADE;
#endif


/**
 * @struct  ST_CORRECT
 * @n   シェーディング補正データ格納用構造体
 */
typedef struct st_correct
{
  union {
    unsigned int   Data[AXH_Shade_Grid_Height_Max][AXH_Shade_Grid_Width];
    struct {
      unsigned char R;
      unsigned char Gr;
      unsigned char Gb;
      unsigned char B;
    } Col [AXH_Shade_Grid_Height_Max][AXH_Shade_Grid_Width];
  };
} ST_CORRECT;

/**
 * @struct  ST_LENS_SHADE
 * @n   [Img-7.3]レンズシェーディング補正設定値格納用構造体
 */
typedef struct st_lens_shade
{
  unsigned char regCorrectStart;                            //  レンズシェーディング補正演算開始
  unsigned char Enabled;                                    //  有効/無効設定
  unsigned char Pitch;                                      //  水平ピッチ
  unsigned char Shift;                                      //  ゲインシフト量
//  補正データを含めると領域オーバーになるので削除する
//  （シェーディング補正エリアを使用する）
//  ST_CORRECT    Correct;                                    //  補正データ
} ST_LENS_SHADE;

/**
 * @struct  ST_IRIDIX
 * @n   [Img-7.8]IRIDIX設定値格納用構造体
 */
typedef struct st_iridix
{
  unsigned char Strength;                                   //  強度
  unsigned char MinSlope;                                   //  最小スロープ
  unsigned char MaxSlope;                                   //  最大スロープ
} ST_IRIDIX;

/**
 * @struct  ST_NR_MAIN
 * @n   3DNR設定値格納用構造体
 */
typedef struct st_nr_main
{
  unsigned char YTH[AXH_NR_Main_Max];                       //  Y信号ノイズ検知レベル設定
  unsigned char YIN[AXH_NR_Main_Max];                       //  Y信号ノイズ削減強度設定
  unsigned char YLV[AXH_NR_Main_Max];                       //  Y信号動き検知設定
  unsigned char CTH[AXH_NR_Main_Max];                       //  C信号ノイズ検知レベル設定
  unsigned char CIN[AXH_NR_Main_Max];                       //  C信号ノイズ削減強度設定
  unsigned char CLV[AXH_NR_Main_Max];                       //  C信号動き検知設定
} ST_NR_MAIN;

/**
 * @struct  ST_NR_SUB
 * @n   2DNR設定値格納用構造体
 */
typedef struct st_nr_sub
{
  unsigned char YTH[AXH_NR_Sub_Max];                       //  Y信号ノイズ検知レベル設定
  unsigned char YIN[AXH_NR_Sub_Max];                       //  Y信号ノイズ削減強度設定
  unsigned char YLV[AXH_NR_Sub_Max];                       //  Y信号動き検知設定
  unsigned char CTH[AXH_NR_Sub_Max];                       //  C信号ノイズ検知レベル設定
  unsigned char CIN[AXH_NR_Sub_Max];                       //  C信号ノイズ削減強度設定
  unsigned char CLV[AXH_NR_Sub_Max];                       //  C信号動き検知設定
} ST_NR_SUB;

/**
 * @struct  ST_NR
 * @n   [Img-7.9]NR設定値格納用構造体
 */
typedef struct st_nr
{
#ifndef DISABLE_NR_MODE
  unsigned int  Mode;                                       //  動作モード
#endif  //  DISABLE_NR_MODE
  ST_NR_MAIN Main;                                          //  3DNR設定値
  ST_NR_SUB  Sub;                                           //  2DNR設定値
} ST_NR;

/**
 * @struct  ST_IMG_SIZE
 * @n   画像サイズ格納用構造体
 */
typedef struct st_img_size
{
  unsigned short Width;
  unsigned short Height;
} ST_IMG_SIZE;

/**
 * @struct  ST_SCL
 * @n   [Img-8.1]スケーラ機能
 */
typedef struct st_scale {
  unsigned char enabled [SCL_SCALING_CH_CNT];               //  スケーリング機能ON
  ST_IMG_SIZE InImgSize;                                    //  入力画像サイズ
  ST_IMG_SIZE OutImgSize[SCL_SCALING_CH_CNT];               //  出力画像サイズ
} ST_SCALE;

/**
 * @struct  ST_FLIP
 * @n   上下・左右反転設定格納用構造体
 */
typedef struct st_flip {
  unsigned char vFlip;                                      //  上下反転[0:反転を行わない/1:行う]
  unsigned char hFlip;                                      //  左右反転[0:反転を行わない/1:行う]
} ST_FLIP;

/**
 * @struct  ST_SCALER
 * @n   [Img-8.1]スケーラ機能
 */
typedef struct st_scaler
{
  ST_SCALE       scaling;                                   //!< 拡大縮小設定
  ST_FLIP        flip   [SCL_NEG_FLIP_CH_CNT];              //!< 上下・左右反転設定
  unsigned char  neg    [SCL_NEG_FLIP_CH_CNT];              //!< ネガポジ反転設定
} ST_SCALER;

/**
 * @struct  ST_OB
 * @n       OB調整格納用構造体
 */
typedef struct st_ob {
  unsigned char   mode;
  short           samplingWidth;
  short           samplingHeight;
  unsigned short  darkLevelFloorR;
  unsigned short  darkLevelFloorGr;
  unsigned short  darkLevelFloorB;
  unsigned short  darkLevelFloorGb;
  unsigned char   sensorArrayPtn;
  unsigned char   arrayPtnIndex[AXH_OBPixelIndex_Max];
  unsigned short  indexValue[AXH_OBIndexValue_Max];
} ST_OB;

/**
 * @struct  ST_RGB_MATRIX
 * @n       RGBマトリックス設定値格納用構造体
 */
typedef struct st_rgb_matrix {
  unsigned short Coef[AXH_RGBMatrixSetOut_Max][AXH_RGBMatrixSetIn_Max];
  unsigned short Offset[AXH_RGBMatrixSetOut_Max];
} ST_RGB_MATRIX;


/**
 * @struct  ST_GAMMA
 * @n       ガンマ調整格納用構造体
 */
typedef struct st_gamma {
  unsigned char   mode;
  unsigned char   curveSelect;
  unsigned short  dRange;
  unsigned short  hRange;
  unsigned short  usrCurvePoint[GAMMA_CURVE_POI_CNT];
  unsigned char   compLevelSelect;
} ST_GAMMA;

/**
 * @struct  ST_APERTURE
 * @n       アパーチャ補正設定値格納用構造体
 */
typedef struct st_aperture {
  unsigned char	totalGain;                                 //!< トータルゲイン
  short			limitPositive;                             //!< 正側リミット設定
  short			limitNegative;                             //!< 負側リミット設定
  unsigned char	coringTh;                                  //!< コアリングしきい値
  unsigned char	midRangeRatio;                             //!< 高域・中域MIX設定(高域に対する中域ゲイン比率)
  unsigned short	weakSignalStrLevel;                        //!< 微小信号強調強度
  unsigned char	darkSupressStartLuminance;                 //!< 暗部アパーチャ抑制開始輝度
  unsigned char	darkCorrectSupressInc;                     //!< 暗部アパーチャ補正抑圧傾き
  unsigned char	highCorrectStartStrongLuminance;           //!< 高輝度側アパーチャ補正強化開始輝度
  unsigned char	highCorrectStrongInc;                      //!< 高輝度側アパーチャ補正強化傾き
  unsigned char	highCorrectStrongLimit;                    //!< 高輝度側アパーチャ補正強化リミット
} ST_APERTURE;

/**
 * @struct  ST_CHROMA
 * @n       クロマサプレス設定値格納用構造体
 */
typedef struct st_chroma {
  unsigned char   darkStartLuminance;                       //!< 暗部クロマプレス開始輝度
  unsigned char   darkInc;                                  //!< 暗部クロマサプレス傾き
  unsigned char   highColorStartLuminance;                  //!< 高輝度側色強化開始輝度
  unsigned char   highColorInc;                             //!< 高輝度側色強化傾き
  unsigned char   highColorLimit;                           //!< 高輝度側色強化リミット
  unsigned char   highLightStartLuminance;                  //!< ハイライトクロマサプレス開始輝度
  unsigned char   highLightInc;                             //!< ハイライトクロマサプレス傾き
  unsigned char   edgeTh;                                   //!< エッジしきい値
  unsigned char   edgeSuppressStrong;                       //!< サプレス強度
  unsigned char   lowStartGain;                             //!< 低輝度クロマサプレス開始ゲイン
  unsigned char   lowInc;                                   //!< 低輝度クロマサプレス傾き
} ST_CHROMA;

/**
 * @struct ST_DAY_NIGHT
 * @n   Day/Night機能の調整設定構造体
 * @n   
 */
typedef struct st_day_night {
  unsigned char	dayNightMode;			//  Day/Nightモード  0. OFF
										// 					 1. ON"
  unsigned char	judgeMode;				// 判定モード  0. AGCとシャッタスピードから算出されるセンサー像面照度に基づく判定
										//             1. AGCに基づく判定"
  unsigned short upperLimit;			// 上限設定（判定モード：センサー像面照度に基づく判定）"
  unsigned short dayNightInThre;		// Day/Nightモード IN点閾値
  unsigned short dayNightOutThre;		// Day/Nightモード OUT点閾値
  unsigned short judgeTransTime;		// 判定遷移時間
  unsigned short nightColorSig;			// Night時の色信号設定
  unsigned char  forceMode;				// 強制モード  0. OFF
										//             1. ON
  unsigned char  forceDayNightSelect;	// 強制モード時Day/Night選択 0. Dayモード
										//                           1. Nightモード
} ST_DAY_NIGHT;

/**
 * @struct ST_AFHW_H
 * @n   水平AFエリア座標設定構造体
 * @n   
 */
typedef struct st_afhw_h {
	unsigned short afhw_h_hstart[9];	// 水平開始座標
	unsigned short afhw_h_hend[9];		// 水平終了座標
	unsigned short afhw_h_vstart[9];	// 垂直開始座標
	unsigned short afhw_h_vend[9];		// 垂直終了座標
} ST_AFHW_H;

/**
 * @struct ST_AFHW_H_FILTER
 * @n   水平AFフィルタ設定構造体
 * @n   
 */
typedef struct st_afhw_h_filter {
	unsigned char afhw_h_[2];	// 計算する色の選択 ?
	unsigned char afhw_h_haveon[2];	// 水平平均制御
	unsigned char afhw_h_vaveon[2];	// 垂直平均制御
	unsigned char afhw_h_afsqrsht[2];	// 二乗値に対するシフト数
	unsigned short afhw_h_accth[2];	// 計算結果のコアリングレベル
	unsigned short afhw_h_cor[2];	// 画素値のコアリングレベル
	unsigned char afhw_h_afpitch;		// 高域フィルタのピッチ
	unsigned char afhw_h_afsqrsel;		// 高域フィルタの計算方法
	unsigned char afhw_h_afpitchl;		// 低域フィルタのピッチ
} ST_AFHW_H_FILTER;

/**
 * @struct ST_AFHW_V
 * @n   垂直AFエリア座標設定構造体
 * @n   
 */
typedef struct st_afhw_v {
	unsigned short afhw_v_hstart;	// 水平開始座標
	unsigned short afhw_v_hend;		// 水平終了座標
	unsigned short afhw_v_vstart;	// 垂直開始座標
	unsigned short afhw_v_vend;		// 垂直終了座標
} ST_AFHW_V;

/**
 * @struct ST_AFHW_V_FILTER
 * @n   垂直AFフィルタ設定構造体
 * @n   
 */
typedef struct st_afhw_v_filter {
	unsigned char afhw_v_;	// 計算する色の選択 ?
	unsigned char afhw_v_haveon;	// 水平平均制御
	unsigned char afhwvh_vaveon;	// 垂直平均制御
	unsigned char afhw_v_afsqrsel;		// 高域フィルタの計算方法
	unsigned char afhw_v_afsqrsht;	// 二乗値に対するシフト数
	unsigned short afhw_v_accth;	// 計算結果のコアリングレベル
} ST_AFHW_V_FILTER;

/**
 * @struct ST_AF_DETEC_OUT
 * @n   水平AF検波結果構造体
 * @n   
 */
typedef struct st_afh_h_eval {
	unsigned long	afhHfEval[9];	// 高域フィルタ検波結果
	unsigned long	afhHfPeak[9];	// 高域フィルタピーク値
	unsigned long	afhLfEval[9];	// 低域フィルタ検波結果
	unsigned long	afhLfPeak[9];	// 低域フィルタピーク値

} ST_AFH_H_EVAL;

/**
 * @struct ST_AF_DETEC_OUT
 * @n   垂直AF検波結果構造体
 * @n   
 */
typedef struct st_afh_v_eval {
	unsigned long	afhVEval;	// 垂直AF検波結果
	unsigned long	afhVfPeak;	// 垂直AF検波ピーク値

} ST_AFH_V_EVAL;

/**
 * @struct ST_AF_DEC_START_DIR
 * @n   AF開始時方向決定
 * @n   
 */
typedef struct st_af_decide_start_direction {
	unsigned char	afStartDir;				// 初動方向
	unsigned long	afStartDirChangeThresh;	// 開始時方向切替判定閾値
	unsigned short	afStartDirJudMax;		// 開始時方向切替判定所定回数

} ST_AF_DEC_START_DIR;

/**
 * @struct ST_AF
 * @n   AF機能設定構造体
 * @n   
 */
typedef struct st_af {
	unsigned char	focusArea;			// フォーカスエリア指定 0～8
	unsigned char	afStartDir;				// 初動方向
	unsigned short	afStartDirJudMax;		// 開始時方向切替判定所定回数
	long	afStartDirChangeThresh;	// 開始時方向切替判定閾値
//	ST_AF_DEC_START_DIR afStart;		// 開始時方向判定
	long	afChngSpedThresh;	// 駆動速度切替閾値
	long	afOverPeakThresh;	// 頂点超え閾値
	long	afEvalRebootThresh;	// 再起動閾値
	unsigned char	afEvalPeakRatio;	// ピークに戻る時のAF評価値比率（％）
	unsigned char	afOneShotEnable;	// AFワンショットモードOn/Off
	unsigned short	lensAtEndJudg;		// レンズが端にあるか判定用
} ST_AF;

/**
 * @struct ST_IMAGESENSOR
 * @n   イメージセンサ設定構造体
 * @n   
 */
typedef struct st_imagesensor {
	unsigned char	lensKind;			// レンズ種類
										//	0 マニュアル
										//	1 DCアイリス
										//	2 P-アイリス
										//	4 フォーカス (1,2と同時設定あり)

} ST_IMAGESENSOR;

/**
 * @struct ST_AF_DETEC_OUT
 * @n   AF検波値出力機能設定構造体
 * @n   
 */
typedef struct st_af_detect_output {
	ST_AFHW_H			afhwh;
	ST_AFHW_H_FILTER	afhwhFilter;
	ST_AFHW_V			afhwv;
	ST_AFHW_V_FILTER	afhwvFilter;
	ST_AFH_H_EVAL		afhwHEval;
	ST_AFH_V_EVAL		afhwVEval;
} ST_AF_DETEC_OUT;

/**
 * @struct ST_SPEC
 * @n   デバッグ用設定値格納用構造体
 * @n   デバッグ用(eclipse上で変数を変更できる)に整数型を使用
 */
typedef struct st_spec {
  unsigned long   changeStatus[2];                          //!<  変更ステータスフラグ

  unsigned char   Mode;                                     //!<  モード格納用
  ST_AWB          AWB;                                      //!<  AWB設定値
  ST_AE           AE;                                       //!<  AE設定値


  unsigned char   if_imageSensorMode;                       //!< センサー品番およびモード

  unsigned char   imageIFOpeMode;                           //!< ImageIF動作モード

  ST_OB           OB;

  ST_RGB_MATRIX   RGBMatrix;                                //  [Img-6.2]RGBマトリックス

  ST_GAMMA        Gamma;                                    //!< ガンマ設定

  ST_APERTURE     Aperture;                                 //!< アパーチャ補正

  ST_DEFECT       Defect;                                   //  [Img-7.1]画素欠陥補正
#if 0
  ST_DARK_SHADE   DarkShade;                                //  [Img-7.2]ダークシェーディング補正
#endif
  ST_LENS_SHADE   LensShade;                                //  [Img-7.3]レンズシェーディング補正

  ST_CHROMA       CHROMA;                                   //!< クロマサプレス設定値

  ST_IRIDIX       Iridix;                                   //  [Img-7.8]Iridix設定値
  ST_NR           NR;                                       //  [Img-7.9]3DNR設定値

  ST_SCALER       Scaler;                                   //  スケーラー機能

  ST_DAY_NIGHT    DayNight;						            // Day/Night機能の調整

  ST_AF_DETEC_OUT AFDetectOut;								// AF検波値出力機能

  ST_AF           AF;

  ST_IMAGESENSOR  ImageSensor;
} ST_SPEC;

#endif /* AXH_SPEC_STRUCT_HPP_ */
