/**
 * @file   AdjSpec.c
 * @brief  Source file for adjusting spec.
 * @par    Programming Language
 *         C
 */
#include "AdjSpec.h"

#define reg32_wr(addr, wdata)           (*(volatile uint32_t *)(addr)) = (uint32_t)(wdata)
#define reg32(addr)                     (*(volatile uint32_t *)(addr))
#define reg16_wr(addr, wdata)           (*(volatile uint16_t *)(addr)) = (uint16_t)(wdata & 0x0000FFFF)
#define reg16(addr)                     (*(volatile uint16_t *)(addr))
#define reg8_wr(addr, wdata)           (*(volatile uint8_t *)(addr)) = (uint8_t)(wdata & 0x000000FF)
#define reg8(addr)                     (*(volatile uint8_t *)(addr))

//
//	AX設定更新
//
void setSpec(uint32_t addr, uint32_t dat)
{
	if ((addr >= ADJSP_CHANG_STATUS) && (addr < ADJSP_MODE)) {																// changeStatus
		// 32bit書き込み
		reg32_wr(addr, dat);
	} else if (	((addr >= ADJSP_AWB_OP_AREA) && (addr < ADJSP_AWB_OP_RANGE)) ||								// AWB.OnePush.Area
							((addr >= ADJSP_AWB_OP_AREA) && (addr < ADJSP_AWB_OP_RANGE)) ||								// AWB.LightRange.CPnt
							((addr >= ADJSP_AWB_OFF_PNT) && (addr < ADJSP_AWB_ADJMATRIX_MATRIX)) ||				// AWB.Offset.Pnt
							((addr >= ADJSP_AWB_ADJMATRIX_MATRIX) && (addr < ADJSP_AWB_WBGAIN_RGAIN)) ||	// AWB.AdjustMatrix
							((addr >= ADJSP_AWB_LIGHTSRC) && (addr < ADJSP_AWB_LIGHTDEF)) ||							// AWB.LightSource
							((addr >= ADJSP_AWB_LIGHTDEF) && (addr < ADJSP_AWB_OPDTRUST_TH)) ||						// AWB.LightDefault
							((addr >= ADJSP_AWB_COLORMTX_MATRIX) && (addr < ADJSP_AWB_COLORMTX_CC11))) {	// AWB.ColorMatrix.Matrix
		// 16bit書き込み
		reg16_wr(addr, dat);
	} else if (	((addr >= ADJSP_AWB_LIGHTW_WAIGHT) && (addr < ADJSP_AWB_STOPLOWBRIGHTTH)) ||	// AWB.LightWeight.Weight
							((addr >= ADJSP_AWB_OPDWAIGHT_MODE) && (addr < ADJSP_AWB_OPDMASK_PNT)) ||			// AWB.OPDWeight.WeightMode
							((addr >= ADJSP_AWB_OPDMASK_PNT) && (addr < ADJSP_AWB_SPECADJ_LOWSTART)) ||		// AWB.OPDMask.Pnt
							((addr >= ADJSP_AE_PHOTPATT_PATTERN) && (addr < ADJSP_AE_AETARGET))) {				// AE.photPatt.pattern
		// 8bit書き込み
		reg8_wr(addr, dat);
	} else {
		switch (addr) {
			case ADJSP_AE_CHARA_SSHTTMAX:						// AE.aeChara.slowShutterMax
			case ADJSP_AE_WDRCHR_MIXTHRERR:					// AE.wdrCharacteristic.mixThrErr
				// 32bit書き込み
				reg32_wr(addr, dat);
				break;
			case ADJSP_AWB_MANU_MODE_COLOR:					// AWB.ManuModeColorTemp
			case ADJSP_AWB_LIGHTRANGE_LTMPADJ:			// AWB.LightRange.LTempAdjust
			case ADJSP_AWB_LIGHTRANGE_HTMPADJ:			// AWB.LightRange.HTempAdjust
			case ADJSP_AWB_LIGHTRANGE_MGDIRADJ:			// AWB.LightRange.MgDirAdjust
			case ADJSP_AWB_LIGHTRANGE_GDIRADJ:			// AWB.LightRange.GDirAdjust
			case ADJSP_AWB_WBGAIN_RGAIN:						// AWB.WBGain.rGain
			case ADJSP_AWB_WBGAIN_BGAIN:						// AWB.WBGain.bGain
			case ADJSP_AWB_CONV_SPEED:							// AWB.Convergence.Speed
			case ADJSP_AWB_CONV_LIGHTTH:						// AWB.Convergence.LightTH
			case ADJSP_AWB_CONV_STABLETH:						// AWB.Convergence.StableTH
			case ADJSP_AWB_CONV_STABLETERM:					// AWB.Convergence.StableTern
			case ADJSP_AWB_STOPLOWBRIGHTTH:					// AWB.stopLowBrightTH
			case ADJSP_AWB_OPDSET_HLIMIT:						// AWB.OPDSet.Hlimit
			case ADJSP_AWB_OPDSET_LLIMIT:						// AWB.OPDSet.Lllimit
			case ADJSP_AWB_SPECADJ_PNTLOW_BG:				// AWB.SpectrumAdjust.pntLowTemp.Bg
			case ADJSP_AWB_SPECADJ_PNTLOW_RG:				// AWB.SpectrumAdjust.pntLowTemp.Rg
			case ADJSP_AWB_SPECADJ_PNTHIGH_BG:			// AWB.SpectrumAdjust.pntHighTemp.Bg
			case ADJSP_AWB_SPECADJ_PNTHIGH_RG:			// AWB.SpectrumAdjust.pntHighTemp.Rg
			case ADJSP_AWB_OPDTRUST_TH:							// AWB.OPDTrust.TH
			case ADJSP_AWB_COLORMTX_CC11:						// AWB.ColorMatrix.CC11
			case ADJSP_AWB_COLORMTX_COF1:						// AWB.ColorMatrix.COF1
			case ADJSP_AE_CHARA_SHTTSPEED_U:				// AE.aeChara.st_shutterSpeed.upper
			case ADJSP_AE_CHARA_SHTTSPEED_L:				// AE.aeChara.st_shutterSpeed.lower
			case ADJSP_AE_CHARA_GAINUP:							// AE.aeChara.gainUpper
			case ADJSP_AE_AETARGET:									// AE.AETarget
			case ADJSP_AE_AEMANU_SHTTSPEED:					// AE.aeManual.shutter_speed
			case ADJSP_AE_AEMANU_GAIN:							// AE.aeManual.gain
			case ADJSP_AE_AECONVADJ_AESPEED:				// AE.aeConvAdj.aeSpeed
			case ADJSP_AE_AECONVADJ_DEADZONEOUT:		// AE.aeConvAdj.deadZoneOut
			case ADJSP_AE_AECONVADJ_DEADZONEIN:			// AE.aeConvAdj.deadZoneIn
			case ADJSP_AE_WDRCHR_EXPRATIO:					// AE.wdrCharacteristic.exposureRatio
			case ADJSP_AE_WDRCHR_MIXEXPRATIO:				// AE.wdrCharacteristic.mixExpRatio
			case ADJSP_AE_WDRCHR_MIXTHRLNG:					// AE.wdrCharacteristic.mixThrLong
			case ADJSP_AE_WDRCHR_MIXTHRSHT:					// AE.wdrCharacteristic.mixThrShort
			case ADJSP_AE_WDRCHR_AUTOWDRSEXPTGT:		// AE.wdrCharacteristic.autoWdrShortExpTarget
			case ADJSP_AE_WDRCHR_AUTOWDRLEXPTGT:		// AE.wdrCharacteristic.autoWdrLongExpTarget
			case ADJSP_AE_WDRCMPCHARA1:							// AE.wdrCompoChara1
			case ADJSP_AE_WDRCMPCHARA2:							// AE.wdrCompoChara2
			case ADJSP_AE_WDRCMPCHARA3:							// AE.wdrCompoChara3
				// 16bit書き込み
				reg16_wr(addr, dat);
				break;
			case ADJSP_MODE:												// Mode
			case ADJSP_AWB_MODE:										// AWB.AWBMode
			case ADJSP_AWB_ATW_SMODE:								// AWB.ATWSceaneMode
			case ADJSP_AWB_MANU_MODE_LIGHT_SEL:			// AWB.ManuModeLightSelect
			case ADJSP_AWB_OP_START:								// AWB.OnePush.Start
			case ADJSP_AWB_OP_RANGE:								// AWB.OnePush.Range
			case ADJSP_AWB_OP_SPEED:								// AWB.OnePush.Speed
			case ADJSP_AWB_OPDSET_HDIV:							// AWB.OPDSet.Hdiv
			case ADJSP_AWB_OPDSET_VDIV:							// AWB.OPDSet.Vdiv
			case ADJSP_AWB_OPDWEIGHT_V1:						// AWB.OPDWeight.V1
			case ADJSP_AWB_OPDWEIGHT_H2:						// AWB.OPDWeight.H2
			case ADJSP_AWB_OPDWAIGHT_H3:						// AWB.OPDWeight.H3
			case ADJSP_AWB_OPDWAIGHT_V4:						// AWB.OPDWeight.V4
			case ADJSP_AWB_SPECADJ_LOWSTART:				// AWB.SpectrumAdjust.regLowTempStart
			case ADJSP_AWB_SPECADJ_HIGHSTART:				// AWB.SpectrumAdjust.regHighTempStart
			case ADJSP_AWB_OPDTRUST_SEL:						// AWB.OPDTrust.Sel
			case ADJSP_AWB_OPDTRUST_ZERO:						// AWB.OPDTrust.Zero
			case ADJSP_AWB_COLORMTX_MODE:						// AWB.ColorMatrix.Mode
			case ADJSP_AE_MODE:											// AE.AEMode
			case ADJSP_AE_FLICKER_ENABLE:						// AE.flickerEnable
			case ADJSP_AE_CHARA_SSHTTENABLE:				// AE.aeChara.slowShutterEnable
			case ADJSP_AE_CHARA_GAINSSHTTPRIO:			// AE.aeChara.gainSlowShutterPrio
			case ADJSP_AE_CHARA_PHOTOPATNO:					// AE.aeChara.photometryPatNo
			case ADJSP_AE_CHARA_SELBLCFLCENABLE:		// AE.aeChara.selectBL_CorFLCEnable
			case ADJSP_AE_CHARA_SELBLCFLC:					// AE.aeChara.selectBL_CorFLC
			case ADJSP_AE_CHARA_SELHISTMAIN:				// AE.aeChara.selectHISTorMAIN
			case ADJSP_AE_STMAINSAREA_START_H:			// AE.aeChara.st_mainSubjArea.start.h
			case ADJSP_AE_STMAINSAREA_START_V:			// AE.aeChara.st_mainSubjArea.start.v
			case ADJSP_AE_STMAINSAREA_END_H:				// AE.aeChara.st_mainSubjArea.end.h
			case ADJSP_AE_STMAINSAREA_END_V:				// AE.aeChara.st_mainSubjArea.end.v
#ifdef MECHA_IRIS
			case ADJSP_AE_MIRISADJ_FLGREGION:				// AE.mechaIrisAdjust.flagIrisRegion
			case ADJSP_AE_MIRISADJ_RIRISVAL:				// AE.mechaIrisAdjust.roughIrisValue
			case ADJSP_AE_MIRISADJ_IRISSTOPU:				// AE.mechaIrisAdjust.irisStopUpper
			case ADJSP_AE_MIRISADJ_IRISSTOPL:				// AE.mechaIrisAdjust.irisStopLower
			case ADJSP_AE_MIRISADJ_IRISCLSS:				// AE.mechaIrisAdjust.irisCloseSlow
			case ADJSP_AE_MIRISADJ_IRISCLSF:				// AE.mechaIrisAdjust.irisCloseFast
			case ADJSP_AE_MIRISADJ_IRISOPNS:				// AE.mechaIrisAdjust.irisOpenSlow
			case ADJSP_AE_MIRISADJ_IRISOPNF:				// AE.mechaIrisAdjust.irisOpenFast
			case ADJSP_AE_WDRCHR_SHTEXPCTRL:				// AE.wdrCharacteristic.shortExpoControl
#endif
				// 8bit書き込み
				reg8_wr(addr, dat);
				break;
			default:
				// 32bit書き込み（LISr制御用）
				reg32_wr(addr, dat);
				break;
		}
	}
}


//
//	AX設定値取得
//
uint32_t getSpec(uint32_t addr)
{
	uint32_t retVal = 0;
	
	if ((addr >= ADJSP_CHANG_STATUS) && (addr < ADJSP_MODE)) {																// changeStatus
		// 32bit読み込み
		retVal = reg32(addr);
	} else if (	((addr >= ADJSP_AWB_OP_AREA) && (addr < ADJSP_AWB_OP_RANGE)) ||								// AWB.OnePush.Area
							((addr >= ADJSP_AWB_OP_AREA) && (addr < ADJSP_AWB_OP_RANGE)) ||								// AWB.LightRange.CPnt
							((addr >= ADJSP_AWB_OFF_PNT) && (addr < ADJSP_AWB_ADJMATRIX_MATRIX)) ||				// AWB.Offset.Pnt
							((addr >= ADJSP_AWB_ADJMATRIX_MATRIX) && (addr < ADJSP_AWB_WBGAIN_RGAIN)) ||	// AWB.AdjustMatrix
							((addr >= ADJSP_AWB_LIGHTSRC) && (addr < ADJSP_AWB_LIGHTDEF)) ||							// AWB.LightSource
							((addr >= ADJSP_AWB_LIGHTDEF) && (addr < ADJSP_AWB_OPDTRUST_TH)) ||						// AWB.LightDefault
							((addr >= ADJSP_AWB_COLORMTX_MATRIX) && (addr < ADJSP_AWB_COLORMTX_CC11))) {	// AWB.ColorMatrix.Matrix
		// 16bit読み込み
		retVal = (uint32_t)reg16(addr);
	} else if (	((addr >= ADJSP_AWB_LIGHTW_WAIGHT) && (addr < ADJSP_AWB_STOPLOWBRIGHTTH)) ||	// AWB.LightWeight.Weight
							((addr >= ADJSP_AWB_OPDWAIGHT_MODE) && (addr < ADJSP_AWB_OPDMASK_PNT)) ||			// AWB.OPDWeight.WeightMode
							((addr >= ADJSP_AWB_OPDMASK_PNT) && (addr < ADJSP_AWB_SPECADJ_LOWSTART)) ||		// AWB.OPDMask.Pnt
							((addr >= ADJSP_AE_PHOTPATT_PATTERN) && (addr < ADJSP_AE_AETARGET))) {				// AE.photPatt.pattern
		// 8bit読み込み
		retVal = (uint32_t)reg8(addr);
	} else {
		switch (addr) {
			case ADJSP_AE_CHARA_SSHTTMAX:						// AE.aeChara.slowShutterMax
			case ADJSP_AE_WDRCHR_MIXTHRERR:					// AE.wdrCharacteristic.mixThrErr
				// 32bit読み込み
				retVal = reg32(addr);
				break;
			case ADJSP_AWB_MANU_MODE_COLOR:					// AWB.ManuModeColorTemp
			case ADJSP_AWB_LIGHTRANGE_LTMPADJ:			// AWB.LightRange.LTempAdjust
			case ADJSP_AWB_LIGHTRANGE_HTMPADJ:			// AWB.LightRange.HTempAdjust
			case ADJSP_AWB_LIGHTRANGE_MGDIRADJ:			// AWB.LightRange.MgDirAdjust
			case ADJSP_AWB_LIGHTRANGE_GDIRADJ:			// AWB.LightRange.GDirAdjust
			case ADJSP_AWB_WBGAIN_RGAIN:						// AWB.WBGain.rGain
			case ADJSP_AWB_WBGAIN_BGAIN:						// AWB.WBGain.bGain
			case ADJSP_AWB_CONV_SPEED:							// AWB.Convergence.Speed
			case ADJSP_AWB_CONV_LIGHTTH:						// AWB.Convergence.LightTH
			case ADJSP_AWB_CONV_STABLETH:						// AWB.Convergence.StableTH
			case ADJSP_AWB_CONV_STABLETERM:					// AWB.Convergence.StableTern
			case ADJSP_AWB_STOPLOWBRIGHTTH:					// AWB.stopLowBrightTH
			case ADJSP_AWB_OPDSET_HLIMIT:						// AWB.OPDSet.Hlimit
			case ADJSP_AWB_OPDSET_LLIMIT:						// AWB.OPDSet.Lllimit
			case ADJSP_AWB_SPECADJ_PNTLOW_BG:				// AWB.SpectrumAdjust.pntLowTemp.Bg
			case ADJSP_AWB_SPECADJ_PNTLOW_RG:				// AWB.SpectrumAdjust.pntLowTemp.Rg
			case ADJSP_AWB_SPECADJ_PNTHIGH_BG:			// AWB.SpectrumAdjust.pntHighTemp.Bg
			case ADJSP_AWB_SPECADJ_PNTHIGH_RG:			// AWB.SpectrumAdjust.pntHighTemp.Rg
			case ADJSP_AWB_OPDTRUST_TH:							// AWB.OPDTrust.TH
			case ADJSP_AWB_COLORMTX_CC11:						// AWB.ColorMatrix.CC11
			case ADJSP_AWB_COLORMTX_COF1:						// AWB.ColorMatrix.COF1
			case ADJSP_AE_CHARA_SHTTSPEED_U:				// AE.aeChara.st_shutterSpeed.upper
			case ADJSP_AE_CHARA_SHTTSPEED_L:				// AE.aeChara.st_shutterSpeed.lower
			case ADJSP_AE_CHARA_GAINUP:							// AE.aeChara.gainUpper
			case ADJSP_AE_AETARGET:									// AE.AETarget
			case ADJSP_AE_AEMANU_SHTTSPEED:					// AE.aeManual.shutter_speed
			case ADJSP_AE_AEMANU_GAIN:							// AE.aeManual.gain
			case ADJSP_AE_AECONVADJ_AESPEED:				// AE.aeConvAdj.aeSpeed
			case ADJSP_AE_AECONVADJ_DEADZONEOUT:		// AE.aeConvAdj.deadZoneOut
			case ADJSP_AE_AECONVADJ_DEADZONEIN:			// AE.aeConvAdj.deadZoneIn
			case ADJSP_AE_WDRCHR_EXPRATIO:					// AE.wdrCharacteristic.exposureRatio
			case ADJSP_AE_WDRCHR_MIXEXPRATIO:				// AE.wdrCharacteristic.mixExpRatio
			case ADJSP_AE_WDRCHR_MIXTHRLNG:					// AE.wdrCharacteristic.mixThrLong
			case ADJSP_AE_WDRCHR_MIXTHRSHT:					// AE.wdrCharacteristic.mixThrShort
			case ADJSP_AE_WDRCHR_AUTOWDRSEXPTGT:		// AE.wdrCharacteristic.autoWdrShortExpTarget
			case ADJSP_AE_WDRCHR_AUTOWDRLEXPTGT:		// AE.wdrCharacteristic.autoWdrLongExpTarget
			case ADJSP_AE_WDRCMPCHARA1:							// AE.wdrCompoChara1
			case ADJSP_AE_WDRCMPCHARA2:							// AE.wdrCompoChara2
			case ADJSP_AE_WDRCMPCHARA3:							// AE.wdrCompoChara3
				// 16bit読み込み
				retVal = (uint32_t)reg16(addr);
				break;
			case ADJSP_MODE:												// Mode
			case ADJSP_AWB_MODE:										// AWB.AWBMode
			case ADJSP_AWB_ATW_SMODE:								// AWB.ATWSceaneMode
			case ADJSP_AWB_MANU_MODE_LIGHT_SEL:			// AWB.ManuModeLightSelect
			case ADJSP_AWB_OP_START:								// AWB.OnePush.Start
			case ADJSP_AWB_OP_RANGE:								// AWB.OnePush.Range
			case ADJSP_AWB_OP_SPEED:								// AWB.OnePush.Speed
			case ADJSP_AWB_OPDSET_HDIV:							// AWB.OPDSet.Hdiv
			case ADJSP_AWB_OPDSET_VDIV:							// AWB.OPDSet.Vdiv
			case ADJSP_AWB_OPDWEIGHT_V1:						// AWB.OPDWeight.V1
			case ADJSP_AWB_OPDWEIGHT_H2:						// AWB.OPDWeight.H2
			case ADJSP_AWB_OPDWAIGHT_H3:						// AWB.OPDWeight.H3
			case ADJSP_AWB_OPDWAIGHT_V4:						// AWB.OPDWeight.V4
			case ADJSP_AWB_SPECADJ_LOWSTART:				// AWB.SpectrumAdjust.regLowTempStart
			case ADJSP_AWB_SPECADJ_HIGHSTART:				// AWB.SpectrumAdjust.regHighTempStart
			case ADJSP_AWB_OPDTRUST_SEL:						// AWB.OPDTrust.Sel
			case ADJSP_AWB_OPDTRUST_ZERO:						// AWB.OPDTrust.Zero
			case ADJSP_AWB_COLORMTX_MODE:						// AWB.ColorMatrix.Mode
			case ADJSP_AE_MODE:											// AE.AEMode
			case ADJSP_AE_FLICKER_ENABLE:						// AE.flickerEnable
			case ADJSP_AE_CHARA_SSHTTENABLE:				// AE.aeChara.slowShutterEnable
			case ADJSP_AE_CHARA_GAINSSHTTPRIO:			// AE.aeChara.gainSlowShutterPrio
			case ADJSP_AE_CHARA_PHOTOPATNO:					// AE.aeChara.photometryPatNo
			case ADJSP_AE_CHARA_SELBLCFLCENABLE:		// AE.aeChara.selectBL_CorFLCEnable
			case ADJSP_AE_CHARA_SELBLCFLC:					// AE.aeChara.selectBL_CorFLC
			case ADJSP_AE_CHARA_SELHISTMAIN:				// AE.aeChara.selectHISTorMAIN
			case ADJSP_AE_STMAINSAREA_START_H:			// AE.aeChara.st_mainSubjArea.start.h
			case ADJSP_AE_STMAINSAREA_START_V:			// AE.aeChara.st_mainSubjArea.start.v
			case ADJSP_AE_STMAINSAREA_END_H:				// AE.aeChara.st_mainSubjArea.end.h
			case ADJSP_AE_STMAINSAREA_END_V:				// AE.aeChara.st_mainSubjArea.end.v
#ifdef MECHA_IRIS
			case ADJSP_AE_MIRISADJ_FLGREGION:				// AE.mechaIrisAdjust.flagIrisRegion
			case ADJSP_AE_MIRISADJ_RIRISVAL:				// AE.mechaIrisAdjust.roughIrisValue
			case ADJSP_AE_MIRISADJ_IRISSTOPU:				// AE.mechaIrisAdjust.irisStopUpper
			case ADJSP_AE_MIRISADJ_IRISSTOPL:				// AE.mechaIrisAdjust.irisStopLower
			case ADJSP_AE_MIRISADJ_IRISCLSS:				// AE.mechaIrisAdjust.irisCloseSlow
			case ADJSP_AE_MIRISADJ_IRISCLSF:				// AE.mechaIrisAdjust.irisCloseFast
			case ADJSP_AE_MIRISADJ_IRISOPNS:				// AE.mechaIrisAdjust.irisOpenSlow
			case ADJSP_AE_MIRISADJ_IRISOPNF:				// AE.mechaIrisAdjust.irisOpenFast
#endif
			case ADJSP_AE_WDRCHR_SHTEXPCTRL:				// AE.wdrCharacteristic.shortExpoControl
				// 8bit読み込み
				retVal = (uint32_t)reg8(addr);
				break;
			default:
				// 32bit読み込み（LISr制御用）
				retVal = reg32(addr);
				break;
		}
	}
}
