/**
 * AdjTask.h
 */
#ifndef _ADJTASK_H_
#define _ADJTASK_H_

#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "timers.h"

#include "lisoc.h"
#include "register_top.h"

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */
	
/***************************************************************
* Constants
***************************************************************/

/**
 * @brief 調整用タスクを初期化する
 *
 * @retval pdPASS	正常終了
 * @retval pdFAIL	異常終了
 */
BaseType_t adjTaskInit(void);

/**
 * @brief 調整用タスクの処理
 *
 * @param [in]	param	タスクパラメータ
 */
void adjTask(void *param);
	
#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif	/* _ADKTASK_H_ */