/*
 * AXMCommonStruct.hpp
 */

#ifndef AXMCOMMONSTRUCT_HPP_
#define AXMCOMMONSTRUCT_HPP_

#include "AXHSpecStruct.hpp"

#include "AXMCommon/AXMCommonTypedefine.hpp"

/**
 * @struct ST_MSG
 * @n   メールボックス送受信用構造体定義
 */
typedef struct st_msg {
  UCHAR   sid;                          //  送信元ID
  UCHAR   rid;                          //  受信先ID
  USHORT  cmd;                          //  コマンド
  VOID    *data;                        //  メッセージ
} ST_MSG;

/**
 * @struct ST_AWB_CALC
 * @n   AWB 演算データ用構造体定義
 */
typedef struct st_awb_calc {
  USHORT  Luminance;                    //  明るさ情報(lx)
} ST_AWB_CALC;

/**
 * @struct  ST_AWB_ADJUST
 * @n   バラつき調整データ格納用構造体(メールボックス送受信)
 */
typedef struct st_awb_adjust {
  ST_AREA       LightSource[AWBLightSource_Rolling_Max];    //  光源枠座標
  ST_COL_POINT  LightDefault[AWBLightDefault_Max];          //  光源デフォルト座標
  ST_COL_POINT  pntLowTemp;                                 //  低色温度側基準点座標
  ST_COL_POINT  pntHighTemp;                                //  高色温度側基準点座標
} ST_AWB_ADJUST;

/**
 * @struct  ST_AWB_STATUS
 * @n   AWB状態出力用構造体(メールボックス送受信)
 */
typedef struct st_awb_status {
  UCHAR       Sts_Convergence;                              //  引き込み動作ステータス
  UCHAR       TrustJudge;                                   //  信頼性判定結果
  UCHAR       Sts_LightSourceErr;                           //  光源枠外エラー
  ST_WB_GAIN  WBGain;                                       //  WBゲイン
  CHAR        LightSource;                                  //  照明判定結果
} ST_AWB_STATUS;

enum ImageSensorChange {
	E_ISCHANG_none    = 0x00,
	E_ISCHANG_shutter = 0x01,
	E_ISCHANG_gain    = 0x02,
	E_ISCHANG_vmax    = 0x04
};

typedef struct  {
	UINT st_change_sts;
	UINT st_time;
	UINT st_gain;
	UINT st_frm;
} ImageSensorParam ;

typedef struct st_controlAF {
	UINT lensMove;
}ST_CONTROL_AF;

#endif  //  AXMCOMMONSTRUCT_HPP_
