/**
 * @file   AXMImageSensorState.hpp
 * @brief  AXMImageSensor IFクラス StateMachineオブジェクトヘッダ
 *
 * @n      ImageSensor IFクラス
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

  typedef unsigned char   UCHAR;

  // StateMachine用状態定義
  enum ModelState {
    STATE_WAITING = 0,
    STATE_RUNNING ,
    STATE_MAX
  };

  // StateMachine用イベント定義
  enum ModelEvent {
    ISP_EVENT_IMAGESENSOR = AXFEVENT_MODEL(0) ,
  	ISP_EVENT_IRISCONTROL ,
  	ISP_EVENT_FOCUSCONTROL ,
  	EVENT_SPEC_ADDR ,
  	
  };

  // StateMachine用状態テーブル宣言
  static const AXMImageSensor::StateTable state_waiting[];
  static const AXMImageSensor::StateTable state_running[];
  unsigned char irisContStop;
  unsigned char irisContCloseSlow;
  unsigned char irisContCloseFast;
  unsigned char irisContOpenSlow;
  unsigned char irisContOpenFast;

  // StateMachine用メンバ関数宣言
  ax::actorFuncStatus funcImageSensor(const void *pParam, int size);
  ax::actorFuncStatus funcIrisControl(const void *pParam, int size);
  ax::actorFuncStatus funcFocusControl(const void *pParam, int size);
  ax::actorFuncStatus funcSpecAddr(const void *pParam, int size);
  

#ifdef PARASOFT_CPPTEST
  int send(AXFObjectName& name, AXFEvent_t eventId, void* data, int size);
  int return_stub_send;
  int setStateInfo(AXFActor* obj, int initState, int maxState);
  int return_stub_setStateInfo;
  void setStateTable(int registState, const StateTable* stateTable);
#endif	// PARASOFT_CPPTEST
  int   state;                          //  次期ステータス格納用

//  UCHAR AwbCorrectImage[0x9000];		//[0x10000];
