/**
 * @file			AXMIspChromaSuppressAlgorithm.hpp
 * @brief			AXMIspChromaSuppressAlgorithmクラスヘッダ
 *
 * @par			言語
 * 					C++
 */
#ifndef AXMISPCHROMASUPPRESSALGORITHM_HPP_
#define AXMISPCHROMASUPPRESSALGORITHM_HPP_
#include "AXMIspAdjustType.hpp"

/**
 * @class		AXMIspChromaSuppressAlgorithm
 * @brief		クロマサプレスアルゴリズムクラス
 *
 * @n			クロマサプレス計算時に計算アルゴリズムを提供する
 */
typedef class AXMIspChromaSuppressAlgorithm {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspChromaSuppressAlgorithm();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspChromaSuppressAlgorithm();

public:
	/**
	 * @brief	クロマサプレス輝度変調LUT計算
	 *
	 * @param	[in]  darkStartLuminance       暗部クロマプレス開始輝度
	 * @param	[in]  darkInc                  暗部クロマサプレス傾き
	 * @param	[in]  highColorStartLuminance  高輝度側色強化開始輝度
	 * @param	[in]  highColorInc             高輝度側色強化傾き
	 * @param	[in]  highColorLimit           高輝度側色強化リミット
	 * @param	[in]  highLightStartLuminance  ハイライトクロマサプレス開始輝度
	 * @param	[in]  highLightInc             ハイライトクロマサプレス傾き
	 * @param	[out] lut                      出力ゲインLUTテーブル
	 */
	void 				CalcLuminanceModulationLUT(BYTE darkStartLuminance, BYTE darkInc, BYTE highColorStartLuminance, BYTE highColorInc, BYTE highColorLimit, BYTE highLightStartLuminance, BYTE highLightInc, BYTE* lut);

	/**
	 * @brief	エッジクロマサプレス輝度変調LUT計算
	 *
	 * @param	[in]  startTh                  エッジしきい値
	 * @param	[in]  supprStr                 サプレス強度
	 * @param	[out] lut                      出力ゲインLUTテーブル
	 */
	void				CalcEdgeLuminanceModulationLUT(BYTE startTh, BYTE supprStr, BYTE* lut);
} AXMIspChromaAlgorithm;

#endif /* AXMISPCHROMASUPPRESSALGORITHM_HPP_ */
