/*
 * AXMIspChromaSuppressSettings.cpp
 */

#include "AXMIspChromaSuppressSettings.hpp"

ChromaModulationSettings::ChromaModulationSettings() :
	  darkStartLuminance     (0)
	, darkInc                (0)
	, highColorStartLuminance(0)
	, highColorInc           (0)
	, highColorLimit         (0xFF)
	, highLightStartLuminance(CH_DEF_HIGH_LIGHT_START_LUMINANCE)
	, highLightInc           (CH_DEF_HIGH_LIGHT_INC)
{
	// TODO 自動生成されたコンストラクター・スタブ
}

ChromaModulationSettings::~ChromaModulationSettings() {
	// TODO Auto-generated destructor stub
}

/*
 * クロマサプレス変調パラメータ設定
 */
bool ChromaModulationSettings::Set(BYTE darkStartLuminance, BYTE darkInc, BYTE highColorStartLuminance, BYTE highColorInc, BYTE highColorLimit, BYTE highLightStartLuminance, BYTE highLightInc) {
	bool isChange = false;
	bool ngValue = false;
	if (highColorStartLuminance < darkStartLuminance || highLightStartLuminance < highColorStartLuminance) {
		ngValue = true;
	}

	if (this->darkStartLuminance != darkStartLuminance && ngValue == false) {
		this->darkStartLuminance = darkStartLuminance;
		isChange = true;
	}
	if (this->darkInc != darkInc) {
		this->darkInc = darkInc;
		isChange = true;
	}
	if (this->highColorStartLuminance != highColorStartLuminance && ngValue == false) {
		this->highColorStartLuminance = highColorStartLuminance;
		isChange = true;
	}
	if (this->highColorInc != highColorInc) {
		this->highColorInc = highColorInc;
		isChange = true;
	}
	if (this->highColorLimit != highColorLimit) {
		this->highColorLimit = highColorLimit;
		isChange = true;
	}
	if (this->highLightStartLuminance != highLightStartLuminance && ngValue == false) {
		this->highLightStartLuminance = highLightStartLuminance;
		isChange = true;
	}
	if (this->highLightInc != highLightInc) {
		this->highLightInc = highLightInc;
		isChange = true;
	}
	return isChange;
}

AXMIspChromaSuppressSettings::AXMIspChromaSuppressSettings() :
	  modSettings			(ChromaModSettings())
	, lowStartGain		(0)
	, lowInc				(0)
	, edgeTh				(0)
	, edgeSuppressStrong	(0)
{
	// TODO 自動生成されたコンストラクター・スタブ
}

AXMIspChromaSuppressSettings::~AXMIspChromaSuppressSettings() {
	// TODO Auto-generated destructor stub
}

