/**
 * @file       	AXMIspAeSetting.hpp
 * @brief      	AE設定値格納クラス群ヘッダ
 *
 * @par			言語
 *              C++
 */

#ifndef AXMISPAESETTING_H_
#define AXMISPAESETTING_H_
#include "AXMISPtype.hpp"
#include "AXMIspAeValue.hpp"

static const UCHAR defaultAreaInfo[100]={
		0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
		0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ,
		0 , 0 , 0 , 0 , 1 , 1 , 0 , 0 , 0 , 0 ,
		0 , 0 , 0 , 1 , 1 , 1 , 1 , 0 , 0 , 0 ,
		0 , 0 , 0 , 1 , 1 , 1 , 1 , 0 , 0 , 0 ,
		0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 ,
		0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 ,
		0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 ,
		0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0 ,
		0 , 0 , 1 , 1 , 1 , 1 , 1 , 1 , 0 , 0
};

/**
 * @class  AXMIspAeCharacteristic
 * @brief  AE特性設定クラス
 *
 * @n		[AE-2]AE特性設定
 */
class AXMIspAeCharacteristic {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeCharacteristic();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeCharacteristic();
 public:
  ULONG RangeExposureTimeLower;					// シャッタースピード範囲下限
  ULONG RangeExposureTimeUpper;					// シャッタースピード範囲上限
  ULONG RangeGain;								// ゲイン範囲
  UCHAR SlowShutterEnable;						// 低速シャッタースピード制御ON/OFF
  ULONG MaxSlowShutter;							// 低速シャッタースピード制御時最長露光時間設定
  UCHAR PrioritySlowGain;						// ゲイン制御と低速シャッタースピード制御の優先順位
  AXMIspPhotometModes PhotometryPatternNo;		// 露光パターン指定
  UCHAR SelectBL_CorFLCEnable;					// 自動逆光／過順光補正ＯＮ／ＯＦＦ
  UCHAR SelectBL_CorFLC;						// 逆光補正／過順光補正切り替え
  AutoCompMode SelectHISTorMAIN;				// 自動補正モード選択
  UCHAR startX;
  UCHAR startY;
  UCHAR endX;
  UCHAR endY;

  UCHAR AXMIspAeMainObjectAreaInfo[100];		// 主要被写体指定モード時エリア指定
};

/**
 * @class  AXMIspAePhotometryPattern
 * @brief  ユーザー測光パターン設定クラス
 *
 * @n		[AE-3]ユーザー測光パターン設定
 */
class AXMIspAePhotometryPattern {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAePhotometryPattern();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAePhotometryPattern();
 public:
  UCHAR PhotometUSER[100];						//　エリア重み
};
#ifdef MECHA_IRIS
/**
 * @class  AXMIspAeMechaIrisAdjust
 * @brief  メカアイリス調整設定クラス
 *
 * @n		[AE-4]メカアイリス調整
 */
class AXMIspAeMechaIrisAdjust {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeMechaIrisAdjust();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeMechaIrisAdjust();
 public:
  ULONG FlagIrisRegion;						// メカアイリス（DCサーボタイプ）調整モード起動
  ULONG RoughIrisValue;
  UCHAR irisStopUpper;					// 1）停止範囲上限電圧
  UCHAR irisStopLower;					// 2）停止範囲下限電圧
  UCHAR irisCloseSlow;					// 3）アイリス閉低速電圧
  UCHAR irisCloseFast;					// 4）アイリス閉高速電圧
  UCHAR irisOpenSlow;					// 5）アイリス開低速電圧
  UCHAR irisOpenFast;					// 6）アイリス開高速電圧
};
#endif
/**
 * @class AXMIspAeTarget
 * @brief AE目標値設定クラス
 *
 * @n		[AE-5]AE目標値設定
 */
class AXMIspAeTarget {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeTarget();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeTarget();
  AXMIspAeValue AeTarget;						// AE目標値
};

/**
 * @class  AXMIspAeManualSet
 * @brief  マニュアルモード設定クラス
 *
 * @n		[AE-6]マニュアルモード設定
 */
class AXMIspAeManualSet {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeManualSet();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeManualSet();
 public:
  ULONG ShutterSpeed;							// シャッタースピード設定
  USHORT Gain;									// ゲイン設定
};

/**
 * @class AXMIspAeConvergenceAdjust
 * @brief AE収束調整クラス
 *
 * @n		[AE-7]AE収束調整
 */
class AXMIspAeConvergenceAdjust {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeConvergenceAdjust();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeConvergenceAdjust();
 public:
  USHORT AeSpeed;								// 収束時間
  AXMIspAePercent DeadZoneOut;					// 不感帯
  AXMIspAePercent DeadZoneIn;
};

/**
 * @class  AXMIspAeWDRCompositionCharacteristic
 * @brief  WDR時合成特性設定クラス
 *
 * @n		[AE-8]WDR時合成特性設定
 */
#ifdef WDR
class AXMIspAeWDRCompositionCharacteristic {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeWDRCompositionCharacteristic();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeWDRCompositionCharacteristic();
 public:
  ULONG LongExposureCompMin;
  ULONG CompErrDetectSensity;

};
#endif

/**
 * @class  AXMIspAeWDRCharacteristic
 * @brief  WDR時AE制御特性設定クラス
 *
 * @n		[AE-9]WDR時AE制御特性設定
 */
#ifdef WDR
class AXMIspAeWDRCharacteristic {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeWDRCharacteristic();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeWDRCharacteristic();
 public:
  ULONG ExposureRatio;
  ULONG ShortExposureControl;
  LONG AutoWDRShortExposureTarget;
  LONG AutoWDRLongExposureTarget;	//
  ULONG ShortExposureCompMax;
// add
  ULONG adjustExposureRatio;
  ULONG adjustThrLong;
  ULONG adjustThrShort;
  ULONG adjustThrErr;
};
#endif
/**
 * @class  AXMIspDayNight
 * @brief  Day/Nightクラス
 *
 * @n	 Day/Night設定
 */
class AXMIspDayNight {
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspDayNight();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspDayNight();
 public:
  unsigned char	dayNightMode;			//  Day/Nightモード  0. OFF
										// 					 1. ON"
  unsigned char	judgeMode;				// 判定モード  0. AGCとシャッタスピードから算出されるセンサー像面照度に基づく判定
										//             1. AGCに基づく判定"
  unsigned short upperLimit;			// 上限設定（判定モード：センサー像面照度に基づく判定）"
  unsigned short dayNightInThre;		// Day/Nightモード IN点閾値
  unsigned short dayNightOutThre;		// Day/Nightモード OUT点閾値
  unsigned short judgeTransTime;		// 判定遷移時間
  unsigned short nightColorSig;			// Night時の色信号設定
  unsigned char  forceMode;				// 強制モード  0. OFF
										//             1. ON
  unsigned char  forceDayNightSelect;	// 強制モード時Day/Night選択 0. Dayモード
										//                           1. Nightモード
  unsigned char dayNightIndicate;		// Day/Nightモード表示
};

/**
 * @class  AXMIspAeSetting
 * @brief  AE設定クラス
 *
 * @n			
 */
class AXMIspAeSetting {
  friend class AXMIspAeBase;
 public:
  /**
   * @brief  オブジェクトを初期化する
   *
   * @n
   */
  AXMIspAeSetting();
  /**
   * @brief  オブジェクトを開放する
   *
   * @n
   */
  virtual ~AXMIspAeSetting();
 public:
  AXMIspAeModes AeMode;
  unsigned char	flickerEnable;
  class AXMIspAeCharacteristic objAeChara;
  class AXMIspAePhotometryPattern objAePhotPatt;
#ifdef MECHA_IRIS
  class AXMIspAeMechaIrisAdjust objAeMechaIris;
#endif
	class AXMIspAeTarget objAeTarget;
  class AXMIspAeManualSet objAeManual;
  class AXMIspAeConvergenceAdjust objAeConvAdj;
#ifdef WDR
  class AXMIspAeWDRCompositionCharacteristic objAeWDRCompChara;
  class AXMIspAeWDRCharacteristic objAeWDRChara;
#endif
	class AXMIspDayNight objDayNight;
};

#endif /* AXMISPAESETTING_H_ */
