/*
 * AXMIspAeState.cpp
 */

#include <iostream>

#ifndef PARASOFT_CPPTEST
using namespace std;
#endif

#include "AXMCommon/AXMCommonConfig.hpp"
#include "AXMCommon/AXMCommonParam.hpp"

#include "AXMIspAe.hpp"
#include "AXMIsp/AXMIsp.hpp"
#include "AXMImageSensor/AXMImageSensor.hpp"
#include "../../project/refkit/AXMIspConfig.hpp"	// project/refkit
#ifdef AXM_ISP_CT_AE
#include "AXMIspCT/AXMIspCTAe.hpp"
#endif
#ifdef AXM_ISP_CT_AWB
#include "AXMIspCT/AXMIspCTAwb.hpp"
//#define DISABLE_AE_PROC
#endif

#ifdef USE_AXFTEST_COMMAND
//#include "AXMIspAf/AXMIspAf.hpp"
#include <stdio.h>
#endif /*USE_AXFTEST_COMMAND*/
#include "AXMImageSensor/imageSensorDrv.h"
#include "AXMIspAssist/AXMIspAssist.hpp"
#include "AXMIspTest/adrs_map.h"
extern "C" {
	#include "AXMIspTest/proc_def_cmos_eval.h"
	#include "AXMIspTest/proc_def_sio.h"
	#include "AXMIspTest/reg_gpio.h"
	#include "AXMIspTest/proc_def_imageif_eval.h"
	#include "AXMIspTest/proc_def_isp_eval.h"
	#include "AXMIspTest/audio_dsp_com.h"
}

static UCHAR  g_dayNightIndicate  __attribute__ ((at (0x20059300)));		//今回セクション名では無く直接アドレス指定を行う ((section ("ispParam1")));
extern ULONG  g_aeDriverOutControl;
extern ULONG  g_aeDriverOutError;

// 3rdリリースから、「モデルイベント」と「デバイスイベント」の
// 登録が可能となる。
//
// 状態テーブルは、状態ごとに定義し、イベントIDとメンバ関数の紐付けを行う。
// ※状態テーブルの最後は、必ず{0,NULL}で終了する必要がある。

// STATE_WATING状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAe::StateTable AXMIspAe::state_wating[] = {
    //{ AXMIspAe::EVENT_START,
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix0000 },
    { AXMIspAe::EVENT_SPEC_ADDR,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcSpecAddr },   //  
    //  モード変更
    { AXMIspAe::EVENT_RUNNING,                              //  通常モード切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix0008 },
		// アイリス使用しないため不要
    //{ AXMIspAe::EVENT_ADJUST,                               //  調整モード(IRIS調整)切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix0009 },
    { AXMIspAe::EVENT_WAITING,                              //  モード変更なし : 調整モード(IRIS調整以外)切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix000A },
    { AXMIspAe::EVENT_SPEC_AEMODE,                          //  AEモード指定切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix000B },
		// 欠陥モードなしのため不要
    //{ AXMIspAe::EVENT_DEFECT_MODE,                          //  画素欠陥補正モード指定切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix000C },

#ifdef USE_AXFTEST_COMMAND
    { AXMIspAe::EVENT_SAMPLE_DATA,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcSampleData },
    { AXMIspAe::EVENT_PRIORITY_TEST,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcPriorityTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// STATE_RUNNING状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAe::StateTable AXMIspAe::state_running[] = {
    { AXMIspAe::EVENT_START,                                //  周期演算処理
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix0100 },
    { AXMIspAe::EVENT_RUNNING,                              //  通常モード切替(dummy)
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix0108 },
		// アイリス使用しないため不要
    //{ AXMIspAe::EVENT_ADJUST,                               //  調整モード(IRIS調整)切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix0109 },
    { AXMIspAe::EVENT_WAITING,                              //  待機中:調整モード(IRIS調整以外)切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix010A },
    { AXMIspAe::EVENT_SPEC_AEMODE,                          //  AEモード指定切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix010B },
		// 欠陥モードなしのため不要
    //{ AXMIspAe::EVENT_DEFECT_MODE,                          //  画素欠陥補正モード指定切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix010C },

#ifdef USE_AXFTEST_COMMAND
    { AXMIspAe::EVENT_SAMPLE_DATA,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcSampleData },
    { AXMIspAe::EVENT_PRIORITY_TEST,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcPriorityTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// STATE_ADJUST状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAe::StateTable AXMIspAe::state_adjust[] = {
    { AXMIspAe::EVENT_START,                                //  周期処理
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix1000 },
    { AXMIspAe::EVENT_RUNNING,                              //  通常モード切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix1008 },
		// アイリス使用しないため不要
    //{ AXMIspAe::EVENT_ADJUST,                               //  調整モード(IRIS調整)切替(dummy)
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix1009 },
    { AXMIspAe::EVENT_WAITING,                              //  待機中:調整モード(IRIS調整以外)切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix100A },
    { AXMIspAe::EVENT_SPEC_AEMODE,                          //  AEモード指定切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix100B },
		// 欠陥モードなしのため不要
    //{ AXMIspAe::EVENT_DEFECT_MODE,                          //  画素欠陥補正モード指定切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix100C },

#ifdef USE_AXFTEST_COMMAND
    { AXMIspAe::EVENT_SAMPLE_DATA,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcSampleData },
    { AXMIspAe::EVENT_PRIORITY_TEST,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcPriorityTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// STATE_WATING状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAe::StateTable AXMIspAe::state_shutt_aemode[] = {
    { AXMIspAe::EVENT_START,                                //  周期処理
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix2000 },
    { AXMIspAe::EVENT_RUNNING,                              //  通常モード切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix2008 },
		// アイリス使用しないため不要
    //{ AXMIspAe::EVENT_ADJUST,                               //  調整モード(IRIS調整)切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix2009 },
    { AXMIspAe::EVENT_WAITING,                              //  待機中:調整モード(IRIS調整以外)切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix200A },
    { AXMIspAe::EVENT_SPEC_AEMODE,                          //  AEモード指定切替(dummy)
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix200B },
		// 欠陥モードなしのため不要
    //{ AXMIspAe::EVENT_DEFECT_MODE,                          //  画素欠陥補正モード指定切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix200C },

#ifdef USE_AXFTEST_COMMAND
    { AXMIspAe::EVENT_SAMPLE_DATA,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcSampleData },
    { AXMIspAe::EVENT_PRIORITY_TEST,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcPriorityTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

// DEFECT MODE状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMIspAe::StateTable AXMIspAe::state_defect_mode[] = {
    { AXMIspAe::EVENT_START,                                //  周期処理
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix3000 },
    { AXMIspAe::EVENT_RUNNING,                              //  通常モード切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix3008 },
		// アイリス使用しないため不要
    //{ AXMIspAe::EVENT_ADJUST,                               //  調整モード(IRIS調整)切替
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix3009 },
    { AXMIspAe::EVENT_WAITING,                              //  待機中:調整モード(IRIS調整以外)切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix300A },
    { AXMIspAe::EVENT_SPEC_AEMODE,                          //  AEモード指定切替
      (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix300B },
		// 欠陥モードなしのため不要
    //{ AXMIspAe::EVENT_DEFECT_MODE,                          //  画素欠陥補正モード指定切替(dummy)
    //  (AXMIspAe::StateFuncPtr) &AXMIspAe::matrix300C },

#ifdef USE_AXFTEST_COMMAND
    { AXMIspAe::EVENT_SAMPLE_DATA,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcSampleData },
    { AXMIspAe::EVENT_PRIORITY_TEST,
      (AXMIspAe::StateFuncPtr) &AXMIspAe::funcPriorityTest },
#endif /*USE_AXFTEST_COMMAND*/
    {0,NULL}
};

ax::actorFuncStatus AXMIspAe::funcSpecAddr(const void *pParam, int size) {
  if((0 < size) && (pParam != 0x00000000ul)) {
    ST_MSG *msg = (ST_MSG *)pParam;
    p_spec = (ST_SPEC *)msg->data;

  	checkComm();

    state = STATE_RUNNING;
#ifndef PARASOFT_CPPTEST
    setNextState(state);
#endif  //  PARASOFT_CPPTEST
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix0000(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix0000()");

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix0008(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix0008() : Waiting[Adjust Mode] -> Running");

  //  通常モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

  state = STATE_RUNNING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix0009(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix0009() : Waiting[Adjust Mode] -> Adjust Mode");

  //  調整モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	aeSetteingSav = aeSetting;
	aeSetting = new AXMIspAeSetting();
#ifdef PARASOFT_CPPTEST
  if(flag_newStub) {
	  if(aeSetting) delete aeSetting;
	  aeSetting = NULL;
  }
#endif

	if(aeSetting && aeSetteingSav) {
		aeSetting->AeMode = E_AeManualMode;
		aeSetting->objAeManual.ShutterSpeed = aeSetteingSav->objAeManual.ShutterSpeed;
	    aeSetting->objAeManual.Gain = aeSetteingSav->objAeManual.Gain;
#ifdef MECHA_IRIS
	    aeSetting->objAeMechaIris.FlagIrisRegion = 1;
	    aeSetting->objAeMechaIris.RoughIrisValue = aeSetteingSav->objAeMechaIris.RoughIrisValue;
#endif
		}
  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix000A(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix000A() : Waiting[Adjust Mode]");

  //  モード変更なし
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix000B(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix000B() : Waiting[Adjust Mode] -> AE Shutter Control Mode ");

  //  AEモード指定に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	aeSetteingSav = aeSetting;
	aeSetting = new AXMIspAeSetting();
#ifdef PARASOFT_CPPTEST
  if(flag_newStub) {
	  if(aeSetting) delete aeSetting;
	  aeSetting = NULL;
  }
#endif

	if(aeSetting) {
		aeSetting->AeMode = E_AeShutterControlMode;     		// シャッター制御モード;
		aeSetting->objAeChara.SlowShutterEnable = false;		// Slow Shutter off
		aeSetting->objAeChara.SelectBL_CorFLCEnable = false;	// 自動逆光/過順光補正 off
	}
  state = STATE_SHUTT_AEMODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix000C(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix000C() : Waiting[Adjust Mode] -> defect mode ");

  //  調整モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	aeSetteingSav = aeSetting;
	aeSetting = new AXMIspAeSetting();
#ifdef PARASOFT_CPPTEST
  if(flag_newStub) {
	  if(aeSetting) delete aeSetting;
	  aeSetting = NULL;
  }
#endif

	if(aeSetting && p_spec) {
		aeSetting->AeMode = E_AeManualMode;
		aeSetting->objAeManual.ShutterSpeed = p_spec->Defect.DetectSet.AE.ShutterSpeed;
	    aeSetting->objAeManual.Gain = p_spec->Defect.DetectSet.AE.Gain;
#ifdef MECHA_IRIS
			aeSetting->objAeMechaIris.FlagIrisRegion = p_spec->Defect.DetectSet.AE.IrisCloseMode;
	    aeSetting->objAeMechaIris.RoughIrisValue = 0xFF;
#endif
		}
  state = STATE_DEFECT_MODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}


ax::actorFuncStatus AXMIspAe::matrix0100(const void *pParam, int size) {
		

  ST_MSG *p_msg = (ST_MSG*)pParam;
  if(p_msg) {
		// startIsr対応(0xA55AA55A)
	  opdData = static_cast<UCHAR *>(p_msg->data);

	  m_log.write(AXFLOG_DEBUG, "AE matrix0100()");
#ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
	  cout << "AE:opdData=";
	  cout << opdData << endl;
  #endif
#endif
		checkComm();
#ifdef AXM_ISP_CT_AE
	  AXMIspCTAe::CreateTestData();
#endif
	  // 必要な処理をここに記述
#ifndef DISABLE_AE_PROC
	  static int cnt;
	  cnt++;
	  AeExec(p_msg);		// AEシーケンサ実行
	  
	#ifndef PARASOFT_CPPTEST
		  #ifndef COUT_DEBUG
		  cout << "cnt=";
		  cout << cnt << endl;
		  #endif
	#endif

		  static int m_count;
		  m_count++;
	#ifndef PARASOFT_CPPTEST
		  #ifndef COUT_DEBUG
		  cout << "m_count=";
		  cout << m_count << endl;
		  #endif
	#endif
#endif  //  DISABLE_AE_PROC

	  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_END), &fromAeToIsp, sizeof(int))) {
	    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_END");
	  }

	  state = STATE_RUNNING;
#ifndef PARASOFT_CPPTEST
	  setNextState(state);
#endif  //  PARASOFT_CPPTEST
	}
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix0108(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix0108() : Running -> Running");

  //  モード切替完了通知
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix0109(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix0109() : Running -> Adjust Mode");

	modeChangeAdjust(false);
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix010A(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix010A() : Running -> Waiting[Adjust Mode]");

		modeChangeWating();
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix010B(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix010B() : Running -> AE Shutter Control Mode ");

	modeChangeSpecAe(false);
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix010C(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix010C() : Running -> defect mode ");

	modeChangeDefect(false);
  return ax::AXFACTOR_SUCCESS;
}


ax::actorFuncStatus AXMIspAe::matrix1000(const void *pParam, int size) {
 ST_MSG *p_msg = (ST_MSG*)pParam;

  m_log.write(AXFLOG_DEBUG, "AE matrix1000()");

	if(p_spec != NULL && aeSetting != NULL) {
		if( p_spec->changeStatus[0] & SPEC_CHG_AE007 ) {
#ifdef MECHA_IRIS
			aeSetting->objAeMechaIris.FlagIrisRegion = p_spec->AE.mechaIrisAdjust.flagIrisRegion;	// 調整モード
			aeSetting->objAeMechaIris.RoughIrisValue  = p_spec->AE.mechaIrisAdjust.roughIrisValue;	// アイリス制御値
#endif
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE007;
		}
	}

  AeExecAdjust(p_msg);		// AEシーケンサ実行 msgはWDRモードで必要な情報なので、ここでは未設定でよい

  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_END), &fromAeToIsp, sizeof(int))) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_END");
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix1008(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix1008() : Adjust Mode -> Running");

  //  通常モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }
	if(aeSetting) {
		delete aeSetting;
	}
	aeSetting = aeSetteingSav;

  state = STATE_RUNNING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix1009(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix1009() : Adjust Mode -> Adjust Mode");

  //  モード切替完了通知
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix100A(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix100A() : Adjust Mode -> Waiting[Adjust Mode]");

  //  待機中に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(aeSetting) {
		delete aeSetting;
	}
	aeSetting = aeSetteingSav;
  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix100B(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix010B() : Adjust Mode -> AE Shutter Control Mode ");

  //  AEモード指定に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(aeSetting) {
		aeSetting->AeMode = E_AeShutterControlMode;     // シャッター制御モード;
		aeSetting->objAeChara.SlowShutterEnable = false;		// Slow Shutter off
		aeSetting->objAeChara.SelectBL_CorFLCEnable = false;	// 自動逆光/過順光補正 off
	}
  state = STATE_SHUTT_AEMODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix100C(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix100C() : Adjust Mode -> defect mode ");

  //  調整モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(aeSetting && p_spec) {
		aeSetting->AeMode = E_AeManualMode;
		aeSetting->objAeManual.ShutterSpeed = p_spec->Defect.DetectSet.AE.ShutterSpeed;
	    aeSetting->objAeManual.Gain = p_spec->Defect.DetectSet.AE.Gain;
#ifdef MECHA_IRIS
			aeSetting->objAeMechaIris.FlagIrisRegion = p_spec->Defect.DetectSet.AE.IrisCloseMode;
	    aeSetting->objAeMechaIris.RoughIrisValue = 0xFF;
	    aeSetting->objAeMechaIris.RoughIrisValue = 0xFF;
#endif
		}
  state = STATE_DEFECT_MODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}


ax::actorFuncStatus AXMIspAe::matrix2000(const void *pParam, int size) {
 ST_MSG *p_msg = (ST_MSG*)pParam;

  m_log.write(AXFLOG_DEBUG, "AE matrix2000()");

  AeExecAdjust(p_msg);		// AEシーケンサ実行

  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_END), &fromAeToIsp, sizeof(int))) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_END");
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix2008(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix2008() : AE Shutter Control Mode -> Running");

  //  通常モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }
	if(aeSetting) {
		delete aeSetting;
	}
	aeSetting = aeSetteingSav;

  state = STATE_RUNNING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix2009(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix2009() : AE Shutter Control Mode -> Adjust Mode");

  //  モード切替完了通知
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }
	if(aeSetting && aeSetteingSav) {
		aeSetting->AeMode = E_AeManualMode;
		aeSetting->objAeManual.ShutterSpeed = aeSetteingSav->objAeManual.ShutterSpeed;
	    aeSetting->objAeManual.Gain = aeSetteingSav->objAeManual.Gain;
#ifdef MECHA_IRIS
	    aeSetting->objAeMechaIris.FlagIrisRegion = 1;
	    aeSetting->objAeMechaIris.RoughIrisValue = aeSetteingSav->objAeMechaIris.RoughIrisValue;
#endif
		}

  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix200A(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix200A() : AE Shutter Control Mode -> Waiting[Adjust Mode]");

  //  待機中に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(aeSetting) {
		delete aeSetting;
	}
	aeSetting = aeSetteingSav;
  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix200B(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix200B() : AE Shutter Control Mode -> AE Shutter Control Mode ");

  //  AEモード指定に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

  state = STATE_SHUTT_AEMODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix200C(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix200C() : AE Shutter Control Mode -> defect mode ");

  //  調整モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(aeSetting && p_spec) {
		aeSetting->AeMode = E_AeManualMode;
		aeSetting->objAeManual.ShutterSpeed = p_spec->Defect.DetectSet.AE.ShutterSpeed;
	    aeSetting->objAeManual.Gain = p_spec->Defect.DetectSet.AE.Gain;
#ifdef MECHA_IRIS
			aeSetting->objAeMechaIris.FlagIrisRegion = p_spec->Defect.DetectSet.AE.IrisCloseMode;
	    aeSetting->objAeMechaIris.RoughIrisValue = 0xFF;
#endif
		}
  state = STATE_DEFECT_MODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}


ax::actorFuncStatus AXMIspAe::matrix3000(const void *pParam, int size) {
 ST_MSG *p_msg = (ST_MSG*)pParam;
  m_log.write(AXFLOG_DEBUG, "AE matrix3000()");

  AeExecAdjust(p_msg);		// AEシーケンサ実行

  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_END), &fromAeToIsp, sizeof(int))) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_END");
  }
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix3008(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix3008() : Defect Mode -> Running");

  //  通常モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }
	if(aeSetting) {
		delete aeSetting;
	}
	aeSetting = aeSetteingSav;

  state = STATE_RUNNING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix3009(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix3009() : Defect Mode -> Adjust Mode");

  //  モード切替完了通知
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }
	if(aeSetting && aeSetteingSav) {
		aeSetting->AeMode = E_AeManualMode;
		aeSetting->objAeManual.ShutterSpeed = aeSetteingSav->objAeManual.ShutterSpeed;
	    aeSetting->objAeManual.Gain = aeSetteingSav->objAeManual.Gain;
#ifdef MECHA_IRIS
			aeSetting->objAeMechaIris.FlagIrisRegion = 1;
	    aeSetting->objAeMechaIris.RoughIrisValue = aeSetteingSav->objAeMechaIris.RoughIrisValue;
#endif
		}

  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix300A(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix300A() : Defect Mode -> Waiting[Adjust Mode]");

  //  待機中に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(aeSetting) {
		delete aeSetting;
	}
	aeSetting = aeSetteingSav;
  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix300B(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix300B() : Defect Mode -> AE Shutter Mode ");

  //  AEモード指定に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(aeSetting) {
		aeSetting->AeMode = E_AeShutterControlMode;     // シャッター制御モード;
		aeSetting->objAeChara.SlowShutterEnable = false;		// Slow Shutter off
		aeSetting->objAeChara.SelectBL_CorFLCEnable = false;	// 自動逆光/過順光補正 off

	}
  state = STATE_SHUTT_AEMODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::matrix300C(const void *pParam, int size) {
  m_log.write(AXFLOG_DEBUG, "AE matrix300C() : Defect Mode -> defect mode ");

  //  調整モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

  state = STATE_DEFECT_MODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
  return ax::AXFACTOR_SUCCESS;
}

static unsigned char sensorGainO = 0;
void AXMIspAe::sendSensorGainToIspAssist(unsigned char sensorGain) {
  // センサー出力ゲイン値が前回と同じ場合、通知はしない
  if (sensorGainO == sensorGain) {
    return;
  }
	
	// 今回Assistは使用しないため不要
	/*
  int datasize = sizeof(ST_MSG);
	static ST_MSG msg;
	*/
#ifndef PARASOFT_CPPTEST
	// 今回Assistは使用しないため不要
	/*
	sensorGainO = sensorGain;
	msg.data = &sensorGainO;
	// 暫定対応gain変更時ユーザーエクセプション発生するため原因が判明するまでnop
	if (0 > send(nameIspAssist, AXFEVENT_MODEL(AXMIspAssist::EVENT_PROC_LOW_LUMINANCE_GAIN), &msg, datasize))
	{
		;
  }
	*/
#else
  return_stub_send = sensorGain;
#endif  //  CPPTEST_PARASOFT
}

// ここから 複雑な関数の細分化  
#define DO_CALC(instance , p_msg) { 					\
    if (instance != NULL) { 					\
      instance->opdData = opdData; 				\
      instance->doCalc(p_msg); \
    	send2Driver(&instance->controlExposure); \
    	fromAeToIsp = instance->execFromAeToIsp; \
    } \
}
#ifndef DISABLE_AE_PROC
void AXMIspAe::AeExec(ST_MSG *p_msg) {
  m_log.write(AXFLOG_DEBUG, "AeExec()");
  #ifndef COUT_DEBUG
  std::cout << "AeModeSave=" << std::dec << AeModeSave << std::endl;
  #endif
  #ifndef COUT_DEBUG
    std::cout << "aeSetting->AeMode =" << std::dec << aeSetting->AeMode << std::endl;
  #endif

#ifdef AXM_ISP_CT_AWB
    opdData = AXMIspCTAwb::GetAEImagePtr();
    if (opdData != 0) {
    	AXMIspCTAwb::UpdateAeSettings(aeSetting);
    }
#endif
	// 通常プログラムモード、シャッター制御モード、シャッター＆ゲイン制御モードで自動補正モードがON場合AeModeを変換する
  	convertAeMode();

	// AeModeが変更された場合にシーケンス制御の切り替えを行う
	checkAeModeChange();

#ifdef AXM_ISP_CT_AE
    opdData = AXMIspCTAe::GetImagePtr();
    p_msg->cmd = AXMIspCTAe::GetWDRImageNo();
#endif
    if(sequencer != NULL){
    	sequencer->notifyAeSequencer(aeSetting);
    }
	
	if(aeSetting != NULL){
		AeExecDoCalc(p_msg);
	}


}
#endif  //  DISABLE_AE_PROC

// 調整モード用AE実行処理
void AXMIspAe::AeExecAdjust(ST_MSG *p_msg) {
  m_log.write(AXFLOG_DEBUG, "AeExecAdjust()");

	// AeModeが変更された場合にシーケンス制御の切り替えを行う
	checkAeModeChange();

    if(sequencer != NULL){
    	sequencer->notifyAeSequencer(aeSetting);
    }
	
	if(aeSetting != NULL){
		AeExecDoCalc(p_msg);
	}

}

void AXMIspAe::convertAeMode(void) {
	if (aeSetting != NULL) {
		switch (aeSetting->AeMode) {
		case E_AeUsualProgMode:					//通常プログラムモード
			if(aeSetting->objAeChara.SelectBL_CorFLCEnable){						// 自動逆光/過順光補正ON？
				if(aeSetting->objAeChara.SelectHISTorMAIN == E_AutoCompHist){
					aeSetting->AeMode =  E_AeUsualProg_HistogramMode;				// ヒストグラム 通常プログラムモード
				} else /* if(eAutoCompMode == E_AutoCompMain) */ {
					aeSetting->AeMode = E_AeUsualProg_MainObjMode;					// 主要被写体 通常プログラムモード
				}
			}
			break;
		case E_AeShutterControlMode:			//シャッター制御モード
			if(aeSetting->objAeChara.SelectBL_CorFLCEnable){						// 自動逆光/過順光補正ON？
				if(aeSetting->objAeChara.SelectHISTorMAIN == E_AutoCompHist){
					aeSetting->AeMode = E_AeShutterControl_HistogramMode;			//ヒストグラム シャッター制御モード
				} else /* if(eAutoCompMode == E_AutoCompMain) */ {
					aeSetting->AeMode = E_AeShutterControl_MainObjMode;				//主要被写体 シャッター制御モード
				}
			}
			break;
		case E_AeShutterAndGainControlMode:		//シャッター＆ゲイン制御AEモード
			if(aeSetting->objAeChara.SelectBL_CorFLCEnable){						// 自動逆光/過順光補正ON？
				if(aeSetting->objAeChara.SelectHISTorMAIN == E_AutoCompHist){
					aeSetting->AeMode = E_AeShutterAndGainControl_HistogramMode;		//ヒストグラム シャッター＆ゲイン制御AEモード
				} else /* if(eAutoCompMode == E_AutoCompMain) */ {
					aeSetting->AeMode = E_AeShutterAndGainControl_MainObjMode;		//主要被写体 シャッター＆ゲイン制御AEモード
				}
			}
			break;
		}
	}
}

// AeModeが変更された場合にインスタンスの再生成を行う
void AXMIspAe::checkAeModeChange(void) {
  if (aeSetting != NULL) {
    if (aeSetting->AeMode != AeModeSave) {
      m_log.write(AXFLOG_DEBUG, "AXMIspAe::AeMode != AeModeSave");

		AeModeSave = aeSetting->AeMode;

    }  // end of if(aeSetting->AeMode != AeModeSave)
  }
}

void AXMIspAe::AeExecDoCalc(ST_MSG *p_msg) {
	DO_CALC(sequencer , p_msg);

}

// ここまで 複雑な関数の細分化  

void AXMIspAe::send2Driver(AXMIspAeControlExposure *controlExposure) {

	clrDrvLog();	// ドライバ関連ログをクリア

	if((controlExposure->doControlExposure & ~E_ISC_Iris) != E_ISC_None){
		sendShutterSpeed(controlExposure->contShutter, controlExposure->contGain, controlExposure->frame);
		unsigned char sensorGain = (controlExposure->chromaOff) ? 0 : (unsigned char)(controlExposure->contGain / 10);
		sendSensorGainToIspAssist(sensorGain);
	}
#ifdef MECHA_IRIS
	if((controlExposure->doControlExposure & E_ISC_Iris) != E_ISC_None){
		sendIrisControl(controlExposure->contIris);
	}
#endif
	if((controlExposure->doControlExposure & (E_ISC_Focus|E_ISC_Zoom)) != E_ISC_None){
		sendFocusControl(controlExposure->contFocus);
	}
}

void AXMIspAe::sendShutterSpeed(unsigned int time, unsigned int gain) {
  m_log.write(AXFLOG_DEBUG, "AXMIspAe::sendShutterSpeed()");

 #ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAe::sendShutterSpeed(" ;
  cout << time;
  cout << ",";
  cout << gain;
  cout << ")" << endl;
  #endif
 #endif
	static ST_MSG  msg;
	static ST_ISMSG stims;
	msg.sid = SID_AXMIspAe;
	msg.rid = RID_AXMImageSensor;
	stims.time = time;
	stims.gain = gain;
	msg.data = &stims;
	msg.cmd = 0;
	if(aeSetting != NULL) {
		msg.cmd = aeSetting->AeMode;
	}
	
  //  Control Exposure呼出
  if (0 > send(nameImageSensor, AXFEVENT_MODEL(AXMImageSensor::ISP_EVENT_IMAGESENSOR), &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send ISP ISP_EVENT_IMAGESENSOR");
  }
}

void AXMIspAe::sendShutterSpeed(unsigned int time, unsigned int gain, unsigned int frame) {
  m_log.write(AXFLOG_DEBUG, "AXMIspAe::sendShutterSpeed()");

 #ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAe::sendShutterSpeed(" ;
  cout << time;
  cout << ",";
  cout << gain;
  cout << ")" << endl;
  #endif
 #endif
	static ST_MSG  msg;
	static ST_ISMSG stims;
	msg.sid = SID_AXMIspAe;
	msg.rid = RID_AXMImageSensor;
	stims.time = time;
	stims.gain = gain;
	stims.frame = frame;
	msg.data = &stims;
	msg.cmd = 0;
	if(aeSetting != NULL) {
		msg.cmd = aeSetting->AeMode;
	}

  //  Control Exposure呼出
  if (0 > send(nameImageSensor, AXFEVENT_MODEL(AXMImageSensor::ISP_EVENT_IMAGESENSOR), &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send ISP ISP_EVENT_IMAGESENSOR");
  }
}
#ifdef MECHA_IRIS
void AXMIspAe::sendIrisControl(unsigned int iris) {
  m_log.write(AXFLOG_DEBUG, "AXMIspAe::sendIrisControl()");

 #ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAe::sendIrisControl(" ;
  cout << time;
  cout << ",";
  cout << gain;
  cout << ")" << endl;
  #endif
 #endif
	static ST_MSG  msg;
	static ST_ISMSG stims;
	msg.sid = SID_AXMIspAe;
	msg.rid = RID_AXMImageSensor;
	stims.iris = iris;
	msg.data = &stims;
	msg.cmd = 0;
	if(aeSetting != NULL) {
		msg.cmd = aeSetting->AeMode;
	}

  //  Control Exposure呼出
  if (0 > send(nameImageSensor, AXFEVENT_MODEL(AXMImageSensor::ISP_EVENT_IRISCONTROL), &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send ISP ISP_EVENT_IRISCONTROL");
  }

}
#endif
void AXMIspAe::sendFocusControl(unsigned int focus) {
  m_log.write(AXFLOG_DEBUG, "AXMIspAe::sendFocusControl()");

 #ifndef PARASOFT_CPPTEST
  #ifndef COUT_DEBUG
  cout << "AXMIspAe::sendFocusControl(" ;
  cout << focus;
  cout << ")" << endl;
  #endif
 #endif
	static ST_CONTROL_AF	controlAF;
	controlAF.lensMove = focus;
	static ST_MSG sndMsg;
	sndMsg.sid = SID_AXMIspAe;
	sndMsg.rid = RID_AXMImageSensor;
	sndMsg.data = &controlAF;
	sndMsg.cmd = 0;
	if(aeSetting != NULL) {
		sndMsg.cmd = aeSetting->AeMode;
	}

	int stat = send(nameImageSensor, AXFEVENT_MODEL(AXMImageSensor::ISP_EVENT_FOCUSCONTROL), (void *)&sndMsg, sizeof(ST_MSG));
	if (0 > stat) {
		m_log.write(AXFLOG_ERR, "fail send Focus Control Data");
	}
}

#ifdef USE_AXFTEST_COMMAND
ax::actorFuncStatus AXMIspAe::funcSampleData(const void *pParam, int size) {
  ST_MSG *rcvMsg;
  rcvMsg = (ST_MSG *)pParam;
 #ifndef PARASOFT_CPPTEST
  std::string buf("AE funcSampleData() receive data=");
  std::string rcvstr((char *)rcvMsg->data);
  buf += rcvstr;
  m_log.write(AXFLOG_DEBUG, buf);
#ifdef USE_AXFTEST_COMMAND_COMPLOG
  if(0 != rcvstr.compare(aeSampleData)){
    AXMScenarioTest::getInstance()->writeLog(&m_log, AXMScenarioTest::RESULT_FAILED, AXMScenarioTest::E_RECVFAILED);
    return ax::AXFACTOR_SUCCESS;
  }
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
 #endif

  if (m_count > AXM_SAMPLE_SEND_MAX_COUNT) {
    m_count = 0;
#ifdef USE_AXFTEST_COMMAND_COMPLOG
    AXMScenarioTest::getInstance()->writeLog(&m_log, AXMScenarioTest::RESULT_SUCCESS);
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
    return ax::AXFACTOR_SUCCESS;
  }
  m_count++;

//  // AF宛てに、サンプルデータを送信する
//  ST_MSG sndMsg;
//  sndMsg.cmd  = m_count;
//  sndMsg.data = (void *)afSampleData.c_str();
//  int stat = send(nameIspAf, AXMIspAf::EVENT_SAMPLE_DATA, (void *)&sndMsg, sizeof(ST_MSG));
//  if (0 > stat) {
//    m_log.write(AXFLOG_ERR, "fail send AF Sample Data");
//  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAe::funcPriorityTest(const void *pParam, int size) {
  m_log.write(AXFLOG_SCENARIO, "AE priorityTest");
 #ifndef PARASOFT_CPPTEST
  pthread_pri_dbgprint();
 #endif  //  PARASOFT_CPTPEST

  //受信データからカウンタ値を取得
  int count = 0;
  if(pParam != NULL){
    count = *((int*)pParam);
  }

  //Ispへ結果送信
  int stat = send(nameIsp, AXMIsp::EVENT_PRISCHED_END, (void *)&count, sizeof(count));
  if (0 > stat) {
    m_log.write(AXFLOG_ERR, "fail send Isp AF Prisched End");
  }
  return ax::AXFACTOR_SUCCESS;
}
#endif /* USE_AXFTEST_COMMAND */

void AXMIspAe::checkComm(void) {
	
#ifndef AXM_ISP_CT_AE
	if(p_spec != NULL && aeSetting != NULL) {
		// 今回changeStatusは見ない※for文がない箇所のみ
		//if( p_spec->changeStatus[0] & SPEC_CHG_AE001 ) {
			aeSetting->AeMode = p_spec->AE.AEMode;
			aeSetting->flickerEnable = p_spec->AE.flickerEnable;
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE001;
		//}
		// 今回changeStatusは見ない※for文があるが使用するレジスタが存在するため
		//if( p_spec->changeStatus[0] & SPEC_CHG_AE002 ) {
			aeSetting->objAeChara.RangeExposureTimeLower = p_spec->AE.aeChara.st_shutterSpeed.upper;
			aeSetting->objAeChara.RangeExposureTimeUpper = p_spec->AE.aeChara.st_shutterSpeed.lower;
			aeSetting->objAeChara.RangeGain = p_spec->AE.aeChara.gainUpper;										// ゲイン範囲(上限値)			
			aeSetting->objAeChara.SlowShutterEnable = p_spec->AE.aeChara.slowShutterEnable;						// 低速シャッタースピード制御  0. OFF
			aeSetting->objAeChara.MaxSlowShutter = p_spec->AE.aeChara.slowShutterMax;							// 低速シャッタースピード制御時 最長露光時間設定
			aeSetting->objAeChara.PrioritySlowGain = p_spec->AE.aeChara.gainSlowShutterPrio;					// ゲイン制御/シャッタースピード制御の優先設定 "0. ゲイン制御
			aeSetting->objAeChara.PhotometryPatternNo = p_spec->AE.aeChara.photometryPatNo;						// 測光パターンの指定（通常AE時）	0. 中央重点
			aeSetting->objAeChara.SelectBL_CorFLCEnable = p_spec->AE.aeChara.selectBL_CorFLCEnable;				// 自動逆光/過順光補正 0. OFF
			aeSetting->objAeChara.SelectBL_CorFLC = p_spec->AE.aeChara.selectBL_CorFLC;							// 逆光補正／過順光補正切り替え 0. 逆光補正
			aeSetting->objAeChara.SelectHISTorMAIN = p_spec->AE.aeChara.selectHISTorMAIN;						// 自動補正モード選択 0. 主要被写体指定モード
			UCHAR startX = aeSetting->objAeChara.startX = p_spec->AE.aeChara.st_mainSubjArea.start.h;							// "主要被写体指定モード時 エリア指定 （自動補正モード）"	
			UCHAR startY = aeSetting->objAeChara.startY = p_spec->AE.aeChara.st_mainSubjArea.start.v;							// "主要被写体指定モード時 エリア指定 （自動補正モード）"	
			UCHAR endX = aeSetting->objAeChara.endX = p_spec->AE.aeChara.st_mainSubjArea.end.h;								// "主要被写体指定モード時 エリア指定 （自動補正モード）"	
			UCHAR endY = aeSetting->objAeChara.endY = p_spec->AE.aeChara.st_mainSubjArea.end.v;								// "主要被写体指定モード時 エリア指定 （自動補正モード）"	

			for (UCHAR y = 0; y < 10; y++) {
			  for (UCHAR x = 0; x < 10; x++) {
				// 主要被写体指定モード時エリア指定
				aeSetting->objAeChara.AXMIspAeMainObjectAreaInfo[(y * 10) + x] = ((startX <= x) && (x <= endX) && (startY <= y) && (y <= endY)) ? 1 : 0;
			  }
			}

			p_spec->changeStatus[0] &= ~SPEC_CHG_AE002;
		//}
		if( p_spec->changeStatus[0] & SPEC_CHG_AE003 ) {
			for(int i = 0 ; i < 100 ; i++ ) {
				aeSetting->objAePhotPatt.PhotometUSER[i] = p_spec->AE.photPatt.pattern[i];
			}
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE003;
		}
		// 今回changeStatusは見ない※for文がない箇所のみ
		//if( p_spec->changeStatus[0] & SPEC_CHG_AE004 ) {
			aeSetting->objAeTarget.AeTarget = (ULONG)p_spec->AE.AETarget;
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE004;
		//}
		// 今回changeStatusは見ない※for文がない箇所のみ
		//if( p_spec->changeStatus[0] & SPEC_CHG_AE005 ) {
			aeSetting->objAeManual.ShutterSpeed = p_spec->AE.aeManual.shutter_speed;
			aeSetting->objAeManual.Gain = p_spec->AE.aeManual.gain;
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE005;
		//}
		// 今回changeStatusは見ない※for文がない箇所のみ
		//if( p_spec->changeStatus[0] & SPEC_CHG_AE006 ) {
			aeSetting->objAeConvAdj.AeSpeed = p_spec->AE.aeConvAdj.aeSpeed;
			aeSetting->objAeConvAdj.DeadZoneOut.set(p_spec->AE.aeConvAdj.deadZoneOut);
			aeSetting->objAeConvAdj.DeadZoneIn.set(p_spec->AE.aeConvAdj.deadZoneIn);
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE006;
		//}
		// 今回changeStatusは見ない※for文がない箇所のみ
		//if( p_spec->changeStatus[0] & SPEC_CHG_AE007 ) {
#ifdef MECHA_IRIS
			aeSetting->objAeMechaIris.FlagIrisRegion = p_spec->AE.mechaIrisAdjust.flagIrisRegion;	// 調整モード
			aeSetting->objAeMechaIris.RoughIrisValue  = p_spec->AE.mechaIrisAdjust.roughIrisValue;	// アイリス制御値
			aeSetting->objAeMechaIris.irisStopUpper = p_spec->AE.mechaIrisAdjust.irisStopUpper; 	// 1）停止範囲上限電圧
			aeSetting->objAeMechaIris.irisStopLower = p_spec->AE.mechaIrisAdjust.irisStopLower; 	// 2）停止範囲下限電圧
			aeSetting->objAeMechaIris.irisCloseSlow = p_spec->AE.mechaIrisAdjust.irisCloseSlow; 	// 3）アイリス閉低速電圧
			aeSetting->objAeMechaIris.irisCloseFast = p_spec->AE.mechaIrisAdjust.irisCloseFast; 	// 4）アイリス閉高速電圧
			aeSetting->objAeMechaIris.irisOpenSlow = p_spec->AE.mechaIrisAdjust.irisOpenSlow;  	// 5）アイリス開低速電圧
			aeSetting->objAeMechaIris.irisOpenFast = p_spec->AE.mechaIrisAdjust.irisOpenFast;  	// 6）アイリス開高速電圧
#endif
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE007;
			p_spec->changeStatus[0] |= SPEC_CHG_AE009;									// 1`6ImageSensor
		//}
#ifdef WDR
		if(p_spec->AE.wdrCharacteristic.mixExpRatio != 0) {		// mixExpRatioは0以外が設定されたらadjustExposureRatioに反映するものとする。0を設定する場合は0x1000を設定する。
			aeSetting->objAeWDRChara.adjustExposureRatio = (p_spec->AE.wdrCharacteristic.mixExpRatio & 0x0FFF);
		}
#endif
		// 今回changeStatusは見ない※for文がない箇所のみ
		//if( p_spec->changeStatus[0] & SPEC_CHG_AE008 ) {
#ifdef WDR
			aeSetting->objAeWDRChara.ExposureRatio = p_spec->AE.wdrCharacteristic.exposureRatio;
			aeSetting->objAeWDRChara.adjustThrLong = p_spec->AE.wdrCharacteristic.mixThrLong;
			aeSetting->objAeWDRChara.adjustThrShort = p_spec->AE.wdrCharacteristic.mixThrShort;
			aeSetting->objAeWDRChara.adjustThrErr = p_spec->AE.wdrCharacteristic.mixThrErr;
			aeSetting->objAeWDRChara.ShortExposureControl = p_spec->AE.wdrCharacteristic.shortExpoControl;
			aeSetting->objAeWDRChara.AutoWDRShortExposureTarget = p_spec->AE.wdrCharacteristic.autoWdrShortExpTarget;
			aeSetting->objAeWDRChara.AutoWDRLongExposureTarget = p_spec->AE.wdrCharacteristic.autoWdrLongExpTarget;
#endif
			p_spec->changeStatus[0] &= ~SPEC_CHG_AE008;
		//}
		if(aeSetting->objDayNight.dayNightMode) {
			g_dayNightIndicate = aeSetting->objDayNight.dayNightIndicate;				// Day/Nightモード表示       0. Dayモード
		}

		// 今回changeStatusは見ない※for文がない箇所のみ
		//if( p_spec->changeStatus[0] & SPEC_CHG_DAYNI ) {
			aeSetting->objDayNight.dayNightMode = p_spec->DayNight.dayNightMode;					//  Day/Nightモード  0. OFF
																							// 					 1. ON"
			aeSetting->objDayNight.judgeMode = p_spec->DayNight.judgeMode;						// 判定モード  0. AGCとシャッタスピードから算出されるセンサー像面照度に基づく判定
																							//             1. AGCに基づく判定"
			aeSetting->objDayNight.upperLimit = p_spec->DayNight.upperLimit;						// 上限設定（判定モード：センサー像面照度に基づく判定）"
			aeSetting->objDayNight.dayNightInThre = p_spec->DayNight.dayNightInThre;				// Day/Nightモード IN点閾値 75lx
			aeSetting->objDayNight.dayNightOutThre = p_spec->DayNight.dayNightOutThre;			// Day/Nightモード OUT点閾値 9lx
			aeSetting->objDayNight.judgeTransTime = p_spec->DayNight.judgeTransTime;				// 判定遷移時間 10frame = 160ms
			aeSetting->objDayNight.nightColorSig = p_spec->DayNight.nightColorSig;				// Night時の色信号設定
			aeSetting->objDayNight.forceMode = p_spec->DayNight.forceMode;						// 強制モード  0. OFF
																							//             1. ON
			aeSetting->objDayNight.forceDayNightSelect = p_spec->DayNight.forceDayNightSelect;	// 強制モード時Day/Night選択 0. Dayモード
																							//                           1. Nightモード
																							//                           1. Nightモード
			p_spec->changeStatus[0] &= ~SPEC_CHG_DAYNI;
		//}

	}
#endif
}

void AXMIspAe::modeChangeAdjust(bool isAdjust) {
  m_log.write(AXFLOG_DEBUG, "AE modeChangeAdjust() : Running -> Adjust Mode");

  //  調整モードに切替
//#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }
//#endif  //  CPPTEST_PARASOFT
	if(isAdjust == false) {
		aeSetteingSav = aeSetting;
		aeSetting = new AXMIspAeSetting();
	}
	if(aeSetting && aeSetteingSav) {
		aeSetting->AeMode = E_AeManualMode;
		aeSetting->objAeManual.ShutterSpeed = aeSetteingSav->objAeManual.ShutterSpeed;
	    aeSetting->objAeManual.Gain = aeSetteingSav->objAeManual.Gain;
#ifdef MECHA_IRIS
	    aeSetting->objAeMechaIris.FlagIrisRegion = 1;
	    aeSetting->objAeMechaIris.RoughIrisValue = aeSetteingSav->objAeMechaIris.RoughIrisValue;
#endif
		}
  state = STATE_ADJUST;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
}

void AXMIspAe::modeChangeWating(void) {
	// 該当処理は無いため不要
	/*
// WDRWBWX^肪
    SetReg32(RegMIX_MODE, 0x01100000);								// K.Kawachi 0x01100010 => 0x01100001 B24:always 1 B20:always 1 | B4: 0:short first | B0: 0:linear mode
	SetReg32(RegMIX_EXP_RATIO, 0x00000400);							//  B27-16:THRESH_LONG 0 | B11-0:I 16{
	SetReg32(RegMIX_THR_SHORT, 0x00800000);							// B11-00	THRESH_SHORT 0
	SetReg32(RegMIX_ERR_THR,   0x02000010);
	*/

  //  待機中に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

  state = STATE_WAITING;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST

}

void AXMIspAe::modeChangeSpecAe(bool isAdjust) {
  m_log.write(AXFLOG_DEBUG, "AE modeChangeSpecAe() : Running -> Shutter Mode");

  //  AEモード指定に切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(isAdjust == false) {
		aeSetteingSav = aeSetting;
		aeSetting = new AXMIspAeSetting();
	}
	if(aeSetting) {
		aeSetting->AeMode = E_AeShutterControlMode;     		// シャッター制御モード;
		aeSetting->objAeChara.SlowShutterEnable = false;		// Slow Shutter off
		aeSetting->objAeChara.SelectBL_CorFLCEnable = false;	// 自動逆光/過順光補正 off
	}
  state = STATE_SHUTT_AEMODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
}

void AXMIspAe::modeChangeDefect(bool isAdjust) {
  m_log.write(AXFLOG_DEBUG, "AE modeChangeDefect() : Running -> Defect Mode");

  //  調整モードに切替
  if (0 > send(nameIsp, AXFEVENT_MODEL(AXMIsp::EVENT_AE_MODE_CHANGE), 0, 0)) {
    m_log.write(AXFLOG_ERR, "fail send ISP EVENT_AE_MODE_CHANGE");
  }

	if(isAdjust == false) {
		aeSetteingSav = aeSetting;
		aeSetting = new AXMIspAeSetting();
	}
	if(aeSetting) {
		aeSetting->AeMode = E_AeManualMode;
		if(p_spec) {
			aeSetting->objAeManual.ShutterSpeed = p_spec->Defect.DetectSet.AE.ShutterSpeed;
		    aeSetting->objAeManual.Gain = p_spec->Defect.DetectSet.AE.Gain;
#ifdef MECHA_IRIS
				aeSetting->objAeMechaIris.FlagIrisRegion = p_spec->Defect.DetectSet.AE.IrisCloseMode;
#endif
		}
#ifdef MECHA_IRIS
	    aeSetting->objAeMechaIris.RoughIrisValue = 0xFF;
#endif
	}
  state = STATE_DEFECT_MODE;
#ifndef PARASOFT_CPPTEST
  setNextState(state);
#endif  //  PARASOFT_CPPTEST
}

#ifdef PARASOFT_CPPTEST
// C++test sendスタブ
int AXMIspAe::send(AXFObjectName& name, AXFEvent_t eventId, void* data, int size)
{
	return return_stub_send;
}

// C++test setStateInfoスタブ
int AXMIspAe::setStateInfo(AXFActor* obj, int initState, int maxState)
{
	return return_stub_setStateInfo;
}

void AXMIspAe::setStateTable(int registState, const StateTable* stateTable)
{
	return;
}

#endif	// PARASOFT_CPPTEST
