/**
 * @file   AXMIspAf.hpp
 * @brief  AXMIspAfクラスヘッダ
 *
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMISPAF_HPP_
#define AXMISPAF_HPP_

#include "AXM/AXModelActor.hpp"
#include "AXMCommon/AXMCommonConfig.hpp"
#include "AXMIspAfAlgorithm.hpp"
#include "AXHSpec.hpp"

extern const std::string afSampleData;

/**
 * @class AXMIspAf
 * @brief AF実処理クラス
 *
 */
class AXMIspAf : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
  int m_count;

 public:
  AXMIspAf(AXFObjectName& name);
  virtual ~AXMIspAf();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
  AXMIspAfBase *base;
// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMIspAfState.hpp"
};
#endif /* AXMISPAF_HPP_ */
