/*
 * AXMIspAssist.cpp
 */
#include "../AXMCommon/AXMCommonConfig.hpp"
#ifndef BB_TMP_PASS	/* 一旦コンパイルを通す用 */
#include "../../project/refkit/AXMIspConfig.hpp"
#endif

#include "AXMIspAssist.hpp"
#include "AXMIspAssistDef.hpp"
#include "AXHSpec.hpp"

AXMIspAssist::AXMIspAssist(AXFObjectName& name) :
	  AXModelActor    (name)
	, m_log           (name)
	, m_name          (name)
	, state           (STATE_RUNNING)
	, m_obCalc        (NULL)
	, m_preSensorGain (0)
	, p_spec          (0)
{
	// TODO 自動生成されたコンストラクター・スタブ
	
    // 設定値格納先アドレス取得
	::AXHSpec spec;
	p_spec = (ST_SPEC*)spec.getSpecAddr();
}

AXMIspAssist::~AXMIspAssist() {
	// TODO Auto-generated destructor stub
}

ax::actorFuncStatus AXMIspAssist::onCreate() {
	// StateMachine に必要な情報を登録する
	//      自オブジェクト,
	//      初期状態,
	//      状態の最大数
#ifndef PARASOFT_CPPTEST
	if (0 > setStateInfo(this, STATE_RUNNING, STATE_MAX)) {
		return ax::AXFACTOR_ERROR;
	}

	// STATE_0状態の状態テーブルを登録する
	//      状態テーブルで登録する状態,
	//      状態テーブルのポインタ,
	// Wait状態は不要
	setStateTable(STATE_RUNNING, state_running);
#endif  //  PARASOFT_CPPTEST

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAssist::onStart() {
	// OB初期値
	m_obCalc.NotifyObSettings(&m_obSettings);

	// LISRに機能が無いため不要
	//// 低輝度クロマサプレス初期値
	//ChInit();

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAssist::onStop() {
	return ax::AXFACTOR_SUCCESS;
}


void AXMIspAssist::ChInit() {
#ifndef DISABLE_CHROMA_PROC
	// 低輝度クロマサプレスゲイン初期値
	chDefaultLowLuminanceGainSet();
#endif
}
