/**
 * @file   AXMIspAssist.hpp
 * @brief  AXMIspAssistクラスヘッダ
 *
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMISPASSIST_HPP_
#define AXMISPASSIST_HPP_

#include "../AXMCommon/AXMCommonStruct.hpp"
#include "../AXM/AXModelActor.hpp"
#include "AXMIspAssistType.hpp"
#include "AXMIspObSettings.hpp"
#include "AXMIspChSettings.hpp"
#include "AXMIspCh.hpp"
#include "AXMIspOb.hpp"

#ifdef PARASOFT_CPPTEST
	typedef struct {
		BYTE			size;
		BYTE			data[300];
		int				param[15];
	} CHROMA_TEST_DATA;
#endif

const USHORT PTN_OB_UPD_MODE         = 0x0001u;             ///<  OBモード更新要求
const USHORT PTN_OB_UPD_RANGE        = 0x0002u;             ///<  OBサンプリング領域更新要求
const USHORT PTN_OB_UPD_FLOOR        = 0x0004u;             ///<  OB床レベル更新要求
const USHORT PTN_OB_UPD_ARRAY_PTN    = 0x0008u;             ///<  OBセンサ配列パターン選択領域設定更新要求
const USHORT PTN_OB_UPD_ARRAY_PTN_IDX= 0x0010u;             ///<  OB配列パターンへのインデックス設定値更新要求
const USHORT PTN_OB_UPD_ARRAY_IDX_VAL= 0x0020u;             ///<  OBIndex値の設定更新要求

/**
 * @class		AXMIspAssist
 * @brief		補助タスククラス
 *
 * @n			Isp処理の補助タスク。毎フレーム行われる、軽微な処理を実行する。
 */
class AXMIspAssist : public AXModelActor {
	AXFLog m_log;
	AXFObjectName& m_name;
public:
	AXMIspAssist(AXFObjectName& name);
	virtual ~AXMIspAssist();

#include "AXMIspAssistState.hpp"
public:
	ax::actorFuncStatus onCreate();
	ax::actorFuncStatus onStart();
	ax::actorFuncStatus onStop();
	/**
	 * @brief	低輝度クロマサプレスゲイン初期化
	 */
	void ChInit();
private:
	// インスタンスのコピーは想定しない(Klockwork指摘対応:CL.FFM.ASSIGN)
	AXMIspAssist& operator=(const AXMIspAssist&);
	// インスタンスのコピーは想定しない(Klockwork指摘対応:CL.FFM.COPY)
	AXMIspAssist(const AXMIspAssist& obj);

public:
	AXMIspObSettings        m_obSettings;						//!< OB調整設定
	AXMIspObFeedback        m_obCalc;							//!< OB計算
	AXMIspChSettings        m_chSettings;						//!< 低輝度クロマサプレス設定
	AXMIspChCalc            m_chCalc;							//!< 低輝度クロマサプレス計算
	BYTE                    m_preSensorGain;					//!< センサーゲイン前回値
	ST_SPEC*                p_spec;                         //!< パラメータ調整設定格納先ポインタ

#ifdef PARASOFT_CPPTEST
	CHROMA_TEST_DATA			checkDataCPPTEST;
#endif
};

#endif /* AXMISPASSIST_HPP_ */
