/**
 * @file   AXMIspAssistState.hpp
 * @brief  AXMIspAssistクラス StateMachineオブジェクトヘッダ
 *
 * @n
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

/**
 * @enum  ispAssistModelState
 * @brief StateMachine用状態定義
 */
enum ispAssistModelState {
	STATE_RUNNING = 0,					//!< 常に処理を行う
	STATE_MAX,
};

/**
 * @enum  ispAssisstModelEvent
 * @brief StateMachine用イベント定義
 */
enum ispAssisstModelEvent {
	EVENT_START = AXFEVENT_MODEL(0),
	EVENT_SET_OB_PARAM,					//!< OBパラメータ変更チェック
	EVENT_PROC_OB_START,					//!< OB処理開始
	EVENT_PROC_CALC_DARK_LEVEL,			//!< 黒レベル計算開始
	EVENT_PROC_SET_DARK_LEVEL,			//!< 黒レベル設定終了
	EVENT_PROC_PARAM_SETTINGS,			//!< 低輝度クロマサプレス処理パラメータ設定
	EVENT_PROC_LOW_LUMINANCE_GAIN,		//!< 低輝度クロマサプレス処理
};

// StateMachine用状態テーブル宣言
static const AXMIspAssist::StateTable state_running[];

// StateMachine用メンバ関数宣言
/**
 * @brief  OBパラメータ変更チェックを実行する
 *
 * @param  [in]  pParam                        受信パラメータ
 * @param  [in]  size                          受信パラメータサイズ
 * @return       実行完了状態(正常終了)
 */
ax::actorFuncStatus matrix0100(const void *pParam, int size);
/**
 * @brief  OB積算値読み出し処理を実行する
 *
 * @param  [in]  pParam                        受信パラメータ
 * @param  [in]  size                          受信パラメータサイズ
 * @return       実行完了状態(正常終了)
 */
ax::actorFuncStatus matrix0101(const void *pParam, int size);
/**
 * @brief	黒レベル計算処理を実行する
 *
 * @param  [in]  pParam                        受信パラメータ
 * @param  [in]  size                          受信パラメータサイズ
 * @return       実行完了状態(正常終了)
 */
ax::actorFuncStatus matrix0102(const void *pParam, int size);
/**
 * @brief	黒レベル設定完了
 *
 * @param  [in]  pParam                        受信パラメータ
 * @param  [in]  size                          受信パラメータサイズ
 * @return       実行完了状態(正常終了)
 */
ax::actorFuncStatus matrix0103(const void *pParam, int size);
/**
 * @brief	低輝度クロマサプレスパラメータ設定処理を実行する
 *
 * @param  [in]  pParam                        受信パラメータ
 * @param  [in]  size                          受信パラメータサイズ
 * @return       実行完了状態(正常終了)
 */
ax::actorFuncStatus matrix0200(const void *pParam, int size);
/**
 * @brief  低輝度クロマサプレス処理を実行する
 *
 * @param  [in]  pParam                        受信パラメータ
 * @param  [in]  size                          受信パラメータサイズ
 * @return       実行完了状態(正常終了)
 */
ax::actorFuncStatus matrix0201(const void *pParam, int size);

/**
 * @brief	OBパラメータ変更チェック＆取り込み
 *
 * @retval	      0                            パラメータ変更なし
 * @retval	      PTN_OB_UPD_MODE(1)           OBモード変更
 * @retval	      PTN_OB_UPD_RANGE(2)          OBサンプリング領域変更
 * @retval	      PTN_OB_UPD_FLOOR(4)          OB床レベル変更
 * @retval	      PTN_OB_UPD_ARRAY_PTN(8)      OBセンサ配列パターン選択領域設定変更
 * @retval	      PTN_OB_UPD_ARRAY_PTN_IDX(16) OB配列パターンへのインデックス設定値変更
 * @retval	      PTN_OB_UPD_ARRAY_IDX_VAL(32) OBIndex値の設定変更
 */
USHORT					checkOBParam();
/**
 * @brief	OBサンプリング領域設定
 */
void					setOBSamplingRange();
/**
 * @brief	OBセンサ配列パターン選択領域設定
 */
void					setOBArrayPattern();
/**
 * @brief	OB配列パターンへのインデックス設定
 */
void					setOBArrayPatternIndex();
/**
 * @brief	OBIndex値の設定
 */
void					setOBIndexValue();
/**
 * @brief	低輝度クロマサプレスパラメータ変更チェック＆取り込み
 *
 * @return      パラメータ変更有無
 */
bool					checkLowChromaParam();

/**
 * @brief	低輝度クロマサプレスデフォルトゲイン設定
 */
void 					chDefaultLowLuminanceGainSet();

/**
 * @brief	低輝度クロマサプレスゲイン設定
 *
 * @param	[in]  sensorGain                   センサーゲイン
 */
void 					chLowLuminanceGainSet(BYTE sensorGain);

int		state; 					//<! 次期ステータス格納用(setNextStateの引数)
