/*
 * AXMIspCh.cpp
 */

#include "AXMIspCh.hpp"
#include "AXMIspChSettings.hpp"

AXMIspChCalc::AXMIspChCalc() {
	// TODO 自動生成されたコンストラクター・スタブ

}

AXMIspChCalc::~AXMIspChCalc() {
	// TODO Auto-generated destructor stub
}

/*
 * 低輝度クロマサプレス計算
 */
void AXMIspChCalc::CalcLowLuminanceChromaSuppress(BYTE sensorGain, BYTE lowStartGain, BYTE lowInc, BYTE* gain) {
	if (gain == 0) {
		return;
	}
	if (CH_MAX_SENSOR_GAIN < sensorGain) {
		sensorGain = CH_MAX_SENSOR_GAIN;
	}
	if (CH_MAX_SENSOR_GAIN < lowStartGain) {
		lowStartGain = CH_MAX_SENSOR_GAIN;
	}

	// 初期値
	*gain = CH_MAX_OUTPUT_GAIN;

	SHORT outputGain = 0;

	// センサーゲイン入力に対するゲインを決定
	if (lowStartGain < sensorGain) {
		outputGain = CH_MAX_OUTPUT_GAIN - (((sensorGain - lowStartGain) * lowInc) >> 4);
		if (outputGain < 0) {
			outputGain = 0;
		}

		*gain = static_cast<BYTE>(outputGain);
	}
}

