/*
 * AXMIspOb.cpp
 */

#include "AXMIspOb.hpp"
#include "AXMIspObSettings.hpp"
#include "AXMIspAssistDef.hpp"

AXMIspObCalcBase::AXMIspObCalcBase() : m_obSettings(0) {
	// TODO 自動生成されたコンストラクター・スタブ
}

AXMIspObCalcBase::~AXMIspObCalcBase() {
	// TODO Auto-generated destructor stub
}


void AXMIspObCalcBase::NotifyObSettings(AXMIspObSettings* obSettings) {
	m_obSettings = obSettings;
}

AXMIspObFeedback::AXMIspObFeedback() {
	// TODO 自動生成されたコンストラクター・スタブ
}

AXMIspObFeedback::AXMIspObFeedback(AXMIspObSettings* obSettings) {
	// TODO 自動生成されたコンストラクター・スタブ
	NotifyObSettings(obSettings);
}

AXMIspObFeedback::~AXMIspObFeedback() {
	// TODO Auto-generated destructor stub
}

void AXMIspObFeedback::Exec() {
	// 黒レベル(減算される値)計算
	// R , Gr
	// Gb,  B で1画素分なので、実際の画素数は4分の1
	int pixelCnt = (m_obSettings->samplingRange.GetWidth() * m_obSettings->samplingRange.GetHeight()) >> 2;
	for (int i = 0; i < OB_ACCUM_CNT; i++) {
		if (pixelCnt != 0) {
			int darkLevel = ROUND((int)m_obSettings->obAccumlator[i], pixelCnt) - m_obSettings->obDarkLevelFloor[i];
			if (darkLevel < 0) {
				m_obSettings->obDarkLevel[i] = 0;
			}
			else {
				m_obSettings->obDarkLevel[i] = darkLevel;
			}
		}
	}
}
