/*
 * AXMIspAwb.cpp
 */

#include "../AXMCommon/AXMCommonConfig.hpp"

#include "AXMIspAwb.hpp"
#include "AXMIspAwb2.hpp"
#include "../AXMIsp/AXMIsp.hpp"
#ifndef BB_TMP_PASS	/* 一旦コンパイルを通す用 */
#include "../../project/refkit/AXMIspConfig.hpp"
#endif
#include "../AXMCommon/AXMCommonConfig.hpp"

extern ST_AWB_ADJUST g_AwbAdjust;
extern ST_AWB_STATUS g_AwbStatus;


AXMIspAwb::AXMIspAwb(AXFObjectName& name)
    : AXModelActor(name),
      m_log(name),
      m_name(name) {
  m_log.write(AXFLOG_DEBUG, "AWB Constractor");
  JudgeLightSource = NULL;

  p_spec = NULL;

  //  AWB調整ポイント出力初期化
  g_AwbAdjust.pntLowTemp.Bg = 0;
  g_AwbAdjust.pntLowTemp.Rg = 0;
  g_AwbAdjust.pntHighTemp.Bg = 0;
  g_AwbAdjust.pntHighTemp.Rg = 0;
  //  AWBデフォルト座標出力初期化
  for(INT i = 0; i < AWBLightDefault_Max; i++) {
    g_AwbAdjust.LightDefault[i].Bg = 0;
    g_AwbAdjust.LightDefault[i].Rg = 0;
  }
  //  AWB光源枠座標出力初期化
  for(INT i = 0; i < AWBLightSource_Rolling_Max; i++) {
    for(INT j = 0; j < AWB_LightSourcePnt; j++) {
      g_AwbAdjust.LightSource[i].Area[j].Bg = 0;
      g_AwbAdjust.LightSource[i].Area[j].Rg = 0;
    }
  }
  //  AWB状態出力初期化
  g_AwbStatus.Sts_Convergence = AwbStatus_flact;            //  引込み動作状態:変動中
  g_AwbStatus.TrustJudge = AWBOPDTrustJudge_High;           //  低信頼性判定:低信頼性でない
  g_AwbStatus.Sts_LightSourceErr = 0;                       //  光源枠外エラー:エラーなし
  g_AwbStatus.WBGain.bGain = 0x0000u;                       //  WB Bゲイン
  g_AwbStatus.WBGain.rGain = 0x0000u;                       //  WB Rゲイン
  g_AwbStatus.LightSource = AWBLightSource_None;            //  照明判定:光源枠なし

  state = STATE_WAITING;
#ifdef USE_AXFTEST_COMMAND
  m_loopbackCount = 0;
#endif /* USE_AXFTEST_COMMAND */
}

AXMIspAwb::~AXMIspAwb() {
  m_log.write(AXFLOG_DEBUG, "AWB Destractor");
}

ax::actorFuncStatus AXMIspAwb::onCreate() {
  m_log.write(AXFLOG_DEBUG, "AWB onCreate()");

  // StateMachine に必要な情報を登録する
  //      自オブジェクト,
  //      初期状態,
  //      状態の最大数
#ifndef PARASOFT_CPPTEST
  if (0 > setStateInfo(this, STATE_WAITING, STATE_MAX)) {                       //  起動時 待機中
    m_log.write(AXFLOG_ERR, "fail registHandle");
    return ax::AXFACTOR_ERROR;
  }

  // STATE_0状態の状態テーブルを登録する
  //      状態テーブルで登録する状態,
  //      状態テーブルのポインタ,
  setStateTable(STATE_WAITING, state_wating);               //  待機中:調整モード(WB調整以外)
  setStateTable(STATE_ATWMode, state_atw_mode);             //  ATWモード
  setStateTable(STATE_ManuMode, state_manu_mode);           //  マニュアルモード
  setStateTable(STATE_OnePush, state_one_push);             //  ワンプッシュモード
  setStateTable(STATE_ADJUST, state_adjust);                //  調整モード
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::onStart() {
  m_log.write(AXFLOG_DEBUG, "AWB onStart()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::onStop() {
  m_log.write(AXFLOG_DEBUG, "AWB onStop()");
  {
    delete JudgeLightSource;
  }
  return ax::AXFACTOR_SUCCESS;
}

#if 0
ax::actorFuncStatus AXMIspAwb::onPause() {
  m_log.write(AXFLOG_DEBUG, "AWB onPause()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::onResume() {
  m_log.write(AXFLOG_DEBUG, "AWB onResume()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::onRestart() {
  m_log.write(AXFLOG_DEBUG, "AWB onRestart()");
  return ax::AXFACTOR_SUCCESS;
}
#endif
