/**
 * @file	AXMIspAwbOPDConfig.hpp
 * @brief	AXMIspAwb共通OPD定数ヘッダ
 *
 * @par	言語
 *			C++
 */


#ifndef AXMISPAWBOPDCONFIG_HPP_
#define AXMISPAWBOPDCONFIG_HPP_


const INT       AWB_OPD_H_Div_Max = 40;                                         ///< 水平分割数最大値
const INT       AWB_OPD_V_Div_Max = 40;                                         ///< 垂直分割数最大値

const INT       AWB_OPD_H_Div = 40;                                             ///< 水平分割数
const INT       AWB_OPD_V_Div = 36;                                             ///< 垂直分割数

const SHORT     AWBOnePushPnt_Start_H = 0;                                      ///< OnePushモード開始水平座標初期値
const SHORT     AWBOnePushPnt_Start_V = 0;                                      ///< OnePushモード開始垂直座標初期値
const SHORT     AWBOnePushPnt_End_H   = AWB_OPD_H_Div - 1;                      ///< OnePushモード終了水平座標初期値
const SHORT     AWBOnePushPnt_End_V   = AWB_OPD_V_Div - 1;                      ///< OnePushモード終了垂直座標初期値

const USHORT    AWB_OPDWeightV1_Init = 10;                                      ///< エリア座標v1 初期値
const USHORT    AWB_OPDWeightH2_Init = 7;                                       ///< エリア座標h2 初期値
const USHORT    AWB_OPDWeightH3_Init = 30;                                      ///< エリア座標h3 初期値
const USHORT    AWB_OPDWeightV4_Init = 25;                                      ///< エリア座標v4 初期値

const USHORT    AWB_WB_RGain_Init = 0x018e;                                     ///< ホワイトバランス初期値
const USHORT    AWB_WB_BGain_Init = 0x0198;                                     ///< ホワイトバランス初期値
//const INT       AWB_Rg_Bg_Cal_Sft = 12;                                         ///< R/G，B/G 演算時シフト量
//const INT       AWB_Rg_Bg_OnePush_Sft = (AWB_Rg_Bg_Cal_Sft + 8);                ///< R/G，B/G OnePushモード演算時シフト量
//const INT       AWB_Rg_Bg_OnePush_Sft = 20;                                     ///< R/G，B/G OnePushモード演算時シフト量
const INT       AWB_Rg_Bg_Cal_Sft = 8;                                          ///< R/G, B/G演算時シフト量
const INT       AWB_Rg_Bg_WB_Sft  = (AWB_Rg_Bg_Cal_Sft * 2);                    ///< R/G，B/G ATWモード演算時シフト量
const INT       AWB_Rg_Bg_OnePush_Sft = (AWB_Rg_Bg_Cal_Sft * 2);                ///< R/G, B/G OnePushモード演算時シフト量

const USHORT    AWB_ManuModeColorTemp_Init = 0;                                 ///< マニュアルモード時色温度指定

const USHORT    AWB_StopLowBright_Init = 0;                                     ///< ATW停止しきい値初期値

const USHORT    AWB_CbGain_Init = 0x0100;                                       ///< Cbクロマゲイン初期値
const USHORT    AWB_CrGain_Init = 0x0100;                                       ///< Crクロマゲイン初期値

const USHORT    AWB_Bright_Init = 1000;                                         ///< 明るさデータ初期値

const INT       AWB_Matrix_Sft = 8;                                             ///< マトリックス演算時シフト量(基準値)

const INT       AWB_LightSourceNum_ATWStandardMode = 6;                         ///< ATWシーン 標準モード時光源数
const INT       AWB_LightSourceNum_ATWSceaneIndoorMode = 4;                     ///< ATWシーン インドアモード時光源数
const INT       AWB_LightSourceNum_ATWSceaneIndoorCWFMode = 4;                  ///< ATWシーン インドアCWFモード時光源数
const INT       AWB_LightSourceNum_ATWSceaneIndoorAMode = 1;                    ///< ATWシーン インドアAモード時光源数
const INT       AWB_LightSourceNum_ATWSceaneOutdoorMode = 7;                    ///< ATWシーン アウトドアモード時光源数
const INT       AWB_LightSourceNum_ATWSceaneLEDMode = 3;                        ///< LEDモード時光源数
const INT       AWB_LightSourceNum_ATWSceaneColorRollingMode = 3;               ///< LEDモード時光源数
const INT       AWB_LightSourceNum_OnePushMode = 6;                             ///< One Pushモード時光源数
const INT       AWB_LightSourceNum_None = 0;                                    ///< 光源なし時光源数

const SHORT     AWB_SHORT_MIN = 0x8000;
const SHORT     AWB_SHORT_MAX = 0x7FFF;


#endif /* AXMISPAWBOPDCONFIG_HPP_ */
