/********************************************************************

  		DSPCommon.h
  
 ********************************************************************/

#ifndef _DSPCommon_h_
#define _DSPCommon_h_
/*----------------------------------------------------------------------*
 *					Register read/write macros							*
 *----------------------------------------------------------------------*/
// 下記以降のレジスタ操作マクロは現状未使用
//#define GetReg32(reg)			(*(volatile UInt32*)(reg))
//#define SetReg32(reg,val)		(*(volatile UInt32*)(reg)=(val))
//#define GetRegFld32(reg,fld)		(*(volatile UInt32*)(reg)&=(fld))
//#define SetRegFld32(reg,fld)		(*(volatile UInt32*)(reg)|=(fld))
//#define ClrRegFld32(reg,fld)		(*(volatile UInt32*)(reg)&=~(fld))
//#define ClrSetRegFld32(reg,fld,val)	SetReg32((reg),(GetReg32(reg)&~(fld))|(val))
//
//#define GetReg16(reg)			(*(volatile UInt16*)(reg))
//#define SetReg16(reg,val)		(*(volatile UInt16*)(reg)=(val))
//#define SetRegFld16(reg,fld)		(*(volatile UInt16*)(reg)|=(fld))
//#define ClrRegFld16(reg,fld)		(*(volatile UInt16*)(reg)&=~(fld))
//#define ClrSetRegFld16(reg,fld,val)	SetReg16((reg), (GetReg16(reg)&~(fld))|(val))
//
//#define GetReg8(reg)			(*(volatile UInt8*)(reg))
//#define SetReg8(reg,val)		(*(volatile UInt8*)(reg)=(val))
//#define SetRegFld8(reg,fld)		(*(volatile UInt8*)(reg)|=(fld))
//#define ClrRegFld8(reg,fld)		(*(volatile UInt8*)(reg)&=~(fld))
//#define ClrSetRegFld8(reg,fld,val)	SetReg8((reg), (GetReg8(reg)&~(fld))|(val))
//
//#define GetReg			        GetReg32
//#define SetReg			        SetReg32
//#define GetRegFld		        GetRegFld32
//#define SetRegFld		        SetRegFld32
//#define ClrRegFld		        ClrRegFld32
//#define ClrSetRegFld	                ClrSetRegFld32

#define Asm		                __asm__ volatile

/* global memory */

#if defined(VERSATILE)

#define DDR_BASE				
#define SPAD_BASE				
#define DSP0_RAM_BASE			(0xE2000000)
#define DSP1_RAM_BASE			DSP0_RAM_BASE	// not supported

#else

#define DDR_BASE			(0x10000000)
#ifdef MARBLEL
  #define SPAD_BASE			(0x60000000)
  #if 0
  #define DSP0_RAM_BASE			(0x70100000)
  #define DSP1_RAM_BASE			(0x70140000)
  #else
  #define DSP0_RAM_BASE			(0xB0100000)
  #define DSP1_RAM_BASE			(0xB0140000)
  #endif
#else
#define SPAD_BASE			(0xB8000000)
#define DSP0_RAM_BASE			(0xBC000000)
#define DSP1_RAM_BASE			(0xBE000000)
#endif

#endif

/* local memory */
#define DSP_SYSROM_BASE			(0xC0000000)
#define DSP_SYSRAM_BASE			(0xC1000000)
#define DSP_DRAM0_BASE			(0xD0000000)
#define DSP_DRAM1_BASE			(0xD0010000)
#define DSP_IRAM_BASE			(0xD0020000)

/* interrupt */
#define TIMER0_INT_NUM			0
#define TIMER1_INT_NUM			1
#define EXLEVEL_INT_NUM 		2

#define TIMER0_INT_MASK			(0x1 << TIMER0_INT_NUM)
#define TIMER1_INT_MASK			(0x1 << TIMER1_INT_NUM)
#define EXLEVEL_INT_MASK		(0x1 << EXLEVEL_INT_NUM)

#ifdef MARBLE2
#define TIMER0_INT_PRI			2
#else
#define TIMER0_INT_PRI			1
#endif
#define TIMER1_INT_PRI			1
#define EXLEVEL_INT_PRI			2



typedef unsigned long		        UInt32;
typedef unsigned short		        UInt16;
typedef unsigned char		        UInt8;
typedef signed char			SInt8;
typedef unsigned char		        Byte;

#endif /* _DSPCommon_h_ */
