// DT10（動的テストツール）でのパフォーマンス計測を行う場合は、
// USE_DT10_PERFORMACEを有効にし、ビルドを行ってください。
#ifdef USE_DT10_PERFORMACE
/*==============================================================================*/

/*==============================================================================*/
/*  Please customize the code for your environment.                             */
/*==============================================================================*/

/*==============================================================================*/
/*  Desc:   Header for Port Control                                             */
/*==============================================================================*/
//#include "Common.h"
// #include <itron.h>
// #include <kernel.h>
//<<<
#include <tk/tkernel.h>

#include "../DSPCommon.h"
#include "../adrs_base.h"
#include "../reg_gpio.h"

#define GPIO_CLK    0x01
#define GPIO_CS     0x02
#define GPIO_DAT0   0x04
#define GPIO_DAT1   0x08
#define GPIO_DAT2   0x10
#define GPIO_DAT3   0x80

#define EXT_INTERRUPT			(2)
#define SOFTWARE_INTERRUPT		(3)
//>>>

/*==============================================================================*/
/*  Macro:  DT_UINT                                                             */
/*  Desc:   Please change Test Point argument type for DT10 Project setting.    */
/*==============================================================================*/
#define	DT_UINT unsigned int

/*==============================================================================*/
/*  Macro:  DT_INLINE                                                           */
/*  Desc:   Please use "static" instead of "inline" if "inline" cannot be used. */
/*==============================================================================*/
#define	DT_INLINE	inline
/* #define	DT_INLINE	static */

/*==============================================================================*/
/*  Macro:  DT_WRITE_VARIABLE                                                   */
/*  Desc:   Please set 1 if use Write Test Point                                */
/*==============================================================================*/
#define DT_WRITE_VARIABLE 0

/*==============================================================================*/
/*  Macro:  DT_ADD_EVENT_INFO                                                   */
/*  Desc:   Please set 1 when you add Event Value to Test Point.                */
/*==============================================================================*/
#define	DT_ADD_EVENT_INFO 1 // 0->1

/*==============================================================================*/
/*  Func:   _TP_BusPortInit                                                     */
/*  Desc:   Please describe the code to initializes ports.                      */
/*==============================================================================*/
static void _TP_BusPortInit(void)
{
	/* ex)	
			PA.DIR = 0x3f;
			PD.DIR = 0x3f;
			PA.word = 0x3f;
			PD.word = 0x3f;	
	*/
//	SysCtlPeripheralEnable( SYSCTL_PERIPH_GPIOA );
//	SysCtlPeripheralEnable( SYSCTL_PERIPH_GPIOD );
	SetRegFld32( REG_GPIO_3_GPIODIR, GPIO_CLK );				/*	CLK	*/
	SetRegFld32( REG_GPIO_3_GPIODIR, GPIO_CS  );				/*	CS	*/
//	GPIOPinTypeGPIOInput( GPIO_PORTD_BASE, GPIO_PIN_6 );		/*	SEL	*/
	SetRegFld32( REG_GPIO_4_GPIODIR, GPIO_DAT0 );				/*	DAT0	*/
	SetRegFld32( REG_GPIO_4_GPIODIR, GPIO_DAT1 );				/*	DAT0	*/
	SetRegFld32( REG_GPIO_4_GPIODIR, GPIO_DAT2 );				/*	DAT0	*/
	SetRegFld32( REG_GPIO_4_GPIODIR, GPIO_DAT3 );				/*	DAT0	*/
	SetRegFld32( REG_GPIO_3_GPIODATA_F, GPIO_CLK );
	SetRegFld32( REG_GPIO_3_GPIODATA_F, GPIO_CS  );
	SetRegFld32( REG_GPIO_4_GPIODATA_F, GPIO_DAT0 );
	SetRegFld32( REG_GPIO_4_GPIODATA_F, GPIO_DAT1 );
	SetRegFld32( REG_GPIO_4_GPIODATA_F, GPIO_DAT2 );
	SetRegFld32( REG_GPIO_4_GPIODATA_F, GPIO_DAT3 );
}

/*==============================================================================*/
/*  Func:   portReverseCLK                                                      */
/*  Desc:   Please describe the code to reverse CLK Port.                       */
/*==============================================================================*/
DT_INLINE void portReverseCLK(void)
{
	/* ex)
		PA.bit.b0 ^= 1;
	*/
	if( GetRegFld( REG_GPIO_3_GPIODATA_F, GPIO_CLK ) ){
		ClrRegFld( REG_GPIO_3_GPIODATA_F, GPIO_CLK );
	}
	else{
		SetRegFld( REG_GPIO_3_GPIODATA_F, GPIO_CLK );
	}
}

/*==============================================================================*/
/*  Func:   portSetCLK                                                          */
/*  Desc:   Please describe the code to set the value to CLK Port.              */
/*==============================================================================*/
DT_INLINE void portSetCLK( DT_UINT dat)
{
	/* ex)
		PA.bit.b0 = dat?1:0;
	*/
	if( dat ) {
		SetRegFld( REG_GPIO_3_GPIODATA_F, GPIO_CLK );
	}
	else {
		ClrRegFld( REG_GPIO_3_GPIODATA_F, GPIO_CLK );
	}
}

/*==============================================================================*/
/*  Func:   portSetCS                                                           */
/*  Desc:   Please describe the code to set the value to CS Port.               */
/*==============================================================================*/
DT_INLINE void portSetCS(DT_UINT dat)
{
	/* ex)
		PA.bit.b1 = dat?1:0;
	*/
	if( dat ) {
		SetRegFld( REG_GPIO_3_GPIODATA_F, GPIO_CS );
	}
	else {
		ClrRegFld( REG_GPIO_3_GPIODATA_F, GPIO_CS );
	}
}

/*==============================================================================*/
/*  Func:   portSetDATA                                                         */
/*  Desc:   Please describe the code to set the value to DATA Port              */
/*==============================================================================*/
DT_INLINE void portSetDATA(DT_UINT dat)
{
	/* ex)
	 PA.word = (PA.word & 0xff0f) | (dat << 4);
	*/
	if( dat & 0x01 ) {
		SetRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT0 );
	}
	else {
		ClrRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT0 );
	}

	if( dat & 0x02 ) {
		SetRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT1 );
	}
	else {
		ClrRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT1 );
	}

	if( dat & 0x04 ) {
		SetRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT2 );
	}
	else {
		ClrRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT2 );
	}

	if( dat & 0x08 ) {
		SetRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT3 );
	}
	else {
		ClrRegFld( REG_GPIO_4_GPIODATA_F, GPIO_DAT3 );
	}
}

/*==============================================================================*/
/*  Func:   portGetSEL                                                          */
/*  Desc:   Please describe the code to get the value from SEL Port             */
/*==============================================================================*/
#if DT_WRITE_VARIABLE
DT_INLINE DT_UINT portGetSEL(void)
{
	/* ex)
		return PA.bit.b6;
	*/ 

	return GPIOPinRead( GPIO_PORTD_BASE, GPIO_PIN_6 );
}
#endif

/*==============================================================================*/
/*  Func:   enterCritical                                                       */
/*  Desc:   Please describe the code to enter Critical Section.                 */
/*==============================================================================*/
int dtDrvImask;
DT_INLINE void enterCritical(void)
{
	/* ex)
		DI();
	*/ 
//	taskENTER_CRITICAL();
	DI(dtDrvImask);
}

/*==============================================================================*/
/*  Func:   exitCritical                                                        */
/*  Desc:   Please describe the code to exit Critical Section.                  */
/*==============================================================================*/
DT_INLINE void exitCritical(void)
{
	/* ex)
		EI();
	*/ 
//	taskEXIT_CRITICAL();
	EI(dtDrvImask);
}

/*==============================================================================*/
/*  Func:   addEventInfo                                                        */
/*  Desc:   please describe the code to get target event                        */
/*==============================================================================*/
#if DT_ADD_EVENT_INFO
DT_INLINE DT_UINT addEventInfo(void)
{
	int event_id = 0;

	/* describe code to get target eventinformation */
	/* ex. uITron4.0 API	*/
	//ID* p_taskid;
	//get_tid(p_taskid);
	//event_id = (int)*p_taskid;
	event_id = tk_get_tid();;
	return event_id;

}
#endif

/*==============================================================================*/
/*  Don't change the code from here as possible.                                */
/*==============================================================================*/

/*==============================================================================*/
/*  Desc:   Test Point Parametaer                                               */
/*==============================================================================*/
#define		DT_VARIABLE_BIT			0x02
#define		DT_TARGET_TIME_BIT		0x04
#define		DT_EVTTRG_BIT			0x08
#define		DT_VARIABLE_FAST_BIT	0x01
#define		DT_EVTTRG_FAST_BIT		0x02
#define		DT_VARIABLE_WRITE_BIT	0x01

/*==============================================================================*/
/*  Func:   portInit                                                            */
/*  Desc:   Initialize Port Function                                            */
/*==============================================================================*/
static int init = 0;
DT_INLINE void portInit(void)
{
	if( init == 0 ){
		_TP_BusPortInit();
		init = 1;
	}
}

/*==============================================================================*/
/*  Func:   _TP_Bus4BitOutDrv                                                   */
/*  Desc:   4bit Data Output Function                                           */
/*==============================================================================*/
DT_INLINE void _TP_Bus4BitOutDrv( DT_UINT dat )
{
	portSetDATA( dat );
	portReverseCLK();
}

/*==============================================================================*/
/*  Func: _TP_BusOutDrv                                                         */
/*  Desc: Test Point Output Function                                            */
/*==============================================================================*/
DT_INLINE void _TP_BusOutDrv( DT_UINT addr, DT_UINT dat )
{
	portSetCS(0);
	_TP_Bus4BitOutDrv( dat >> 12 );
	_TP_Bus4BitOutDrv( dat >> 8 );
	_TP_Bus4BitOutDrv( dat >> 4 );
	_TP_Bus4BitOutDrv( dat );
	addr &= 0xfffff;
	if( addr >= 0x10000 ) _TP_Bus4BitOutDrv( addr >> 16 );
	if( addr >= 0x1000 ) _TP_Bus4BitOutDrv( addr >> 12 );
	if( addr >= 0x0100 ) _TP_Bus4BitOutDrv( addr >> 8 );
	if( addr >= 0x0010 ) _TP_Bus4BitOutDrv( addr >> 4 );
	_TP_Bus4BitOutDrv( addr );
	portSetCS(1);
}

/*==============================================================================*/
/*  Func:   _TP_BusOutByteDrv                                                   */
/*  Desc:   Byte Data Output Function                                           */
/*==============================================================================*/
DT_INLINE void _TP_BusOutByteDrv( DT_UINT dat )
{
	_TP_Bus4BitOutDrv( dat >> 4 );
	_TP_Bus4BitOutDrv( dat );
}

/*==============================================================================*/
/*  Func:   _TP_MemoryOutDrv                                                    */
/*  Desc:   Value Output Function                                               */
/*==============================================================================*/
DT_INLINE void _TP_MemoryOutDrv( unsigned char *p, DT_UINT size )
{
	if( size >= 256 ) size = 256;
	_TP_BusOutByteDrv( size );
	for( ; size != 0; --size, ++p ){
		_TP_BusOutByteDrv( *p );
	}
}

/*==============================================================================*/
/*  Func:   _TP_InputByteDrv                                                    */
/*  Desc:   Byte Data Input Function                                            */
/*==============================================================================*/
#if DT_WRITE_VARIABLE
DT_INLINE DT_UINT _TP_InputByteDrv( void )
{
	DT_UINT	i, c;
	c = 0;
	for( i = 0; i < 8; i++ ){
		portSetCLK(0);
		c <<= 1;
		if( portGetSEL() ) c |= 0x01;
		portSetCLK(1);
	}
	return c;
}

/*==============================================================================*/
/*  Func:   _TP_WritePointDrv                                                   */
/*  Desc:   Value Write Function                                                */
/*==============================================================================*/
DT_INLINE void _TP_WritePointDrv( unsigned char *p, DT_UINT size )
{
	int	i, s;
	for( i = 0; i < 50; i++ ){
		portSetCLK(0);
		s = portGetSEL();
		portSetCLK(1);
		if( s ) break;
	}
	if( s == 0 ) return ;
	s = _TP_InputByteDrv();
	if( s > 16 || s == 0 ) return;
	for( i = 0; i < s; i++, p++ ){
		*p = _TP_InputByteDrv();
	}
}
#endif

/*==============================================================================*/
/*  Func: _TP_BusOut                                                            */
/*  Desc: Called by Test Point                                                  */
/*==============================================================================*/
void _TP_BusOut( DT_UINT addr, DT_UINT dat )
{

#if DT_ADD_EVENT_INFO
	unsigned int event_id = 0;
#endif

	portInit();
	enterCritical();

#if DT_ADD_EVENT_INFO
	addr = addr | DT_EVTTRG_BIT;
#endif

	_TP_BusOutDrv( addr, dat );

#if DT_ADD_EVENT_INFO
	portSetCS(0);

	event_id = addEventInfo();
	_TP_BusOutByteDrv(event_id);
	_TP_BusOutByteDrv(event_id >> 8);
	_TP_BusOutByteDrv(event_id >> 16);
	_TP_BusOutByteDrv(event_id >> 24);

	portSetCS(1);
#endif
	exitCritical();
}

/*==============================================================================*/
/*  Func:   _TP_MemoryOutput                                                    */
/*  Desc:   Called by Variable Test Point                                       */
/*==============================================================================*/
void _TP_MemoryOutput( DT_UINT addr, DT_UINT dat, void *value, DT_UINT size )
{

#if DT_ADD_EVENT_INFO
	int event_id = 0;
#endif

	portInit();
	enterCritical();

#if DT_ADD_EVENT_INFO
	addr = addr | DT_EVTTRG_BIT;
#endif

	_TP_BusOutDrv( addr | DT_VARIABLE_BIT, dat );

	/* 2nd data output */
	 portSetCS(0);

#if DT_ADD_EVENT_INFO
	event_id = addEventInfo();
	_TP_BusOutByteDrv(event_id);
	_TP_BusOutByteDrv(event_id >> 8);
	_TP_BusOutByteDrv(event_id >> 16);
	_TP_BusOutByteDrv(event_id >> 24);
#endif

	/* output value */
	_TP_MemoryOutDrv( (unsigned char *)value, size );

	portSetCS(1);
	exitCritical();
}


/*==============================================================================*/
/*  Func:   _TP_WritePoint                                                      */
/*  Desc:   Called by Variable Write Test Point                                 */
/*==============================================================================*/
#if DT_WRITE_VARIABLE
void _TP_WritePoint( DT_UINT addr, DT_UINT dat, void *value, DT_UINT size )
{

	addr |= DT_VARIABLE_WRITE_BIT;

	portInit();
	enterCritical();
	_TP_BusOutDrv( addr, dat );

	_TP_WritePointDrv( value, size );
	exitCritical();
}
#endif

#endif /* USE_DT10_PERFORMACE */
