#ifndef  PARASOFT_CPPTEST

#ifdef  __cplusplus
extern "C"
{
#endif

#include "DSPCommon.h"
#include "adrs_map.h"
#include "proc_def_isp_eval.h"
#include "gamma_param.h"

#include "AXMIspAe/AXMISPtype.hpp"
#include "AXMImageSensor/imageSensorDrv.h"

//  アパーチャ補正が正常に動作するようになれば、次の#defineを削除してください
#define ENABLE_APERTURE_SAMPLE_SETTINGS

UInt32 g_isp_scl_ch0_en;
UInt32 g_isp_scl_ch1_en;
UInt32 g_isp_scl_ch2_en;
UInt32 g_isp_scl_ch3_en;
UInt32 g_isp_scl_ch4_en;
UInt32 g_isp_scl_ch5_en;

void init_isp_enc(UInt32 input_width, UInt32 input_height,
                  UInt32 output_width0, UInt32 output_height0,
                  UInt32 output_width1, UInt32 output_height1,
                  UInt32 output_width2, UInt32 output_height2,
                  UInt32 scl_ch_en)
{
    g_isp_scl_ch0_en = ((scl_ch_en >> 0) & 0x1) ? SCL_CTL_CH0 : 0;
    g_isp_scl_ch1_en = ((scl_ch_en >> 1) & 0x1) ? SCL_CTL_CH1 : 0;
    g_isp_scl_ch2_en = ((scl_ch_en >> 2) & 0x1) ? SCL_CTL_CH2 : 0;
    g_isp_scl_ch3_en = ((scl_ch_en >> 3) & 0x1) ? SCL_CTL_CH3 : 0;
    g_isp_scl_ch4_en = ((scl_ch_en >> 4) & 0x1) ? SCL_CTL_CH4 : 0;
    g_isp_scl_ch5_en = ((scl_ch_en >> 5) & 0x1) ? SCL_CTL_CH5 : 0;

    SetReg32 (r_ISP_DMAR_SRST,      0x00000000);  // DMAR_SRST
    SetReg32 (r_ISP_DMAR_INT_MASK,  0x00000001);  // INT_MASK
    SetReg32 (r_ISP_DMAR_INT_INV,   0x00000001);  // INT_INV
    SetReg32 (r_ISP_DMAR_UF_MODE,   0x00000000);  // UF_MODE
    SetReg32 (r_ISP_DMAR_EN,        0x00000001);  // DMA_EN
    SetReg32 (r_ISP_DMAR_SRST,      0x00000001);  // DMAR_SRST
    SetReg32 (r_ISP_DMAR_SRST,      0x00000000);  // DMAR_SRST release
    
    SetReg32 (r_ISP_DMAW_SRST,      0x00000000);  // DMAW_SRST
    SetReg32 (r_ISP_DMAW_INT_MASK,  0x00000001);  // INT_MASK
    SetReg32 (r_ISP_DMAW_INT_INV,   0x00000001);  // INT_INV
    SetReg32 (r_ISP_DMAW_UF_MODE,   0x00000000);  // UF_MODE
    SetReg32 (r_ISP_DMAW_EN,        0x00000001);  // DMA_EN
    SetReg32 (r_ISP_DMAW_SRST,      0x00000001);  // DMAW_SRST
    SetReg32 (r_ISP_DMAW_SRST,      0x00000000);  // DMAW_SRST release
    
    // [0] RPURUN   RPU total Enable
    // [1] RPUSTART RPU One Shot Processing Start
    // [2] RPURMD   RPU RUN MODE Select
    /***
    SetReg32 (r_ISP_RPU_C0,         0x02104084);  // 1_0_0
    SetReg32 (r_ISP_RPU_C0,         0x02104086);  // 1_1_0
    SetReg32 (r_ISP_RPU_C0,         0x02104087);  // 1_1_1
    SetReg32 (r_ISP_RPU_C0,         0x02104085);  // 1_0_1
    ***/
    
    // ---> yuv422thru
    //SetReg32(RPU_C0, 0x02104084); // DMA output
    SetReg32(RPU_C0, 0xc0104084); // direct output
    SetReg32(RPU_IDM, 0x00200000);
    //SetReg32(RPU_ID0, 0x00002001);      // bayer 12bit
    SetReg32(RPU_ID0, 0x00004001);        // bayer 14bit
    SetReg32(RPU_ID3, 0x000040f7);
    //SetReg32(RPU_ID4, 0x000040f7);
    SetReg32(RPU_ID4, 0x000040f7);
    SetReg32(RPU_ODM, 0x00000000);
    SetReg32(RPU_OD0, 0x00100024);
    SetReg32(RPU_OD0CSL, 0x000000e4);
    SetReg32(RPU_OD1, 0x00000000);
    SetReg32(RPU_OD1CSL, 0x000000e4);
    SetReg32(RPU_OD2, 0x00000000);
    SetReg32(RPU_OD2CSL, 0x000000e4);
    SetReg32(DMAO0_HW, ((input_width-1)<<16));      // width-1
    SetReg32(DMAO0_VW, ((input_height-1)<<16));     // height-1
    SetReg32(DMAO1_HW, 0x007f0000);
    SetReg32(DMAO1_VW, 0x007f0000);
    SetReg32(DMAO2_HW, 0x007f0000);
    SetReg32(DMAO2_VW, 0x007f0000);
    SetReg32(RPU_LN, ((input_height << 16) | (input_width))); // height, width
    SetReg32(SPP_C, 0x00001004);
    SetReg32(SPPOB0, 0x00000000);
    SetReg32(SPPOB1, 0x00000000);
    SetReg32(SPPOB2, 0x00000000);
    SetReg32(SPPOB3, 0x00000000);
    SetReg32(SPPWB0, 0x00000080);
    SetReg32(SPPWB1, 0x00000080);
    SetReg32(SPPWB2, 0x00000080);
    SetReg32(SPPWB3, 0x00000080);
    SetReg32(SPPVAL, 0x00800080);
    SetReg32(SPP_C2, 0x00000c00);
    SetReg32(SPP_VAL2, 0x00800080);
    SetReg32(SPP_VAL3, 0x00000000);
    SetReg32(SPP_SHT0, 0x00000000);
    SetReg32(SPP_SHT1, 0x00000007);
    SetReg32(SPP_SHT2, 0x00000000);
    SetReg32(SPPLMTWB0, 0x00003fff);
    SetReg32(IAG_C, 0x24000138);
    //SetReg32(IAG_C2, 0x00000240);         // bayer
    SetReg32(IAG_C2, 0x00000040);         // bayer
    SetReg32(ITP_CHONY, 0x00000000);
    SetReg32(ITP_V0, 0x00150000);
    SetReg32(ITP_V1, 0x00200004);
    SetReg32(ITP_V2, 0x00800040);
    SetReg32(ITP_V3, 0x00000008);
    SetReg32(ITP_V4, 0x028000a0);
    SetReg32(ITP_V5, 0x00000020);
    SetReg32(ITP_V6, 0x00100010);
    SetReg32(ITP_V7, 0x00000002);
    SetReg32(ITP_V9, 0x00000000);
    SetReg32(ITP_V10, 0x00000000);
    SetReg32(ITP_V11, 0x00000004);
    SetReg32(ITP_LAP0, 0x22041204);
    SetReg32(ITP_LAP1, 0x00000008);
    SetReg32(ITP_LAP2, 0x0000fff0);
    SetReg32(ITP_LAP3, 0x00100040);
    SetReg32(ITP_LAP4, 0x0fff0fff);
    SetReg32(AFV_C, 0x00000000);
    SetReg32(AFVW_H, 0x01000000);
    SetReg32(AFVW_V, 0x01000000);
    SetReg32(AFV_DT, 0x00000000);
    SetReg32(AFV_PD, 0x00000000);
#if 0
    SetReg32(LMCF00, 0x00000100);
    SetReg32(LMCF01, 0x00000000);
    SetReg32(LMCF02, 0x00000000);
    SetReg32(LMCF03, 0x00000000);
    SetReg32(LMCF10, 0x00000000);
    SetReg32(LMCF11, 0x00000100);
    SetReg32(LMCF12, 0x00000000);
    SetReg32(LMCF13, 0x00000000);
    SetReg32(LMCF20, 0x00000000);
    SetReg32(LMCF21, 0x00000000);
    SetReg32(LMCF22, 0x00000100);
    SetReg32(LMCF23, 0x00000000);
    SetReg32(LMCF30, 0x00000000);
    SetReg32(LMCF31, 0x00000000);
    SetReg32(LMCF32, 0x00000000);
    SetReg32(LMCF33, 0x00000011);
    SetReg32(LMOF0, 0x00000000);
    SetReg32(LMOF1, 0x00000000);
    SetReg32(LMOF2, 0x00000000);
    SetReg32(LMOF3, 0x00000000);
    SetReg32(LMBC, 0x00007777);
#endif
    SetReg32(RG_GMLMTPOS0, 0x00003fff);
    SetReg32(RG_GMLMTPOS1, 0x00003fff);
    SetReg32(RG_GMLMTPOS2, 0x00003fff);
    SetReg32(RG_GMLMTPOS3, 0x00003fff);
    SetReg32(CSCF00, 0x0000004c);
    SetReg32(CSCF01, 0x00000096);
    SetReg32(CSCF02, 0x0000001e);
    SetReg32(CSCF03, 0x00000000);
    SetReg32(CSCF10, 0x00000fd5);
    SetReg32(CSCF11, 0x00000fab);
    SetReg32(CSCF12, 0x00000080);
    SetReg32(CSCF13, 0x00000000);
    SetReg32(CSCF20, 0x00000080);
    SetReg32(CSCF21, 0x00000f95);
    SetReg32(CSCF22, 0x00000feb);
    SetReg32(CSCF23, 0x00000000);
    SetReg32(CSCF30, 0x0000004c);
    SetReg32(CSCF31, 0x00000096);
    SetReg32(CSCF32, 0x0000001e);
    SetReg32(CSCF33, 0x00000000);
    SetReg32(CSOS0, 0x00000000);
    SetReg32(CSOS1, 0x00000000);
    SetReg32(CSOS2, 0x00000000);
    SetReg32(CSOS3, 0x00000000);
    SetReg32(CSBC, 0x000f1111);
    SetReg32(SAC_C, 0x004307f2);
#ifdef  ENABLE_APERTURE_SAMPLE_SETTINGS
//  アパーチャ補正のための設定のためコメントアウト
//  AXHAperture::set_aperture_lutでSAC_C00に設定
    SetReg32(SAC_C00, 0x0000b100);
#endif  //  ENABLE_APERTURE_SAMPLE_SETTINGS
    SetReg32(SAC_C01, 0x00000008);
    SetReg32(SAC_C02, 0x00000000);
    SetReg32(SAC_C10, 0x00020002);
    SetReg32(SAC_C20, 0x00040004);
    SetReg32(SAC_C30, 0x00000200);
    SetReg32(SAC_C40, 0x000001c0);
    SetReg32(SAC_C50, 0x00000080);
    SetReg32(C0CR00, 0x00000fff);
    SetReg32(C0CR01, 0x00000ffd);
    SetReg32(C0CR02, 0x00000ffd);
    SetReg32(C0CR03, 0x00000ffd);
    SetReg32(C0CR04, 0x00000fff);
    SetReg32(C0CR10, 0x00000ffd);
    SetReg32(C0CR11, 0x00000ffd);
    SetReg32(C0CR12, 0x00000ffc);
    SetReg32(C0CR13, 0x00000ffd);
    SetReg32(C0CR14, 0x00000ffd);
    SetReg32(C0CR20, 0x00000ffd);
    SetReg32(C0CR21, 0x00000ffc);
    SetReg32(C0CR22, 0x00000044);
    SetReg32(C0CR23, 0x00000ffc);
    SetReg32(C0CR24, 0x00000ffd);
    SetReg32(C0CR30, 0x00000ffd);
    SetReg32(C0CR31, 0x00000ffd);
    SetReg32(C0CR32, 0x00000ffc);
    SetReg32(C0CR33, 0x00000ffd);
    SetReg32(C0CR34, 0x00000ffd);
    SetReg32(C0CR40, 0x00000fff);
    SetReg32(C0CR41, 0x00000ffd);
    SetReg32(C0CR42, 0x00000ffd);
    SetReg32(C0CR43, 0x00000ffd);
    SetReg32(C0CR44, 0x00000fff);
    SetReg32(C0CRA00, 0x00000fff);
    SetReg32(C0CRA01, 0x00000ffd);
    SetReg32(C0CRA02, 0x00000ffd);
    SetReg32(C0CRA03, 0x00000ffd);
    SetReg32(C0CRA04, 0x00000fff);
    SetReg32(C0CRA10, 0x00000ffd);
    SetReg32(C0CRA11, 0x00000ffd);
    SetReg32(C0CRA12, 0x00000ffc);
    SetReg32(C0CRA13, 0x00000ffd);
    SetReg32(C0CRA14, 0x00000ffd);
    SetReg32(C0CRA20, 0x00000ffd);
    SetReg32(C0CRA21, 0x00000ffc);
    SetReg32(C0CRA22, 0x00000064);
    SetReg32(C0CRA23, 0x00000ffc);
    SetReg32(C0CRA24, 0x00000ffd);
    SetReg32(C0CRA30, 0x00000ffd);
    SetReg32(C0CRA31, 0x00000ffd);
    SetReg32(C0CRA32, 0x00000ffc);
    SetReg32(C0CRA33, 0x00000ffd);
    SetReg32(C0CRA34, 0x00000ffd);
    SetReg32(C0CRA40, 0x00000fff);
    SetReg32(C0CRA41, 0x00000ffd);
    SetReg32(C0CRA42, 0x00000ffd);
    SetReg32(C0CRA43, 0x00000ffd);
    SetReg32(C0CRA44, 0x00000fff);
    SetReg32(C0KFHHV0, 0x00000fff);
    SetReg32(C0KFHHV1, 0x00000002);
    SetReg32(C0KFHHV2, 0x00000003);
    SetReg32(C0KFHHV3, 0x00000004);
    SetReg32(C0KFHHV4, 0x00000ffb);
    SetReg32(C0KFHHV5, 0x00000020);
    SetReg32(C0KFHHV6, 0x00000040);
    SetReg32(C0KFHHV7, 0x00000fe0);
    SetReg32(C0KFHHV8, 0x00000009);
    SetReg32(C0KFHDD0, 0x00000001);
    SetReg32(C0KFHDD1, 0x00000002);
    SetReg32(C0KFHDD2, 0x00000003);
    SetReg32(C0KFHDD3, 0x00000004);
    SetReg32(C0KFHDD4, 0x00000ffb);
    SetReg32(C0KFHDD5, 0x00000fe0);
    SetReg32(C0KFHDD6, 0x00000040);
    SetReg32(C0KFHDD7, 0x00000020);
    SetReg32(C0KFHDD8, 0x00000009);
    SetReg32(C0KCTL0, 0x00000109);
    SetReg32(C0KTH0, 0x07ff0040);
    SetReg32(C0KCR0, 0x0001a860);
    SetReg32(C0KCR1, 0x00022c80);
    SetReg32(C0KCR2, 0x00004000);
    SetReg32(C0KCR3, 0x00004400);
#ifdef  ENABLE_APERTURE_SAMPLE_SETTINGS
//  アパーチャ補正のための設定のためコメントアウト
//  AXHAperture::set_aperture_coringでC0CORに設定
    SetReg32(C0COR, 0x00000000);
#endif  //  ENABLE_APERTURE_SAMPLE_SETTINGS
    SetReg32(SBLCOR, 0x00000000);
    SetReg32(C1COR, 0x00000000);
    SetReg32(C2COR, 0x00000000);
    SetReg32(HPYOFS_L0_0, 0x80808080);
    SetReg32(HPYOFS_L0_1, 0x80808080);
    SetReg32(HPYOFS_L0_2, 0x00000080);
    SetReg32(HPYOFS_L3A_0, 0x80808080);
    SetReg32(HPYOFS_L3A_1, 0x80808080);
    SetReg32(HPYOFS_L3A_2, 0x00000080);
    SetReg32(HPYOFS_L4_0, 0x80808080);
    SetReg32(HPYOFS_L4_1, 0x80808080);
    SetReg32(HPYOFS_L4_2, 0x00000080);
    SetReg32(HPYOFS_L5_0, 0x80808080);
    SetReg32(HPYOFS_L5_1, 0x80808080);
    SetReg32(HPYOFS_L5_2, 0x00000080);
#ifdef  ENABLE_APERTURE_SAMPLE_SETTINGS
//  アパーチャ補正のための設定のためコメントアウト
//  AXHAperture::set_aperture_overmidrange_gainratioでSAC_VAL00に設定
    SetReg32(SAC_VAL00, 0x00404000);
//  AXHAperture::set_aperture_plus_minus_limitでSAC_VAL01に設定
    SetReg32(SAC_VAL01, 0xf0000fff);
//  AXHAperture::set_aperture_totalgainでSAC_VAL02に設定
    SetReg32(SAC_VAL02, 0x40404040);/* 0x00404040 -> 0x40404040 */
#endif  //  ENABLE_APERTURE_SAMPLE_SETTINGS
    SetReg32(SAC_VAL03, 0x00000000);
    SetReg32(SAC_VAL04, 0x00055052);
    SetReg32(SAC_VAL05, 0x00000000);
    SetReg32(SAC_VAL10, 0x05808080);
    SetReg32(SAC_VAL11, 0x0003ff00);
    SetReg32(SAC_VAL20, 0x05808080);
    SetReg32(SAC_VAL21, 0x0003ff00);
    SetReg32(SAC_VAL30, 0x000000a4);
    SetReg32(SAC_VAL40, 0x00000000);
    SetReg32(SAC_VAL50, 0x00000000);
    SetReg32(SBL33_VAL0, 0x00000002);
    SetReg32(SBL33_VAL1, 0x04000200);
    SetReg32(SBL33_VAL2, 0x08000600);
    SetReg32(SBL33_VAL3, 0x0c000a00);
    SetReg32(SBL33_VAL4, 0x10000e00);
    SetReg32(SBL55_VAL0, 0x00000002);
    SetReg32(SBL55_VAL1, 0x04000200);
    SetReg32(SBL55_VAL2, 0x08000600);
    SetReg32(SBL55_VAL3, 0x0c000a00);
    SetReg32(SBL55_VAL4, 0x10000e00);
    SetReg32(C4CNTFHV0, 0x00011111);
    SetReg32(C4CNTFHV1, 0x00011111);
    SetReg32(C4CNTFHV2, 0x00011111);
    SetReg32(C4CNTFHV3, 0x00011111);
    SetReg32(C4CNTFHV4, 0x00011111);
    SetReg32(C4CNTFDD0, 0x00011111);
    SetReg32(C4CNTFDD1, 0x00011111);
    SetReg32(C4CNTFDD2, 0x00011111);
    SetReg32(C4CNTFDD3, 0x00011111);
    SetReg32(C4CNTFDD4, 0x00011111);
    SetReg32(C4CNTFMM0, 0x00011111);
    SetReg32(C4CNTFMM1, 0x00011111);
    SetReg32(C4CNTFMM2, 0x00011111);
    SetReg32(C4CNTFMM3, 0x00011111);
    SetReg32(C4CNTFMM4, 0x00011111);
#if 0
    SetReg32(RSZ_C0, 0x00000000);
    SetReg32(RG_RZ_CSCF00, 0x00000100);
    SetReg32(RG_RZ_CSCF01, 0x00000000);
    SetReg32(RG_RZ_CSCF02, 0x00000000);
    SetReg32(RG_RZ_CSCF10, 0x00000000);
    SetReg32(RG_RZ_CSCF11, 0x00000100);
    SetReg32(RG_RZ_CSCF12, 0x00000000);
    SetReg32(RG_RZ_CSCF20, 0x00000000);
    SetReg32(RG_RZ_CSCF21, 0x00000000);
    SetReg32(RG_RZ_CSCF22, 0x00000100);
    SetReg32(RG_RZ_CSCFB00, 0x00000100);
    SetReg32(RG_RZ_CSCFB01, 0x00000000);
    SetReg32(RG_RZ_CSCFB02, 0x00000000);
    SetReg32(RG_RZ_CSCFB10, 0x00000000);
    SetReg32(RG_RZ_CSCFB11, 0x00000100);
    SetReg32(RG_RZ_CSCFB12, 0x00000000);
    SetReg32(RG_RZ_CSCFB20, 0x00000000);
    SetReg32(RG_RZ_CSCFB21, 0x00000000);
    SetReg32(RG_RZ_CSCFB22, 0x00000100);
    SetReg32(RG_RZ_CSCFC00, 0x00000100);
    SetReg32(RG_RZ_CSCFC01, 0x00000000);
    SetReg32(RG_RZ_CSCFC02, 0x00000000);
    SetReg32(RG_RZ_CSCFC10, 0x00000000);
    SetReg32(RG_RZ_CSCFC11, 0x00000100);
    SetReg32(RG_RZ_CSCFC12, 0x00000000);
    SetReg32(RG_RZ_CSCFC20, 0x00000000);
    SetReg32(RG_RZ_CSCFC21, 0x00000000);
    SetReg32(RG_RZ_CSCFC22, 0x00000100);
    SetReg32(RG_RZ_CSCFD00, 0x00000100);
    SetReg32(RG_RZ_CSCFD01, 0x00000000);
    SetReg32(RG_RZ_CSCFD02, 0x00000000);
    SetReg32(RG_RZ_CSCFD10, 0x00000000);
    SetReg32(RG_RZ_CSCFD11, 0x00000100);
    SetReg32(RG_RZ_CSCFD12, 0x00000000);
    SetReg32(RG_RZ_CSCFD20, 0x00000000);
    SetReg32(RG_RZ_CSCFD21, 0x00000000);
    SetReg32(RG_RZ_CSCFD22, 0x00000100);
    SetReg32(RG_RZ_CSOS0, 0x00000010);/* 0x00000000 -> 0x00000010 */
    SetReg32(RG_RZ_CSOS1, 0x00000080);    // bayer
    SetReg32(RG_RZ_CSOS2, 0x00000080);
    /* CSLMT0 = 3, CSRGC0 = 0 */
    SetReg32(RG_RZ_CSBC, 0x00300555);/* 0x00070555 -> 0x00300555 */
#endif
    SetReg32(RG_RZ_VRMD, 0x00000000);
    SetReg32(RNR_AREAOPT, 0x00000000);
    SetReg32(RNR_REPN, 0x00000000);
    SetReg32(RNR_REPNS, 0x00000000);
    SetReg32(RNR_MAXLIM0, 0x00000000);
    SetReg32(RNR_MAXLIM1, 0x00000000);
    SetReg32(RNR_MAXLIM2, 0x00000000);
    SetReg32(RNR_MAXLIM3, 0x00000000);
    SetReg32(RNR_MINLIM0, 0x00000000);
    SetReg32(RNR_MINLIM1, 0x00000000);
    SetReg32(RNR_MINLIM2, 0x00000000);
    SetReg32(RNR_MINLIM3, 0x00000000);
    SetReg32(RNR_MAXTH0, 0x00000000);
    SetReg32(RNR_MAXTH1, 0x00000000);
    SetReg32(RNR_MAXTH2, 0x00000000);
    SetReg32(RNR_MAXTH3, 0x00000000);
    SetReg32(RNR_MINTH0, 0x00000000);
    SetReg32(RNR_MINTH1, 0x00000000);
    SetReg32(RNR_MINTH2, 0x00000000);
    SetReg32(RNR_MINTH3, 0x00000000);
    SetReg32(RNR_DIFFTH0, 0x00000000);
    SetReg32(RNR_DIFFTH1, 0x00000000);
    SetReg32(RNR_DIFFTH2, 0x00000000);

#if 0
//  AXMIspAdjustでガンマ補正関連のレジスタを設定するので、ガンマ補正関連のレジスタの設定はコメントアウト
#if 1
    //gamma setting  2014/7/11 temporary
    SetReg32(RG_GMOF0_00, GMOF_00);
    SetReg32(RG_GMOF0_01, GMOF_01);
    SetReg32(RG_GMOF0_02, GMOF_02);
    SetReg32(RG_GMOF0_03, GMOF_03);
    SetReg32(RG_GMOF0_04, GMOF_04);
    SetReg32(RG_GMOF0_05, GMOF_05);
    SetReg32(RG_GMOF0_06, GMOF_06);
    SetReg32(RG_GMOF0_07, GMOF_07);
    SetReg32(RG_GMOF0_08, GMOF_08);
    SetReg32(RG_GMOF0_09, GMOF_09);
    SetReg32(RG_GMOF0_10, GMOF_10);
    SetReg32(RG_GMOF0_11, GMOF_11);
    SetReg32(RG_GMOF0_12, GMOF_12);
    SetReg32(RG_GMOF0_13, GMOF_13);
    SetReg32(RG_GMOF0_14, GMOF_14);
    SetReg32(RG_GMOF0_15, GMOF_15);
    SetReg32(RG_GMOF0_16, GMOF_16);
    SetReg32(RG_GMOF0_17, GMOF_17);
    SetReg32(RG_GMOF0_18, GMOF_18);
    SetReg32(RG_GMOF0_19, GMOF_19);
    SetReg32(RG_GMOF0_20, GMOF_20);
    SetReg32(RG_GMOF0_21, GMOF_21);
    SetReg32(RG_GMOF0_22, GMOF_22);
    SetReg32(RG_GMOF0_23, GMOF_23);
    SetReg32(RG_GMOF0_24, GMOF_24);
    SetReg32(RG_GMOF0_25, GMOF_25);
    SetReg32(RG_GMOF0_26, GMOF_26);
    SetReg32(RG_GMOF0_27, GMOF_27);
    SetReg32(RG_GMOF0_28, GMOF_28);
    SetReg32(RG_GMOF0_29, GMOF_29);
    SetReg32(RG_GMOF0_30, GMOF_30);
    SetReg32(RG_GMOF0_31, GMOF_31);
    SetReg32(RG_GMOF0_32, GMOF_32);
    SetReg32(RG_GMOF0_33, GMOF_33);
    SetReg32(RG_GMOF0_34, GMOF_34);
    SetReg32(RG_GMOF0_35, GMOF_35);
    SetReg32(RG_GMOF0_36, GMOF_36);
    SetReg32(RG_GMOF0_37, GMOF_37);
    SetReg32(RG_GMOF0_38, GMOF_38);
    SetReg32(RG_GMOF0_39, GMOF_39);
    SetReg32(RG_GMOF0_40, GMOF_40);
    SetReg32(RG_GMOF0_41, GMOF_41);
    SetReg32(RG_GMOF0_42, GMOF_42);
    SetReg32(RG_GMOF0_43, GMOF_43);
    SetReg32(RG_GMOF0_44, GMOF_44);
    SetReg32(RG_GMOF0_45, GMOF_45);
    SetReg32(RG_GMOF0_46, GMOF_46);
    SetReg32(RG_GMOF0_47, GMOF_47);
    SetReg32(RG_GMOF0_48, GMOF_48);
    SetReg32(RG_GMOF0_49, GMOF_49);
    SetReg32(RG_GMOF0_50, GMOF_50);
    SetReg32(RG_GMOF0_51, GMOF_51);
    SetReg32(RG_GMOF0_52, GMOF_52);
    SetReg32(RG_GMOF0_53, GMOF_53);
    SetReg32(RG_GMOF0_54, GMOF_54);
    SetReg32(RG_GMOF0_55, GMOF_55);
    SetReg32(RG_GMOF0_56, GMOF_56);
    SetReg32(RG_GMOF0_57, GMOF_57);
    SetReg32(RG_GMOF0_58, GMOF_58);
    SetReg32(RG_GMOF0_59, GMOF_59);
    SetReg32(RG_GMOF0_60, GMOF_60);
    SetReg32(RG_GMOF0_61, GMOF_61);
    SetReg32(RG_GMOF0_62, GMOF_62);
    SetReg32(RG_GMOF0_63, GMOF_63);
    SetReg32(RG_GMOF0_64, GMOF_64);

    SetReg32(RG_GMOF1_00, GMOF_00);
    SetReg32(RG_GMOF1_01, GMOF_01);
    SetReg32(RG_GMOF1_02, GMOF_02);
    SetReg32(RG_GMOF1_03, GMOF_03);
    SetReg32(RG_GMOF1_04, GMOF_04);
    SetReg32(RG_GMOF1_05, GMOF_05);
    SetReg32(RG_GMOF1_06, GMOF_06);
    SetReg32(RG_GMOF1_07, GMOF_07);
    SetReg32(RG_GMOF1_08, GMOF_08);
    SetReg32(RG_GMOF1_09, GMOF_09);
    SetReg32(RG_GMOF1_10, GMOF_10);
    SetReg32(RG_GMOF1_11, GMOF_11);
    SetReg32(RG_GMOF1_12, GMOF_12);
    SetReg32(RG_GMOF1_13, GMOF_13);
    SetReg32(RG_GMOF1_14, GMOF_14);
    SetReg32(RG_GMOF1_15, GMOF_15);
    SetReg32(RG_GMOF1_16, GMOF_16);
    SetReg32(RG_GMOF1_17, GMOF_17);
    SetReg32(RG_GMOF1_18, GMOF_18);
    SetReg32(RG_GMOF1_19, GMOF_19);
    SetReg32(RG_GMOF1_20, GMOF_20);
    SetReg32(RG_GMOF1_21, GMOF_21);
    SetReg32(RG_GMOF1_22, GMOF_22);
    SetReg32(RG_GMOF1_23, GMOF_23);
    SetReg32(RG_GMOF1_24, GMOF_24);
    SetReg32(RG_GMOF1_25, GMOF_25);
    SetReg32(RG_GMOF1_26, GMOF_26);
    SetReg32(RG_GMOF1_27, GMOF_27);
    SetReg32(RG_GMOF1_28, GMOF_28);
    SetReg32(RG_GMOF1_29, GMOF_29);
    SetReg32(RG_GMOF1_30, GMOF_30);
    SetReg32(RG_GMOF1_31, GMOF_31);
    SetReg32(RG_GMOF1_32, GMOF_32);
    SetReg32(RG_GMOF1_33, GMOF_33);
    SetReg32(RG_GMOF1_34, GMOF_34);
    SetReg32(RG_GMOF1_35, GMOF_35);
    SetReg32(RG_GMOF1_36, GMOF_36);
    SetReg32(RG_GMOF1_37, GMOF_37);
    SetReg32(RG_GMOF1_38, GMOF_38);
    SetReg32(RG_GMOF1_39, GMOF_39);
    SetReg32(RG_GMOF1_40, GMOF_40);
    SetReg32(RG_GMOF1_41, GMOF_41);
    SetReg32(RG_GMOF1_42, GMOF_42);
    SetReg32(RG_GMOF1_43, GMOF_43);
    SetReg32(RG_GMOF1_44, GMOF_44);
    SetReg32(RG_GMOF1_45, GMOF_45);
    SetReg32(RG_GMOF1_46, GMOF_46);
    SetReg32(RG_GMOF1_47, GMOF_47);
    SetReg32(RG_GMOF1_48, GMOF_48);
    SetReg32(RG_GMOF1_49, GMOF_49);
    SetReg32(RG_GMOF1_50, GMOF_50);
    SetReg32(RG_GMOF1_51, GMOF_51);
    SetReg32(RG_GMOF1_52, GMOF_52);
    SetReg32(RG_GMOF1_53, GMOF_53);
    SetReg32(RG_GMOF1_54, GMOF_54);
    SetReg32(RG_GMOF1_55, GMOF_55);
    SetReg32(RG_GMOF1_56, GMOF_56);
    SetReg32(RG_GMOF1_57, GMOF_57);
    SetReg32(RG_GMOF1_58, GMOF_58);
    SetReg32(RG_GMOF1_59, GMOF_59);
    SetReg32(RG_GMOF1_60, GMOF_60);
    SetReg32(RG_GMOF1_61, GMOF_61);
    SetReg32(RG_GMOF1_62, GMOF_62);
    SetReg32(RG_GMOF1_63, GMOF_63);
    SetReg32(RG_GMOF1_64, GMOF_64);

    SetReg32(RG_GMOF2_00, GMOF_00);
    SetReg32(RG_GMOF2_01, GMOF_01);
    SetReg32(RG_GMOF2_02, GMOF_02);
    SetReg32(RG_GMOF2_03, GMOF_03);
    SetReg32(RG_GMOF2_04, GMOF_04);
    SetReg32(RG_GMOF2_05, GMOF_05);
    SetReg32(RG_GMOF2_06, GMOF_06);
    SetReg32(RG_GMOF2_07, GMOF_07);
    SetReg32(RG_GMOF2_08, GMOF_08);
    SetReg32(RG_GMOF2_09, GMOF_09);
    SetReg32(RG_GMOF2_10, GMOF_10);
    SetReg32(RG_GMOF2_11, GMOF_11);
    SetReg32(RG_GMOF2_12, GMOF_12);
    SetReg32(RG_GMOF2_13, GMOF_13);
    SetReg32(RG_GMOF2_14, GMOF_14);
    SetReg32(RG_GMOF2_15, GMOF_15);
    SetReg32(RG_GMOF2_16, GMOF_16);
    SetReg32(RG_GMOF2_17, GMOF_17);
    SetReg32(RG_GMOF2_18, GMOF_18);
    SetReg32(RG_GMOF2_19, GMOF_19);
    SetReg32(RG_GMOF2_20, GMOF_20);
    SetReg32(RG_GMOF2_21, GMOF_21);
    SetReg32(RG_GMOF2_22, GMOF_22);
    SetReg32(RG_GMOF2_23, GMOF_23);
    SetReg32(RG_GMOF2_24, GMOF_24);
    SetReg32(RG_GMOF2_25, GMOF_25);
    SetReg32(RG_GMOF2_26, GMOF_26);
    SetReg32(RG_GMOF2_27, GMOF_27);
    SetReg32(RG_GMOF2_28, GMOF_28);
    SetReg32(RG_GMOF2_29, GMOF_29);
    SetReg32(RG_GMOF2_30, GMOF_30);
    SetReg32(RG_GMOF2_31, GMOF_31);
    SetReg32(RG_GMOF2_32, GMOF_32);
    SetReg32(RG_GMOF2_33, GMOF_33);
    SetReg32(RG_GMOF2_34, GMOF_34);
    SetReg32(RG_GMOF2_35, GMOF_35);
    SetReg32(RG_GMOF2_36, GMOF_36);
    SetReg32(RG_GMOF2_37, GMOF_37);
    SetReg32(RG_GMOF2_38, GMOF_38);
    SetReg32(RG_GMOF2_39, GMOF_39);
    SetReg32(RG_GMOF2_40, GMOF_40);
    SetReg32(RG_GMOF2_41, GMOF_41);
    SetReg32(RG_GMOF2_42, GMOF_42);
    SetReg32(RG_GMOF2_43, GMOF_43);
    SetReg32(RG_GMOF2_44, GMOF_44);
    SetReg32(RG_GMOF2_45, GMOF_45);
    SetReg32(RG_GMOF2_46, GMOF_46);
    SetReg32(RG_GMOF2_47, GMOF_47);
    SetReg32(RG_GMOF2_48, GMOF_48);
    SetReg32(RG_GMOF2_49, GMOF_49);
    SetReg32(RG_GMOF2_50, GMOF_50);
    SetReg32(RG_GMOF2_51, GMOF_51);
    SetReg32(RG_GMOF2_52, GMOF_52);
    SetReg32(RG_GMOF2_53, GMOF_53);
    SetReg32(RG_GMOF2_54, GMOF_54);
    SetReg32(RG_GMOF2_55, GMOF_55);
    SetReg32(RG_GMOF2_56, GMOF_56);
    SetReg32(RG_GMOF2_57, GMOF_57);
    SetReg32(RG_GMOF2_58, GMOF_58);
    SetReg32(RG_GMOF2_59, GMOF_59);
    SetReg32(RG_GMOF2_60, GMOF_60);
    SetReg32(RG_GMOF2_61, GMOF_61);
    SetReg32(RG_GMOF2_62, GMOF_62);
    SetReg32(RG_GMOF2_63, GMOF_63);
    SetReg32(RG_GMOF2_64, GMOF_64);

    SetReg32(RG_GMOF3_00, GMOF_00);
    SetReg32(RG_GMOF3_01, GMOF_01);
    SetReg32(RG_GMOF3_02, GMOF_02);
    SetReg32(RG_GMOF3_03, GMOF_03);
    SetReg32(RG_GMOF3_04, GMOF_04);
    SetReg32(RG_GMOF3_05, GMOF_05);
    SetReg32(RG_GMOF3_06, GMOF_06);
    SetReg32(RG_GMOF3_07, GMOF_07);
    SetReg32(RG_GMOF3_08, GMOF_08);
    SetReg32(RG_GMOF3_09, GMOF_09);
    SetReg32(RG_GMOF3_10, GMOF_10);
    SetReg32(RG_GMOF3_11, GMOF_11);
    SetReg32(RG_GMOF3_12, GMOF_12);
    SetReg32(RG_GMOF3_13, GMOF_13);
    SetReg32(RG_GMOF3_14, GMOF_14);
    SetReg32(RG_GMOF3_15, GMOF_15);
    SetReg32(RG_GMOF3_16, GMOF_16);
    SetReg32(RG_GMOF3_17, GMOF_17);
    SetReg32(RG_GMOF3_18, GMOF_18);
    SetReg32(RG_GMOF3_19, GMOF_19);
    SetReg32(RG_GMOF3_20, GMOF_20);
    SetReg32(RG_GMOF3_21, GMOF_21);
    SetReg32(RG_GMOF3_22, GMOF_22);
    SetReg32(RG_GMOF3_23, GMOF_23);
    SetReg32(RG_GMOF3_24, GMOF_24);
    SetReg32(RG_GMOF3_25, GMOF_25);
    SetReg32(RG_GMOF3_26, GMOF_26);
    SetReg32(RG_GMOF3_27, GMOF_27);
    SetReg32(RG_GMOF3_28, GMOF_28);
    SetReg32(RG_GMOF3_29, GMOF_29);
    SetReg32(RG_GMOF3_30, GMOF_30);
    SetReg32(RG_GMOF3_31, GMOF_31);
    SetReg32(RG_GMOF3_32, GMOF_32);
    SetReg32(RG_GMOF3_33, GMOF_33);
    SetReg32(RG_GMOF3_34, GMOF_34);
    SetReg32(RG_GMOF3_35, GMOF_35);
    SetReg32(RG_GMOF3_36, GMOF_36);
    SetReg32(RG_GMOF3_37, GMOF_37);
    SetReg32(RG_GMOF3_38, GMOF_38);
    SetReg32(RG_GMOF3_39, GMOF_39);
    SetReg32(RG_GMOF3_40, GMOF_40);
    SetReg32(RG_GMOF3_41, GMOF_41);
    SetReg32(RG_GMOF3_42, GMOF_42);
    SetReg32(RG_GMOF3_43, GMOF_43);
    SetReg32(RG_GMOF3_44, GMOF_44);
    SetReg32(RG_GMOF3_45, GMOF_45);
    SetReg32(RG_GMOF3_46, GMOF_46);
    SetReg32(RG_GMOF3_47, GMOF_47);
    SetReg32(RG_GMOF3_48, GMOF_48);
    SetReg32(RG_GMOF3_49, GMOF_49);
    SetReg32(RG_GMOF3_50, GMOF_50);
    SetReg32(RG_GMOF3_51, GMOF_51);
    SetReg32(RG_GMOF3_52, GMOF_52);
    SetReg32(RG_GMOF3_53, GMOF_53);
    SetReg32(RG_GMOF3_54, GMOF_54);
    SetReg32(RG_GMOF3_55, GMOF_55);
    SetReg32(RG_GMOF3_56, GMOF_56);
    SetReg32(RG_GMOF3_57, GMOF_57);
    SetReg32(RG_GMOF3_58, GMOF_58);
    SetReg32(RG_GMOF3_59, GMOF_59);
    SetReg32(RG_GMOF3_60, GMOF_60);
    SetReg32(RG_GMOF3_61, GMOF_61);
    SetReg32(RG_GMOF3_62, GMOF_62);
    SetReg32(RG_GMOF3_63, GMOF_63);
    SetReg32(RG_GMOF3_64, GMOF_64);
#else
    //gamma setting
    SetReg32(RG_GMOF0_00, 0x00000000);
    SetReg32(RG_GMOF0_01, 0x00000040);
    SetReg32(RG_GMOF0_02, 0x00000080);
    SetReg32(RG_GMOF0_03, 0x000000C0);
    SetReg32(RG_GMOF0_04, 0x00000100);
    SetReg32(RG_GMOF0_05, 0x00000140);
    SetReg32(RG_GMOF0_06, 0x00000180);
    SetReg32(RG_GMOF0_07, 0x000001C0);
    SetReg32(RG_GMOF0_08, 0x00000200);
    SetReg32(RG_GMOF0_09, 0x00000240);
    SetReg32(RG_GMOF0_10, 0x00000280);
    SetReg32(RG_GMOF0_11, 0x000002C0);
    SetReg32(RG_GMOF0_12, 0x00000300);
    SetReg32(RG_GMOF0_13, 0x00000340);
    SetReg32(RG_GMOF0_14, 0x00000380);
    SetReg32(RG_GMOF0_15, 0x000003C0);
    SetReg32(RG_GMOF0_16, 0x00000400);
    SetReg32(RG_GMOF0_17, 0x00000440);
    SetReg32(RG_GMOF0_18, 0x00000480);
    SetReg32(RG_GMOF0_19, 0x000004C0);
    SetReg32(RG_GMOF0_20, 0x00000500);
    SetReg32(RG_GMOF0_21, 0x00000540);
    SetReg32(RG_GMOF0_22, 0x00000580);
    SetReg32(RG_GMOF0_23, 0x000005C0);
    SetReg32(RG_GMOF0_24, 0x00000600);
    SetReg32(RG_GMOF0_25, 0x00000640);
    SetReg32(RG_GMOF0_26, 0x00000680);
    SetReg32(RG_GMOF0_27, 0x000006C0);
    SetReg32(RG_GMOF0_28, 0x00000700);
    SetReg32(RG_GMOF0_29, 0x00000740);
    SetReg32(RG_GMOF0_30, 0x00000780);
    SetReg32(RG_GMOF0_31, 0x000007C0);
    SetReg32(RG_GMOF0_32, 0x00000800);
    SetReg32(RG_GMOF0_33, 0x00000840);
    SetReg32(RG_GMOF0_34, 0x00000880);
    SetReg32(RG_GMOF0_35, 0x000008C0);
    SetReg32(RG_GMOF0_36, 0x00000900);
    SetReg32(RG_GMOF0_37, 0x00000940);
    SetReg32(RG_GMOF0_38, 0x00000980);
    SetReg32(RG_GMOF0_39, 0x000009C0);
    SetReg32(RG_GMOF0_40, 0x00000A00);
    SetReg32(RG_GMOF0_41, 0x00000A40);
    SetReg32(RG_GMOF0_42, 0x00000A80);
    SetReg32(RG_GMOF0_43, 0x00000AC0);
    SetReg32(RG_GMOF0_44, 0x00000B00);
    SetReg32(RG_GMOF0_45, 0x00000B40);
    SetReg32(RG_GMOF0_46, 0x00000B80);
    SetReg32(RG_GMOF0_47, 0x00000BC0);
    SetReg32(RG_GMOF0_48, 0x00000C00);
    SetReg32(RG_GMOF0_49, 0x00000C40);
    SetReg32(RG_GMOF0_50, 0x00000C80);
    SetReg32(RG_GMOF0_51, 0x00000CC0);
    SetReg32(RG_GMOF0_52, 0x00000D00);
    SetReg32(RG_GMOF0_53, 0x00000D40);
    SetReg32(RG_GMOF0_54, 0x00000D80);
    SetReg32(RG_GMOF0_55, 0x00000DC0);
    SetReg32(RG_GMOF0_56, 0x00000E00);
    SetReg32(RG_GMOF0_57, 0x00000E40);
    SetReg32(RG_GMOF0_58, 0x00000E80);
    SetReg32(RG_GMOF0_59, 0x00000EC0);
    SetReg32(RG_GMOF0_60, 0x00000F00);
    SetReg32(RG_GMOF0_61, 0x00000F40);
    SetReg32(RG_GMOF0_62, 0x00000F80);
    SetReg32(RG_GMOF0_63, 0x00000FC0);	
    SetReg32(RG_GMOF0_64, 0x00001000);	
    SetReg32(RG_GMOF1_00, 0x00000000);
    SetReg32(RG_GMOF1_01, 0x00000040);
    SetReg32(RG_GMOF1_02, 0x00000080);
    SetReg32(RG_GMOF1_03, 0x000000C0);
    SetReg32(RG_GMOF1_04, 0x00000100);
    SetReg32(RG_GMOF1_05, 0x00000140);
    SetReg32(RG_GMOF1_06, 0x00000180);
    SetReg32(RG_GMOF1_07, 0x000001C0);
    SetReg32(RG_GMOF1_08, 0x00000200);
    SetReg32(RG_GMOF1_09, 0x00000240);
    SetReg32(RG_GMOF1_10, 0x00000280);
    SetReg32(RG_GMOF1_11, 0x000002C0);
    SetReg32(RG_GMOF1_12, 0x00000300);
    SetReg32(RG_GMOF1_13, 0x00000340);
    SetReg32(RG_GMOF1_14, 0x00000380);
    SetReg32(RG_GMOF1_15, 0x000003C0);
    SetReg32(RG_GMOF1_16, 0x00000400);
    SetReg32(RG_GMOF1_17, 0x00000440);
    SetReg32(RG_GMOF1_18, 0x00000480);
    SetReg32(RG_GMOF1_19, 0x000004C0);
    SetReg32(RG_GMOF1_20, 0x00000500);
    SetReg32(RG_GMOF1_21, 0x00000540);
    SetReg32(RG_GMOF1_22, 0x00000580);
    SetReg32(RG_GMOF1_23, 0x000005C0);
    SetReg32(RG_GMOF1_24, 0x00000600);
    SetReg32(RG_GMOF1_25, 0x00000640);
    SetReg32(RG_GMOF1_26, 0x00000680);
    SetReg32(RG_GMOF1_27, 0x000006C0);
    SetReg32(RG_GMOF1_28, 0x00000700);
    SetReg32(RG_GMOF1_29, 0x00000740);
    SetReg32(RG_GMOF1_30, 0x00000780);
    SetReg32(RG_GMOF1_31, 0x000007C0);
    SetReg32(RG_GMOF1_32, 0x00000800);
    SetReg32(RG_GMOF1_33, 0x00000840);
    SetReg32(RG_GMOF1_34, 0x00000880);
    SetReg32(RG_GMOF1_35, 0x000008C0);
    SetReg32(RG_GMOF1_36, 0x00000900);
    SetReg32(RG_GMOF1_37, 0x00000940);
    SetReg32(RG_GMOF1_38, 0x00000980);
    SetReg32(RG_GMOF1_39, 0x000009C0);
    SetReg32(RG_GMOF1_40, 0x00000A00);
    SetReg32(RG_GMOF1_41, 0x00000A40);
    SetReg32(RG_GMOF1_42, 0x00000A80);
    SetReg32(RG_GMOF1_43, 0x00000AC0);
    SetReg32(RG_GMOF1_44, 0x00000B00);
    SetReg32(RG_GMOF1_45, 0x00000B40);
    SetReg32(RG_GMOF1_46, 0x00000B80);
    SetReg32(RG_GMOF1_47, 0x00000BC0);
    SetReg32(RG_GMOF1_48, 0x00000C00);
    SetReg32(RG_GMOF1_49, 0x00000C40);
    SetReg32(RG_GMOF1_50, 0x00000C80);
    SetReg32(RG_GMOF1_51, 0x00000CC0);
    SetReg32(RG_GMOF1_52, 0x00000D00);
    SetReg32(RG_GMOF1_53, 0x00000D40);
    SetReg32(RG_GMOF1_54, 0x00000D80);
    SetReg32(RG_GMOF1_55, 0x00000DC0);
    SetReg32(RG_GMOF1_56, 0x00000E00);
    SetReg32(RG_GMOF1_57, 0x00000E40);
    SetReg32(RG_GMOF1_58, 0x00000E80);
    SetReg32(RG_GMOF1_59, 0x00000EC0);
    SetReg32(RG_GMOF1_60, 0x00000F00);
    SetReg32(RG_GMOF1_61, 0x00000F40);
    SetReg32(RG_GMOF1_62, 0x00000F80);
    SetReg32(RG_GMOF1_63, 0x00000FC0);	
    SetReg32(RG_GMOF1_64, 0x00001000);	
    SetReg32(RG_GMOF2_00, 0x00000000);
    SetReg32(RG_GMOF2_01, 0x00000040);
    SetReg32(RG_GMOF2_02, 0x00000080);
    SetReg32(RG_GMOF2_03, 0x000000C0);
    SetReg32(RG_GMOF2_04, 0x00000100);
    SetReg32(RG_GMOF2_05, 0x00000140);
    SetReg32(RG_GMOF2_06, 0x00000180);
    SetReg32(RG_GMOF2_07, 0x000001C0);
    SetReg32(RG_GMOF2_08, 0x00000200);
    SetReg32(RG_GMOF2_09, 0x00000240);
    SetReg32(RG_GMOF2_10, 0x00000280);
    SetReg32(RG_GMOF2_11, 0x000002C0);
    SetReg32(RG_GMOF2_12, 0x00000300);
    SetReg32(RG_GMOF2_13, 0x00000340);
    SetReg32(RG_GMOF2_14, 0x00000380);
    SetReg32(RG_GMOF2_15, 0x000003C0);
    SetReg32(RG_GMOF2_16, 0x00000400);
    SetReg32(RG_GMOF2_17, 0x00000440);
    SetReg32(RG_GMOF2_18, 0x00000480);
    SetReg32(RG_GMOF2_19, 0x000004C0);
    SetReg32(RG_GMOF2_20, 0x00000500);
    SetReg32(RG_GMOF2_21, 0x00000540);
    SetReg32(RG_GMOF2_22, 0x00000580);
    SetReg32(RG_GMOF2_23, 0x000005C0);
    SetReg32(RG_GMOF2_24, 0x00000600);
    SetReg32(RG_GMOF2_25, 0x00000640);
    SetReg32(RG_GMOF2_26, 0x00000680);
    SetReg32(RG_GMOF2_27, 0x000006C0);
    SetReg32(RG_GMOF2_28, 0x00000700);
    SetReg32(RG_GMOF2_29, 0x00000740);
    SetReg32(RG_GMOF2_30, 0x00000780);
    SetReg32(RG_GMOF2_31, 0x000007C0);
    SetReg32(RG_GMOF2_32, 0x00000800);
    SetReg32(RG_GMOF2_33, 0x00000840);
    SetReg32(RG_GMOF2_34, 0x00000880);
    SetReg32(RG_GMOF2_35, 0x000008C0);
    SetReg32(RG_GMOF2_36, 0x00000900);
    SetReg32(RG_GMOF2_37, 0x00000940);
    SetReg32(RG_GMOF2_38, 0x00000980);
    SetReg32(RG_GMOF2_39, 0x000009C0);
    SetReg32(RG_GMOF2_40, 0x00000A00);
    SetReg32(RG_GMOF2_41, 0x00000A40);
    SetReg32(RG_GMOF2_42, 0x00000A80);
    SetReg32(RG_GMOF2_43, 0x00000AC0);
    SetReg32(RG_GMOF2_44, 0x00000B00);
    SetReg32(RG_GMOF2_45, 0x00000B40);
    SetReg32(RG_GMOF2_46, 0x00000B80);
    SetReg32(RG_GMOF2_47, 0x00000BC0);
    SetReg32(RG_GMOF2_48, 0x00000C00);
    SetReg32(RG_GMOF2_49, 0x00000C40);
    SetReg32(RG_GMOF2_50, 0x00000C80);
    SetReg32(RG_GMOF2_51, 0x00000CC0);
    SetReg32(RG_GMOF2_52, 0x00000D00);
    SetReg32(RG_GMOF2_53, 0x00000D40);
    SetReg32(RG_GMOF2_54, 0x00000D80);
    SetReg32(RG_GMOF2_55, 0x00000DC0);
    SetReg32(RG_GMOF2_56, 0x00000E00);
    SetReg32(RG_GMOF2_57, 0x00000E40);
    SetReg32(RG_GMOF2_58, 0x00000E80);
    SetReg32(RG_GMOF2_59, 0x00000EC0);
    SetReg32(RG_GMOF2_60, 0x00000F00);
    SetReg32(RG_GMOF2_61, 0x00000F40);
    SetReg32(RG_GMOF2_62, 0x00000F80);
    SetReg32(RG_GMOF2_63, 0x00000FC0);	
    SetReg32(RG_GMOF2_64, 0x00001000);	
    SetReg32(RG_GMOF3_00, 0x00000000);
    SetReg32(RG_GMOF3_01, 0x00000040);
    SetReg32(RG_GMOF3_02, 0x00000080);
    SetReg32(RG_GMOF3_03, 0x000000C0);
    SetReg32(RG_GMOF3_04, 0x00000100);
    SetReg32(RG_GMOF3_05, 0x00000140);
    SetReg32(RG_GMOF3_06, 0x00000180);
    SetReg32(RG_GMOF3_07, 0x000001C0);
    SetReg32(RG_GMOF3_08, 0x00000200);
    SetReg32(RG_GMOF3_09, 0x00000240);
    SetReg32(RG_GMOF3_10, 0x00000280);
    SetReg32(RG_GMOF3_11, 0x000002C0);
    SetReg32(RG_GMOF3_12, 0x00000300);
    SetReg32(RG_GMOF3_13, 0x00000340);
    SetReg32(RG_GMOF3_14, 0x00000380);
    SetReg32(RG_GMOF3_15, 0x000003C0);
    SetReg32(RG_GMOF3_16, 0x00000400);
    SetReg32(RG_GMOF3_17, 0x00000440);
    SetReg32(RG_GMOF3_18, 0x00000480);
    SetReg32(RG_GMOF3_19, 0x000004C0);
    SetReg32(RG_GMOF3_20, 0x00000500);
    SetReg32(RG_GMOF3_21, 0x00000540);
    SetReg32(RG_GMOF3_22, 0x00000580);
    SetReg32(RG_GMOF3_23, 0x000005C0);
    SetReg32(RG_GMOF3_24, 0x00000600);
    SetReg32(RG_GMOF3_25, 0x00000640);
    SetReg32(RG_GMOF3_26, 0x00000680);
    SetReg32(RG_GMOF3_27, 0x000006C0);
    SetReg32(RG_GMOF3_28, 0x00000700);
    SetReg32(RG_GMOF3_29, 0x00000740);
    SetReg32(RG_GMOF3_30, 0x00000780);
    SetReg32(RG_GMOF3_31, 0x000007C0);
    SetReg32(RG_GMOF3_32, 0x00000800);
    SetReg32(RG_GMOF3_33, 0x00000840);
    SetReg32(RG_GMOF3_34, 0x00000880);
    SetReg32(RG_GMOF3_35, 0x000008C0);
    SetReg32(RG_GMOF3_36, 0x00000900);
    SetReg32(RG_GMOF3_37, 0x00000940);
    SetReg32(RG_GMOF3_38, 0x00000980);
    SetReg32(RG_GMOF3_39, 0x000009C0);
    SetReg32(RG_GMOF3_40, 0x00000A00);
    SetReg32(RG_GMOF3_41, 0x00000A40);
    SetReg32(RG_GMOF3_42, 0x00000A80);
    SetReg32(RG_GMOF3_43, 0x00000AC0);
    SetReg32(RG_GMOF3_44, 0x00000B00);
    SetReg32(RG_GMOF3_45, 0x00000B40);
    SetReg32(RG_GMOF3_46, 0x00000B80);
    SetReg32(RG_GMOF3_47, 0x00000BC0);
    SetReg32(RG_GMOF3_48, 0x00000C00);
    SetReg32(RG_GMOF3_49, 0x00000C40);
    SetReg32(RG_GMOF3_50, 0x00000C80);
    SetReg32(RG_GMOF3_51, 0x00000CC0);
    SetReg32(RG_GMOF3_52, 0x00000D00);
    SetReg32(RG_GMOF3_53, 0x00000D40);
    SetReg32(RG_GMOF3_54, 0x00000D80);
    SetReg32(RG_GMOF3_55, 0x00000DC0);
    SetReg32(RG_GMOF3_56, 0x00000E00);
    SetReg32(RG_GMOF3_57, 0x00000E40);
    SetReg32(RG_GMOF3_58, 0x00000E80);
    SetReg32(RG_GMOF3_59, 0x00000EC0);
    SetReg32(RG_GMOF3_60, 0x00000F00);
    SetReg32(RG_GMOF3_61, 0x00000F40);
    SetReg32(RG_GMOF3_62, 0x00000F80);
    SetReg32(RG_GMOF3_63, 0x00000FC0);
    SetReg32(RG_GMOF3_64, 0x00001000);
#endif
    
    // gammaRz setting
    SetReg32(RG_RZ_GMOF0_00, 0xfffff000);
    SetReg32(RG_RZ_GMOF0_01, 0xfffff200);
    SetReg32(RG_RZ_GMOF0_02, 0xfffff400);
    SetReg32(RG_RZ_GMOF0_03, 0xfffff600);
    SetReg32(RG_RZ_GMOF0_04, 0xfffff800);
    SetReg32(RG_RZ_GMOF0_05, 0xfffffa00);
    SetReg32(RG_RZ_GMOF0_06, 0xfffffc00);
    SetReg32(RG_RZ_GMOF0_07, 0xfffffe00);
    SetReg32(RG_RZ_GMOF0_08, 0x00000000);
    SetReg32(RG_RZ_GMOF0_09, 0x00000200);
    SetReg32(RG_RZ_GMOF0_10, 0x00000400);
    SetReg32(RG_RZ_GMOF0_11, 0x00000600);
    SetReg32(RG_RZ_GMOF0_12, 0x00000800);
    SetReg32(RG_RZ_GMOF0_13, 0x00000a00);
    SetReg32(RG_RZ_GMOF0_14, 0x00000c00);
    SetReg32(RG_RZ_GMOF0_15, 0x00000e00);
    SetReg32(RG_RZ_GMOF0_16, 0x00001000);
    SetReg32(RG_RZ_GMOF1_00, 0xfffff000);
    SetReg32(RG_RZ_GMOF1_01, 0xfffff200);
    SetReg32(RG_RZ_GMOF1_02, 0xfffff400);
    SetReg32(RG_RZ_GMOF1_03, 0xfffff600);
    SetReg32(RG_RZ_GMOF1_04, 0xfffff800);
    SetReg32(RG_RZ_GMOF1_05, 0xfffffa00);
    SetReg32(RG_RZ_GMOF1_06, 0xfffffc00);
    SetReg32(RG_RZ_GMOF1_07, 0xfffffe00);
    SetReg32(RG_RZ_GMOF1_08, 0x00000000);
    SetReg32(RG_RZ_GMOF1_09, 0x00000200);
    SetReg32(RG_RZ_GMOF1_10, 0x00000400);
    SetReg32(RG_RZ_GMOF1_11, 0x00000600);
    SetReg32(RG_RZ_GMOF1_12, 0x00000800);
    SetReg32(RG_RZ_GMOF1_13, 0x00000a00);
    SetReg32(RG_RZ_GMOF1_14, 0x00000c00);
    SetReg32(RG_RZ_GMOF1_15, 0x00000e00);
    SetReg32(RG_RZ_GMOF1_16, 0x00001000);
    SetReg32(RG_RZ_GMOF2_00, 0xfffff000);
    SetReg32(RG_RZ_GMOF2_01, 0xfffff200);
    SetReg32(RG_RZ_GMOF2_02, 0xfffff400);
    SetReg32(RG_RZ_GMOF2_03, 0xfffff600);
    SetReg32(RG_RZ_GMOF2_04, 0xfffff800);
    SetReg32(RG_RZ_GMOF2_05, 0xfffffa00);
    SetReg32(RG_RZ_GMOF2_06, 0xfffffc00);
    SetReg32(RG_RZ_GMOF2_07, 0xfffffe00);
    SetReg32(RG_RZ_GMOF2_08, 0x00000000);
    SetReg32(RG_RZ_GMOF2_09, 0x00000200);
    SetReg32(RG_RZ_GMOF2_10, 0x00000400);
    SetReg32(RG_RZ_GMOF2_11, 0x00000600);
    SetReg32(RG_RZ_GMOF2_12, 0x00000800);
    SetReg32(RG_RZ_GMOF2_13, 0x00000a00);
    SetReg32(RG_RZ_GMOF2_14, 0x00000c00);
    SetReg32(RG_RZ_GMOF2_15, 0x00000e00);
    SetReg32(RG_RZ_GMOF2_16, 0x00001000);
    SetReg32(RG_RZ_GMOF3_00, 0xfffff000);
    SetReg32(RG_RZ_GMOF3_01, 0xfffff200);
    SetReg32(RG_RZ_GMOF3_02, 0xfffff400);
    SetReg32(RG_RZ_GMOF3_03, 0xfffff600);
    SetReg32(RG_RZ_GMOF3_04, 0xfffff800);
    SetReg32(RG_RZ_GMOF3_05, 0xfffffa00);
    SetReg32(RG_RZ_GMOF3_06, 0xfffffc00);
    SetReg32(RG_RZ_GMOF3_07, 0xfffffe00);
    SetReg32(RG_RZ_GMOF3_08, 0x00000000);
    SetReg32(RG_RZ_GMOF3_09, 0x00000200);
    SetReg32(RG_RZ_GMOF3_10, 0x00000400);
    SetReg32(RG_RZ_GMOF3_11, 0x00000600);
    SetReg32(RG_RZ_GMOF3_12, 0x00000800);
    SetReg32(RG_RZ_GMOF3_13, 0x00000a00);
    SetReg32(RG_RZ_GMOF3_14, 0x00000c00);
    SetReg32(RG_RZ_GMOF3_15, 0x00000e00);
    SetReg32(RG_RZ_GMOF3_16, 0x00001000);
#endif

#ifdef  ENABLE_APERTURE_SAMPLE_SETTINGS
//  アパーチャ補正のための設定のためコメントアウト
	    SetReg32(LUT_ACS, 0x00000fff);
    
    SetReg32(LUT_ACS, 0x00000000);
#endif  //  ENABLE_APERTURE_SAMPLE_SETTINGS
    //SetReg32(RPU_INTCNT_MASK, 0xffffffff);
    //SetReg32(RPU_INTCNT_MASK, 0x00000020);
    
#if 0    
    // iridix settings
    SetReg32 (IR_LEN,       (input_width | (input_height << 16)));
    SetReg32 (IR_DITHER,     0x00000002);
    SetReg32 (IR_SLOPE,      0x00803066);
    SetReg32 (IR_LEVEL,      0x0000ffff);
    SetReg32 (IR_CONTROL,    0x00000600);
    SetReg32 (IR_STRENGTH,   0x00000003);
    SetReg32 (IR_RGGB_START, 0x00000000);
    SetReg32 (IR_WBGAIN0,    0x01000100);
    SetReg32 (IR_WBGAIN1,    0x01000100);
    SetReg32 (IR_IFCONTROL,  0x00000000);
    
    // NR settings
//    SetReg32 (NR_HLEN,      (0x00000000 | input_width));  // hsize
    SetReg32 (NR_HLEN,      0x00000780);  // hsize:Full HD
//    SetReg32 (NR_VLEN,      (0x00010000 | input_height)); // vsize
    SetReg32 (NR_VLEN,      0x00010438);  // vsize:Full HD
    SetReg32 (NR_EN,        0x00000004);  // 0: direct, 1: input select, 2: MAIN NR, 3: SUB NR

    SetReg32 (NR_BLANK,     0x02000000);
    SetReg32 (NR_MAIN_YTH0, 0x10101010);
    SetReg32 (NR_MAIN_YTH1, 0x10101010);
    SetReg32 (NR_MAIN_YTH2, 0x10101010);
    SetReg32 (NR_MAIN_YTH3, 0x10101010);
    SetReg32 (NR_MAIN_CTH0, 0x10101010);
    SetReg32 (NR_MAIN_CTH1, 0x10101010);
    SetReg32 (NR_MAIN_CTH2, 0x10101010);
    SetReg32 (NR_MAIN_CTH3, 0x10101010);
    SetReg32 (NR_MAIN_YIN0, 0x30303030);
    SetReg32 (NR_MAIN_YIN1, 0x30303030);
    SetReg32 (NR_MAIN_YIN2, 0x30303030);
    SetReg32 (NR_MAIN_YIN3, 0x30303030);
    SetReg32 (NR_MAIN_CIN0, 0x30303030);
    SetReg32 (NR_MAIN_CIN1, 0x30303030);
    SetReg32 (NR_MAIN_CIN2, 0x30303030);
    SetReg32 (NR_MAIN_CIN3, 0x30303030);
    SetReg32 (NR_SUB_YTH,   0x10101010);
    SetReg32 (NR_SUB_CTH,   0x10101010);
    SetReg32 (NR_SUB_YIN,   0x30303030);
    SetReg32 (NR_SUB_CIN,   0x30303030);
    SetReg32 (NR_MAIN_YLV0, 0x00000000);
    SetReg32 (NR_MAIN_YLV1, 0x00000000);
    SetReg32 (NR_MAIN_YLV2, 0x00000000);
    SetReg32 (NR_MAIN_YLV3, 0x00000000);
    SetReg32 (NR_MAIN_CLV0, 0x00000000);
    SetReg32 (NR_MAIN_CLV1, 0x00000000);
    SetReg32 (NR_MAIN_CLV2, 0x00000000);
    SetReg32 (NR_MAIN_CLV3, 0x00000000);
    SetReg32 (NR_SUB_YLV,   0x00000000);
    SetReg32 (NR_SUB_CLV,   0x00000000);
#endif
    
    // ptz settings
    // area 1
    SetReg32 (NR_PTZ1_X,    0x01600000);  // {4'dd0, PTZ_X2_AREA0, 4'd0, PTZ_X1_AREA0}
    SetReg32 (NR_PTZ1_Y,    0x01200000);  // {4'd0, PTZ_Y2_AREA0, 4'd0, PTZ_Y1_AREA0}
    // area 2
    SetReg32 (NR_PTZ2_X,    0x01600000);  // {4'd0, PTZ_X2_AREA1, 4'd0, PTZ_X1_AREA1}
    SetReg32 (NR_PTZ2_Y,    0x01200000);  // {4'd0, PTZ_Y2_AREA1, 4'd0, PTZ_Y1_AREA1}
    // area 3
    SetReg32 (NR_PTZ3_X,    0x01600000);  // {4'd0, PTZ_X2_AREA2, 4'd0, PTZ_X1_AREA2}
    SetReg32 (NR_PTZ3_Y,    0x01200000);  // {4'd0, PTZ_Y2_AREA2, 4'd0, PTZ_Y1_AREA2}
    // area 4
    SetReg32 (NR_PTZ4_X,    0x01600000);  // {4'd0, PTZ_X2_AREA3, 4'd0, PTZ_X1_AREA3}
    SetReg32 (NR_PTZ4_Y,    0x01200000);  // {4'd0, PTZ_Y2_AREA3, 4'd0, PTZ_Y1_AREA3}
    // area 5
    SetReg32 (NR_PTZ5_X,    0x01600000);  // {4'd0, PTZ_X2_AREA4, 4'd0, PTZ_X1_AREA4}
    SetReg32 (NR_PTZ5_Y,    0x01200000);  // {4'd0, PTZ_Y2_AREA4, 4'd0, PTZ_Y1_AREA4}
    
    // dmaif settings
    //SetReg32(RPU_DMA_ACT, 0x00000007);
    SetReg32(RPU_DMAR0_OFS, DRAM_OFST_IMG_MIX_0);
    SetReg32(RPU_DMAR1_OFS, DRAM_OFST_ISP_SHAD);
    SetReg32(NR_DMAR_OFS, DRAM_OFST_IMG_MIX_0);
    //SetReg32(RPU_DMAR0_FMT, (2'd1 << 28) |
    SetReg32(RPU_DMAR0_FMT, (2 << 28) | (input_width*input_height));
    
    // FMT_I	// 2'b00 : yuv4:2:2 8bit, 2'b01 : yuv4:2:2 12bit
    //		// 2'b10 : bayer 14bit
    SetReg32(RPU_DMAR1_FMT, (0 << 28) | (0x0018c00));
    
    //SetReg32(RegRPU_AVE_C, 0x80000000);//double buffer
    
    SetReg32 (r_ISP_DMAREG_SRST,    0x00000000);  // DMA_SRST release
    SetReg32 (r_ISP_DMAREG_EN,      0x00000300);  // DMA_EN
    
    // SCL configuration
    SetReg32(REG_ISP_SCL_CLIP0, ((0<<24) | (255<<16) | (0<<8)  | 255));
    SetReg32(REG_ISP_SCL_CLIP1, ((0<<24) | (255<<16) | (0<<8)  | 255));
    SetReg32(REG_ISP_SCL_CLIP2, ((0<<24) | (255<<16) | (0<<8)  | 255));
    SetReg32(REG_ISP_SCL_CLIP3, ((0<<24) | (255<<16) | (0<<8)  | 255));
    SetReg32(REG_ISP_SCL_CLIP4, ((0<<24) | (255<<16) | (0<<8)  | 255));
    SetReg32(REG_ISP_SCL_SRC0, ((input_height << 16) | input_width));
    SetReg32(REG_ISP_SCL_SRC1, ((input_height << 16) | input_width));
    SetReg32(REG_ISP_SCL_SRC2, ((input_height << 16) | input_width));
    SetReg32(REG_ISP_SCL_SRC3, ((input_height << 16) | input_width));
    SetReg32(REG_ISP_SCL_SRC4, ((input_height << 16) | input_width));
    SetReg32(REG_ISP_SCL_SRC5, ((input_height << 16) | input_width));
    // ch0, 1, 2, 3
    SetReg32(REG_ISP_SCL_DST0, ((output_height0 << 16) | output_width0));
    SetReg32(REG_ISP_SCL_DST1, ((output_height1 << 16) | output_width1));
    SetReg32(REG_ISP_SCL_DST2, ((output_height2 << 16) | output_width2));
    SetReg32(REG_ISP_SCL_DST5, ((output_height0 << 16) | output_width0));     // for IVA
    SetReg32(REG_ISP_SCL_DMA0, DRAM_OFST_ISP_SCL0_0);
    SetReg32(REG_ISP_SCL_DMA1, DRAM_OFST_ISP_SCL1_0);
    SetReg32(REG_ISP_SCL_DMA2, DRAM_OFST_ISP_SCL2_0);
    SetReg32(REG_ISP_SCL_DMA3, DRAM_OFST_ISP_SCL3_0);
    SetReg32(REG_ISP_SCL_DMA4, DRAM_OFST_ISP_NR_0);
    
    // srst
    //SetRegFld32(REG_ISP_SCL_CTL, SCL_CTL_SRST);
    //ClrRegFld32(REG_ISP_SCL_CTL, SCL_CTL_SRST);
    // interrupt enable
    /*
    SetReg32(REG_ISP_SCL_INT_STATUS, 0x0000ffff);
    SetRegFld32(REG_ISP_SCL_INT_MASK, (
    SCL_INT_DMA_ALL_DONE // |
    //      SCL_INT_DMA4_SCALE_DONE |
    //      SCL_INT_DMA3_SCALE_DONE |
    //      SCL_INT_DMA2_SCALE_DONE |
    //      SCL_INT_DMA1_SCALE_DONE |
    //      SCL_INT_DMA0_SCALE_DONE));
    ));
    */

    // NEG_IMAGE, FLIP
    //SetReg32(REG_ISP_SCL_NEG_FLIP0, 0x00000000);
    //SetReg32(REG_ISP_SCL_NEG_FLIP1, 0x00000000);
    //SetReg32(REG_ISP_SCL_NEG_FLIP2, 0x00000000);
    //SetReg32(REG_ISP_SCL_NEG_FLIP3, 0x00000000);
    //SetReg32(REG_ISP_SCL_NEG_FLIP4, 0x00000000);
   
    SetReg32(REG_ISP_SCL_INT_STATUS, 0x0000ffff);
    SetRegFld32(REG_ISP_SCL_INT_MASK, (SCL_INT_DMA_ALL_DONE // |
				       //SCL_INT_DMA4_SCALE_DONE |
				       //SCL_INT_DMA3_SCALE_DONE |
				       //SCL_INT_DMA2_SCALE_DONE |
				       //SCL_INT_DMA1_SCALE_DONE |
				       //SCL_INT_DMA0_SCALE_DONE));
		    ));

    SetReg32(REG_ISP_SCL_IMG_ID, 0x00000000);
}

void isp_enc_pic_start(UInt8 PicNum)
{
//    // dio start
//    SetReg32(REG_ISP_SCL_CTL, (SCL_CTL_SATD8X8_CLR |
//                               g_isp_scl_ch5_en    |
//                               g_isp_scl_ch4_en    |
//                               g_isp_scl_ch3_en    |
//                               g_isp_scl_ch2_en    |
//                               g_isp_scl_ch1_en    |
//                               g_isp_scl_ch0_en    |
//                               SCL_CTL_START));
//    ClrRegFld32(REG_ISP_SCL_CTL, SCL_CTL_SATD8X8_CLR);
//
//    ///// RPU START Set
////    SetReg32(RPU_C0, 0xc0104086); // direct output
//    {
//        UInt32 tmp = GetReg32(RPU_C0); // direct output
//        SetReg32(RPU_C0, tmp | 0x00000006ul); // direct output
//    }
//    ///// RPU ENABLE Set
////    SetReg32(RPU_C0, 0xc0104087); // direct output <---yuv422thru
//    {
//        UInt32 tmp = GetReg32(RPU_C0); // direct output <---yuv422thru
//        SetReg32(RPU_C0, tmp | 0x00000007ul); // direct output <---yuv422thru
//    }
//
////    SetReg32(RPU_DMA_ACT,  0x00000001);
//    {
//        UInt32 tmp = GetReg32(RPU_DMA_ACT);
//        SetReg32(RPU_DMA_ACT,  tmp | 0x80000001);
//    }
//    SetRegFld32(NR_ISP_MODE, 0x00000001);  // isp frame start !!
//
//    // next param setting
//
//    // IVA
//    SetReg32(REG_ISP_SCL_IMG_ID, PicNum);
//
//    if (PicNum&0x1) {
//        SetReg32(RPU_DMAR0_OFS, DRAM_OFST_IMG_MIX_1);
//#ifndef USE_AXBRIDGE
//        SetReg32(RPU_DMAW1_OFS, DRAM_OFST_ISP_3A_1);
//#endif  /* USE_AXBRIDGE */
//        SetReg32(REG_ISP_SCL_DMA0, DRAM_OFST_ISP_SCL0_1);
//        SetReg32(REG_ISP_SCL_DMA1, DRAM_OFST_ISP_SCL1_1);
//        SetReg32(REG_ISP_SCL_DMA2, DRAM_OFST_ISP_SCL2_1);
//        SetReg32(REG_ISP_SCL_DMA3, DRAM_OFST_ISP_SCL3_1);
//        SetReg32(NR_DMAR_OFS     , DRAM_OFST_ISP_NR_0);
//        SetReg32(REG_ISP_SCL_DMA4, DRAM_OFST_ISP_NR_1);
//    } else {
//        SetReg32(RPU_DMAR0_OFS, DRAM_OFST_IMG_MIX_0);
//#ifndef USE_AXBRIDGE
//        SetReg32(RPU_DMAW1_OFS, DRAM_OFST_ISP_3A_0);
//#endif  /* USE_AXBRIDGE */
//        SetReg32(REG_ISP_SCL_DMA0, DRAM_OFST_ISP_SCL0_0);
//        SetReg32(REG_ISP_SCL_DMA1, DRAM_OFST_ISP_SCL1_0);
//        SetReg32(REG_ISP_SCL_DMA2, DRAM_OFST_ISP_SCL2_0);
//        SetReg32(REG_ISP_SCL_DMA3, DRAM_OFST_ISP_SCL3_0);
//        SetReg32(NR_DMAR_OFS     , DRAM_OFST_ISP_NR_1);
//        SetReg32(REG_ISP_SCL_DMA4, DRAM_OFST_ISP_NR_0);
//    }
//	setRegLog3(GetReg32(RPU_DMAR0_OFS) , PicNum);
}

#ifdef  __cplusplus
}
#endif

#endif  //  PARASOFT_CPPTEST
