#ifndef _PROC_DEF_SIO_H_
#define _PROC_DEF_SIO_H_

#define SIO_SSPSR_BSY                   (1 << 4)
#define SIO_SSPSR_REF                   (1 << 3)
#define SIO_SSPSR_RNE                   (1 << 2)
#define SIO_SSPSR_TNF                   (1 << 1)
#define SIO_SSPSR_TFE                   (1 << 0)

void init_sio(void);
void set_sio_fifo(UInt8 *wdata, UInt8 size, UInt8 lsbf);
void get_sio_fifo(UInt8 *rdata, UInt8 size, UInt8 lsbf);
UInt8 get_sio_status(void);
void wait_sio_status(UInt8 mask, UInt8 comp);
void start_sio(void);
void stop_sio(void);
void set_sio_cmos_register(UInt16 addr, UInt8 wdata);
void set_sio_cmos_shutter(UInt16 addr, UInt32 wdata);	/* K.Kawachi add */
void set_sio_cmos_gain(UInt16 addr, UInt32 wdata);		/* K.Kawachi add */
UInt8 get_sio_cmos_register(UInt16 addr);
UInt32 get_sio_cmos_shutter(UInt16 addr);				/* K.Kawachi add */
UInt32 get_sio_cmos_gain(UInt16 addr);					/* K.Kawachi add */


#endif // _PROC_DEF_SIO_H_
