#ifndef _REG_IMAGEIF_H_
#define _REG_IMAGEIF_H_

#define P_IMG_DMA        REG_IMG_DMAC_BASE
#define P_IMG_DMAREG     REG_IMG_ISI_BASE + 0x00000000
#define P_ISI_BASE       REG_IMG_ISI_BASE + 0x00002000
#define P_MIX_BASE       REG_IMG_ISI_BASE + 0x00004000
#define P_SPB_BASE       REG_IMG_ISI_BASE + 0x00005000
#define P_SPU_BASE       REG_IMG_ISI_BASE + 0x00006000

#define P_ISI_DMAW_BASE  (P_IMG_DMA + 0x00000000)
#define P_ISI_DMAR_BASE  (P_IMG_DMA + 0x00001000)

//---- isi_dmareg ---------------------------------------------------------
//#define P_ISI_DMAREG     (P_IMG_DMA + 0x0000)	//'d000
#define P_ISI_DMAREG     (P_IMG_DMA + 0x0004)	//'d000


//---- isi_reg ------------------------------------------------------------
#define ISI_SRST			 (P_ISI_BASE + 0x0000)
#define ISI_ACT			 (P_ISI_BASE + 0x0004)
//Reserved
//Reserved

#define ISI_IC_MASK			 (P_ISI_BASE + 0x0020)
//Reserved	0x0024
//Reserved	0x0028
#define ISI_IC_STATUS			 (P_ISI_BASE + 0x002c)

#define ISI_IC_UNMASKED_STATUS	 (P_ISI_BASE + 0x0030)
//Reserved	0x0034
//Reserved	0x0038
//Reserved	0x003c

#define ISI_C				 (P_ISI_BASE + 0x0040)
//Reserved	0x0044
//Reserved	0x0048
//Reserved	0x004c

#define ISI_IVL			 (P_ISI_BASE + 0x0050)
#define ISI_CAP_STAT			 (P_ISI_BASE + 0x0054)
#define ISI_CAP_SIZE			 (P_ISI_BASE + 0x0058)
#define ISI_ACT_SIZE			 (P_ISI_BASE + 0x005c)
//Reserved	0x005c

#define ISI_STGINT0TM			 (P_ISI_BASE + 0x0060)
#define ISI_STGINT1TM			 (P_ISI_BASE + 0x0064)
#define ISI_STGINT2TM			 (P_ISI_BASE + 0x0068)
#define ISI_STGINT3TM			 (P_ISI_BASE + 0x006c)

#define ISI_STGINT4TM			 (P_ISI_BASE + 0x0070)
#define ISI_STGINT5TM			 (P_ISI_BASE + 0x0074)
#define ISI_STGINT6TM			 (P_ISI_BASE + 0x0078)
#define ISI_STGINT7TM			 (P_ISI_BASE + 0x007c)

#define ISI_STGCTV			 (P_ISI_BASE + 0x0080)
#define ISI_STGUP0TM			 (P_ISI_BASE + 0x0084)		//@@121024
#define ISI_STGDN0TM			 (P_ISI_BASE + 0x0088)		//@@121024
#define ISI_FRMSTTM			 (P_ISI_BASE + 0x008c)		//@@131030

#define ISI_PIC_ID			 (P_ISI_BASE + 0x0090)		//@@131030
#define ISI_STGUP1TM			 (P_ISI_BASE + 0x0094)		//@@130312
#define ISI_STGDN1TM			 (P_ISI_BASE + 0x0098)		//@@130312
#define ISI_DSP_IC_MASK			(P_ISI_BASE + 0x00a0)
//Reserved      16'h00a4
//Reserved      16'h00a8
#define ISI_DSP_IC_STATUS     		(P_ISI_BASE + 0x00ac)
#define ISI_DSP_IC_UNMASKED_STATUS 	(P_ISI_BASE + 0x00b0)
//Reserved      16'h00b4
//Reserved	0x00b4 -0x00fc

#define CH1P0_SOF_12W			 (P_ISI_BASE + 0x0100)
#define CH1P0_SOF_34W			 (P_ISI_BASE + 0x0104)
#define CH1P0_SOL_12W			 (P_ISI_BASE + 0x0108)
#define CH1P0_SOL_34W			 (P_ISI_BASE + 0x010c)

#define CH1P0_EOL_12W			 (P_ISI_BASE + 0x0110)
#define CH1P0_EOL_34W			 (P_ISI_BASE + 0x0114)
#define CH1P0_EOF_12W			 (P_ISI_BASE + 0x0118)
#define CH1P0_EOF_34W			 (P_ISI_BASE + 0x011c)

#define CH1P1_SOF_12W			 (P_ISI_BASE + 0x0120)
#define CH1P1_SOF_34W			 (P_ISI_BASE + 0x0124)
#define CH1P1_SOL_12W			 (P_ISI_BASE + 0x0128)
#define CH1P1_SOL_34W			 (P_ISI_BASE + 0x012c)

#define CH1P1_EOL_12W			 (P_ISI_BASE + 0x0130)
#define CH1P1_EOL_34W			 (P_ISI_BASE + 0x0134)
#define CH1P1_EOF_12W			 (P_ISI_BASE + 0x0138)
#define CH1P1_EOF_34W			 (P_ISI_BASE + 0x013c)

#define CH2P0_SOF_12W			 (P_ISI_BASE + 0x0140)
#define CH2P0_SOF_34W			 (P_ISI_BASE + 0x0144)
#define CH2P0_SOL_12W			 (P_ISI_BASE + 0x0148)
#define CH2P0_SOL_34W			 (P_ISI_BASE + 0x014c)

#define CH2P0_EOL_12W			 (P_ISI_BASE + 0x0150)
#define CH2P0_EOL_34W			 (P_ISI_BASE + 0x0154)
#define CH2P0_EOF_12W			 (P_ISI_BASE + 0x0158)
#define CH2P0_EOF_34W			 (P_ISI_BASE + 0x015c)

#define CH2P1_SOF_12W			 (P_ISI_BASE + 0x0160)
#define CH2P1_SOF_34W			 (P_ISI_BASE + 0x0164)
#define CH2P1_SOL_12W			 (P_ISI_BASE + 0x0168)
#define CH2P1_SOL_34W			 (P_ISI_BASE + 0x016c)

#define CH2P1_EOL_12W			 (P_ISI_BASE + 0x0170)
#define CH2P1_EOL_34W			 (P_ISI_BASE + 0x0174)
#define CH2P1_EOF_12W			 (P_ISI_BASE + 0x0178)
#define CH2P1_EOF_34W			 (P_ISI_BASE + 0x017c)

#define ISI_DMAWADS_INI                (P_ISI_BASE + 0x0200)


#define CIO_C				 (P_ISI_BASE + 0x0300)
#define CIO_HS_EN			 (P_ISI_BASE + 0x0304)
#define CIO_LP_EN			 (P_ISI_BASE + 0x0308)
#define CIO_TE_EN			 (P_ISI_BASE + 0x030c)
#define CIO_DLY_A			 (P_ISI_BASE + 0x0310)
#define CIO_DLY_B			 (P_ISI_BASE + 0x0314)
#define CIO_DLY_C			 (P_ISI_BASE + 0x0318)


//---- dmareg_reg ------------------------------------------------------------
#define r_ISI_DMAREG_SRST              (P_IMG_DMAREG + 0x000)
#define r_ISI_DMAREG_EN                (P_IMG_DMAREG + 0x004)


//---- dmaw_reg ------------------------------------------------------------
#define r_ISI_DMAW_SRST                 (P_ISI_DMAW_BASE + 0x000)	// 'd000
#define r_ISI_DMAW_EN                   (P_ISI_DMAW_BASE + 0x004)	// 'd001
#define r_ISI_DMAW_reserve_0x008        (P_ISI_DMAW_BASE + 0x008)	// 'd002
#define r_ISI_DMAW_reserve_0x00c        (P_ISI_DMAW_BASE + 0x00c)	// 'd003
#define r_ISI_DMAW_reserve_0x010        (P_ISI_DMAW_BASE + 0x010)	// 'd004
#define r_ISI_DMAW_reserve_0x014        (P_ISI_DMAW_BASE + 0x014)	// 'd005
#define r_ISI_DMAW_reserve_0x018        (P_ISI_DMAW_BASE + 0x018)	// 'd006
#define r_ISI_DMAW_reserve_0x01c        (P_ISI_DMAW_BASE + 0x01c)	// 'd007
#define r_ISI_DMAW_INT_MASK             (P_ISI_DMAW_BASE + 0x020)	// 'd008
#define r_ISI_DMAW_INT_INV              (P_ISI_DMAW_BASE + 0x024)	// 'd009
#define r_ISI_DMAW_INT_LVLEDGE          (P_ISI_DMAW_BASE + 0x028)	// 'd010
#define r_ISI_DMAW_INT_STATUS           (P_ISI_DMAW_BASE + 0x02c)	// 'd011
#define r_ISI_DMAW_INT_UNMASKED_STATUS  (P_ISI_DMAW_BASE + 0x030)	// 'd012
#define r_ISI_DMAW_INT_RAW_STATUS       (P_ISI_DMAW_BASE + 0x034)	// 'd013
#define r_ISI_DMAW_reserve_0x038        (P_ISI_DMAW_BASE + 0x038)	// 'd014
#define r_ISI_DMAW_reserve_0x03c        (P_ISI_DMAW_BASE + 0x03c)	// 'd015
#define r_ISI_DMAW_reserve_0x040        (P_ISI_DMAW_BASE + 0x040)	// 'd016
#define r_ISI_DMAW_reserve_0x044        (P_ISI_DMAW_BASE + 0x044)	// 'd017
#define r_ISI_DMAW_reserve_0x048        (P_ISI_DMAW_BASE + 0x048)	// 'd018
#define r_ISI_DMAW_reserve_0x04c        (P_ISI_DMAW_BASE + 0x04c)	// 'd019
#define r_ISI_DMAW_reserve_0x050        (P_ISI_DMAW_BASE + 0x050)	// 'd020
#define r_ISI_DMAW_reserve_0x054        (P_ISI_DMAW_BASE + 0x054)	// 'd021
#define r_ISI_DMAW_reserve_0x058        (P_ISI_DMAW_BASE + 0x058)	// 'd022
#define r_ISI_DMAW_reserve_0x05c        (P_ISI_DMAW_BASE + 0x05c)	// 'd023
#define r_ISI_DMAW_reserve_0x060        (P_ISI_DMAW_BASE + 0x060)	// 'd024
#define r_ISI_DMAW_reserve_0x064        (P_ISI_DMAW_BASE + 0x064)	// 'd025
#define r_ISI_DMAW_reserve_0x068        (P_ISI_DMAW_BASE + 0x068)	// 'd026
#define r_ISI_DMAW_reserve_0x06c        (P_ISI_DMAW_BASE + 0x06c)	// 'd027
#define r_ISI_DMAW_reserve_0x070        (P_ISI_DMAW_BASE + 0x070)	// 'd028
#define r_ISI_DMAW_reserve_0x074        (P_ISI_DMAW_BASE + 0x074)	// 'd029
#define r_ISI_DMAW_reserve_0x078        (P_ISI_DMAW_BASE + 0x078)	// 'd030
#define r_ISI_DMAW_reserve_0x07c        (P_ISI_DMAW_BASE + 0x07c)	// 'd031
#define r_ISI_DMAW_reserve_0x080        (P_ISI_DMAW_BASE + 0x080)	// 'd032
#define r_ISI_DMAW_reserve_0x084        (P_ISI_DMAW_BASE + 0x084)	// 'd033
#define r_ISI_DMAW_reserve_0x088        (P_ISI_DMAW_BASE + 0x088)	// 'd034
#define r_ISI_DMAW_reserve_0x08c        (P_ISI_DMAW_BASE + 0x08c)	// 'd035
#define r_ISI_DMAW_reserve_0x090        (P_ISI_DMAW_BASE + 0x090)	// 'd036
#define r_ISI_DMAW_reserve_0x094        (P_ISI_DMAW_BASE + 0x094)	// 'd037
#define r_ISI_DMAW_reserve_0x098        (P_ISI_DMAW_BASE + 0x098)	// 'd038
#define r_ISI_DMAW_reserve_0x09c        (P_ISI_DMAW_BASE + 0x09c)	// 'd039
#define r_ISI_DMAW_reserve_0x0a0        (P_ISI_DMAW_BASE + 0x0a0)	// 'd040
#define r_ISI_DMAW_reserve_0x0a4        (P_ISI_DMAW_BASE + 0x0a4)	// 'd041
#define r_ISI_DMAW_reserve_0x0a8        (P_ISI_DMAW_BASE + 0x0a8)	// 'd042
#define r_ISI_DMAW_reserve_0x0ac        (P_ISI_DMAW_BASE + 0x0ac)	// 'd043
#define r_ISI_DMAW_reserve_0x0b0        (P_ISI_DMAW_BASE + 0x0b0)	// 'd044
#define r_ISI_DMAW_reserve_0x0b4        (P_ISI_DMAW_BASE + 0x0b4)	// 'd045
#define r_ISI_DMAW_reserve_0x0b8        (P_ISI_DMAW_BASE + 0x0b8)	// 'd046
#define r_ISI_DMAW_reserve_0x0bc        (P_ISI_DMAW_BASE + 0x0bc)	// 'd047
#define r_ISI_DMAW_reserve_0x0c0        (P_ISI_DMAW_BASE + 0x0c0)	// 'd048
#define r_ISI_DMAW_reserve_0x0c4        (P_ISI_DMAW_BASE + 0x0c4)	// 'd049
#define r_ISI_DMAW_reserve_0x0c8        (P_ISI_DMAW_BASE + 0x0c8)	// 'd050
#define r_ISI_DMAW_reserve_0x0cc        (P_ISI_DMAW_BASE + 0x0cc)	// 'd051
#define r_ISI_DMAW_reserve_0x0d0        (P_ISI_DMAW_BASE + 0x0d0)	// 'd052
#define r_ISI_DMAW_reserve_0x0d4        (P_ISI_DMAW_BASE + 0x0d4)	// 'd053
#define r_ISI_DMAW_reserve_0x0d8        (P_ISI_DMAW_BASE + 0x0d8)	// 'd054
#define r_ISI_DMAW_reserve_0x0dc        (P_ISI_DMAW_BASE + 0x0dc)	// 'd055
#define r_ISI_DMAW_reserve_0x0e0        (P_ISI_DMAW_BASE + 0x0e0)	// 'd056
#define r_ISI_DMAW_reserve_0x0e4        (P_ISI_DMAW_BASE + 0x0e4)	// 'd057
#define r_ISI_DMAW_reserve_0x0e8        (P_ISI_DMAW_BASE + 0x0e8)	// 'd058
#define r_ISI_DMAW_reserve_0x0ec        (P_ISI_DMAW_BASE + 0x0ec)	// 'd059
#define r_ISI_DMAW_reserve_0x0f0        (P_ISI_DMAW_BASE + 0x0f0)	// 'd060
#define r_ISI_DMAW_reserve_0x0f4        (P_ISI_DMAW_BASE + 0x0f4)	// 'd061
#define r_ISI_DMAW_reserve_0x0f8        (P_ISI_DMAW_BASE + 0x0f8)	// 'd062
#define r_ISI_DMAW_reserve_0x0fc        (P_ISI_DMAW_BASE + 0x0fc)	// 'd063
#define r_ISI_DMAW_UF_MODE              (P_ISI_DMAW_BASE + 0x100)	// 'd064
#define r_ISI_DMAW_reserve_0x104        (P_ISI_DMAW_BASE + 0x104)	// 'd065
#define r_ISI_DMAW_reserve_0x108        (P_ISI_DMAW_BASE + 0x108)	// 'd066
#define r_ISI_DMAW_reserve_0x10c        (P_ISI_DMAW_BASE + 0x10c)	// 'd067
#define r_ISI_DMAW_reserve_0x110        (P_ISI_DMAW_BASE + 0x110)	// 'd068
#define r_ISI_DMAW_reserve_0x114        (P_ISI_DMAW_BASE + 0x114)	// 'd069
#define r_ISI_DMAW_reserve_0x118        (P_ISI_DMAW_BASE + 0x118)	// 'd070
#define r_ISI_DMAW_reserve_0x11c        (P_ISI_DMAW_BASE + 0x11c)	// 'd071

//---- dmar_reg ------------------------------------------------------------
#define r_ISI_DMAR_SRST                 (P_ISI_DMAR_BASE + 0x000)	// 'd000
#define r_ISI_DMAR_EN                   (P_ISI_DMAR_BASE + 0x004)	// 'd001
#define r_ISI_DMAR_reserve_0x008        (P_ISI_DMAR_BASE + 0x008)	// 'd002
#define r_ISI_DMAR_reserve_0x00c        (P_ISI_DMAR_BASE + 0x00c)	// 'd003
#define r_ISI_DMAR_reserve_0x010        (P_ISI_DMAR_BASE + 0x010)	// 'd004
#define r_ISI_DMAR_reserve_0x014        (P_ISI_DMAR_BASE + 0x014)	// 'd005
#define r_ISI_DMAR_reserve_0x018        (P_ISI_DMAR_BASE + 0x018)	// 'd006
#define r_ISI_DMAR_reserve_0x01c        (P_ISI_DMAR_BASE + 0x01c)	// 'd007
#define r_ISI_DMAR_INT_MASK             (P_ISI_DMAR_BASE + 0x020)	// 'd008
#define r_ISI_DMAR_INT_INV              (P_ISI_DMAR_BASE + 0x024)	// 'd009
#define r_ISI_DMAR_INT_LVLEDGE          (P_ISI_DMAR_BASE + 0x028)	// 'd010
#define r_ISI_DMAR_INT_STATUS           (P_ISI_DMAR_BASE + 0x02c)	// 'd011
#define r_ISI_DMAR_INT_UNMASKED_STATUS  (P_ISI_DMAR_BASE + 0x030)	// 'd012
#define r_ISI_DMAR_INT_RAW_STATUS       (P_ISI_DMAR_BASE + 0x034)	// 'd013
#define r_ISI_DMAR_reserve_0x038        (P_ISI_DMAR_BASE + 0x038)	// 'd014
#define r_ISI_DMAR_reserve_0x03c        (P_ISI_DMAR_BASE + 0x03c)	// 'd015
#define r_ISI_DMAR_reserve_0x040        (P_ISI_DMAR_BASE + 0x040)	// 'd016
#define r_ISI_DMAR_reserve_0x044        (P_ISI_DMAR_BASE + 0x044)	// 'd017
#define r_ISI_DMAR_reserve_0x048        (P_ISI_DMAR_BASE + 0x048)	// 'd018
#define r_ISI_DMAR_reserve_0x04c        (P_ISI_DMAR_BASE + 0x04c)	// 'd019
#define r_ISI_DMAR_reserve_0x050        (P_ISI_DMAR_BASE + 0x050)	// 'd020
#define r_ISI_DMAR_reserve_0x054        (P_ISI_DMAR_BASE + 0x054)	// 'd021
#define r_ISI_DMAR_reserve_0x058        (P_ISI_DMAR_BASE + 0x058)	// 'd022
#define r_ISI_DMAR_reserve_0x05c        (P_ISI_DMAR_BASE + 0x05c)	// 'd023
#define r_ISI_DMAR_reserve_0x060        (P_ISI_DMAR_BASE + 0x060)	// 'd024
#define r_ISI_DMAR_reserve_0x064        (P_ISI_DMAR_BASE + 0x064)	// 'd025
#define r_ISI_DMAR_reserve_0x068        (P_ISI_DMAR_BASE + 0x068)	// 'd026
#define r_ISI_DMAR_reserve_0x06c        (P_ISI_DMAR_BASE + 0x06c)	// 'd027
#define r_ISI_DMAR_reserve_0x070        (P_ISI_DMAR_BASE + 0x070)	// 'd028
#define r_ISI_DMAR_reserve_0x074        (P_ISI_DMAR_BASE + 0x074)	// 'd029
#define r_ISI_DMAR_reserve_0x078        (P_ISI_DMAR_BASE + 0x078)	// 'd030
#define r_ISI_DMAR_reserve_0x07c        (P_ISI_DMAR_BASE + 0x07c)	// 'd031
#define r_ISI_DMAR_reserve_0x080        (P_ISI_DMAR_BASE + 0x080)	// 'd032
#define r_ISI_DMAR_reserve_0x084        (P_ISI_DMAR_BASE + 0x084)	// 'd033
#define r_ISI_DMAR_reserve_0x088        (P_ISI_DMAR_BASE + 0x088)	// 'd034
#define r_ISI_DMAR_reserve_0x08c        (P_ISI_DMAR_BASE + 0x08c)	// 'd035
#define r_ISI_DMAR_reserve_0x090        (P_ISI_DMAR_BASE + 0x090)	// 'd036
#define r_ISI_DMAR_reserve_0x094        (P_ISI_DMAR_BASE + 0x094)	// 'd037
#define r_ISI_DMAR_reserve_0x098        (P_ISI_DMAR_BASE + 0x098)	// 'd038
#define r_ISI_DMAR_reserve_0x09c        (P_ISI_DMAR_BASE + 0x09c)	// 'd039
#define r_ISI_DMAR_reserve_0x0a0        (P_ISI_DMAR_BASE + 0x0a0)	// 'd040
#define r_ISI_DMAR_reserve_0x0a4        (P_ISI_DMAR_BASE + 0x0a4)	// 'd041
#define r_ISI_DMAR_reserve_0x0a8        (P_ISI_DMAR_BASE + 0x0a8)	// 'd042
#define r_ISI_DMAR_reserve_0x0ac        (P_ISI_DMAR_BASE + 0x0ac)	// 'd043
#define r_ISI_DMAR_reserve_0x0b0        (P_ISI_DMAR_BASE + 0x0b0)	// 'd044
#define r_ISI_DMAR_reserve_0x0b4        (P_ISI_DMAR_BASE + 0x0b4)	// 'd045
#define r_ISI_DMAR_reserve_0x0b8        (P_ISI_DMAR_BASE + 0x0b8)	// 'd046
#define r_ISI_DMAR_reserve_0x0bc        (P_ISI_DMAR_BASE + 0x0bc)	// 'd047
#define r_ISI_DMAR_reserve_0x0c0        (P_ISI_DMAR_BASE + 0x0c0)	// 'd048
#define r_ISI_DMAR_reserve_0x0c4        (P_ISI_DMAR_BASE + 0x0c4)	// 'd049
#define r_ISI_DMAR_reserve_0x0c8        (P_ISI_DMAR_BASE + 0x0c8)	// 'd050
#define r_ISI_DMAR_reserve_0x0cc        (P_ISI_DMAR_BASE + 0x0cc)	// 'd051
#define r_ISI_DMAR_reserve_0x0d0        (P_ISI_DMAR_BASE + 0x0d0)	// 'd052
#define r_ISI_DMAR_reserve_0x0d4        (P_ISI_DMAR_BASE + 0x0d4)	// 'd053
#define r_ISI_DMAR_reserve_0x0d8        (P_ISI_DMAR_BASE + 0x0d8)	// 'd054
#define r_ISI_DMAR_reserve_0x0dc        (P_ISI_DMAR_BASE + 0x0dc)	// 'd055
#define r_ISI_DMAR_reserve_0x0e0        (P_ISI_DMAR_BASE + 0x0e0)	// 'd056
#define r_ISI_DMAR_reserve_0x0e4        (P_ISI_DMAR_BASE + 0x0e4)	// 'd057
#define r_ISI_DMAR_reserve_0x0e8        (P_ISI_DMAR_BASE + 0x0e8)	// 'd058
#define r_ISI_DMAR_reserve_0x0ec        (P_ISI_DMAR_BASE + 0x0ec)	// 'd059
#define r_ISI_DMAR_reserve_0x0f0        (P_ISI_DMAR_BASE + 0x0f0)	// 'd060
#define r_ISI_DMAR_reserve_0x0f4        (P_ISI_DMAR_BASE + 0x0f4)	// 'd061
#define r_ISI_DMAR_reserve_0x0f8        (P_ISI_DMAR_BASE + 0x0f8)	// 'd062
#define r_ISI_DMAR_reserve_0x0fc        (P_ISI_DMAR_BASE + 0x0fc)	// 'd063
#define r_ISI_DMAR_UF_MODE              (P_ISI_DMAR_BASE + 0x100)	// 'd064
#define r_ISI_DMAR_reserve_0x104        (P_ISI_DMAR_BASE + 0x104)	// 'd065
#define r_ISI_DMAR_reserve_0x108        (P_ISI_DMAR_BASE + 0x108)	// 'd066
#define r_ISI_DMAR_reserve_0x10c        (P_ISI_DMAR_BASE + 0x10c)	// 'd067
#define r_ISI_DMAR_reserve_0x110        (P_ISI_DMAR_BASE + 0x110)	// 'd068
#define r_ISI_DMAR_reserve_0x114        (P_ISI_DMAR_BASE + 0x114)	// 'd069
#define r_ISI_DMAR_reserve_0x118        (P_ISI_DMAR_BASE + 0x118)	// 'd070
#define r_ISI_DMAR_reserve_0x11c        (P_ISI_DMAR_BASE + 0x11c)	// 'd071


//---- spu_reg ------------------------------------------------------------
#define RegHCAPT                         (P_SPU_BASE + 0x008)
#define RegVCAPT1                        (P_SPU_BASE + 0x00c)
#define RegVCAPT2                        (P_SPU_BASE + 0x010)
#define RegCOLRAM0                       (P_SPU_BASE + 0x6d8)
#define RegCOLRAM1                       (P_SPU_BASE + 0x6dc)
#define RegCOLRAM2                       (P_SPU_BASE + 0x6e0)
#define RegCOLRAM3                       (P_SPU_BASE + 0x6e4)
#define RegSTG_RSLD                      (P_SPU_BASE + 0x714)
#define RegSTG_IVL                       (P_SPU_BASE + 0x718)
#define RegSTG_CTV                       (P_SPU_BASE + 0x71c)
#define RegHD_H                          (P_SPU_BASE + 0x768)

#define RegSPU_INTCNT_MASK               (P_SPU_BASE + 0x780)
#define RegSPU_INTCNT_INV                (P_SPU_BASE + 0x784)
#define RegSPU_INTCNT_LVLEDGE            (P_SPU_BASE + 0x788)
#define RegSPU_INTCNT_STATUS             (P_SPU_BASE + 0x78c)
#define RegSPU_INTCNT_UNMASKED_STATUS    (P_SPU_BASE + 0x790)
#define RegSPU_INTCNT_RAW_STATUS         (P_SPU_BASE + 0x794)
// basic
#define RegSPU_C		 (P_SPU_BASE + 0x014)
#define RegSPU_C2		 (P_SPU_BASE + 0x018)
#define RegSPU_C3		 (P_SPU_BASE + 0x01c)
#define RegC0CS_L		 (P_SPU_BASE + 0x020)
#define RegC0CS_H		 (P_SPU_BASE + 0x024)
#define RegDL0		 (P_SPU_BASE + 0x040)
#define RegDL1		 (P_SPU_BASE + 0x044)
#define RegDL2		 (P_SPU_BASE + 0x048)
#define RegDL3		 (P_SPU_BASE + 0x04c)
#define RegDL4		 (P_SPU_BASE + 0x050)
#define RegDL5		 (P_SPU_BASE + 0x054)
#define RegDL6		 (P_SPU_BASE + 0x058)
#define RegDL7		 (P_SPU_BASE + 0x05c)
#define RegWB0		 (P_SPU_BASE + 0x060)
#define RegWB1		 (P_SPU_BASE + 0x064)
#define RegWB2		 (P_SPU_BASE + 0x068)
#define RegWB3		 (P_SPU_BASE + 0x06c)
#define RegWB4		 (P_SPU_BASE + 0x070)
#define RegWB5		 (P_SPU_BASE + 0x074)
#define RegWB6		 (P_SPU_BASE + 0x078)
#define RegWB7		 (P_SPU_BASE + 0x07c)
#define RegCOLOR_TMG		 (P_SPU_BASE + 0x080)
#define RegVLINE_C		 (P_SPU_BASE + 0x084)
#define RegVLINEPS		 (P_SPU_BASE + 0x088)
#define RegVOPB		 (P_SPU_BASE + 0x08c)
#define RegAVE_C		 (P_SPU_BASE + 0x094)
#define RegWB0_TH		 (P_SPU_BASE + 0x098)
#define RegWB1_TH		 (P_SPU_BASE + 0x09c)
#define RegWB2_TH		 (P_SPU_BASE + 0x0a0)
#define RegWB3_TH		 (P_SPU_BASE + 0x0a4)
#define RegWB4_TH		 (P_SPU_BASE + 0x0a8)
#define RegWB5_TH		 (P_SPU_BASE + 0x0ac)
#define RegWB6_TH		 (P_SPU_BASE + 0x0b0)
#define RegWB7_TH		 (P_SPU_BASE + 0x0b4)
#define RegAFH_C		 (P_SPU_BASE + 0x0bc)
#define RegAFHW_H0		 (P_SPU_BASE + 0x0c0)
#define RegAFHW_H1		 (P_SPU_BASE + 0x0c4)
#define RegAFHW_H2		 (P_SPU_BASE + 0x0c8)
#define RegAFHW_H3		 (P_SPU_BASE + 0x0cc)
#define RegAFHW_H4		 (P_SPU_BASE + 0x0d0)
#define RegAFHW_H5		 (P_SPU_BASE + 0x0d4)
#define RegAFHW_H6		 (P_SPU_BASE + 0x0d8)
#define RegAFHW_H7		 (P_SPU_BASE + 0x0dc)
#define RegAFHW_H8		 (P_SPU_BASE + 0x0e0)
#define RegAFHW_V0		 (P_SPU_BASE + 0x0e4)
#define RegAFHW_V1		 (P_SPU_BASE + 0x0e8)
#define RegAFHW_V2		 (P_SPU_BASE + 0x0ec)
#define RegAFHW_V3		 (P_SPU_BASE + 0x0f0)
#define RegAFHW_V4		 (P_SPU_BASE + 0x0f4)
#define RegAFHW_V5		 (P_SPU_BASE + 0x0f8)
#define RegAFHW_V6		 (P_SPU_BASE + 0x0fc)
#define RegAFHW_V7		 (P_SPU_BASE + 0x100)
#define RegAFHW_V8		 (P_SPU_BASE + 0x104)
#define RegAFH_DTH0		 (P_SPU_BASE + 0x108)
#define RegAFH_DTH1		 (P_SPU_BASE + 0x10c)
#define RegAFH_DTH2		 (P_SPU_BASE + 0x110)
#define RegAFH_DTH3		 (P_SPU_BASE + 0x114)
#define RegAFH_DTH4		 (P_SPU_BASE + 0x118)
#define RegAFH_DTH5		 (P_SPU_BASE + 0x11c)
#define RegAFH_DTH6		 (P_SPU_BASE + 0x120)
#define RegAFH_DTH7		 (P_SPU_BASE + 0x124)
#define RegAFH_DTH8		 (P_SPU_BASE + 0x128)
#define RegAFH_DTL0		 (P_SPU_BASE + 0x12c)
#define RegAFH_DTL1		 (P_SPU_BASE + 0x130)
#define RegAFH_DTL2		 (P_SPU_BASE + 0x134)
#define RegAFH_DTL3		 (P_SPU_BASE + 0x138)
#define RegAFH_DTL4		 (P_SPU_BASE + 0x13c)
#define RegAFH_DTL5		 (P_SPU_BASE + 0x140)
#define RegAFH_DTL6		 (P_SPU_BASE + 0x144)
#define RegAFH_DTL7		 (P_SPU_BASE + 0x148)
#define RegAFH_DTL8		 (P_SPU_BASE + 0x14c)
#define RegAFH_PDH0		 (P_SPU_BASE + 0x150)
#define RegAFH_PDH1		 (P_SPU_BASE + 0x154)
#define RegAFH_PDH2		 (P_SPU_BASE + 0x158)
#define RegAFH_PDH3		 (P_SPU_BASE + 0x15c)
#define RegAFH_PDH4		 (P_SPU_BASE + 0x160)
#define RegAFH_PDH5		 (P_SPU_BASE + 0x164)
#define RegAFH_PDH6		 (P_SPU_BASE + 0x168)
#define RegAFH_PDH7		 (P_SPU_BASE + 0x16c)
#define RegAFH_PDH8		 (P_SPU_BASE + 0x170)
#define RegAFH_PDL0		 (P_SPU_BASE + 0x174)
#define RegAFH_PDL1		 (P_SPU_BASE + 0x178)
#define RegAFH_PDL2		 (P_SPU_BASE + 0x17c)
#define RegAFH_PDL3		 (P_SPU_BASE + 0x180)
#define RegAFH_PDL4		 (P_SPU_BASE + 0x184)
#define RegAFH_PDL5		 (P_SPU_BASE + 0x188)
#define RegAFH_PDL6		 (P_SPU_BASE + 0x18c)
#define RegAFH_PDL7		 (P_SPU_BASE + 0x190)
#define RegAFH_PDL8		 (P_SPU_BASE + 0x194)
#define RegCDEF0		 (P_SPU_BASE + 0x198)
#define RegCDEF1		 (P_SPU_BASE + 0x19c)
#define RegCDEF2		 (P_SPU_BASE + 0x1a0)
#define RegCDEF3		 (P_SPU_BASE + 0x1a4)
#define RegCDEF4		 (P_SPU_BASE + 0x1a8)
#define RegCDEF5		 (P_SPU_BASE + 0x1ac)
#define RegCDEF6		 (P_SPU_BASE + 0x1b0)
#define RegCDEF7		 (P_SPU_BASE + 0x1b4)
#define RegCDEF8		 (P_SPU_BASE + 0x1b8)
#define RegCDEF9		 (P_SPU_BASE + 0x1bc)
#define RegCDEF10		 (P_SPU_BASE + 0x1c0)
#define RegCDEF11		 (P_SPU_BASE + 0x1c4)
#define RegCDEF12		 (P_SPU_BASE + 0x1c8)
#define RegCDEF13		 (P_SPU_BASE + 0x1cc)
#define RegCDEF14		 (P_SPU_BASE + 0x1d0)
#define RegCDEF15		 (P_SPU_BASE + 0x1d4)
#define RegBRTTH		 (P_SPU_BASE + 0x1dc)
#define RegHCAPT2		 (P_SPU_BASE + 0x1e0)
#define RegOBEAH		 (P_SPU_BASE + 0x1e4)
#define RegOBEAV		 (P_SPU_BASE + 0x1e8)
#define RegOBCRR0		 (P_SPU_BASE + 0x1ec)
#define RegOBCRR1		 (P_SPU_BASE + 0x1f0)
#define RegOBCRR2		 (P_SPU_BASE + 0x1f4)
#define RegOBCRR3		 (P_SPU_BASE + 0x1f8)
#define RegSMODE		 (P_SPU_BASE + 0x204)
#define RegSMODE2		 (P_SPU_BASE + 0x208)
#define RegSHCAPT		 (P_SPU_BASE + 0x20c)
#define RegSVCAPT		 (P_SPU_BASE + 0x210)
#define RegDEFCT_C		 (P_SPU_BASE + 0x214)
#define RegADFOFS_1A		 (P_SPU_BASE + 0x218)
#define RegADFOFS_2A		 (P_SPU_BASE + 0x21c)
#define RegADFOFS_3A		 (P_SPU_BASE + 0x220)
#define RegADFOFS_4A		 (P_SPU_BASE + 0x224)
#define RegADFOFS_5A		 (P_SPU_BASE + 0x228)
#define RegADFOFS_6A		 (P_SPU_BASE + 0x22c)
#define RegADFOFS_7A		 (P_SPU_BASE + 0x230)
#define RegADFOFS_8A		 (P_SPU_BASE + 0x234)
#define RegADFOFSZ		 (P_SPU_BASE + 0x238)
#define RegADFCTTH		 (P_SPU_BASE + 0x23c)
#define RegADFCTTH_H		 (P_SPU_BASE + 0x240)
#define RegADFCTTH_L		 (P_SPU_BASE + 0x244)
#define RegADFCTEGTH		 (P_SPU_BASE + 0x248)
#define RegADFCT_CT		 (P_SPU_BASE + 0x24c)
#define RegLNZ_C		 (P_SPU_BASE + 0x348)
#define RegLZT0_00		 (P_SPU_BASE + 0x34c)
#define RegLZT0_01		 (P_SPU_BASE + 0x350)
#define RegLZT0_02		 (P_SPU_BASE + 0x354)
#define RegLZT0_03		 (P_SPU_BASE + 0x358)
#define RegLZT0_04		 (P_SPU_BASE + 0x35c)
#define RegLZT0_05		 (P_SPU_BASE + 0x360)
#define RegLZT0_06		 (P_SPU_BASE + 0x364)
#define RegLZT0_07		 (P_SPU_BASE + 0x368)
#define RegLZT0_08		 (P_SPU_BASE + 0x36c)
#define RegLZT0_09		 (P_SPU_BASE + 0x370)
#define RegLZT0_10		 (P_SPU_BASE + 0x374)
#define RegLZT0_11		 (P_SPU_BASE + 0x378)
#define RegLZT0_12		 (P_SPU_BASE + 0x37c)
#define RegLZT0_13		 (P_SPU_BASE + 0x380)
#define RegLZT0_14		 (P_SPU_BASE + 0x384)
#define RegLZT0_15		 (P_SPU_BASE + 0x388)
#define RegLZT0_16		 (P_SPU_BASE + 0x38c)
#define RegLZT0_17		 (P_SPU_BASE + 0x390)
#define RegLZT0_18		 (P_SPU_BASE + 0x394)
#define RegLZT0_19		 (P_SPU_BASE + 0x398)
#define RegLZT0_20		 (P_SPU_BASE + 0x39c)
#define RegLZT0_21		 (P_SPU_BASE + 0x3a0)
#define RegLZT0_22		 (P_SPU_BASE + 0x3a4)
#define RegLZT0_23		 (P_SPU_BASE + 0x3a8)
#define RegLZT0_24		 (P_SPU_BASE + 0x3ac)
#define RegLZT0_25		 (P_SPU_BASE + 0x3b0)
#define RegLZT0_26		 (P_SPU_BASE + 0x3b4)
#define RegLZT0_27		 (P_SPU_BASE + 0x3b8)
#define RegLZT0_28		 (P_SPU_BASE + 0x3bc)
#define RegLZT0_29		 (P_SPU_BASE + 0x3c0)
#define RegLZT0_30		 (P_SPU_BASE + 0x3c4)
#define RegLZT0_31		 (P_SPU_BASE + 0x3c8)
#define RegLZT0_32		 (P_SPU_BASE + 0x3cc)
#define RegLZT1_00		 (P_SPU_BASE + 0x3d0)
#define RegLZT1_01		 (P_SPU_BASE + 0x3d4)
#define RegLZT1_02		 (P_SPU_BASE + 0x3d8)
#define RegLZT1_03		 (P_SPU_BASE + 0x3dc)
#define RegLZT1_04		 (P_SPU_BASE + 0x3e0)
#define RegLZT1_05		 (P_SPU_BASE + 0x3e4)
#define RegLZT1_06		 (P_SPU_BASE + 0x3e8)
#define RegLZT1_07		 (P_SPU_BASE + 0x3ec)
#define RegLZT1_08		 (P_SPU_BASE + 0x3f0)
#define RegLZT1_09		 (P_SPU_BASE + 0x3f4)
#define RegLZT1_10		 (P_SPU_BASE + 0x3f8)
#define RegLZT1_11		 (P_SPU_BASE + 0x3fc)
#define RegLZT1_12		 (P_SPU_BASE + 0x400)
#define RegLZT1_13		 (P_SPU_BASE + 0x404)
#define RegLZT1_14		 (P_SPU_BASE + 0x408)
#define RegLZT1_15		 (P_SPU_BASE + 0x40c)
#define RegLZT1_16		 (P_SPU_BASE + 0x410)
#define RegLZT1_17		 (P_SPU_BASE + 0x414)
#define RegLZT1_18		 (P_SPU_BASE + 0x418)
#define RegLZT1_19		 (P_SPU_BASE + 0x41c)
#define RegLZT1_20		 (P_SPU_BASE + 0x420)
#define RegLZT1_21		 (P_SPU_BASE + 0x424)
#define RegLZT1_22		 (P_SPU_BASE + 0x428)
#define RegLZT1_23		 (P_SPU_BASE + 0x42c)
#define RegLZT1_24		 (P_SPU_BASE + 0x430)
#define RegLZT1_25		 (P_SPU_BASE + 0x434)
#define RegLZT1_26		 (P_SPU_BASE + 0x438)
#define RegLZT1_27		 (P_SPU_BASE + 0x43c)
#define RegLZT1_28		 (P_SPU_BASE + 0x440)
#define RegLZT1_29		 (P_SPU_BASE + 0x444)
#define RegLZT1_30		 (P_SPU_BASE + 0x448)
#define RegLZT1_31		 (P_SPU_BASE + 0x44c)
#define RegLZT1_32		 (P_SPU_BASE + 0x450)
#define RegLZT2_00		 (P_SPU_BASE + 0x454)
#define RegLZT2_01		 (P_SPU_BASE + 0x458)
#define RegLZT2_02		 (P_SPU_BASE + 0x45c)
#define RegLZT2_03		 (P_SPU_BASE + 0x460)
#define RegLZT2_04		 (P_SPU_BASE + 0x464)
#define RegLZT2_05		 (P_SPU_BASE + 0x468)
#define RegLZT2_06		 (P_SPU_BASE + 0x46c)
#define RegLZT2_07		 (P_SPU_BASE + 0x470)
#define RegLZT2_08		 (P_SPU_BASE + 0x474)
#define RegLZT2_09		 (P_SPU_BASE + 0x478)
#define RegLZT2_10		 (P_SPU_BASE + 0x47c)
#define RegLZT2_11		 (P_SPU_BASE + 0x480)
#define RegLZT2_12		 (P_SPU_BASE + 0x484)
#define RegLZT2_13		 (P_SPU_BASE + 0x488)
#define RegLZT2_14		 (P_SPU_BASE + 0x48c)
#define RegLZT2_15		 (P_SPU_BASE + 0x490)
#define RegLZT2_16		 (P_SPU_BASE + 0x494)
#define RegLZT2_17		 (P_SPU_BASE + 0x498)
#define RegLZT2_18		 (P_SPU_BASE + 0x49c)
#define RegLZT2_19		 (P_SPU_BASE + 0x4a0)
#define RegLZT2_20		 (P_SPU_BASE + 0x4a4)
#define RegLZT2_21		 (P_SPU_BASE + 0x4a8)
#define RegLZT2_22		 (P_SPU_BASE + 0x4ac)
#define RegLZT2_23		 (P_SPU_BASE + 0x4b0)
#define RegLZT2_24		 (P_SPU_BASE + 0x4b4)
#define RegLZT2_25		 (P_SPU_BASE + 0x4b8)
#define RegLZT2_26		 (P_SPU_BASE + 0x4bc)
#define RegLZT2_27		 (P_SPU_BASE + 0x4c0)
#define RegLZT2_28		 (P_SPU_BASE + 0x4c4)
#define RegLZT2_29		 (P_SPU_BASE + 0x4c8)
#define RegLZT2_30		 (P_SPU_BASE + 0x4cc)
#define RegLZT2_31		 (P_SPU_BASE + 0x4d0)
#define RegLZT2_32		 (P_SPU_BASE + 0x4d4)
#define RegLZT3_00		 (P_SPU_BASE + 0x4d8)
#define RegLZT3_01		 (P_SPU_BASE + 0x4dc)
#define RegLZT3_02		 (P_SPU_BASE + 0x4e0)
#define RegLZT3_03		 (P_SPU_BASE + 0x4e4)
#define RegLZT3_04		 (P_SPU_BASE + 0x4e8)
#define RegLZT3_05		 (P_SPU_BASE + 0x4ec)
#define RegLZT3_06		 (P_SPU_BASE + 0x4f0)
#define RegLZT3_07		 (P_SPU_BASE + 0x4f4)
#define RegLZT3_08		 (P_SPU_BASE + 0x4f8)
#define RegLZT3_09		 (P_SPU_BASE + 0x4fc)
#define RegLZT3_10		 (P_SPU_BASE + 0x500)
#define RegLZT3_11		 (P_SPU_BASE + 0x504)
#define RegLZT3_12		 (P_SPU_BASE + 0x508)
#define RegLZT3_13		 (P_SPU_BASE + 0x50c)
#define RegLZT3_14		 (P_SPU_BASE + 0x510)
#define RegLZT3_15		 (P_SPU_BASE + 0x514)
#define RegLZT3_16		 (P_SPU_BASE + 0x518)
#define RegLZT3_17		 (P_SPU_BASE + 0x51c)
#define RegLZT3_18		 (P_SPU_BASE + 0x520)
#define RegLZT3_19		 (P_SPU_BASE + 0x524)
#define RegLZT3_20		 (P_SPU_BASE + 0x528)
#define RegLZT3_21		 (P_SPU_BASE + 0x52c)
#define RegLZT3_22		 (P_SPU_BASE + 0x530)
#define RegLZT3_23		 (P_SPU_BASE + 0x534)
#define RegLZT3_24		 (P_SPU_BASE + 0x538)
#define RegLZT3_25		 (P_SPU_BASE + 0x53c)
#define RegLZT3_26		 (P_SPU_BASE + 0x540)
#define RegLZT3_27		 (P_SPU_BASE + 0x544)
#define RegLZT3_28		 (P_SPU_BASE + 0x548)
#define RegLZT3_29		 (P_SPU_BASE + 0x54c)
#define RegLZT3_30		 (P_SPU_BASE + 0x550)
#define RegLZT3_31		 (P_SPU_BASE + 0x554)
#define RegLZT3_32		 (P_SPU_BASE + 0x558)
#define RegLZT4_00		 (P_SPU_BASE + 0x55c)
#define RegLZT4_01		 (P_SPU_BASE + 0x560)
#define RegLZT4_02		 (P_SPU_BASE + 0x564)
#define RegLZT4_03		 (P_SPU_BASE + 0x568)
#define RegLZT4_04		 (P_SPU_BASE + 0x56c)
#define RegLZT4_05		 (P_SPU_BASE + 0x570)
#define RegLZT4_06		 (P_SPU_BASE + 0x574)
#define RegLZT4_07		 (P_SPU_BASE + 0x578)
#define RegLZT4_08		 (P_SPU_BASE + 0x57c)
#define RegLZT4_09		 (P_SPU_BASE + 0x580)
#define RegLZT4_10		 (P_SPU_BASE + 0x584)
#define RegLZT4_11		 (P_SPU_BASE + 0x588)
#define RegLZT4_12		 (P_SPU_BASE + 0x58c)
#define RegLZT4_13		 (P_SPU_BASE + 0x590)
#define RegLZT4_14		 (P_SPU_BASE + 0x594)
#define RegLZT4_15		 (P_SPU_BASE + 0x598)
#define RegLZT4_16		 (P_SPU_BASE + 0x59c)
#define RegLZT4_17		 (P_SPU_BASE + 0x5a0)
#define RegLZT4_18		 (P_SPU_BASE + 0x5a4)
#define RegLZT4_19		 (P_SPU_BASE + 0x5a8)
#define RegLZT4_20		 (P_SPU_BASE + 0x5ac)
#define RegLZT4_21		 (P_SPU_BASE + 0x5b0)
#define RegLZT4_22		 (P_SPU_BASE + 0x5b4)
#define RegLZT4_23		 (P_SPU_BASE + 0x5b8)
#define RegLZT4_24		 (P_SPU_BASE + 0x5bc)
#define RegLZT4_25		 (P_SPU_BASE + 0x5c0)
#define RegLZT4_26		 (P_SPU_BASE + 0x5c4)
#define RegLZT4_27		 (P_SPU_BASE + 0x5c8)
#define RegLZT4_28		 (P_SPU_BASE + 0x5cc)
#define RegLZT4_29		 (P_SPU_BASE + 0x5d0)
#define RegLZT4_30		 (P_SPU_BASE + 0x5d4)
#define RegLZT4_31		 (P_SPU_BASE + 0x5d8)
#define RegLZT4_32		 (P_SPU_BASE + 0x5dc)
#define RegLZT0_LMT		 (P_SPU_BASE + 0x5e0)
#define RegLZT1_LMT		 (P_SPU_BASE + 0x5e4)
#define RegLZT2_LMT		 (P_SPU_BASE + 0x5e8)
#define RegLZT3_LMT		 (P_SPU_BASE + 0x5ec)
#define RegLZT4_LMT		 (P_SPU_BASE + 0x5f0)
#define RegLNZ_FX		 (P_SPU_BASE + 0x5f4)
#define RegDLC_C		 (P_SPU_BASE + 0x65c)
#define RegDLC0_R0A		 (P_SPU_BASE + 0x660)
#define RegDLC0_R0B		 (P_SPU_BASE + 0x664)
#define RegDLC0_R1A		 (P_SPU_BASE + 0x668)
#define RegDLC0_R1B		 (P_SPU_BASE + 0x66c)
#define RegDLC0_R2A		 (P_SPU_BASE + 0x670)
#define RegDLC0_R2B		 (P_SPU_BASE + 0x674)
#define RegDLC0_COF		 (P_SPU_BASE + 0x6c0)
#define RegCOLM_C		 (P_SPU_BASE + 0x6d0)
#define RegCOLM_C2		 (P_SPU_BASE + 0x6d4)
#define RegCOLRAM_RAD		 (P_SPU_BASE + 0x6e8)
#define RegCXA00		 (P_SPU_BASE + 0x6ec)
#define RegCXA01		 (P_SPU_BASE + 0x6f0)
#define RegCXA10		 (P_SPU_BASE + 0x6f4)
#define RegCXA11		 (P_SPU_BASE + 0x6f8)
#define RegCXB00		 (P_SPU_BASE + 0x6fc)
#define RegCXB01		 (P_SPU_BASE + 0x700)
#define RegCXB10		 (P_SPU_BASE + 0x704)
#define RegCXB11		 (P_SPU_BASE + 0x708)
#define RegWBC_C		 (P_SPU_BASE + 0x70c)
#define RegSTG_C		 (P_SPU_BASE + 0x710)
#define RegSTG_STP		 (P_SPU_BASE + 0x720)
#define RegSTG_DLD		 (P_SPU_BASE + 0x724)
#define RegSG1T0		 (P_SPU_BASE + 0x728)
#define RegSG1T1		 (P_SPU_BASE + 0x72c)
#define RegSG1T2		 (P_SPU_BASE + 0x730)
#define RegSG1T3		 (P_SPU_BASE + 0x734)
#define RegSG2T0		 (P_SPU_BASE + 0x738)
#define RegSG2T1		 (P_SPU_BASE + 0x73c)
#define RegSG2T2		 (P_SPU_BASE + 0x740)
#define RegSG2T3		 (P_SPU_BASE + 0x744)
#define RegSG3T0		 (P_SPU_BASE + 0x748)
#define RegSG3T1		 (P_SPU_BASE + 0x74c)
#define RegSG3T2		 (P_SPU_BASE + 0x750)
#define RegSG3T3		 (P_SPU_BASE + 0x754)
#define RegSG4T0		 (P_SPU_BASE + 0x758)
#define RegSG4T1		 (P_SPU_BASE + 0x75c)
#define RegSG4T2		 (P_SPU_BASE + 0x760)
#define RegSG4T3		 (P_SPU_BASE + 0x764)
#define RegEFT_L		 (P_SPU_BASE + 0x76c)
#define RegBPR_Mode_Selection		 (P_SPU_BASE + 0x800)
#define RegMedian_Filter_Enable		 (P_SPU_BASE + 0x804)
#define RegG_Channel_Threshold_12		 (P_SPU_BASE + 0x808)
#define RegG_Channel_Threshold_3		 (P_SPU_BASE + 0x80c)
#define RegRB_Channel_Thershold_12		 (P_SPU_BASE + 0x810)
#define RegRB_Channel_Thershold_3		 (P_SPU_BASE + 0x814)
#define RegChannel_Summation_Read_R		 (P_SPU_BASE + 0x818)
#define RegChannel_Summation_Read_G		 (P_SPU_BASE + 0x81c)
#define RegChannel_Summation_Read_B		 (P_SPU_BASE + 0x820)
#define RegCurrent_Pixel_Counter_Read		 (P_SPU_BASE + 0x824)
#define RegNTBBPL		 (P_SPU_BASE + 0x828)
#define RegNBRBPL		 (P_SPU_BASE + 0x82c)
#define RegY_TH		 (P_SPU_BASE + 0x830)
#define RegSlope_a12		 (P_SPU_BASE + 0x834)
#define RegSlope_a34		 (P_SPU_BASE + 0x838)
#define RegSlope_b12		 (P_SPU_BASE + 0x83c)
#define RegSlope_b34		 (P_SPU_BASE + 0x840)
#define RegRB_MinMax		 (P_SPU_BASE + 0x844)
#define RegNormalization_Selection		 (P_SPU_BASE + 0x848)


//---- mix_reg ------------------------------------------------------------
#define RegMIX_ACT             (P_MIX_BASE + 0x0000)
#define RegMIX_MODE            (P_MIX_BASE + 0x0004)
#define RegMIX_EXP_RATIO       (P_MIX_BASE + 0x0008)
#define RegMIX_THR_SHORT       (P_MIX_BASE + 0x000c)
#define RegMIX_ERR_THR         (P_MIX_BASE + 0x0010)
#define RegMIX_DMAR_OFS        (P_MIX_BASE + 0x0014)
#define RegMIX_DMAR_LEN        (P_MIX_BASE + 0x0018)
//#define RegMIX07               (P_MIX_BASE + 0x001c)
//#define RegMIX08               (P_MIX_BASE + 0x0020)
//#define RegMIX09               (P_MIX_BASE + 0x0024)
//#define RegMIX10               (P_MIX_BASE + 0x0028)
#define RegMIX_INT_MASK        (P_MIX_BASE + 0x0040)      // INT_MASK
#define RegMIX_INT_INV         (P_MIX_BASE + 0x0044)      // INT_INV
#define RegMIX_INT_LVLEDGE     (P_MIX_BASE + 0x0048)      // INT_LVLEDGE
#define RegMIX_INT_STATUS      (P_MIX_BASE + 0x004c)      // INT_STATUS
#define RegMIX_INT_UNMASKED    (P_MIX_BASE + 0x0050)      // INT_UNMASKED
#define RegMIX_INT_RAW         (P_MIX_BASE + 0x0054)      // INT_RAW

//---- spb_reg ------------------------------------------------------------
#define RegSPU_ACT             (P_SPB_BASE + 0x0000)
//#define RegSPU_DMAR1_OFS       (P_SPB_BASE + 0x0004)
#define RegSPU_DMAW0_OFS       (P_SPB_BASE + 0x0008)
#define RegSPU_DMAW1_OFS       (P_SPB_BASE + 0x000c)
//#define RegMIX_DMAW_OFS        (P_SPB_BASE + 0x0010)
#define RegSPU_DMAR1_LEN       (P_SPB_BASE + 0x0014)
//#define RegSPU_DMAW0_LEN       (P_SPB_BASE + 0x0018)
#define RegSPU_DMAW1_LEN       (P_SPB_BASE + 0x001c)
#define RegSPU_FLTMODE         (P_SPB_BASE + 0x0020)
#define RegSPU_PROG0           (P_SPB_BASE + 0x0024)
#define RegSPU_PROG1           (P_SPB_BASE + 0x0028)
#define RegSPU_PROG2           (P_SPB_BASE + 0x002c)
#define RegSPU_PROG3           (P_SPB_BASE + 0x0030)
#define RegSPU_PROG4           (P_SPB_BASE + 0x0034)
#define RegAVEVER_MODE_SEL     (P_SPB_BASE + 0x0038)
#define RegAVEVER_W_NUM        (P_SPB_BASE + 0x003c)
#define RegAVEVER_W_SIZE       (P_SPB_BASE + 0x0040)
#define RegAVEVER_MODE2_PARAM0 (P_SPB_BASE + 0x0044)
#define RegAVEVER_MODE2_PARAM1 (P_SPB_BASE + 0x0048)

/////////////////////////////////////////////////////////////////////////////
// EOF

#endif  //  _REG_IMAGEIF_H_
