/**
 * @file   AXMPixcessorIntState.hpp
 * @brief  AXMPixcessor Interruptクラス StateMachineオブジェクトヘッダ
 *
 * @n      PixcessorInt IFクラス
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

  typedef unsigned char   UCHAR;

  /**
   * @enum  pixcessorIntModelState
   * @brief StateMachine用状態定義
   */
  enum pixcessorIntModelState {
    STATUS_RUNNING = 0,                 //!<  動作中
    STATSU_MAX
  };

  /**
   * @enum  pixcessorIntModelEvent
   * @brief StateMachine用イベント定義
   */
  enum pixcessorIntModelEvent {
    PIXCESSORINT_EVENT_FAKE_ISR = AXFEVENT_MODEL(0),        //!<  AXシミュレータ用擬似フレーム完了割り込み
    PIXCESSORINT_EVENT_FAKE_ISR_START = AXFEVENT_MODEL(1),  //!<  AXシミュレータ用擬似フレーム完了割り込み(タイマ開始)
    PIXCESSORINT_EVENT_FAKE_ISR_STOP = AXFEVENT_MODEL(2),   //!<  AXシミュレータ用擬似フレーム完了割り込み(タイマ停止)
    PIXCESSORINT_EVENT_NOTIFY_ISR_DATA = AXFEVENT_MODEL(3), //!<  ImageSensor param 受信
    PIXCESSORINT_EVENT_GET_AF_EVAL =  AXFEVENT_MODEL(4)
  };

  // StateMachine用状態テーブル宣言
  static const AXMPixcessorInt::StateTable state_running[]; //!<  動作中 状態テーブル定義

  // StateMachine用メンバ関数宣言
  /**
   * @brief 擬似フレーム割り込み受信処理を実行する(シミュレータ用)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus funcFrameIsr(const void *pParam, int size);
  /**
   * @brief 擬似フレーム割り込み開始要求を実行する(シミュレータ用)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus funcFrameIsrStart(const void *pParam, int size);
  /**
   * @brief 擬似フレーム割り込み停止要求を実行する(シミュレータ用)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus funcFrameIsrStop(const void *pParam, int size);
  /**
   * @brief 次回センサ設定用データの受信処理を実行する(シミュレータ用)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus funcNotifyIsrData(const void *pParam, int size);
  /**
   * @brief AF評価値の送信処理を実行する(シミュレータ用)
   *
   * @param [in] pParam 受信パラメータ
   * @param [in] size 受信パラメータサイズ
   * @return     実行完了状態(正常終了)
   */
  ax::actorFuncStatus funcGetAfEval(const void* pParam, int size);


  int m_isrcount;
