/*!
    \file    datapath.c
    \brief   the datapath configuration file

*/

#include "lisoc_test.h"
#include "datapath.h"

/*!
    \brief      datapath init
    \param[in]  none
    \param[out] none
    \retval     none
*/
void datapath_init(void)
{
//  LISOC_MIPI_RX->reg_0x000.LINK_P0_RST_N = 0;
//  LISOC_MIPI_RX->reg_0x000.PHYA_RX_PDATA_RESET_N = 0;
//  LISOC_MIPI_RX->reg_0x014.PHYA_RX_IREF_POW_EN = 0;

  // MIPI-Rx configuration
  // reg_field = m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_MODE");
  // reg_field.set(PHYA_RX_MODE);
  #if 0
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("DPHY_P0_MODE_LANENUM").set(DPHY_P0_MODE_LANENUM);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("DPHY_P0_TIME_RES_ON").set(DPHY_P0_TIME_RES_ON);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("APP_P0_CHK_VENA").set(APP_P0_CHK_VENA);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("APP_P0_CHK_HENA").set(APP_P0_CHK_HENA);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("APP_P0_CHK_VSIZE").set(APP_P0_CHK_VSIZE);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("APP_P0_CHK_HSIZE").set(APP_P0_CHK_HSIZE);
  #endif
  LISOC_MIPI_RX->reg_0x118.DPHY_P0_MODE_LANENUM = D_DPHY_P0_MODE_LANENUM;
  #if 0 //??
  LISOC_MIPI_RX->reg_0x120.DPHY_P0_PREG_DLM_0 = 1;
  LISOC_MIPI_RX->reg_0x120.DPHY_P0_PREG_DLM_1 = 0;
  LISOC_MIPI_RX->reg_0x120.DPHY_P0_PREG_DLM_2 = 3;
  LISOC_MIPI_RX->reg_0x120.DPHY_P0_PREG_DLM_3 = 2;
  #endif
  LISOC_MIPI_RX->reg_0x164.DPHY_P0_TIME_RES_ON = D_DPHY_P0_TIME_RES_ON;
  LISOC_MIPI_RX->reg_0x2A0.APP_P0_CHK_VENA = D_APP_P0_CHK_VENA;
  LISOC_MIPI_RX->reg_0x2A0.APP_P0_CHK_HENA = D_APP_P0_CHK_HENA;
  LISOC_MIPI_RX->reg_0x2A4.APP_P0_CHK_VSIZE = D_APP_P0_CHK_VSIZE;
  LISOC_MIPI_RX->reg_0x2A4.APP_P0_CHK_HSIZE = D_APP_P0_CHK_HSIZE;

#ifdef RAW10
  LISOC_MIPI_RX->reg_0xD50_W = 0x1;
  LISOC_MIPI_RX->reg_0xD54_W = 0x00200000;
#else
  LISOC_MIPI_RX->reg_0xD50_W = 0x2;
  LISOC_MIPI_RX->reg_0xD54_W = 0x00400000;
#endif

  //-------Main Mode Setting
  delay_us(1);
  #if 0
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_MODE").set(PHYA_RX_MODE);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("MODE_P0_OPERATION").set(MODE_P0_OPERATION);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("MODE_P0_PIX_PARA").set(MODE_P0_PIX_PARA);
  m_ral_sys_soc_top_block.MIPI_RX.update(status,UVM_FRONTDOOR,.parent(this));
  #endif
  
  LISOC_MIPI_RX->reg_0x004.MODE_P0_OPERATION = D_MODE_P0_OPERATION;
  LISOC_MIPI_RX->reg_0x00C.PHYA_RX_MODE = D_PHYA_RX_MODE;
  LISOC_MIPI_RX->reg_0x010.MODE_P0_PIX_PARA = D_MODE_P0_PIX_PARA;

#if 0
  LISOC_MIPI_RX->reg_0x0AC.MODE_P0_LBL = 1;
  LISOC_MIPI_RX->reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_EN = 1;
  LISOC_MIPI_RX->reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_0 = 1;
  LISOC_MIPI_RX->reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_1 = 1;
  LISOC_MIPI_RX->reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_2 = 1;
  LISOC_MIPI_RX->reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_3 = 1;
#endif

#if 0
  LISOC_MIPI_RX->reg_0x024.PHYA_RX_C0_RES_EN = 1;

  LISOC_MIPI_RX->reg_0x028.PHYA_RX_D0_RES_EN = 1;
  LISOC_MIPI_RX->reg_0x028.PHYA_RX_D1_RES_EN = 1;
  LISOC_MIPI_RX->reg_0x028.PHYA_RX_D2_RES_EN = 1;
  LISOC_MIPI_RX->reg_0x028.PHYA_RX_D3_RES_EN = 1;

  //LISOC_MIPI_RX->reg_0x0A8.PHYA_RX_LP_LH = 200;
  //LISOC_MIPI_RX->reg_0x0A8.PHYA_RX_LP_HL = 200;
  //LISOC_MIPI_RX->reg_0x0A8.PHYA_RX_OFFSET = 200;
  //LISOC_MIPI_RX->reg_0x088.PHYA_RX_VRMSEL = 1;
  //LISOC_MIPI_RX->reg_0x088.PHYA_RX_IRMSEL = 1;
  LISOC_MIPI_RX->reg_0x034.PHYA_RX_RESCTL = 1;
#endif

  //-------Link Layer Reset
  delay_us(20);
  #if 0
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("LINK_P0_RST_N").set(LINK_P0_RST_N);
  m_ral_sys_soc_top_block.MIPI_RX.update(status,UVM_FRONTDOOR,.parent(this));
  #endif
  
  LISOC_MIPI_RX->reg_0x000.LINK_P0_RST_N = D_LINK_P0_RST_N;

  //-------Power Down for PHYA
  delay_us(1);
  #if 0
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_IREF_POW_EN").set(PHYA_RX_IREF_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.update(status,UVM_FRONTDOOR,.parent(this));
  #endif
  
  LISOC_MIPI_RX->reg_0x014.PHYA_RX_IREF_POW_EN = D_PHYA_RX_IREF_POW_EN;

  delay_us(20);
  #if 0
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D0_HS_AMP_POW_EN").set(PHYA_RX_D0_HS_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D1_HS_AMP_POW_EN").set(PHYA_RX_D1_HS_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D2_HS_AMP_POW_EN").set(PHYA_RX_D2_HS_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D3_HS_AMP_POW_EN").set(PHYA_RX_D3_HS_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_C0_HS_AMP_POW_EN").set(PHYA_RX_C0_HS_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D0_LP_AMP_POW_EN").set(PHYA_RX_D0_LP_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D1_LP_AMP_POW_EN").set(PHYA_RX_D1_LP_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D2_LP_AMP_POW_EN").set(PHYA_RX_D2_LP_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_D3_LP_AMP_POW_EN").set(PHYA_RX_D3_LP_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.get_field_by_name("PHYA_RX_C0_LP_AMP_POW_EN").set(PHYA_RX_C0_LP_AMP_POW_EN);
  m_ral_sys_soc_top_block.MIPI_RX.update(status,UVM_FRONTDOOR,.parent(this));
  #endif

  LISOC_MIPI_RX->reg_0x018.PHYA_RX_C0_LP_AMP_POW_EN = D_PHYA_RX_C0_LP_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x018.PHYA_RX_C0_HS_AMP_POW_EN = D_PHYA_RX_C0_HS_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x01C.PHYA_RX_D3_LP_AMP_POW_EN = D_PHYA_RX_D3_LP_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x01C.PHYA_RX_D2_LP_AMP_POW_EN = D_PHYA_RX_D2_LP_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x01C.PHYA_RX_D1_LP_AMP_POW_EN = D_PHYA_RX_D1_LP_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x01C.PHYA_RX_D0_LP_AMP_POW_EN = D_PHYA_RX_D0_LP_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x020.PHYA_RX_D3_HS_AMP_POW_EN = D_PHYA_RX_D3_HS_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x020.PHYA_RX_D2_HS_AMP_POW_EN = D_PHYA_RX_D2_HS_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x020.PHYA_RX_D1_HS_AMP_POW_EN = D_PHYA_RX_D1_HS_AMP_POW_EN;
  LISOC_MIPI_RX->reg_0x020.PHYA_RX_D0_HS_AMP_POW_EN = D_PHYA_RX_D0_HS_AMP_POW_EN;
//#100;
  delay_us(20);


  // CCHG configuration
  #if 0
  wr_val = {4'd0, CCHG_V_SIZE, 2'd0, CCHG_H_SIZE};
  m_ral_sys_soc_top_block.CCHG.addr_0x04.set(wr_val);
  wr_val = {4'd0, V_VALID_SIZE, 2'd0, H_VALID_SIZE};
  m_ral_sys_soc_top_block.CCHG.addr_0x08.set(wr_val);
  wr_val = {21'd0, BANK_CYCLE};
  m_ral_sys_soc_top_block.CCHG.addr_0x10.set(wr_val);
  m_ral_sys_soc_top_block.CCHG.update(status,UVM_FRONTDOOR,.parent(this));
  #endif
  LISOC_CCHG->reg_0x04.V_SIZE = D_CCHG_V_SIZE;
  LISOC_CCHG->reg_0x04.H_SIZE = D_CCHG_H_SIZE;
  LISOC_CCHG->reg_0x08.V_VALID_SIZE = D_V_VALID_SIZE;
  LISOC_CCHG->reg_0x08.H_VALID_SIZE = D_H_VALID_SIZE;
  LISOC_CCHG->reg_0x10.BANK_CYCLE = D_BANK_CYCLE;


  // ISP configuration
  #if 0
  wr_val = {4'd0, NUM_ROW, 3'd0, NUM_COL};
  m_ral_sys_soc_top_block.ISP.addr_0x00.set(wr_val);
  wr_val = {14'd0, BIT_MODE, THROUGH_MODE, 14'd0, BAYER_PATTERN};
  m_ral_sys_soc_top_block.ISP.addr_0x04.set(wr_val);
  wr_val = {OB_B_SUB, OB_GB_SUB, OB_GR_SUB, OB_R_SUB};
  m_ral_sys_soc_top_block.ISP.addr_0x08.set(wr_val);
  wr_val = {24'd0, TOTAL_GAIN};
  m_ral_sys_soc_top_block.ISP.addr_0x0C.set(wr_val);
  wr_val = {4'd0, WB_B_GAIN ,4'd0, WB_R_GAIN};
  m_ral_sys_soc_top_block.ISP.addr_0x10.set(wr_val);
  wr_val = {29'd0, GAMMA_FACTOR};
  m_ral_sys_soc_top_block.ISP.addr_0x14.set(wr_val);
  wr_val = {APERTURE_V, APERTURE_H, 4'd0, APERTURE_TH};
  m_ral_sys_soc_top_block.ISP.addr_0x18.set(wr_val);
  wr_val = {MATRIX_B_Y_G2, MATRIX_B_Y_G1, MATRIX_R_Y_G2, MATRIX_R_Y_G1};
  m_ral_sys_soc_top_block.ISP.addr_0x1C.set(wr_val);
  wr_val = {16'd0, Y_OUT_OFFSET, Y_OUT_GAIN};
  m_ral_sys_soc_top_block.ISP.addr_0x20.set(wr_val);
  wr_val = {24'd0, PSEUDO_SUPPRESS};
  m_ral_sys_soc_top_block.ISP.addr_0x24.set(wr_val);
  wr_val = {2'd0, AE_AWB_ROW, 2'd0, AE_AWB_COL, 9'd0, AE_AWB_UNIT};
  m_ral_sys_soc_top_block.ISP.addr_0x28.set(wr_val);
  wr_val = {16'd0, V_IN_OFFSET, H_IN_OFFSET};
  m_ral_sys_soc_top_block.ISP.addr_0x2C.set(wr_val);
  wr_val = {VS_WIDTH, HS_WIDTH, V_OUT_OFFSET, H_OUT_OFFSET};
  m_ral_sys_soc_top_block.ISP.addr_0x30.set(wr_val);
  wr_val = {4'd0, V_SIZE, 3'd0, H_SIZE};
  m_ral_sys_soc_top_block.ISP.addr_0x34.set(wr_val);
  wr_val = {4'd0, V_OUT_SIZE, 3'd0, H_OUT_SIZE};
  m_ral_sys_soc_top_block.ISP.addr_0x38.set(wr_val);
  wr_val = {4'd0, V_FR_BLK, 3'd0, H_FR_BLK};
  m_ral_sys_soc_top_block.ISP.addr_0x3C.set(wr_val);
  m_ral_sys_soc_top_block.ISP.update(status,UVM_FRONTDOOR,.parent(this));
  #endif
  
  LISOC_ISP->reg_0x00.NUM_ROW = D_NUM_ROW;
  LISOC_ISP->reg_0x00.NUM_COL = D_NUM_COL;
  
  LISOC_ISP->reg_0x04.BIT_MODE = D_BIT_MODE;
  LISOC_ISP->reg_0x04.THROUGH_MODE = D_THROUGH_MODE;
  LISOC_ISP->reg_0x04.BAYER_PATTERN = D_BAYER_PATTERN;
  
  LISOC_ISP->reg_0x08.OB_B_SUB = D_OB_B_SUB;
  LISOC_ISP->reg_0x08.OB_GB_SUB = D_OB_GB_SUB;
  LISOC_ISP->reg_0x08.OB_GR_SUB = D_OB_GR_SUB;
  LISOC_ISP->reg_0x08.OB_R_SUB = D_OB_R_SUB;
  
  LISOC_ISP->reg_0x0C.TOTAL_GAIN = D_TOTAL_GAIN;
  
  LISOC_ISP->reg_0x10.WB_B_GAIN = D_WB_B_GAIN;
  LISOC_ISP->reg_0x10.WB_R_GAIN = D_WB_R_GAIN;
  
  LISOC_ISP->reg_0x14.GAMMA_FACTOR = D_GAMMA_FACTOR;
  
  LISOC_ISP->reg_0x18.APERTURE_V = D_APERTURE_V;
  LISOC_ISP->reg_0x18.APERTURE_H = D_APERTURE_H;
  LISOC_ISP->reg_0x18.APERTURE_TH = D_APERTURE_TH;
  
  LISOC_ISP->reg_0x1C.MATRIX_B_Y_G2 = D_MATRIX_B_Y_G2;
  LISOC_ISP->reg_0x1C.MATRIX_B_Y_G1 = D_MATRIX_B_Y_G1;
  LISOC_ISP->reg_0x1C.MATRIX_R_Y_G2 = D_MATRIX_R_Y_G2;
  LISOC_ISP->reg_0x1C.MATRIX_R_Y_G1 = D_MATRIX_R_Y_G1;
  
  LISOC_ISP->reg_0x20.Y_OUT_OFFSET = D_Y_OUT_OFFSET;
  LISOC_ISP->reg_0x20.Y_OUT_GAIN = D_Y_OUT_GAIN;
  
  LISOC_ISP->reg_0x24.PSEUDO_SUPPRESS = D_PSEUDO_SUPPRESS;
  
  LISOC_ISP->reg_0x28.AE_AWB_ROW = D_AE_AWB_COL;
  LISOC_ISP->reg_0x28.AE_AWB_COL = D_AE_AWB_ROW;
  LISOC_ISP->reg_0x28.AE_AWB_UNIT = D_AE_AWB_UNIT;
  
  LISOC_ISP->reg_0x2C.V_IN_OFFSET = D_V_IN_OFFSET;
  LISOC_ISP->reg_0x2C.H_IN_OFFSET = D_H_IN_OFFSET;
  
  LISOC_ISP->reg_0x30.VS_WIDTH = D_VS_WIDTH;
  LISOC_ISP->reg_0x30.HS_WIDTH = D_HS_WIDTH;
  LISOC_ISP->reg_0x30.V_OUT_OFFSET = D_V_OUT_OFFSET;
  LISOC_ISP->reg_0x30.H_OUT_OFFSET = D_H_OUT_OFFSET;
  
  LISOC_ISP->reg_0x34.V_SIZE = D_V_SIZE;
  LISOC_ISP->reg_0x34.H_SIZE = D_H_SIZE;
  
  LISOC_ISP->reg_0x38.V_OUT_SIZE = D_V_OUT_SIZE;
  LISOC_ISP->reg_0x38.H_OUT_SIZE = D_H_OUT_SIZE;
  
  LISOC_ISP->reg_0x3C.V_FR_BLK = D_V_FR_BLK;
  LISOC_ISP->reg_0x3C.H_FR_BLK = D_H_FR_BLK;

  //LISR configuration
  #if 0
  wr_val = {IN_SEL, 1'd0, IN_FORM, 1'd0, IN_FRATE, IN_HSIZE, IN_VSIZE};
  m_ral_sys_soc_top_block.LISR.addr_0x00.set(wr_val);
  wr_val = {INH_SD, SD_MODE, 2'd0, SD_HSIZE, 4'd0, SD_VSIZE};
  m_ral_sys_soc_top_block.LISR.addr_0x04.set(wr_val);
  wr_val = {OUT_RESO, OUT_FRATE, OUT_I_P, AHE_BLKSIZ, 2'd0, CROP_HOFF, CROP_VOFF};
  m_ral_sys_soc_top_block.LISR.addr_0x0c.set(wr_val);
  wr_val = {22'd0, AHE_ON, VIDEO_ON, 1'd0, OUT_FORM, 2'd0, OUT_THRU, OUT_DISP_ON};
  m_ral_sys_soc_top_block.LISR.addr_0x18.set(wr_val);
  wr_val = {20'd0, AHE_HWIDTH};
  m_ral_sys_soc_top_block.LISR.addr_0x20.set(wr_val);
  wr_val = {20'd0, AHE_VWIDTH};
  m_ral_sys_soc_top_block.LISR.addr_0x28.set(wr_val);
  wr_val = {27'd0, AHEF_ON, 1'd0, UVENHON, MOVESW};
  m_ral_sys_soc_top_block.LISR.addr_0x3c.set(wr_val);
  wr_val = {24'd0, ALPHA_AHE};
  m_ral_sys_soc_top_block.LISR.addr_0x40.set(wr_val);
  m_ral_sys_soc_top_block.LISR.update(status,UVM_FRONTDOOR,.parent(this));
  #endif
  #if 1
  LISOC_LISR->reg_0x00.IN_SEL = D_IN_SEL;
  LISOC_LISR->reg_0x00.IN_FORM = D_IN_FORM;
  LISOC_LISR->reg_0x00.IN_FRATE = D_IN_FRATE;
  LISOC_LISR->reg_0x00.IN_HSIZE = D_IN_HSIZE;
  LISOC_LISR->reg_0x00.IN_VSIZE = D_IN_VSIZE;

  LISOC_LISR->reg_0x04.INH_SD = D_INH_SD;
  LISOC_LISR->reg_0x04.SD_MODE = D_SD_MODE;
  LISOC_LISR->reg_0x04.SD_HSIZE = D_SD_HSIZE;
  LISOC_LISR->reg_0x04.SD_VSIZE = D_SD_VSIZE;
  
  LISOC_LISR->reg_0x0c.OUT_RESO = D_OUT_RESO;
  LISOC_LISR->reg_0x0c.OUT_FRATE = D_OUT_FRATE;
  LISOC_LISR->reg_0x0c.OUT_I_P = D_OUT_I_P;
  LISOC_LISR->reg_0x0c.AHE_BLKSIZ = D_AHE_BLKSIZ;
  LISOC_LISR->reg_0x0c.CROP_HOFF = D_CROP_HOFF;
  LISOC_LISR->reg_0x0c.CROP_VOFF = D_CROP_VOFF;

  LISOC_LISR->reg_0x18.AHE_ON = D_AHE_ON;
  LISOC_LISR->reg_0x18.VIDEO_ON = D_VIDEO_ON;
  LISOC_LISR->reg_0x18.OUT_FORM = D_OUT_FORM;
  LISOC_LISR->reg_0x18.OUT_THRU = D_OUT_THRU;
  LISOC_LISR->reg_0x18.OUT_DISP_ON = D_OUT_DISP_ON;

  LISOC_LISR->reg_0x20.AHE_HWIDH = D_AHE_HWIDTH;
  LISOC_LISR->reg_0x28.AHE_VWIDH = D_AHE_VWIDTH;

  LISOC_LISR->reg_0x3c.AHEF_ON = D_AHEF_ON;
  LISOC_LISR->reg_0x3c.UVENHON = D_UVENHON;
  LISOC_LISR->reg_0x3c.MOVESW = D_MOVESW;

  LISOC_LISR->reg_0x40.ALPHA_AHE = D_ALPHA_AHE;

  #endif


  // MIPI-TX configuration
  #if 0
  wr_val = {32'hF1F1_F1F1};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x014.write(status,wr_val,UVM_FRONTDOOR);
  
  wr_val = reg_0x04;
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x4.write(status,wr_val,UVM_FRONTDOOR);
  
  wr_val = {{2'b0, DPHY_P0_TX_LP11, 2'h0, DPHY_P0_TX_LP10,2'b0,DPHY_P0_TX_LP01,2'b0,DPHY_P0_TX_LP00,3'b0,CSI2_P0_TX_TC,3'b0,CSI2_P0_TX_TS,5'b0,MODE_LANENUM}};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x030.write(status,wr_val,UVM_FRONTDOOR);
  
  wr_val = {{2'h0, DPHY_P0_TX_TIME_T_CLK_PRE, 1'h0, DPHY_P0_TX_TIME_T_CLK_ZERO, 2'h0, DPHY_P0_TX_TIME_T_CLK_PREPARE, 2'h0, DPHY_P0_TX_TIME_T_LPX }};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x034.write(status,wr_val,UVM_FRONTDOOR);
  
  wr_val = {{2'h0, DPHY_P0_TX_TIME_T_HS_EOT, 2'h0, DPHY_P0_TX_TIME_T_HS_SOT, 2'h0, DPHY_P0_TX_TIME_T_HS_ZERO, 2'h0, DPHY_P0_TX_TIME_T_HS_PREPARE}};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x038.write(status,wr_val,UVM_FRONTDOOR);
  
  wr_val = {{18'h0, DPHY_P0_TX_TIME_T_CLK_EOT, 2'h0, DPHY_P0_TX_TIME_T_CLK_POST}};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x03C.write(status,wr_val,UVM_FRONTDOOR);
  #endif


  LISOC_MIPI_TX->reg_0x014_W = 0xF1F1F1F1;

  LISOC_MIPI_TX->reg_0x004.PHYA_PLL_PDIV  = D_PHYA_PLL_PDIV; // Input reference clock divider: Divider ratio = D_(PDIV + 1)
  LISOC_MIPI_TX->reg_0x004.PHYA_PLL_N1DIV = D_PHYA_PLL_N1DIV; // High Speed Feedback clock divider: Divider ratio: 1/2/4/8
  LISOC_MIPI_TX->reg_0x004.PHYA_PLL_N2DIV = D_PHYA_PLL_N2DIV; // Feedback clock divider: Divider ratio = D_(N2DIV + 1)
  LISOC_MIPI_TX->reg_0x004.PHYA_PLL_K1DIV = D_PHYA_PLL_K1DIV; // Output clock divider for CLK_P/N_O : Divider ratio : 1/2/4/8
  LISOC_MIPI_TX->reg_0x004.PHYA_PLL_K2DIV = D_PHYA_PLL_K2DIV; // Output clock divider-1 for LS_CLK_O : Divider ratio : 1/2/4/8
  LISOC_MIPI_TX->reg_0x004.PHYA_PLL_K3DIV = D_PHYA_PLL_K3DIV; // Output clock divider-2 for LS_CLK_O : Divider ratio = D_(K3DIV + 1)
#if 1
#if 1// 1.485 ghz
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_CHP_TRIM = 0x14;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_KVCO_TRIM = 0x7;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_OSC_SEL = 0x3;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_V2I_OFFSET = 0x3;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_OSC_CLMP_DIS = 0x0;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_VCO_IGAIN = 0xA;
  LISOC_MIPI_TX->reg_0x00C.PHYA_ZUP = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_ZDN = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_VRM = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_IRM = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_POL_SCK = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_CK_EDG = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_PLL_LPF_CSEL = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_PLL_LPF_RSEL = 0x1;
  LISOC_MIPI_TX->reg_0x00C.PHYA_PLL_LPE_SEL_3ORD = 0x0;
#else
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_CHP_TRIM = 0x13;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_KVCO_TRIM = 0x7;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_OSC_SEL = 0x3;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_V2I_OFFSET = 0x3;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_OSC_CLMP_DIS = 0x0;
  LISOC_MIPI_TX->reg_0x008.PHYA_PLL_VCO_IGAIN = 0xD;
  LISOC_MIPI_TX->reg_0x00C.PHYA_ZUP = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_ZDN = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_VRM = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_IRM = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_POL_SCK = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_CK_EDG = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_PLL_LPF_CSEL = 0x0;
  LISOC_MIPI_TX->reg_0x00C.PHYA_PLL_LPF_RSEL = 0x1;
  LISOC_MIPI_TX->reg_0x00C.PHYA_PLL_LPE_SEL_3ORD = 0x0;
#endif
#endif

  LISOC_MIPI_TX->reg_0x030.DPHY_P0_TX_LP11 = D_DPHY_P0_TX_LP11;
  LISOC_MIPI_TX->reg_0x030.DPHY_P0_TX_LP10 = D_DPHY_P0_TX_LP10;
  LISOC_MIPI_TX->reg_0x030.DPHY_P0_TX_LP01 = D_DPHY_P0_TX_LP01;
  LISOC_MIPI_TX->reg_0x030.DPHY_P0_TX_LP00 = D_DPHY_P0_TX_LP00;
  LISOC_MIPI_TX->reg_0x030.CSI2_P0_TX_TC = D_CSI2_P0_TX_TC;
  LISOC_MIPI_TX->reg_0x030.CSI2_P0_TX_TS = D_CSI2_P0_TX_TS;
  LISOC_MIPI_TX->reg_0x100.MODE_LANENUM = D_MODE_LANENUM;//The address of the es2 register has changed
  
  LISOC_MIPI_TX->reg_0x034.DPHY_P0_TX_TIME_T_CLK_PRE = D_DPHY_P0_TX_TIME_T_CLK_PRE;
  LISOC_MIPI_TX->reg_0x034.DPHY_P0_TX_TIME_T_CLK_ZERO = D_DPHY_P0_TX_TIME_T_CLK_ZERO;
  LISOC_MIPI_TX->reg_0x034.DPHY_P0_TX_TIME_T_CLK_PREPARE = D_DPHY_P0_TX_TIME_T_CLK_PREPARE;
  LISOC_MIPI_TX->reg_0x034.DPHY_P0_TX_TIME_T_CLK_LPX = D_DPHY_P0_TX_TIME_T_LPX;
  
  LISOC_MIPI_TX->reg_0x038.DPHY_P0_TX_TIME_T_HS_EOT = D_DPHY_P0_TX_TIME_T_HS_EOT;
  LISOC_MIPI_TX->reg_0x038.DPHY_P0_TX_TIME_T_HS_SOT = D_DPHY_P0_TX_TIME_T_HS_SOT;
  LISOC_MIPI_TX->reg_0x038.DPHY_P0_TX_TIME_T_HS_ZERO = D_DPHY_P0_TX_TIME_T_HS_ZERO;
  LISOC_MIPI_TX->reg_0x038.DPHY_P0_TX_TIME_T_HS_PREPARE = D_DPHY_P0_TX_TIME_T_HS_PREPARE;
  
  LISOC_MIPI_TX->reg_0x03C.DPHY_P0_TX_TIME_T_CLK_EOT = D_DPHY_P0_TX_TIME_T_CLK_EOT;
  LISOC_MIPI_TX->reg_0x03C.DPHY_P0_TX_TIME_T_CLK_POST = D_DPHY_P0_TX_TIME_T_CLK_POST;
  LISOC_MIPI_TX->reg_0x03C.DPHY_P0_TX_TIME_T_WAKEUP = D_DPHY_P0_TX_TIME_T_WAKEUP;//Newly added registers in ES2
#if 0
  LISOC_MIPI_TX->reg_0x00C.PHYA_ZUP = 1;
  LISOC_MIPI_TX->reg_0x00C.PHYA_ZDN = 1;

  LISOC_MIPI_TX->reg_0x018.PHYA_CK_DLY = 100;
  LISOC_MIPI_TX->reg_0x018.PHYA_D0_DLY = 100;
  LISOC_MIPI_TX->reg_0x018.PHYA_D1_DLY = 100;
  LISOC_MIPI_TX->reg_0x018.PHYA_D2_DLY = 100;
  LISOC_MIPI_TX->reg_0x018.PHYA_D3_DLY = 100;
#endif
//#100;
  delay_us(1);

  // Intentionally, place MIPI-RX reset release after CCHG/ISP configuration
  #if 0
  wr_val = {32'h0000_0101};
  m_ral_sys_soc_top_block.MIPI_RX.addr_0x0.set(wr_val);
  m_ral_sys_soc_top_block.MIPI_RX.update(status,UVM_FRONTDOOR,.parent(this));

  wr_val = {{32'h0111_1111}};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x0.write(status,wr_val,UVM_FRONTDOOR);

  wr_val = {{32'h0000_00F1}};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x010.write(status,wr_val,UVM_FRONTDOOR);
  #endif

  LISOC_MIPI_RX->reg_0x000.LINK_P0_RST_N = 1;
  LISOC_MIPI_RX->reg_0x000.PHYA_RX_PDATA_RESET_N = 1;

  LISOC_MIPI_TX->reg_0x000_W = 0x01111111;
  LISOC_MIPI_TX->reg_0x010_W = 0x000000F1;

}


