/*!
    \file    gpio.c
    \brief   the gpio configuration file

*/

#include "lisoc_test.h"
#include "gpio.h"

/*!
    \brief      gpioa_setPinDreict
    \param[in]  gpio_num
                in_out
    \param[out] none
    \retval     none
*/
void gpioa_setPinDreict(uint8_t gpio_num, uint8_t in_out)
{
    // configure pada function to GPIOA
    if(gpio_num < PA15)
    {
      SYSC_GPIOA_AFR &= ~(0x3 << (gpio_num << 1));
      SYSC_GPIOA_AFR |= (0x01 << (gpio_num << 1));
    }
    else
    {
      SYSC_GPIOA_AFR &= ~(0x3 << (gpio_num << 1));
    }

    if(in_out)
    {
      // configure pada as output enable
      SYSC_GPIOA_OER |= 0x1 << gpio_num;

      /*pada  output*/
      GPIOA_PADDR |= 0x1 << gpio_num;
    }
    else
    {
      // configure pada as output disable
      SYSC_GPIOA_OER &= ~(0x1 << gpio_num);

      /*pada  intput*/
      GPIOA_PADDR &= ~(0x1 << gpio_num);
    }
}

/*!
    \brief      gpiob_setPinDreict
    \param[in]  gpio_num
                in_out
    \param[out] none
    \retval     none
*/
void gpiob_setPinDreict(uint8_t gpio_num, uint8_t in_out)
{
    // configure pada function to GPIOA
    if(gpio_num < PB6)
    {
      SYSC_GPIOB_AFR &= ~(0x3 << (gpio_num << 1));
      SYSC_GPIOB_AFR |= (0x01 << (gpio_num << 1));
    }
    else
    {
      SYSC_GPIOB_AFR &= ~(0x3 << (gpio_num << 1));
    }

    if(in_out)
    {
      // configure pada as output enable
      SYSC_GPIOB_OER |= 0x1 << gpio_num;

      /*pada  output*/
      GPIOB_PADDR |= 0x1 << gpio_num;
    }
    else
    {
      // configure pada as output disable
      SYSC_GPIOB_OER &= ~(0x1 << gpio_num);

      /*pada  input*/
      GPIOB_PADDR &= ~(0x1 << gpio_num);
    }
}

/*!
    \brief      gpio_out
    \param[in]  gpio_num
                on_off
    \param[out] none
    \retval     none
*/
void gpioa_out(uint8_t gpio_num, uint8_t on_off)
{
  if (on_off) {
    GPIOA_PADR  |= 1u << gpio_num;
  }
  else {
    GPIOA_PADR  &= ~(1u << gpio_num);
  }
}

/*!
    \brief      gpio_out
    \param[in]  gpio_num
                on_off
    \param[out] none
    \retval     none
*/
void gpiob_out(uint8_t gpio_num, uint8_t on_off)
{
  if (on_off) {
    GPIOB_PADR  |= 1u << gpio_num;
  }
  else {
    GPIOB_PADR  &= ~(1u << gpio_num);
  }
}

/*!
    \brief      gpioa_readOutput
    \param[in]  gpio num
    \param[out] pin status
    \retval     none
*/
uint8_t gpioa_readOutput(uint8_t gpio_num)
{
  return (uint8_t)((GPIOA_PADR >> gpio_num) & 0x1);
}

/*!
    \brief      gpiob_readOutput
    \param[in]  gpio num
    \param[out] pin status
    \retval     none
*/
uint8_t gpiob_readOutput(uint8_t gpio_num)
{
  return (uint8_t)((GPIOB_PADR >> gpio_num) & 0x1);
}

/*!
    \brief      gpioa_readInput
    \param[in]  gpio num
    \param[out] pin status
    \retval     none
*/
uint8_t gpioa_readInput(uint8_t gpio_num)
{
  return (uint8_t)((GPIOA_EXTDR >> gpio_num) & 0x1);
}

/*!
    \brief      gpiob_readInput
    \param[in]  gpio num
    \param[out] pin status
    \retval     none
*/
uint8_t gpiob_readInput(uint8_t gpio_num)
{
  return (uint8_t)((GPIOB_EXTDR >> gpio_num) & 0x1);
}

/*!
    \brief      gpioa_IntEn
    \param[in]  gpio num
    \param[out] none
    \retval     none
*/
void gpioa_IntEn(uint8_t gpio_num)
{
  GPIOA_INTEN |= 1 << gpio_num;
}

/*!
    \brief      gpioa_IntDisable
    \param[in]  gpio num
    \param[out] none
    \retval     none
*/
void gpioa_IntDisable(uint8_t gpio_num)
{
  GPIOA_INTEN &= ~(1 << gpio_num);
}

/*!
    \brief      gpiob_IntEn
    \param[in]  gpio num
    \param[out] none
    \retval     none
*/
void gpiob_IntEn(uint8_t gpio_num)
{
  GPIOB_INTEN |= 1 << gpio_num;
}

/*!
    \brief      gpiob_IntDisable
    \param[in]  gpio num
    \param[out] none
    \retval     none
*/
void gpiob_IntDisable(uint8_t gpio_num)
{
  GPIOB_INTEN &= ~(1 << gpio_num);
}


/*!
    \brief      gpioa_SetIntType
    \param[in]  gpio num
                interrupt type--0:level sensitive 1:edge sensitive
    \param[out] none
    \retval     none
*/
void gpioa_SetIntType(uint8_t gpio_num, uint8_t int_type)
{
  if(int_type)
  {
    GPIOA_INTTYPE_LEVEL |= 1u << gpio_num;
  }
  else
  {
    GPIOA_INTTYPE_LEVEL &= ~(1u << gpio_num);
  }
}

/*!
    \brief      gpiob_SetIntType
    \param[in]  gpio num
                interrupt type--0:level sensitive 1:edge sensitive
    \param[out] none
    \retval     none
*/
void gpiob_SetIntType(uint8_t gpio_num, uint8_t int_type)
{
  if(int_type)
  {
    GPIOB_INTTYPE_LEVEL |= 1u << gpio_num;
  }
  else
  {
    GPIOB_INTTYPE_LEVEL &= ~(1u << gpio_num);
  }
}

/*!
    \brief      gpiob_SetIntPolarity
    \param[in]  gpio num
                interrupt polarity--0:low polarity 1:high polarity
    \param[out] none
    \retval     none
*/
void gpioa_SetIntPolarity(uint8_t gpio_num, uint8_t int_polarity)
{
  if(int_polarity)
  {
    GPIOA_INT_POLARITY |= 1u << gpio_num;
  }
  else
  {
    GPIOA_INT_POLARITY &= ~(1u << gpio_num);
  }
}

/*!
    \brief      gpiob_SetIntPolarity
    \param[in]  gpio num
                interrupt polarity--0:low polarity 1:high polarity
    \param[out] none
    \retval     none
*/
void gpiob_SetIntPolarity(uint8_t gpio_num, uint8_t int_polarity)
{
  if(int_polarity)
  {
    GPIOB_INT_POLARITY |= 1u << gpio_num;
  }
  else
  {
    GPIOB_INT_POLARITY &= ~(1u << gpio_num);
  }
}

/*!
    \brief      gpioa_ClerIntSts
    \param[in]  gpio num
    \param[out] none
    \retval     none
*/
void gpioa_ClerIntSts(uint8_t gpio_num)
{
  GPIOA_EOI |= 1 << gpio_num;
}

/*!
    \brief      gpiob_ClerIntSts
    \param[in]  gpio num
    \param[out] none
    \retval     none
*/
void gpiob_ClerIntSts(uint8_t gpio_num)
{
  GPIOB_EOI |= 1 << gpio_num;
}

/*!
    \brief      gpioa_GetIntSts
    \param[in]  none
    \param[out] gpioa interrupt status
    \retval     none
*/
uint32_t gpioa_GetIntSts(void)
{
  return GPIOA_INTSTATUS;
}

/*!
    \brief      gpiob_GetIntSts
    \param[in]  none
    \param[out] gpioa interrupt status
    \retval     none
*/
uint32_t gpiob_GetIntSts(void)
{
  return GPIOB_INTSTATUS;
}

