/*!
    \file    gpio.h
    \brief   the header file of gpio

*/

#ifndef _GPIO_H_
#define _GPIO_H_

#define PA0                         0U
#define PA1                         1U
#define PA2                         2U
#define PA3                         3U
#define PA4                         4U
#define PA5                         5U
#define PA6                         6U
#define PA7                         7U
#define PA8                         8U
#define PA9                         9U
#define PA10                        10U
#define PA11                        11U
#define PA12                        12U
#define PA13                        13U
#define PA14                        14U
#define PA15                        15U

#define PB0                         0U
#define PB1                         1U
#define PB2                         2U
#define PB3                         3U
#define PB4                         4U
#define PB5                         5U
#define PB6                         6U
#define PB7                         7U
#define PB8                         8U
#define PB9                         9U
#define PB10                        10U
#define PB11                        11U
#define PB12                        12U
#define PB13                        13U
#define PB14                        14U
#define PB15                        15U

#define GPIO_IN                     0u
#define GPIO_OUT                    1u
#define GPIO_LOW                    0u
#define GPIO_HIGH                   1u

/* gpio A pin-name list */

/* gpio B pin-name list */
#define GPIOB_QSPI_CS_OUT             1U
#define GPIOB_LED_OUT                 7U

#define GPIOB_SPI_CS_OUT              13U

/*!
    \brief      PB1_SetToSSICsMode
    \param[in]  none
    \param[out] none
    \retval     none
*/
__INLINE void PB1_SetToSSICsMode(void)
{
  SYSC_GPIOB_AFR = (SYSC_GPIOB_AFR & (~((uint32_t)0x03 << 2)));
}

/*!
    \brief      gpiob_SetSPIMode
    \param[in]  none
    \param[out] none
    \retval     none
*/
__INLINE void gpiob_SetSPIMode(void)
{
  /* set PB12~PB15 spi function pin */
  SYSC_GPIOB_AFR |= (0x55<<24);
}

/*!
    \brief      gpioa_SetSPIMode
    \param[in]  none
    \param[out] none
    \retval     none
*/
__INLINE void gpioa_SetSPIMode(void)
{
  /* set PA11~PA14 spi function pin */
  SYSC_GPIOA_AFR &= ~(0x55<<22);
}

void gpioa_setPinDreict(uint8_t gpio_num, uint8_t in_out);
void gpiob_setPinDreict(uint8_t gpio_num, uint8_t in_out);
void gpioa_out(uint8_t gpio_num, uint8_t on_off);
void gpiob_out(uint8_t gpio_num, uint8_t on_off);
uint8_t gpioa_readOutput(uint8_t gpio_num);
uint8_t gpiob_readOutput(uint8_t gpio_num);
uint8_t gpioa_readInput(uint8_t gpio_num);
uint8_t gpiob_readInput(uint8_t gpio_num);
void gpioa_IntEn(uint8_t gpio_num);
void gpioa_IntDisable(uint8_t gpio_num);
void gpiob_IntEn(uint8_t gpio_num);
void gpiob_IntDisable(uint8_t gpio_num);
void gpioa_SetIntType(uint8_t gpio_num, uint8_t int_type);
void gpiob_SetIntType(uint8_t gpio_num, uint8_t int_type);
void gpioa_SetIntPolarity(uint8_t gpio_num, uint8_t int_polarity);
void gpiob_SetIntPolarity(uint8_t gpio_num, uint8_t int_polarity);
void gpioa_ClerIntSts(uint8_t gpio_num);
void gpiob_ClerIntSts(uint8_t gpio_num);
uint32_t gpioa_GetIntSts(void);
uint32_t gpiob_GetIntSts(void);


#endif  /* _GPIO_H */
