/*!
    \file    i2c.h
    \brief   the header file of i2c

*/

#ifndef _I2C_H_
#define _I2C_H_

#define INA226_ID           0x2260
#define ID_REG              0xFF  //reg addr
#define INA226_ADDR         0x45

#define SPEED_STAND   1
#define SPEED_FAST    2
#define SPEED_HIGH    3

#define FREQ_100K     0
#define FREQ_400K     1

void i2c_Enable(I2C_Register_Table_s *LISOC_I2C);
void i2c_Disable(I2C_Register_Table_s *LISOC_I2C);
void i2c_Config(I2C_Register_Table_s *LISOC_I2C,uint8_t freq,uint16_t addr);
void i2c_Write(I2C_Register_Table_s *LISOC_I2C,uint8_t reg);
uint16_t i2c_Read(I2C_Register_Table_s *LISOC_I2C);
void i2c_reg16_read(I2C_Register_Table_s *LISOC_I2C,uint16_t addr,uint8_t *data);
void i2c_reg16_write(I2C_Register_Table_s *LISOC_I2C,uint16_t addr,uint8_t data);
void i2c_vcm_read(I2C_Register_Table_s *LISOC_I2C,uint8_t addr,uint16_t *data);
void i2c_vcm_write(I2C_Register_Table_s *LISOC_I2C,uint16_t data);

#endif  /* _I2C_H_ */
