/*!
    \file    sensor.c
    \brief   the sensor configuration file

*/

#include "lisoc_test.h"
#include "imx415_fhd60fps.h"
#include "imx415_uhd30fps.h"
#include "imx415_uhd60fps.h"

#include "imx412_uhd30fps.h"
#include "imx412_fhd_r10_53fps.h"
#include "imx662_fhd_r12_30fps.h"
#include "imx662_fhd_r12_60fps.h"

#include "i2c.h"
#include "gpio.h"

#define OV_ID 0x36
#define IMX415_ID 0x1A
#define IMX412_ID 0x1A
#define IMX662_ID 0x1A


#ifdef IMX415
void imx415_init()
{
  int i = 0;
  #ifdef UHD
    #ifdef FPS60
    sensor_reg *p_sensor_cfg = Sensor_8m_60fps_init_table_4lane_linear;
    #else
    sensor_reg *p_sensor_cfg = Sensor_8m_30fps_init_table_4lane_linear;
    #endif
  #else
  sensor_reg *p_sensor_cfg = Sensor_2m_60fps_init_table_4lane_linear_binning_stock ;
  #endif

  i2c_Disable(LISOC_I2C0);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C0, FREQ_400K, IMX415_ID);
  i2c_Enable(LISOC_I2C0);

#if 0
  gpiob_setPinDreict(PA8, GPIO_OUT);
  gpiob_setPinDreict(PB15, GPIO_OUT);
  gpiob_out(PA8, GPIO_HIGH); //pdn
  
  gpiob_out(PB15, GPIO_LOW); //rst
  delay_ms(1);
  gpiob_out(PB15, GPIO_HIGH); //rst
#endif

  while (p_sensor_cfg[i].reg != SEQUENCE_END) {
    if(p_sensor_cfg[i].reg == SEQUENCE_WAIT_MS)
      delay_ms(p_sensor_cfg[i].val);
    else
      i2c_reg16_write(LISOC_I2C0,p_sensor_cfg[i].reg,p_sensor_cfg[i].val);
    i++;
  }
  printf("imx415 init sucess.\r\n");
}
#endif

#ifdef IMX412
void imx412_init()
{
	uint8_t model_id[10];
	uint8_t reg_test[10];
  int i = 0;
  //sensor_reg *p_sensor_cfg = Sensor_imx412_fhd_53fps_init_table_4lane_linear;			// FHD
	//sensor_reg *p_sensor_cfg = Sensor_imx412_uhd_60fps_init_table_4lane_linear;			//UHD 60fps
	sensor_reg *p_sensor_cfg = Sensor_imx412_uhd_30fps_init_table_4lane_linear;			//UHD 30fps
	
	gpiob_setPinDreict(PB15, GPIO_OUT);
	gpiob_out(PB15, GPIO_LOW);		// sensor power on
	delay_ms(3);


  i2c_Disable(LISOC_I2C0);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C0, FREQ_400K, IMX412_ID);
  i2c_Enable(LISOC_I2C0);

//  gpiob_setPinDreict(PB12, GPIO_OUT);
//  gpiob_setPinDreict(PB13, GPIO_OUT);
//  gpiob_out(PB13, GPIO_HIGH); //pdn
  
//  gpiob_out(PB12, GPIO_LOW); //rst
//  delay_ms(1);
//  gpiob_out(PB12, GPIO_HIGH); //rst


	i2c_reg16_read(LISOC_I2C0, 0x0016, &model_id[0]);
  i2c_reg16_read(LISOC_I2C0, 0x0017, &model_id[1]);

  printf("model id, %x %x\r\n", model_id[0], model_id[1]);
	
	i2c_reg16_read(LISOC_I2C0, 0x0005, &model_id[2]);		// 0xff
	i2c_reg16_read(LISOC_I2C0, 0x0006, &model_id[3]);		// 0x01
	i2c_reg16_read(LISOC_I2C0, 0x0009, &model_id[4]);		// 0x40
	i2c_reg16_read(LISOC_I2C0, 0x000a, &model_id[5]);		// 0x01
	i2c_reg16_read(LISOC_I2C0, 0x0019, &model_id[6]);		// 0x0b
	i2c_reg16_read(LISOC_I2C0, 0x0040, &model_id[7]);		// 0x02
	i2c_reg16_read(LISOC_I2C0, 0x0041, &model_id[8]);		// 0x12


  while (p_sensor_cfg[i].reg != SEQUENCE_END) {
    if(p_sensor_cfg[i].reg == SEQUENCE_WAIT_MS)
      delay_ms(p_sensor_cfg[i].val);
    else
      i2c_reg16_write(LISOC_I2C0,p_sensor_cfg[i].reg,p_sensor_cfg[i].val);
    i++;
  }
  printf("imx412 init sucess.\r\n");
	
	i2c_reg16_read(LISOC_I2C0, 0x3040, &reg_test[0]);
	i2c_reg16_read(LISOC_I2C0, 0x38a8, &reg_test[1]);
	i2c_reg16_read(LISOC_I2C0, 0x3f57, &reg_test[2]);
	i2c_reg16_read(LISOC_I2C0, 0x034d, &reg_test[3]);
	i2c_reg16_read(LISOC_I2C0, 0x6a23, &reg_test[4]);
	i2c_reg16_read(LISOC_I2C0, 0x9243, &reg_test[5]);
	i2c_reg16_read(LISOC_I2C0, 0x9383, &reg_test[6]);
	i2c_reg16_read(LISOC_I2C0, 0x9385, &reg_test[7]);
	i2c_reg16_read(LISOC_I2C0, 0x0136, &reg_test[8]);
	
	printf("imx412 init sucess.\r\n");
} 
#endif

#ifdef IMX662
void imx662_init()
{
	uint8_t reg_test[10];
  int i = 0;
	sensor_reg *p_sensor_cfg = Sensor_imx662_fhd_60fps_init_table_4lane_linear;			//FHD 60fps
	
	gpiob_setPinDreict(PB15, GPIO_OUT);
	gpiob_out(PB15, GPIO_LOW);		// sensor power on
	delay_ms(3);


  i2c_Disable(LISOC_I2C0);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C0, FREQ_400K, IMX662_ID);
  i2c_Enable(LISOC_I2C0);

//  gpiob_setPinDreict(PB12, GPIO_OUT);
//  gpiob_setPinDreict(PB13, GPIO_OUT);
//  gpiob_out(PB13, GPIO_HIGH); //pdn
  
//  gpiob_out(PB12, GPIO_LOW); //rst
//  delay_ms(1);
//  gpiob_out(PB12, GPIO_HIGH); //rst


  while (p_sensor_cfg[i].reg != SEQUENCE_END) {
    if(p_sensor_cfg[i].reg == SEQUENCE_WAIT_MS)
      delay_ms(p_sensor_cfg[i].val);
    else
      i2c_reg16_write(LISOC_I2C0,p_sensor_cfg[i].reg,p_sensor_cfg[i].val);
    i++;
  }
  printf("imx662 init sucess.\r\n");
	
	i2c_reg16_read(LISOC_I2C0, 0x3015, &reg_test[0]);
	

	printf("imx662 init sucess.\r\n");
}
#endif
