/*!
    \file    lisoc_it.c
    \brief   interrupt service routines

*/

#include "lisoc_test.h"
#include "lisoc_it.h"
#include "interrupt_test.h"
#include "timer.h"
#include "sensor.h"

uint8_t r_data[3];
uint8_t r_data_i;
#ifndef AX_MAIN
int isp_cnt;
int lisr_mode=0;
#endif

#ifdef configGENERATE_RUN_TIME_STATS
volatile uint32_t CPU_RunTime;
#endif

/**
 * @brief This function handles Non maskable interrupt.
 */
void NMI_Handler(void)
{
}

/**
 * @brief This function handles Hard fault interrupt.
 */
void HardFault_Handler(void)
{
  while(1)
  {
  }
}

/**
 * @brief This function handles Memory management fault.
 */
void MemManage_Handler(void)
{
  while(1)
  {
  }
}

/**
 * @brief This function handles Prefetch fault, memory access fault.
 */
void BusFault_Handler(void)
{
  while(1)
  {
  }
}

/**
 * @brief This function handles Undefined instruction or illegal state.
 */
void UsageFault_Handler(void)
{
  while(1)
  {
  }
}

/**
 * @brief This function handles Debug monitor.
 */
void DebugMon_Handler(void)
{
}

extern void xPortSysTickHandler(void);
/**
 * @brief This function handles System tick timer.
 */
void SysTick_Handler(void)
{
  SysTick1msCount ++;
#if (INCLUDE_xTaskGetSchedulerState  == 1 )
  if (xTaskGetSchedulerState() != taskSCHEDULER_NOT_STARTED)
  {
#endif  /* INCLUDE_xTaskGetSchedulerState */
    xPortSysTickHandler();
#if (INCLUDE_xTaskGetSchedulerState  == 1 )
  }
#endif  /* INCLUDE_xTaskGetSchedulerState */
}


void UART0_Handler(void)
{

}

void UART1_Handler(void)
{
  uart1_irq_handle(); 
}

void WDT_Handler(void)
{
  wdt_irq_handle();
  //WDT_CRR = 0x76;
  //printf("WDT_Handler\n");
}

void I2C0_Handler(void)
{
  i2c0_irq_handle();
}

void I2C1_Handler(void)
{
  i2c1_irq_handle();
}

void I2C2_Handler(void)
{
  uint32_t irq_data;

  i2c2_irq_handle();

  irq_data = reg32(LISOC_I2C2_BASE + 0x34);

  if( (irq_data & 0x20) == 0x20){
    reg32_wr(LISOC_I2C2_BASE + 0x10,0x5A);
    reg32(LISOC_I2C2_BASE + 0x50);
  }

}

void TIMER0_Handler(void)
{
#ifdef CFG_RTOS
  CPU_RunTime++;                    // for CPU load rate calculation
  timer_ClearIRQ(LISOC_TIMER0);     // clear timer 0 IRQ
#else
  timer0_irq_handle();

#endif
}

void TIMER1_Handler(void)
{
  timer1_irq_handle();
  //timer_ClearIRQ(LISOC_TIMER1);     // clear timer 0 IRQ
  //debug("TIMER1_Handler\n");
}

void TIMER2_Handler(void)
{
  timer2_irq_handle();
}

void CACHE_Handler(void)
{
  debug("CACHE_Handler\n");
}

void GPIOA_Handler(void)
{
  gpioa_irq_handle();
}

void GPIOB_Handler(void)
{
  gpiob_irq_handle();
}

void QSPI_Handler(void)
{
  qspi_irq_handle();
}

void SPIMST_Handler(void)
{
  spi_mst_irq_handle();
}

void RTC_Handler(void)
{
  rtc_irq_handle();
  //printf("RTC_Handler\n");
}

#ifdef AX_MAIN
void Test_ISP_Handler(void)	// AX使用時はハンドラ名が被らない用リネームしておく
{
}
#else
void ISP_Handler(void)
{
  //printf("ISP_Handler\n");


  #if 1
  uint32_t temp;
  uint32_t lis_mode;
  uint32_t lis_reg;

	if(lisr_mode == 0x80){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode &= 0xfdff;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lisr_mode &= 0x7f;
	}else if(lisr_mode == 0x81){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode |= 0x0200;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lisr_mode &= 0x7f;
	}
    lis_reg = reg32(LISOC_ISP_BASE + 0x14);
	if((lis_reg & 0xff00) == 0x8000){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode &= 0xfdff;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lis_reg &= 0x0FFF;
		reg32(LISOC_ISP_BASE + 0x14) = lis_reg;
	}else if((lis_reg & 0xff00) == 0x8100){
		lis_mode = reg32(LISOC_LISR_BASE + 0x18);
		lis_mode |= 0x0200;
		reg32(LISOC_LISR_BASE + 0x18) = lis_mode;
		lis_reg &= 0x0FFF;
		reg32(LISOC_ISP_BASE + 0x14) = lis_reg;
	}


  if(isp_cnt++ <20){
    
    temp = reg32(LISOC_ISP_BASE + 0x4d18);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);
    
    temp = reg32(LISOC_ISP_BASE + 0x4d1c);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4d20);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4d24);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp =  reg32(LISOC_ISP_BASE + 0x4e58);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4e5c);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4e60);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X,,",temp);

    temp = reg32(LISOC_ISP_BASE + 0x4e64);
    //printf("%d %d,",temp >> 16 , temp & 0xFFFF);
    printf("%08X\n",temp);
  }

  #else
  uint32_t temp[5][0x2000/4],i,j;
  if(isp_cnt++ < 20){
    if(isp_cnt >= 10 && isp_cnt <15){
      for(i = 0;i <= 0x1B7C/4;i++)
        temp[isp_cnt - 10][i] = reg32(LISOC_ISP_BASE + 0x4000 + i*4);
    }
    if(isp_cnt == 14){
      NVIC_DisableIRQ(ISP_IRQn);
      for(j = 0;j < 1; j++){
        for(i = 0;i <= 0x1B7C/4;i++){
          if(i % 8 == 0)
            printf("%08X: ",LISOC_ISP_BASE + 0x4000  + i*4);
          printf("%08X ",temp[j][i]);
          if(i % 8 == 7)
            printf("\n");
        }
        printf("\n\n");
      }
    }
  }
  #endif
}
#endif

void MIPI_RX_ERR_ECC_Handler(void)
{
  printf("MIPI_RX_ERR_ECC_Handler\n");
}

void MIPI_RX_ERR_CS_Handler(void)
{
  printf("MIPI_RX_ERR_CS_Handler\n");
}

