#ifndef LISOC_ROM_H__
#define LISOC_ROM_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "FreeRTOS.h"
#include "task.h"
#include "queue.h"
#include "timers.h"

#include "SSE050.h"
#include "lisoc.h"
#include "systick.h"
#include "register_top.h"

//#define UHD
//#define THRU
//#define FHD30




/***************************************************************
* Constants
***************************************************************/
#define MEGA_HZ                         (1000000UL)

//#define LISOC_ARM_SYS_CLK               (133UL * MEGA_HZ)
#define LISOC_ARM_SYS_CLK               (133333333UL)
#define LISOC_ARM_PERIPH_CLK            (27UL * MEGA_HZ)
//#define LISOC_ARM_PERIPH_CLK            (27500000UL)

//#define LISOC_WDT_CLK                   (7UL * MEGA_HZ)
#define LISOC_WDT_CLK                   (32768)

#define LISOC_TIMER_CLK                 LISOC_ARM_PERIPH_CLK

/**************************************************************************************************
* Utility Macros
**************************************************************************************************/
#define reg32_wr(addr, wdata)           (*(volatile uint32_t *)(uint32_t)(addr)) = (uint32_t)(wdata)
#define reg32(addr)                     (*(volatile uint32_t *)(uint32_t)(addr))
#define MAX(a,b)                        ((a) >= (b) ? (a) : (b))
#define MIN(a,b)                        ((a) <= (b) ? (a) : (b))

/* Time-out checking utility macro */
#define IS_TIME_PASSED(stamp)           ((int32_t)(SysTick1msCount - (uint32_t)(stamp)) >= 0)
#define IS_TIME_NOT_REACHED(stamp)      ((int32_t)(SysTick1msCount - (uint32_t)(stamp)) < 0)

#define ON                              1u
#define OFF                             0u

/* define common parameters */
#ifndef   NULL
#define   NULL                          0
#endif

#define   TRUE                          1
#define   FALSE                         0

#define   SUCCESS                       0
#define   FAILURE                       1

#define   ERR                           -1

/***************************************************************
* Select DEBUG mode. Shall be commented out in production code.
***************************************************************/
#define CFG_DEBUG

#ifdef CFG_DEBUG
#define debug(...)                      printf(__VA_ARGS__)
#else
#define debug(...)
#endif

/***************************************************************
* Endian swap operation flag for QSPI flash read/write
***************************************************************/
#define CFG_ENDIAN_SWAP                 1

#endif // LISOC_ROM_H__

